/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.Color;
import java.util.Hashtable;
import javax.swing.JTextField;

public class Util {
    public static Hashtable HTMLColors = new Hashtable();

    public static Color getColorForName(String string, Color color) {
        if (HTMLColors.contains(string.toLowerCase())) {
            return (Color)HTMLColors.get(string.toLowerCase());
        }
        return color;
    }

    public static Color decodeColor(String string, Color color) {
        String string2 = "";
        if (string.length() > 0) {
            string2 = string.trim();
            if (string2.startsWith("#")) {
                string2 = string2.substring(1);
            }
            try {
                string2 = new Integer(Integer.parseInt(string2, 16)).toString();
                return Color.decode(string2.toLowerCase());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return color;
        }
        return Util.getColorForName(string, color);
    }

    public static String encodeColor(Color color) {
        return "#" + Integer.toHexString(color.getRGB() - -16777216).toUpperCase();
    }

    public static Color decodeColor(String string) {
        return Util.decodeColor(string, Color.white);
    }

    public static void setBgcolorField(JTextField jTextField) {
        Color color = Util.decodeColor(jTextField.getText());
        jTextField.setBackground(color);
        jTextField.setForeground(new Color(~color.getRGB()));
    }

    public static void setColorField(JTextField jTextField) {
        Color color = Util.decodeColor(jTextField.getText(), Color.black);
        jTextField.setForeground(color);
    }

    static {
        HTMLColors.put("red", Color.red);
        HTMLColors.put("green", Color.green);
        HTMLColors.put("blue", Color.blue);
        HTMLColors.put("cyan", Color.cyan);
        HTMLColors.put("magenta", Color.magenta);
        HTMLColors.put("yellow", Color.yellow);
        HTMLColors.put("black", Color.black);
        HTMLColors.put("white", Color.white);
        HTMLColors.put("gray", Color.gray);
        HTMLColors.put("darkgray", Color.darkGray);
        HTMLColors.put("lightgray", Color.lightGray);
        HTMLColors.put("orange", Color.orange);
        HTMLColors.put("pink", Color.pink);
    }
}

