/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.memoranda.ui.table.TableMap;
import net.sf.memoranda.util.Local;

public class TableSorter
extends TableMap {
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    int sortBy = 0;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class<?> clazz = this.model.getColumnClass(n3);
        TableModel tableModel = this.model;
        Object object2 = tableModel.getValueAt(n, n3);
        Object object3 = tableModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Integer.class) {
            Integer n4;
            int n5;
            Integer n6 = (Integer)tableModel.getValueAt(n, n3);
            int n7 = n6;
            if (n7 < (n5 = (n4 = (Integer)tableModel.getValueAt(n2, n3)).intValue())) {
                return -1;
            }
            if (n7 > n5) {
                return 1;
            }
            return 0;
        }
        if (clazz.getSuperclass() == Number.class) {
            Number number;
            double d;
            Number number2 = (Number)tableModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)tableModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == Date.class) {
            Date date;
            long l;
            Date date2 = (Date)tableModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)tableModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            int n8;
            if (tableModel.getColumnName(n3).equals(Local.getString("Priority"))) {
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                hashtable.put(Local.getString("Lowest"), new Integer(1));
                hashtable.put(Local.getString("Low"), new Integer(2));
                hashtable.put(Local.getString("Normal"), new Integer(3));
                hashtable.put(Local.getString("High"), new Integer(4));
                hashtable.put(Local.getString("Highest"), new Integer(5));
                Integer n9 = (Integer)hashtable.get((String)tableModel.getValueAt(n, n3));
                Integer n10 = (Integer)hashtable.get((String)tableModel.getValueAt(n2, n3));
                if (n9 == null || n10 == null) {
                    return 0;
                }
                n8 = n9.compareTo(n10);
            } else if (tableModel.getColumnName(n3).equals(Local.getString("Status"))) {
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                hashtable.put(Local.getString("Completed"), new Integer(1));
                hashtable.put(Local.getString("Failed"), new Integer(2));
                hashtable.put(Local.getString("Scheduled"), new Integer(3));
                hashtable.put(Local.getString("Active"), new Integer(4));
                hashtable.put(Local.getString("Deadline"), new Integer(5));
                Integer n11 = (Integer)hashtable.get((String)tableModel.getValueAt(n, n3));
                Integer n12 = (Integer)hashtable.get((String)tableModel.getValueAt(n2, n3));
                if (n11 == null || n12 == null) {
                    return 0;
                }
                n8 = n11.compareTo(n12);
            } else {
                String string2 = (String)tableModel.getValueAt(n, n3);
                String string3 = (String)tableModel.getValueAt(n2, n3);
                n8 = string2.compareTo(string3);
            }
            if (n8 < 0) {
                return -1;
            }
            if (n8 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)tableModel.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)tableModel.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = tableModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n13 = string4.compareTo(string = (object = tableModel.getValueAt(n2, n3)).toString());
        if (n13 < 0) {
            return -1;
        }
        if (n13 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = (Integer)this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.ascending ? n4 : -n4;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
            this.setModel(this.model);
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, this.ascending);
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortBy = n;
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public int getSortedBy() {
        return this.sortBy;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            boolean ascending = false;

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    this.ascending = n2 == TableSorter.this.sortBy ? !this.ascending : true;
                    tableSorter.sortByColumn(n2, this.ascending);
                    jTable2.getTableHeader().updateUI();
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }
}

