/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import net.sf.memoranda.Note;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.htmleditor.AltHTMLWriter;
import net.sf.memoranda.util.Configuration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class HTMLFileExport {
    String charset = "";
    File f = null;
    HTMLDocument doc;
    Note note = null;
    boolean xhtml = false;
    boolean num = false;
    String templFile = null;

    public HTMLFileExport(File file, Document document, Note note, String string, boolean bl, String string2, boolean bl2) {
        this.f = file;
        this.doc = (HTMLDocument)document;
        this.note = note;
        this.charset = string;
        this.num = bl;
        this.templFile = string2;
        this.xhtml = bl2;
        this.doExport();
    }

    private void doExport() {
        try {
            if (this.f.getName().indexOf(".htm") == -1) {
                String string = this.f.getPath();
                String string2 = ".html";
                String string3 = string + string2;
                this.f = new File(string3);
            }
            OutputStreamWriter outputStreamWriter = this.charset != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), this.charset) : new FileWriter(this.f);
            outputStreamWriter.write(this.applyTemplate());
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Cannot export file " + this.f.getPath(), null);
        }
    }

    private String getTemplateString(String string) {
        Object object;
        if (string != null && string.length() > 0) {
            object = new File(string);
            String string2 = "";
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    string2 = string2 + string3;
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                new ExceptionDialog(exception, "Cannot read template file from " + string, null);
            }
            if (string2.length() > 0) {
                return string2;
            }
        }
        if ((object = (String)Configuration.get("DEFAULT_EXPORT_TEMPLATE")) != null && ((String)object).length() > 0) {
            return object;
        }
        return "<html>\n<head>\n@METACHARSET@\n<title>@TITLE@ - @PROJECT@</title>\n</head>\n<body>\n@CONTENT@\n</body>\n</html>";
    }

    private String applyTemplate() {
        String string = this.getNoteBody();
        String string2 = this.note != null ? this.note.getTitle() : "";
        String string3 = this.note != null ? this.note.getId() : "";
        String string4 = this.note != null ? this.note.getProject().getTitle() : "";
        String string5 = this.note != null ? this.note.getDate().getFullDateString() : "";
        String string6 = new Date().toString();
        String string7 = this.getTemplateString(this.templFile);
        string7 = string7.replaceAll("@CONTENT@", string);
        string7 = string7.replaceAll("@TITLE@", string2);
        string7 = string7.replaceAll("@ID@", string3);
        string7 = string7.replaceAll("@PROJECT@", string4);
        string7 = string7.replaceAll("@DATE@", string5);
        string7 = string7.replaceAll("@NOW@", string6);
        if (this.charset != null && this.charset.length() > 0) {
            string7 = string7.replaceAll("@METACHARSET@", "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.charset + "\" >");
        }
        if (this.xhtml) {
            string7 = HTMLFileExport.convertToXHTML(string7);
        }
        return string7;
    }

    private String getNoteBody() {
        String string = "";
        StringWriter stringWriter = new StringWriter();
        AltHTMLWriter altHTMLWriter = new AltHTMLWriter((Writer)stringWriter, this.doc, this.charset, this.num);
        try {
            altHTMLWriter.write();
            stringWriter.flush();
            stringWriter.close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
        string = stringWriter.toString();
        string = Pattern.compile("<body(.*?)>", 34).split(string)[1];
        string = Pattern.compile("</body>", 34).split(string)[0];
        return string;
    }

    public static String convertToXHTML(String string) {
        SAXParser sAXParser = new SAXParser();
        OutputFormat outputFormat = new OutputFormat();
        try {
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            outputFormat.setOmitDocumentType(true);
            outputFormat.setOmitXMLDeclaration(true);
            outputFormat.setMethod("xhtml");
            outputFormat.setIndenting(true);
            StringReader stringReader = new StringReader(string);
            StringWriter stringWriter = new StringWriter();
            InputSource inputSource = new InputSource(stringReader);
            sAXParser.setContentHandler((ContentHandler)new XMLSerializer((Writer)stringWriter, outputFormat));
            sAXParser.parse(inputSource);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
            return null;
        }
    }
}

