/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.util.FileStorage;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class TaskListVersioning {
    public static final String[] VERSIONS = new String[]{"-//Memoranda//DTD Tasklist 1.0//EN", "-//Memoranda//DTD Tasklist 1.1d1//EN"};

    public static DocType getCurrentDocType() {
        return new DocType("tasklist", TaskListVersioning.getCurrentVersionPublicId(), "tasklist.dtd");
    }

    public static String getCurrentVersionPublicId() {
        return VERSIONS[VERSIONS.length - 1];
    }

    public static int getIndexOfVersion(String string) {
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < VERSIONS.length; ++i) {
            if (!string.equals(VERSIONS[i])) continue;
            return i;
        }
        Util.debug("Version " + string + " not found");
        return -1;
    }

    public static boolean upgradeTaskList(String string) {
        int n = TaskListVersioning.getIndexOfVersion(string);
        if (n == VERSIONS.length - 1) {
            Util.debug("Version " + string + " is the latest version, skipping upgrade");
            return false;
        }
        Vector vector = ProjectManager.getAllProjects();
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            stringArray[n2++] = project.getID();
        }
        while (n < VERSIONS.length - 1) {
            if (n == 0) {
                TaskListVersioning.upgrade1_1d1(stringArray);
            }
            ++n;
        }
        return true;
    }

    private static void upgrade1_1d1(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Util.debug("Upgrading project " + stringArray[i] + " from version 1.0 to version 1.1d1");
            String string = FileStorage.JN_DOCPATH + stringArray[i] + File.separator + ".tasklist";
            Document document = FileStorage.openDocument(string);
            Element element = document.getRootElement();
            Elements elements = element.getChildElements("task");
            for (int j = 0; j < elements.size(); ++j) {
                Element element2 = elements.get(j);
                Attribute attribute = element2.getAttribute("parent");
                if (attribute == null || attribute.getValue() == "") continue;
                String string2 = attribute.getValue();
                for (int k = 0; k < elements.size(); ++k) {
                    Element element3 = elements.get(k);
                    if (!string2.equals(element3.getAttribute("id").getValue())) continue;
                    element2.removeAttribute(attribute);
                    element2.detach();
                    element3.appendChild((Node)element2);
                }
            }
            document.setDocType(TaskListVersioning.getCurrentDocType());
            FileStorage.saveDocument(document, string);
        }
    }
}

