/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class StackObjectPool
extends BaseObjectPool
implements ObjectPool {
    protected Stack a = null;
    protected PoolableObjectFactory b = null;
    protected int c = 8;
    protected int d = 0;

    public StackObjectPool() {
        this(null, 8, 4);
    }

    public StackObjectPool(int n2) {
        this(null, n2, 4);
    }

    public StackObjectPool(int n2, int n3) {
        this(null, n2, n3);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this(poolableObjectFactory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory, int n2) {
        this(poolableObjectFactory, n2, 4);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, int n3) {
        this.b = poolableObjectFactory;
        this.c = n2 < 0 ? 8 : n2;
        int n4 = n3 < 1 ? 4 : n3;
        this.a = new Stack();
        this.a.ensureCapacity(n4 > this.c ? this.c : n4);
    }

    public synchronized Object borrowObject() throws Exception {
        this.b();
        Object object = null;
        try {
            object = this.a.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (null == this.b) {
                throw new NoSuchElementException();
            }
            object = this.b.makeObject();
        }
        if (null != this.b && null != object) {
            this.b.activateObject(object);
        }
        ++this.d;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        this.b();
        boolean bl = true;
        if (null != this.b) {
            if (!this.b.validateObject(object)) {
                bl = false;
            } else {
                try {
                    this.b.passivateObject(object);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        boolean bl2 = !bl;
        StackObjectPool stackObjectPool = this;
        synchronized (stackObjectPool) {
            --this.d;
            if (this.a.size() >= this.c) {
                bl2 = true;
            } else if (bl) {
                this.a.push(object);
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this.b.destroyObject(object);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void invalidateObject(Object object) throws Exception {
        this.b();
        --this.d;
        if (null != this.b) {
            this.b.destroyObject(object);
        }
        this.notifyAll();
    }

    public int getNumIdle() {
        this.b();
        return this.a.size();
    }

    public int getNumActive() {
        this.b();
        return this.d;
    }

    public synchronized void clear() {
        this.b();
        if (null != this.b) {
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    this.b.destroyObject(enumeration.nextElement());
                }
                catch (Exception exception) {}
            }
        }
        this.a.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this.a = null;
        this.b = null;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        Object object = this.b.makeObject();
        StackObjectPool stackObjectPool = this;
        synchronized (stackObjectPool) {
            ++this.d;
            this.returnObject(object);
            return;
        }
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        this.b();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this.b = poolableObjectFactory;
    }
}

