/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.util.LinkedList;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ViewState;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;

public abstract class ViewStateReader {
    private static final Integer PROPS_ID = new Integer(1);
    private static final Integer PROPS_TYPE = new Integer(1);
    private static final Integer VIEW_NAME = new Integer(641728536);
    private static final Integer VIEW_CONTENTS = new Integer(641728565);

    protected abstract Props getProps(Var2Data var1) throws IOException;

    public void process(ProjectFile file, Var2Data varData) throws IOException {
        Props props = this.getProps(varData);
        if (props != null) {
            String viewName = MPPUtility.removeAmpersands(props.getUnicodeString(VIEW_NAME));
            byte[] listData = props.getByteArray(VIEW_CONTENTS);
            LinkedList<Integer> uniqueIdList = new LinkedList<Integer>();
            if (listData != null) {
                int index = 0;
                while (index < listData.length) {
                    Integer uniqueID = new Integer(MPPUtility.getInt(listData, index));
                    if (file.getTaskByUniqueID(uniqueID) == null) break;
                    uniqueIdList.add(uniqueID);
                    index += 4;
                }
            }
            ViewState state = new ViewState(viewName, uniqueIdList);
            file.setViewState(state);
        }
    }
}

