/*
 * Decompiled with CFR 0.152.
 */
package com.projity.offline_graphics;

import com.projity.configuration.Dictionary;
import com.projity.graphic.configuration.BarStyles;
import com.projity.offline_graphics.SVGRenderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.model.event.CacheListener;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.network.NetworkParamsImpl;
import com.projity.pm.graphic.network.NetworkRenderer;
import com.projity.pm.graphic.pert.PertLayout;
import com.projity.pm.graphic.pert.PertRenderer;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.xbs.XbsLayout;
import com.projity.pm.graphic.xbs.XbsRenderer;
import com.projity.pm.task.Project;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class NetworkSVGRenderer
implements SVGRenderer,
CacheListener,
Cloneable {
    public static final int PERT = 1;
    public static final int WBS = 2;
    public static final int RBS = 3;
    protected NetworkParamsImpl params;
    protected CoordinatesConverter coord;
    protected SpreadSheet spreadSheet;
    protected NetworkRenderer renderer;
    protected Project project;

    public void init(Project project, ReferenceNodeModelCache referenceNodeModelCache) {
        this.init(project, NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, "Network", null), 1, -1);
    }

    public void init(Project project, NodeModelCache nodeModelCache, int n2, int n3) {
        this.project = project;
        this.params = new NetworkParamsImpl();
        this.params.setNetworkLayout(n2 == 1 ? new PertLayout(this.params) : new XbsLayout(this.params));
        String string = null;
        switch (n2) {
            case 1: {
                string = "pert";
                this.renderer = new PertRenderer(this.params);
                this.renderer.setVertical(false);
                break;
            }
            case 2: {
                string = "WBS";
                this.renderer = new XbsRenderer(this.params);
                this.renderer.setVertical(true);
                break;
            }
            case 3: {
                string = "RBS";
                this.renderer = new XbsRenderer(this.params);
                this.renderer.setVertical(true);
            }
        }
        this.params.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", string));
        this.params.setZoom(n3);
        this.params.setCache(nodeModelCache);
        nodeModelCache.addNodeModelListener(this);
        nodeModelCache.update();
        this.params.updateLayout();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public SVGRenderer createSafePrintCopy() {
        NetworkSVGRenderer networkSVGRenderer = (NetworkSVGRenderer)this.clone();
        networkSVGRenderer.params = (NetworkParamsImpl)networkSVGRenderer.params.createSafePrintCopy();
        networkSVGRenderer.renderer.setGraphInfo(networkSVGRenderer.params);
        return networkSVGRenderer;
    }

    public void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, -1, -1);
    }

    public void paint(Graphics2D graphics2D, int n2, int n3) {
        Rectangle rectangle = this.params.getDrawingBounds();
        if (n2 == -1) {
            graphics2D.drawRect(0, 0, rectangle.width, rectangle.height);
            this.renderer.paint(graphics2D);
        } else {
            Rectangle rectangle2 = this.params.getPrintBounds();
            Rectangle rectangle3 = this.params.getNetworkPrintBounds(n2, n3);
            graphics2D.translate(-n3 * rectangle2.width, -n2 * rectangle2.height);
            this.renderer.paint(graphics2D, rectangle3);
        }
    }

    public Dimension getCanvasSize() {
        return this.params.getDrawingBounds().getSize();
    }

    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        this.params.getNetworkLayout().graphicNodesCompositeEvent(compositeCacheEvent);
    }

    public GraphParams getParams() {
        return this.params;
    }

    public Project getProject() {
        return this.project;
    }
}

