/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.configuration.Dictionary;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.pm.graphic.gantt.GanttParamsImpl;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.common.SpreadSheetRowHeaderColumnModel;
import com.projity.strings.Messages;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadSheetParamsImpl
extends GanttParamsImpl
implements SpreadSheetParams {
    protected String spreadsheetCategory = "taskSpreadsheet";
    protected SpreadSheetFieldArray fieldArray;
    protected List<Integer> colWidth;
    protected FieldContext fieldContext;
    protected SpreadSheetColumnModel columnModel;
    protected SpreadSheetRowHeaderColumnModel headerColumnModel = new SpreadSheetRowHeaderColumnModel();
    protected int spreadSheetWidth = -1;
    protected int idColMargin = 2;
    protected int colMargin = 2;
    protected ArrayList colPageInfo;
    protected ArrayList rowPageInfo;

    public SpreadSheetParamsImpl(SpreadSheetFieldArray spreadSheetFieldArray, List<Integer> list, boolean bl) {
        this.setFieldArray(spreadSheetFieldArray == null ? (SpreadSheetFieldArray)Dictionary.get(this.spreadsheetCategory, Messages.getString("Spreadsheet.Task.entry")) : spreadSheetFieldArray, spreadSheetFieldArray == null ? null : (list == null ? spreadSheetFieldArray.getWidths() : list));
        this.setRightPartVisible(bl);
    }

    @Override
    public SpreadSheetFieldArray getFieldArray() {
        return this.fieldArray;
    }

    @Override
    public void setFieldArray(SpreadSheetFieldArray spreadSheetFieldArray, List<Integer> list) {
        this.fieldArray = spreadSheetFieldArray;
        this.colWidth = list;
        this.columnModel = new SpreadSheetColumnModel(spreadSheetFieldArray, list);
        this.columnModel.setSvg(true);
        this.initColumns(this.columnModel, spreadSheetFieldArray.size());
        this.initColumns(this.headerColumnModel, 1);
        this.fieldContext = new FieldContext();
        this.fieldContext.setLeftAssociation(true);
        this.updateWidth();
    }

    @Override
    public String getSpreadsheetCategory() {
        return this.spreadsheetCategory;
    }

    @Override
    public FieldContext getFieldContext() {
        return this.fieldContext;
    }

    public void initColumns(TableColumnModel tableColumnModel, int n2) {
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            TableColumn tableColumn = new TableColumn(i2);
            tableColumn.setHeaderValue("" + i2);
            tableColumnModel.addColumn(tableColumn);
        }
    }

    @Override
    public Rectangle getSpreadSheetBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), this.spreadSheetWidth, this.getRowHeight() * this.cache.getSize());
    }

    @Override
    public Rectangle getDrawingBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), (this.isLeftPartVisible() ? this.getSpreadSheetBounds().width : 0) + (this.isRightPartVisible() ? this.getGanttBounds().width : 0), this.getSpreadSheetBounds().height + this.configuration.getColumnHeaderHeight());
    }

    public int getSpreadSheetWidth() {
        return this.spreadSheetWidth;
    }

    @Override
    public SpreadSheetColumnModel getColumnModel() {
        return this.columnModel;
    }

    @Override
    public SpreadSheetRowHeaderColumnModel getHeaderColumnModel() {
        return this.headerColumnModel;
    }

    @Override
    public Iterator getColumnIterator() {
        return new Iterator(){
            protected Enumeration headerE;
            protected Enumeration e;
            {
                this.headerE = SpreadSheetParamsImpl.this.headerColumnModel.getColumns();
                this.e = SpreadSheetParamsImpl.this.columnModel.getColumns();
            }

            public boolean hasNext() {
                return this.headerE.hasMoreElements() || this.e.hasMoreElements();
            }

            public Object next() {
                if (this.headerE.hasMoreElements()) {
                    return this.headerE.nextElement();
                }
                return this.e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void updateDrawingBounds() {
        this.updateWidth();
    }

    private void updateWidth() {
        this.spreadSheetWidth = this.calculateSpreadSheetWidth();
    }

    private int calculateSpreadSheetWidth() {
        int n2 = this.getConfiguration().getRowHeaderWidth() + 2 * this.idColMargin;
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n3 = tableColumn.getPreferredWidth() + 2 * this.colMargin;
            n2 += n3;
        }
        return n2;
    }

    @Override
    public void setPrintBounds(Rectangle rectangle) {
        super.setPrintBounds(rectangle);
        this.updatePages();
    }

    private void updatePages() {
        if (this.printBounds == null) {
            return;
        }
        if (this.colPageInfo == null) {
            this.colPageInfo = new ArrayList();
        } else {
            this.colPageInfo.clear();
        }
        if (this.rowPageInfo == null) {
            this.rowPageInfo = new ArrayList();
        } else {
            this.rowPageInfo.clear();
        }
        int n2 = this.getConfiguration().getRowHeaderWidth() + 2 * this.idColMargin;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (n2 + tableColumn.getPreferredWidth() + 2 * this.colMargin > this.printBounds.width) {
                this.colPageInfo.add(new PageInfo(n3, n4 - 1, n5, n2));
                n3 = n4;
                n5 += n2;
                n2 = 0;
            }
            n2 += tableColumn.getPreferredWidth() + 2 * this.colMargin;
            ++n4;
        }
        this.colPageInfo.add(new PageInfo(n3, n4 - 1, n5, n2));
        int n6 = this.getRowsPerPage();
        int n7 = this.cache.getSize();
        int n8 = n7 / n6;
        for (n4 = 0; n4 < n8; ++n4) {
            this.rowPageInfo.add(new PageInfo(n4 * n6, (n4 + 1) * n6 - 1, n4 * n6 * this.getRowHeight(), n6 * this.getRowHeight()));
        }
        int n9 = n7 % n6;
        if (n9 != 0) {
            this.rowPageInfo.add(new PageInfo(n4 * n6, n7 - 1, n4 * n6 * this.getRowHeight(), n9 * this.getRowHeight()));
        }
    }

    @Override
    public PageInfo getRowPageInfo(int n2) {
        return n2 < 0 || n2 >= this.rowPageInfo.size() ? null : (PageInfo)this.rowPageInfo.get(n2);
    }

    @Override
    public PageInfo getColPageInfo(int n2) {
        return n2 < 0 || n2 >= this.colPageInfo.size() ? null : (PageInfo)this.colPageInfo.get(n2);
    }

    public int getRowsPerPage() {
        int n2 = (this.printBounds.height - this.configuration.getColumnHeaderHeight() - this.configuration.getPrintFooterHeight()) / this.getRowHeight();
        if (n2 <= 0) {
            System.out.println("Error bad rowsPerPage");
            n2 = 1;
        }
        return n2;
    }

    public Rectangle getSpreadsheetPrintBounds(int n2, int n3, boolean bl) {
        if (bl && !this.isLeftPartVisible()) {
            return null;
        }
        PageInfo pageInfo = this.getColPageInfo(n3);
        PageInfo pageInfo2 = this.getRowPageInfo(n2);
        if (pageInfo == null || pageInfo2 == null) {
            return null;
        }
        return new Rectangle(pageInfo.getX(), pageInfo2.getX() + this.configuration.getColumnHeaderHeight(), pageInfo.getWidth(), pageInfo2.getWidth());
    }

    public Rectangle getGanttPrintBounds(int n2, int n3) {
        int n4;
        if (!this.isRightPartVisible()) {
            return null;
        }
        int n5 = this.colPageInfo.size() - 1;
        if (n3 < n5 && this.isLeftPartVisible()) {
            return null;
        }
        int n6 = this.getGanttBounds().width;
        Rectangle rectangle = this.getSpreadsheetPrintBounds(n2, n5, true);
        if (!(n3 != n5 && this.isLeftPartVisible() || rectangle == null)) {
            int n7 = rectangle.width;
            int n8 = this.getPrintBounds().width - rectangle.width;
            if (n8 > n6) {
                n8 = n6;
            }
            Rectangle rectangle2 = new Rectangle(0, rectangle.y - this.configuration.getColumnHeaderHeight(), n8, rectangle.height);
            if (rectangle2.width == 0) {
                return null;
            }
            return rectangle2;
        }
        rectangle = this.getSpreadsheetPrintBounds(n2, n5, false);
        int n9 = -this.getGanttDeltaX(n2, n3);
        if (n9 + (n4 = this.getPrintBounds().width) > n6) {
            n4 = n6 - n9;
        }
        Rectangle rectangle3 = new Rectangle(n9, rectangle == null ? 0 : rectangle.y - this.configuration.getColumnHeaderHeight(), n4, rectangle == null ? 0 : rectangle.height);
        return rectangle3;
    }

    public int getGanttDeltaX(int n2, int n3) {
        int n4 = this.colPageInfo.size() - 1;
        if (n3 < n4 && this.isLeftPartVisible()) {
            return -1;
        }
        Rectangle rectangle = this.getSpreadsheetPrintBounds(n2, n4, true);
        if (rectangle == null) {
            return -n3 * this.getPrintBounds().width;
        }
        return rectangle.width - (n3 - n4) * this.getPrintBounds().width;
    }

    @Override
    public int getPrintCols() {
        int n2 = this.colPageInfo.size();
        PageInfo pageInfo = this.getColPageInfo(n2 - 1);
        int n3 = (this.isLeftPartVisible() ? pageInfo.width : 0) + (this.isRightPartVisible() ? this.getGanttBounds().width : 0);
        return (this.isLeftPartVisible() ? n2 - 1 : 0) + (int)Math.ceil((double)n3 / this.getPrintBounds().getWidth());
    }

    @Override
    public int getPrintRows() {
        int n2 = this.rowPageInfo.size();
        return n2 == 0 ? 1 : n2;
    }

    public int getColMargin() {
        return this.colMargin;
    }

    public int getIdColMargin() {
        return this.idColMargin;
    }

    @Override
    public GraphParams createSafePrintCopy() {
        SpreadSheetParamsImpl spreadSheetParamsImpl = (SpreadSheetParamsImpl)super.createSafePrintCopy();
        if (spreadSheetParamsImpl.colPageInfo != null) {
            spreadSheetParamsImpl.colPageInfo = (ArrayList)this.colPageInfo.clone();
        }
        if (spreadSheetParamsImpl.rowPageInfo != null) {
            spreadSheetParamsImpl.rowPageInfo = (ArrayList)this.rowPageInfo.clone();
        }
        return spreadSheetParamsImpl;
    }

    public class PageInfo {
        protected int start;
        protected int end;
        protected int x;
        protected int width;

        public PageInfo(int n2, int n3, int n4, int n5) {
            this.start = n2;
            this.end = n3;
            this.x = n4;
            this.width = n5;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n2) {
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n2) {
            this.start = n2;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n2) {
            this.width = n2;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n2) {
            this.x = n2;
        }
    }
}

