/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.util.Environment;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Enumeration;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontUtil {
    public static void setUIFont(String string) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Object object = UIManager.get(k2);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k2, new FontUIResource(Font.decode(string)));
        }
    }

    public static Font getUIFont() {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Object object = UIManager.get(k2);
            if (!(object instanceof FontUIResource)) continue;
            return (FontUIResource)object;
        }
        return null;
    }

    public static String getValidFont(String[] stringArray) {
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                if (!stringArray2[i3].equals(stringArray[i2])) continue;
                return stringArray[i2];
            }
        }
        return null;
    }

    public static void listFonts() {
        Font font = FontUtil.getUIFont();
        System.out.println("Current font: " + font);
        System.out.println("Available fonts: ");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            System.out.println("\t" + stringArray[i2]);
        }
    }

    public static Font getFont(String string, int n2) {
        Font font = Font.decode(Environment.getFont(n2));
        if (string == null) {
            return font;
        }
        Font font2 = Font.decode(string);
        if (font2.getName().equals("_Default_")) {
            return font.deriveFont(font2.getStyle(), font2.getSize() + font.getSize() - 12);
        }
        return font2;
    }
}

