/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.cesilko.rachota.core.IdleTask;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class Day
implements PropertyChangeListener {
    private Vector tasks;
    private Date date;
    private Date startTime;
    private Date finishTime;
    private boolean modified;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Day(Vector tasks, Date date, Date startTime, Date finishTime) {
        this.setTasks(tasks);
        this.setDate(date);
        this.setStartTime(startTime);
        this.setFinishTime(finishTime);
        this.modified = false;
    }

    public void setTasks(Vector tasks) {
        this.tasks = new Vector();
        for (Task task : tasks) {
            this.addTask(task);
        }
        if (this.getIdleTask() == null) {
            this.addTask(new IdleTask());
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "tasks", null, tasks));
    }

    public Vector getTasks() {
        return this.tasks;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
        if (!(task instanceof RegularTask)) {
            this.modified = true;
        }
        task.addPropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "tasks", null, this.tasks));
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
        this.modified = true;
        task.removePropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "tasks", null, this.tasks));
    }

    public void removeNotStartedRegularTasks() {
        Vector<Task> oldTasks = new Vector<Task>();
        for (Task task : this.tasks) {
            if (!(task instanceof RegularTask) || task.getState() != Task.STATE_NEW) continue;
            oldTasks.add(task);
        }
        for (Task task : oldTasks) {
            this.removeTask(task);
        }
    }

    public Task getTask(String description) {
        for (Task task : this.tasks) {
            if (!task.getDescription().equals(description)) continue;
            return task;
        }
        return null;
    }

    public Task getIdleTask() {
        for (Task task : this.tasks) {
            if (!task.isIdleTask()) continue;
            return task;
        }
        return null;
    }

    public boolean existsMorePriorityTask(int priority) {
        if (priority == Task.PRIORITY_HIGH) {
            return false;
        }
        int count = this.tasks.size();
        for (int i = 0; i < count; ++i) {
            Task task = (Task)this.tasks.get(i);
            if (!(task.getState() != Task.STATE_DONE & task.getPriority() < priority)) continue;
            return true;
        }
        return false;
    }

    public void setDate(Date date) {
        this.date = date;
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "date", null, this.tasks));
    }

    public Date getDate() {
        return this.date;
    }

    public void setStartTime(Date startTime) {
        boolean recordStartStopTimeOnIdle = (Boolean)Settings.getDefault().getSetting("recordStartStopTimeOnIdle");
        if (!recordStartStopTimeOnIdle && this.getTotalTime(true) == 0L) {
            return;
        }
        this.startTime = startTime;
        this.modified = true;
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "startTime", null, null));
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setFinishTime(Date finishTime) {
        boolean recordStartStopTimeOnIdle = (Boolean)Settings.getDefault().getSetting("recordStartStopTimeOnIdle");
        if (!recordStartStopTimeOnIdle && this.getIdleTask().isRunning()) {
            return;
        }
        this.finishTime = finishTime;
        this.modified = true;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public boolean isModified() {
        return this.modified;
    }

    public long getTotalTime(boolean includePrivateTasks) {
        Iterator iterator = this.tasks.iterator();
        long totalTime = 0L;
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.isIdleTask() || task.privateTask() && !includePrivateTasks) continue;
            totalTime += task.getDuration();
        }
        return totalTime;
    }

    public long getTotalTime() {
        return this.getTotalTime(Settings.getDefault().getCountPrivateTasks());
    }

    public void sortTasks(int attribute, boolean ascendingOrder) {
        Vector<Task> sortedTasks = new Vector<Task>();
        while (this.tasks.size() > 0) {
            Task selectedTask = (Task)this.tasks.get(0);
            for (Task task : this.tasks) {
                selectedTask = task.compare(selectedTask, attribute, ascendingOrder);
            }
            sortedTasks.add(selectedTask);
            this.tasks.remove(selectedTask);
        }
        this.tasks = sortedTasks;
    }

    public void write(PrintStream stream) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        int id = calendar.get(7);
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("MM-dd-yyyy");
        stream.println("    <day date=\"" + sdf.format(this.date) + "\" id=\"" + id + "\" start=\"" + Tools.getTime(this.startTime) + "\" finish=\"" + Tools.getTime(this.finishTime) + "\">");
        Boolean archiveNotStarted = (Boolean)Settings.getDefault().getSetting("archiveNotStarted");
        boolean pastDay = !(Plan.getDefault().isFuture(this) | Plan.getDefault().isToday(this));
        for (Task task : this.tasks) {
            boolean writeTask = true;
            if (!archiveNotStarted.booleanValue() && pastDay) {
                boolean bl = writeTask = task.getState() != Task.STATE_NEW;
            }
            if (task instanceof RegularTask && task.getDuration() == 0L) {
                writeTask = false;
            }
            if (!writeTask) continue;
            task.write(stream);
        }
        stream.println("    </day>");
    }

    public String toString() {
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        String dayFormat = Translator.getTranslation("FORMAT.DAY_SHORT");
        sdf.applyPattern(dayFormat);
        return sdf.format(this.date);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean today = Plan.getDefault().isToday(this);
        if (today & evt.getPropertyName().equals("duration")) {
            this.modified = true;
            Plan.getDefault().addDay(this);
            if (this.getStartTime() == null) {
                this.setStartTime(new Date());
            }
            this.setFinishTime(new Date());
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "duration", null, null));
        } else {
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "generic", null, this.tasks));
        }
    }

    public long getRemainingWorkingTime() {
        Double workingHoursInMinutes = Settings.getDefault().getWorkingHours() * 60.0;
        long remaining = TimeUnit.MILLISECONDS.convert(workingHoursInMinutes.longValue(), TimeUnit.MINUTES);
        return (remaining -= this.getTotalTime()) >= 0L ? remaining : 0L;
    }
}

