/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core.filters;

import java.util.Iterator;
import java.util.Vector;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.gui.Tools;

public class DurationFilter
extends AbstractTaskFilter {
    public static final int RULE_MORE_THAN = 0;
    public static final int RULE_LESS_THAN = 1;

    public DurationFilter(int contentRule, Long duration) {
        super(contentRule, Tools.getTime(duration.longValue()));
    }

    public DurationFilter() {
        this(0, new Long(0L));
    }

    @Override
    public Vector getContentRules() {
        Vector<String> contentRules = new Vector<String>();
        contentRules.add(Translator.getTranslation("FILTER.RULE_LESS_THAN"));
        contentRules.add(Translator.getTranslation("FILTER.RULE_MORE_THAN"));
        return contentRules;
    }

    @Override
    public Vector filterTasks(Vector tasks) {
        Vector filteredTasks = (Vector)tasks.clone();
        Iterator iterator = tasks.iterator();
        long requiredDuration = Tools.getTime(this.getContent());
        int contentRule = this.getContentRule();
        block4: while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            boolean taskLonger = task.getDuration() > requiredDuration;
            switch (contentRule) {
                case 1: {
                    if (taskLonger) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
                case 0: {
                    if (!taskLonger) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
            }
            System.out.println("Error: Task duration can't be filtered by content rule: " + this.getContentRules().get(contentRule));
        }
        return filteredTasks;
    }

    @Override
    public String toString() {
        return Translator.getTranslation("TASK_DURATION");
    }
}

