/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class AdjustTimeDialog
extends JDialog {
    private JButton btCancel;
    private JButton btOK;
    private JLabel lbColumn1;
    private JLabel lbSelectTime;
    private JPanel pnButtons;
    private JSpinner spHours;
    private JSpinner spMinutes;
    private Integer previousHours = new Integer(0);
    private Integer previousMinutes = new Integer(0);
    private Task task = null;

    public AdjustTimeDialog(Frame parent, String title, Task task) {
        this(parent, title);
        String shortDuration = Tools.getTimeShort(task.getDuration());
        Integer hours = new Integer(shortDuration.substring(0, 2));
        Integer minutes = new Integer(shortDuration.substring(3, 5));
        this.spHours.setValue(hours);
        this.spMinutes.setValue(minutes);
        this.task = task;
    }

    public AdjustTimeDialog(Frame parent, String title, int hours, int minutes) {
        this(parent, title);
        this.spHours.setValue(new Integer(hours));
        this.spMinutes.setValue(new Integer(minutes));
    }

    public AdjustTimeDialog(Frame parent, String title) {
        this.setTitle(title);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        Dimension size = this.spHours.getPreferredSize();
        this.spHours.setPreferredSize(new Dimension((int)size.getWidth() * 2, (int)size.getHeight()));
        this.spMinutes.setPreferredSize(new Dimension((int)size.getWidth() * 2, (int)size.getHeight()));
        Tools.setupSelectAllListener(this.spHours);
        Tools.setupSelectAllListener(this.spMinutes);
        this.getRootPane().setDefaultButton(this.btOK);
        this.pack();
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.lbSelectTime = new JLabel();
        this.spHours = new JSpinner();
        this.lbColumn1 = new JLabel();
        this.spMinutes = new JSpinner();
        this.pnButtons = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AdjustTimeDialog.this.formMouseEntered(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lbSelectTime.setDisplayedMnemonic(Translator.getMnemonic("ADJUSTTIMEDIALOG.SET_TIME"));
        this.lbSelectTime.setFont(this.getFont());
        this.lbSelectTime.setLabelFor(this.spHours);
        this.lbSelectTime.setText(Translator.getTranslation("ADJUSTTIMEDIALOG.SET_TIME"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbSelectTime, gridBagConstraints);
        this.spHours.setFont(this.getFont());
        this.spHours.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.HOURS_TOOLTIP"));
        this.spHours.setMinimumSize(new Dimension(40, 20));
        this.spHours.setPreferredSize(new Dimension(40, 20));
        this.spHours.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AdjustTimeDialog.this.spHoursStateChanged(evt);
            }
        });
        this.spHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AdjustTimeDialog.this.spHoursKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spHours, gridBagConstraints);
        this.lbColumn1.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.lbColumn1, gridBagConstraints);
        this.spMinutes.setFont(this.getFont());
        this.spMinutes.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.MINUTES_TOOLTIP"));
        this.spMinutes.setMinimumSize(new Dimension(40, 20));
        this.spMinutes.setPreferredSize(new Dimension(40, 20));
        this.spMinutes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AdjustTimeDialog.this.spMinutesStateChanged(evt);
            }
        });
        this.spMinutes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AdjustTimeDialog.this.spMinutesKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spMinutes, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("ADJUSTTIMEDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("ADJUSTTIMEDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("ADJUSTTIMEDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdjustTimeDialog.this.btOKActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btOK);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("ADJUSTTIMEDIALOG.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("ADJUSTTIMEDIALOG.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("ADJUSTTIMEDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdjustTimeDialog.this.btCancelActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        this.getContentPane().add((Component)this.pnButtons, gridBagConstraints);
        this.pack();
    }

    private void spMinutesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spHoursKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spMinutesStateChanged(ChangeEvent evt) {
        Integer minutes = (Integer)this.spMinutes.getValue();
        int value = minutes;
        if (value < 0 || value > 59) {
            this.spMinutes.setValue(this.previousMinutes);
        }
    }

    private void spHoursStateChanged(ChangeEvent evt) {
        Integer hours = (Integer)this.spHours.getValue();
        int value = hours;
        if (value < 0 || value > 23) {
            this.spHours.setValue(this.previousHours);
        }
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Integer hours = (Integer)this.spHours.getValue();
        Integer minutes = (Integer)this.spMinutes.getValue();
        if (this.task == null) {
            String newTime = "" + minutes.toString();
            if (minutes < 10) {
                newTime = "0" + newTime;
            }
            newTime = hours.toString() + ":" + newTime;
            if (hours < 10) {
                newTime = "0" + newTime;
            }
            this.firePropertyChange("time_adjusted", null, newTime);
        } else {
            long newDuration = hours * 3600 + minutes * 60;
            this.task.setDuration(newDuration * 1000L);
            if (newDuration == 0L) {
                this.task.setState(Task.STATE_NEW);
            } else if (this.task.getState() == Task.STATE_NEW) {
                this.task.setState(Task.STATE_STARTED);
            }
            this.firePropertyChange("duration_corrected", null, null);
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }
}

