/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class DateDialog
extends JDialog {
    public static final int TYPE_SWITCH_DATE = 0;
    public static final int TYPE_COPY_TASK = 1;
    private int type;
    private JButton btCancel;
    private JButton btOK;
    private JComboBox cmbMonth;
    private JLabel lbSelectDate;
    private JPanel pnDays;
    private JSpinner spYear;
    private JTextField txtDate;
    private Date date = new Date();
    private Date previousYear = new Date();

    public DateDialog(Frame parent, Date date, int type) {
        this.initComponents();
        this.type = type;
        switch (type) {
            case 0: {
                this.lbSelectDate.setText(Translator.getTranslation("DATEDIALOG.SELECT_DATE"));
                break;
            }
            default: {
                this.lbSelectDate.setText(Translator.getTranslation("DATEDIALOG.COPY_TASK"));
            }
        }
        this.setLocationRelativeTo(parent);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MMMMMMMMMMMMMMMMM");
        for (int i = 0; i < 12; ++i) {
            calendar.set(2, i);
            this.cmbMonth.addItem(sdf.format(calendar.getTime()));
        }
        calendar.setTime(date);
        this.spYear.setValue(date);
        this.spYear.setEditor(new JSpinner.DateEditor(this.spYear, "yyyy"));
        this.cmbMonth.setSelectedIndex(calendar.get(2));
        this.date = date;
        this.updateDays();
        this.pack();
    }

    private void updateDays() {
        this.pnDays.removeAll();
        String dateFormat = Translator.getTranslation("FORMAT.DATE");
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        this.txtDate.setText(sdf.format(this.date));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        int dayNumber = calendar.get(5);
        int numberOfDays = calendar.getActualMaximum(5);
        Font font = this.getFont();
        JLabel specimen = new JLabel("31");
        specimen.setFont(font);
        specimen.setBorder(BorderFactory.createEtchedBorder());
        Dimension size = specimen.getPreferredSize();
        size.setSize(size.getWidth() + 2.0, size.getHeight() + 2.0);
        for (int i = 0; i < numberOfDays; ++i) {
            calendar.set(5, i + 1);
            JLabel day = new JLabel(new Integer(i + 1).toString());
            day.setPreferredSize(size);
            day.setHorizontalAlignment(0);
            int dayOfWeek = calendar.get(7);
            if (dayOfWeek == 7 | dayOfWeek == 1) {
                day.setFont(font.deriveFont(1));
            } else {
                day.setFont(font);
            }
            if (dayNumber == i + 1) {
                day.setForeground(Color.BLUE);
                day.setBorder(BorderFactory.createEtchedBorder());
                day.setFont(font.deriveFont(1));
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = i % 7;
            gridBagConstraints.gridy = i / 7;
            day.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    DateDialog.this.lbDayMouseClicked(evt);
                }
            });
            this.pnDays.add((Component)day, gridBagConstraints);
        }
        this.previousYear = (Date)this.spYear.getValue();
        this.repaint();
        this.pack();
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.lbSelectDate = new JLabel();
        this.cmbMonth = new JComboBox();
        this.spYear = new JSpinner();
        this.pnDays = new JPanel();
        this.txtDate = new JTextField();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Translator.getTranslation("DATEDIALOG.TITLE"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DateDialog.this.formMouseEntered(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lbSelectDate.setFont(this.getFont());
        this.lbSelectDate.setHorizontalAlignment(0);
        this.lbSelectDate.setLabelFor(this.cmbMonth);
        this.lbSelectDate.setText(Translator.getTranslation("DATEDIALOG.SELECT_DATE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbSelectDate, gridBagConstraints);
        this.cmbMonth.setFont(this.getFont());
        this.cmbMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDialog.this.cmbMonthActionPerformed(evt);
            }
        });
        this.cmbMonth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DateDialog.this.cmbMonthKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbMonth, gridBagConstraints);
        this.spYear.setFont(this.getFont());
        this.spYear.setModel(new SpinnerDateModel());
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DateDialog.this.spYearStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spYear, gridBagConstraints);
        this.pnDays.setBorder(BorderFactory.createEtchedBorder());
        this.pnDays.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DateDialog.this.pnDaysKeyPressed(evt);
            }
        });
        this.pnDays.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnDays, gridBagConstraints);
        this.txtDate.setEditable(false);
        this.txtDate.setFont(this.getFont());
        this.txtDate.setHorizontalAlignment(0);
        this.txtDate.setToolTipText(Translator.getTranslation("DATEDIALOG.TXT_DATE_TOOLTIP"));
        this.txtDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DateDialog.this.txtDateMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtDate, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("DATEDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("DATEDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("DATEDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDialog.this.btOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btOK, gridBagConstraints);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("DATEDIALOG.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("DATEDIALOG.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("DATEDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDialog.this.btCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btCancel, gridBagConstraints);
        this.pack();
    }

    private void pnDaysKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbMonthKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtDateMouseClicked(MouseEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.spYear.setValue(new Date());
        this.cmbMonth.setSelectedIndex(calendar.get(2));
        this.date = new Date();
        this.updateDays();
    }

    private void lbDayMouseClicked(MouseEvent evt) {
        boolean future;
        Day day;
        Plan plan;
        boolean today;
        JLabel selectedDay = (JLabel)evt.getComponent();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.set(5, Integer.parseInt(selectedDay.getText()));
        if (this.type == 1 && !((today = (plan = Plan.getDefault()).isToday(day = plan.getDay(calendar.getTime()))) | (future = plan.isFuture(day)))) {
            return;
        }
        this.date = calendar.getTime();
        this.updateDays();
    }

    private void spYearStateChanged(ChangeEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.spYear.getValue());
        int year = calendar.get(1);
        if (year < 1970) {
            this.spYear.setValue(this.previousYear);
        } else {
            calendar = Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(2, this.cmbMonth.getSelectedIndex());
            calendar.set(5, 1);
            this.date = calendar.getTime();
            this.updateDays();
        }
    }

    private void cmbMonthActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.spYear.getValue());
        calendar.set(2, this.cmbMonth.getSelectedIndex());
        calendar.set(5, 1);
        this.date = calendar.getTime();
        this.updateDays();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btOKActionPerformed(ActionEvent evt) {
        switch (this.type) {
            case 0: {
                this.firePropertyChange("date_selected_switch", null, this.date);
                break;
            }
            default: {
                this.firePropertyChange("date_selected_copy_task", null, this.date);
            }
        }
        this.setVisible(false);
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }
}

