/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.core.filters.DescriptionFilter;
import org.cesilko.rachota.core.filters.DurationFilter;
import org.cesilko.rachota.core.filters.KeywordFilter;
import org.cesilko.rachota.core.filters.PriorityFilter;
import org.cesilko.rachota.core.filters.PrivateFilter;
import org.cesilko.rachota.core.filters.StateFilter;
import org.cesilko.rachota.gui.FiltersTableModel;
import org.cesilko.rachota.gui.Tools;

public class FilterDialog
extends JDialog {
    FiltersTableModel filtersTableModel;
    AbstractTaskFilter taskFilter;
    private JButton btCancel;
    private JButton btOK;
    private JComboBox cmbContent;
    private JComboBox cmbContentRule;
    private JComboBox cmbFilterName;
    private JLabel lbFilterName;
    private JLabel lblContent;
    private JLabel lblContentRule;
    private JPanel pnButtons;
    private JTextField txtContent;

    public FilterDialog(FiltersTableModel filtersTableModel, AbstractTaskFilter taskFilter) {
        this.filtersTableModel = filtersTableModel;
        this.taskFilter = taskFilter;
        this.initComponents();
        this.cmbFilterName.addItem(new DescriptionFilter());
        this.cmbFilterName.addItem(new KeywordFilter());
        this.cmbFilterName.addItem(new DurationFilter());
        this.cmbFilterName.addItem(new PriorityFilter());
        this.cmbFilterName.addItem(new StateFilter());
        this.cmbFilterName.addItem(new PrivateFilter());
        this.cmbFilterName.setSelectedIndex(0);
        if (taskFilter instanceof KeywordFilter) {
            this.cmbFilterName.setSelectedIndex(1);
        }
        if (taskFilter instanceof DurationFilter) {
            this.cmbFilterName.setSelectedIndex(2);
        }
        if (taskFilter instanceof PriorityFilter) {
            this.cmbFilterName.setSelectedIndex(3);
        }
        if (taskFilter instanceof StateFilter) {
            this.cmbFilterName.setSelectedIndex(4);
        }
        if (taskFilter instanceof PrivateFilter) {
            this.cmbFilterName.setSelectedIndex(5);
        }
        this.setComponents(taskFilter == null ? new DescriptionFilter() : taskFilter);
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    public FilterDialog(FiltersTableModel filtersTableModel) {
        this(filtersTableModel, null);
    }

    private void initComponents() {
        this.lbFilterName = new JLabel();
        this.cmbFilterName = new JComboBox();
        this.lblContentRule = new JLabel();
        this.cmbContentRule = new JComboBox();
        this.lblContent = new JLabel();
        this.cmbContent = new JComboBox();
        this.txtContent = new JTextField();
        this.pnButtons = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setTitle(Translator.getTranslation("FILTERDIALOG.TITLE"));
        this.setModal(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FilterDialog.this.formMouseEntered(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FilterDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lbFilterName.setDisplayedMnemonic(Translator.getMnemonic("FILTERDIALOG.NAME"));
        this.lbFilterName.setFont(this.getFont());
        this.lbFilterName.setLabelFor(this.cmbFilterName);
        this.lbFilterName.setText(Translator.getTranslation("FILTERDIALOG.NAME"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbFilterName, gridBagConstraints);
        this.cmbFilterName.setFont(this.getFont());
        this.cmbFilterName.setToolTipText(Translator.getTranslation("FILTERDIALOG.NAME_TOOLTIP"));
        this.cmbFilterName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterDialog.this.cmbFilterNameItemStateChanged(evt);
            }
        });
        this.cmbFilterName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FilterDialog.this.cmbFilterNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbFilterName, gridBagConstraints);
        this.lblContentRule.setDisplayedMnemonic(Translator.getMnemonic("FILTERDIALOG.CONTENT_RULE"));
        this.lblContentRule.setFont(this.getFont());
        this.lblContentRule.setLabelFor(this.cmbContentRule);
        this.lblContentRule.setText(Translator.getTranslation("FILTERDIALOG.CONTENT_RULE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblContentRule, gridBagConstraints);
        this.cmbContentRule.setFont(this.getFont());
        this.cmbContentRule.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_RULE_TOOLTIP"));
        this.cmbContentRule.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FilterDialog.this.cmbContentRuleKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbContentRule, gridBagConstraints);
        this.lblContent.setDisplayedMnemonic(Translator.getMnemonic("FILTERDIALOG.CONTENT"));
        this.lblContent.setFont(this.getFont());
        this.lblContent.setLabelFor(this.txtContent);
        this.lblContent.setText(Translator.getTranslation("FILTERDIALOG.CONTENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblContent, gridBagConstraints);
        this.cmbContent.setFont(this.getFont());
        this.cmbContent.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_TOOLTIP"));
        this.cmbContent.setEnabled(false);
        this.cmbContent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FilterDialog.this.cmbContentKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbContent, gridBagConstraints);
        this.txtContent.setFont(this.getFont());
        this.txtContent.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_TOOLTIP"));
        this.txtContent.setPreferredSize(new Dimension(100, 19));
        this.txtContent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FilterDialog.this.txtContentKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtContent, gridBagConstraints);
        this.pnButtons.setLayout(new GridBagLayout());
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("FILTERDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("FILTERDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("FILTERDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.btOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btOK, gridBagConstraints);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("FILTERDIALOG.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("FILTERDIALOG.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("FILTERDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.btCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnButtons, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 265) / 2, (screenSize.height - 240) / 2, 265, 240);
    }

    private void cmbContentKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtContentKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbContentRuleKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbFilterNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbFilterNameItemStateChanged(ItemEvent evt) {
        AbstractTaskFilter taskFilter = (AbstractTaskFilter)this.cmbFilterName.getSelectedItem();
        this.setComponents(taskFilter);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void btOKActionPerformed(ActionEvent evt) {
        AbstractTaskFilter newTaskFilter = (AbstractTaskFilter)this.cmbFilterName.getItemAt(this.cmbFilterName.getSelectedIndex());
        newTaskFilter.setContentRule(this.cmbContentRule.getSelectedIndex());
        String content = null;
        if (newTaskFilter instanceof DescriptionFilter) {
            content = this.txtContent.getText();
        }
        if (newTaskFilter instanceof KeywordFilter) {
            content = this.txtContent.getText();
        }
        if (newTaskFilter instanceof DurationFilter) {
            long duration;
            String text = this.txtContent.getText();
            try {
                if (text.length() != 8) {
                    throw new NumberFormatException("Error: invalid task duration specified: " + text);
                }
                duration = Tools.getTime(text);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.INVALID_DURATION"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
                this.txtContent.setText(Tools.getTime(0.0));
                return;
            }
            content = Tools.getTime(duration);
        }
        if (newTaskFilter instanceof PriorityFilter) {
            content = "" + this.cmbContent.getSelectedIndex();
        }
        if (newTaskFilter instanceof StateFilter) {
            content = "" + this.cmbContent.getSelectedIndex();
        }
        if (newTaskFilter instanceof PrivateFilter) {
            content = Boolean.toString(this.cmbContent.getSelectedIndex() == 0);
        }
        newTaskFilter.setContent(content);
        if (this.taskFilter == null) {
            this.filtersTableModel.addFilter(newTaskFilter);
        } else {
            this.filtersTableModel.replaceFilter(this.taskFilter, newTaskFilter);
        }
        this.formWindowClosing(null);
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void setComponents(AbstractTaskFilter taskFilter) {
        this.cmbContentRule.removeAllItems();
        Vector contentRules = taskFilter.getContentRules();
        int length = contentRules.size();
        for (int i = 0; i < length; ++i) {
            this.cmbContentRule.addItem(contentRules.get(i));
        }
        this.cmbContentRule.setSelectedIndex(taskFilter.getContentRule());
        Vector contentValues = taskFilter.getContentValues();
        this.cmbContent.setEnabled(contentValues != null);
        this.txtContent.setEnabled(contentValues == null);
        this.cmbContent.removeAllItems();
        if (contentValues != null) {
            length = contentValues.size();
            String value = taskFilter.getContent();
            for (int i = 0; i < length; ++i) {
                this.cmbContent.addItem(contentValues.get(i));
                if (!contentValues.get(i).equals(value)) continue;
                this.cmbContent.setSelectedIndex(i);
            }
        } else {
            this.txtContent.setText(taskFilter.getContent());
        }
    }
}

