/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.core.filters.DescriptionFilter;
import org.cesilko.rachota.core.filters.DurationFilter;
import org.cesilko.rachota.core.filters.IdleFilter;
import org.cesilko.rachota.core.filters.KeywordFilter;
import org.cesilko.rachota.core.filters.PriorityFilter;
import org.cesilko.rachota.core.filters.PrivateFilter;
import org.cesilko.rachota.core.filters.StateFilter;
import org.cesilko.rachota.gui.FilterDialog;
import org.cesilko.rachota.gui.FilteredTasksTableModel;
import org.cesilko.rachota.gui.FiltersTableModel;
import org.cesilko.rachota.gui.HistoryChart;
import org.cesilko.rachota.gui.LimitedCapacityStack;
import org.cesilko.rachota.gui.PieChart;
import org.cesilko.rachota.gui.ProjectsTreeModel;
import org.cesilko.rachota.gui.ReportWizard;
import org.cesilko.rachota.gui.Tools;

public class HistoryView
extends JPanel
implements PropertyChangeListener {
    private JButton btAddFilter;
    private JButton btBackward;
    private JButton btEditFilter;
    private JButton btForward;
    private JButton btRemoveFilter;
    private JButton btReport;
    private JCheckBox chbGroupTasks;
    private JCheckBox chbHighlightTasks;
    private JComboBox cmbContent;
    private JComboBox cmbContentRule;
    private JComboBox cmbFilterName;
    private JComboBox cmbPeriod;
    private JTree jtProjects;
    private JLabel lbTasks;
    private JLabel lblChartType;
    private JLabel lblFilteredTime;
    private JLabel lblFilters;
    private JLabel lblName;
    private JLabel lblPercentage;
    private JLabel lblPeriod;
    private JLabel lblPriority;
    private JLabel lblState;
    private JLabel lblTasks;
    private JLabel lblTime;
    private JLabel lblTotalTime;
    private JPanel pnButtons;
    private JPanel pnDetails;
    private JPanel pnPeriod;
    private JPanel pnProjects;
    private JPanel pnShare;
    private JPanel pnTasks;
    private JPanel pnTimes;
    private JPanel pnTotalTime;
    private JRadioButton rbFromTo;
    private JRadioButton rbTimeUsage;
    private JRadioButton rbTotal;
    private JScrollPane spFilters;
    private JSpinner spMinus;
    private JSpinner spPlus;
    private JScrollPane spProjects;
    private JScrollPane spTasks;
    private JTable tbFilters;
    private JTable tbTasks;
    private JTabbedPane tpViews;
    private JTextField txtContent;
    private JTextField txtDate;
    private JTextField txtFilteredTime;
    private JTextField txtName;
    private JTextField txtPercentage;
    private JTextField txtPriority;
    private JTextField txtState;
    private JTextField txtTasks;
    private JTextField txtTime;
    private JTextField txtTotalTime;
    private static final int SCALE_DAY = 0;
    private static final int SCALE_WEEK = 1;
    private static final int SCALE_MONTH = 2;
    private static final int SCALE_YEAR = 3;
    private Integer previousPlus = new Integer(0);
    private Integer previousMinus = new Integer(0);
    private HistoryChart historyChart;
    private Date period = new Date();
    private static final boolean FIRST_DATE = true;
    private static final boolean LAST_DATE = false;

    public HistoryView() {
        this.initComponents();
        this.txtName.setFont(this.txtName.getFont().deriveFont(1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        PieChart pieChart = new PieChart();
        this.pnShare.add((Component)pieChart, gridBagConstraints);
        this.addPropertyChangeListener(pieChart);
        final ProjectsTreeModel model = new ProjectsTreeModel(this.getDays());
        this.jtProjects.setModel(model);
        this.jtProjects.getSelectionModel().setSelectionMode(1);
        this.jtProjects.addTreeSelectionListener(new ProjectsTreeModel.ProjectsTreeListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath treePath = event.getPath();
                int nodeType = model.getSelectedNodeType(treePath);
                Vector<String> names = new Vector<String>();
                Vector<Float> shares = new Vector<Float>();
                switch (nodeType) {
                    case 3: {
                        DefaultMutableTreeNode selectedTaskNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        ProjectsTreeModel.TaskNode taskNode = (ProjectsTreeModel.TaskNode)selectedTaskNode.getUserObject();
                        HistoryView.this.txtName.setText(taskNode.getDescription());
                        HistoryView.this.txtName.setCaretPosition(0);
                        HistoryView.this.txtName.setFont(HistoryView.this.txtName.getFont().deriveFont(1));
                        HistoryView.this.txtTime.setText(Tools.getTime(taskNode.getTotalTime()));
                        HistoryView.this.txtTasks.setText("" + taskNode.getTasks().size());
                        DefaultMutableTreeNode selectedCategoryNode = (DefaultMutableTreeNode)selectedTaskNode.getParent();
                        ProjectsTreeModel.CategoryNode category = (ProjectsTreeModel.CategoryNode)selectedCategoryNode.getUserObject();
                        float shareTask = Math.round((float)taskNode.getTotalTime() / (float)category.getTotalTime() * 100.0f);
                        HistoryView.this.txtPercentage.setText("" + shareTask + "%");
                        HistoryView.this.txtPriority.setText(Task.getPriority(taskNode.getAverageValue(0)));
                        HistoryView.this.txtState.setText(Task.getState(taskNode.getAverageValue(1)));
                        PieChart taskPieChart = (PieChart)HistoryView.this.pnShare.getComponent(0);
                        names.add(taskNode.getDescription());
                        shares.add(new Float(shareTask));
                        taskPieChart.setShares(names, shares);
                        break;
                    }
                    case 2: {
                        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        ProjectsTreeModel.CategoryNode categoryNode = (ProjectsTreeModel.CategoryNode)selectedNode.getUserObject();
                        LimitedCapacityStack categoryStack = new LimitedCapacityStack(3);
                        for (ProjectsTreeModel.TaskNode node : categoryNode.getTaskNodes()) {
                            float share = Math.round((float)node.getTotalTime() / (float)categoryNode.getTotalTime() * 100.0f);
                            categoryStack.put(new Float(share), node.getDescription());
                        }
                        HistoryView.this.txtName.setText(categoryNode.getName());
                        HistoryView.this.txtTime.setText(Tools.getTime(categoryNode.getTotalTime()));
                        HistoryView.this.txtTasks.setText("" + categoryNode.getTaskNodes().size());
                        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                        float shareCategory = Math.round((float)categoryNode.getTotalTime() / (float)Tools.getTotalTime(true, includePrivateTime, HistoryView.this.getDays()) * 100.0f);
                        HistoryView.this.txtPercentage.setText("" + shareCategory + "%");
                        HistoryView.this.txtPriority.setText(Task.getPriority(categoryNode.getAverageValue(0)));
                        HistoryView.this.txtState.setText(Task.getState(categoryNode.getAverageValue(1)));
                        PieChart categoryPieChart = (PieChart)HistoryView.this.pnShare.getComponent(0);
                        categoryPieChart.setShares(categoryStack.getObjects(), categoryStack.getKeys());
                        break;
                    }
                    default: {
                        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        long totalTime = 0L;
                        int priority = 0;
                        int state = 0;
                        int tasks = 0;
                        int count = rootNode.getChildCount();
                        LimitedCapacityStack rootStack = new LimitedCapacityStack(3);
                        if (count != 1) {
                            Enumeration<TreeNode> children = rootNode.children();
                            while (children.hasMoreElements()) {
                                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)children.nextElement();
                                ProjectsTreeModel.CategoryNode node = (ProjectsTreeModel.CategoryNode)subNode.getUserObject();
                                totalTime += node.getTotalTime();
                                priority += node.getAverageValue(0);
                                state += node.getAverageValue(1);
                                tasks += node.getTaskNodes().size();
                                float share = Math.round((float)node.getTotalTime() / (float)Tools.getTotalTime(true, true, HistoryView.this.getDays()) * 100.0f);
                                rootStack.put(new Float(share), node.getName());
                            }
                            priority /= count;
                            state /= count;
                        }
                        HistoryView.this.txtName.setText(rootNode.getUserObject().toString());
                        HistoryView.this.txtTime.setText(Tools.getTime(totalTime));
                        HistoryView.this.txtPercentage.setText("100%");
                        if (count != 1) {
                            HistoryView.this.txtTasks.setText("" + tasks);
                            HistoryView.this.txtPriority.setText(Task.getPriority(priority));
                            HistoryView.this.txtState.setText(Task.getState(state));
                        } else {
                            HistoryView.this.txtTasks.setText("0");
                            HistoryView.this.txtPriority.setText("");
                            HistoryView.this.txtState.setText("");
                        }
                        PieChart emptyPieChart = (PieChart)HistoryView.this.pnShare.getComponent(0);
                        emptyPieChart.setShares(rootStack.getObjects(), rootStack.getKeys());
                    }
                }
            }
        });
        this.tbFilters.getSelectionModel().setSelectionMode(0);
        this.tbTasks.getSelectionModel().setSelectionMode(0);
        this.cmbPeriod.addItem(Translator.getTranslation("HISTORYVIEW.PERIOD_0"));
        this.cmbPeriod.addItem(Translator.getTranslation("HISTORYVIEW.PERIOD_1"));
        this.cmbPeriod.addItem(Translator.getTranslation("HISTORYVIEW.PERIOD_2"));
        this.cmbPeriod.addItem(Translator.getTranslation("HISTORYVIEW.PERIOD_3"));
        this.historyChart = new HistoryChart(this.getDays(), null, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.historyChart, gridBagConstraints);
        this.historyChart.setToolTipText(Translator.getTranslation("HISTORYVIEW.CHART_TOOLTIP"));
        this.historyChart.addMouseListener(new MouseAdapter(){
            Date clickedWhen = new Date();
            Point clickedWhere = new Point();

            @Override
            public void mouseClicked(MouseEvent e) {
                Day day;
                Date now = new Date();
                long delay = now.getTime() - this.clickedWhen.getTime();
                boolean samePoint = this.clickedWhere.equals(e.getPoint());
                if (samePoint & delay < 250L && (day = HistoryView.this.historyChart.getDayAt(e.getPoint())) != null) {
                    HistoryView.this.firePropertyChange("day", null, day);
                }
                this.clickedWhere = e.getPoint();
                this.clickedWhen = now;
                Tools.recordActivity();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Tools.recordActivity();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Tools.recordActivity();
            }
        });
        this.cmbPeriod.setSelectedIndex(1);
        this.checkButtons();
        this.filterTasks();
        this.tbFilters.getTableHeader().setForeground(Color.BLUE);
        this.tbFilters.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.tbFilters.getTableHeader().setFont(this.getFont());
        this.tbFilters.setFont(this.getFont());
        this.tbFilters.setRowHeight(this.getFont().getSize() + 2);
        this.tbTasks.getTableHeader().setForeground(Color.BLUE);
        this.tbTasks.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.tbTasks.getTableHeader().setFont(this.getFont());
        this.tbTasks.setFont(this.getFont());
        this.tbTasks.setRowHeight(this.getFont().getSize() + 2);
        this.cmbFilterName.addItem(new DescriptionFilter().toString());
        this.cmbFilterName.addItem(new KeywordFilter().toString());
        this.cmbFilterName.addItem(new DurationFilter().toString());
        this.cmbFilterName.addItem(new PriorityFilter().toString());
        this.cmbFilterName.addItem(new StateFilter().toString());
        this.cmbFilterName.addItem(new PrivateFilter().toString());
        this.loadSetup();
        this.tbTasks.getColumn(Translator.getTranslation("TASKS.DESCRIPTION")).setPreferredWidth(280);
        this.tbTasks.getColumn(Translator.getTranslation("TASKS.DURATION_DAYS")).setPreferredWidth(50);
        this.tbTasks.setRowSelectionAllowed(false);
        JPopupMenu copyPopupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem(Translator.getTranslation("HISTORYVIEW.BT_COPY_TASK_TODAY"));
        MouseActionAdapter mouseActionAdapter = new MouseActionAdapter(copyPopupMenu);
        copyItem.addActionListener(mouseActionAdapter);
        copyPopupMenu.add(copyItem);
        this.tbTasks.addMouseListener(mouseActionAdapter);
        this.tbTasks.getTableHeader().addMouseListener(new MouseAdapter(){
            Point pressedPoint;

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressedPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.getPoint().equals(this.pressedPoint)) {
                    return;
                }
                int column = HistoryView.this.tbTasks.getTableHeader().columnAtPoint(e.getPoint());
                FilteredTasksTableModel filteredTasksTableModel = (FilteredTasksTableModel)HistoryView.this.tbTasks.getModel();
                filteredTasksTableModel.sortTable(column, true);
                int columns = HistoryView.this.tbTasks.getColumnCount();
                for (int i = 0; i < columns; ++i) {
                    HistoryView.this.tbTasks.getColumnModel().getColumn(i).setHeaderValue(filteredTasksTableModel.getColumnName(i));
                }
            }
        });
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.lblPeriod = new JLabel();
        this.cmbPeriod = new JComboBox();
        this.btReport = new JButton();
        this.pnPeriod = new JPanel();
        this.spMinus = new JSpinner();
        this.btBackward = new JButton();
        this.txtDate = new JTextField();
        this.btForward = new JButton();
        this.spPlus = new JSpinner();
        this.tpViews = new JTabbedPane();
        this.pnTimes = new JPanel();
        this.lblChartType = new JLabel();
        this.rbTotal = new JRadioButton();
        this.rbFromTo = new JRadioButton();
        this.rbTimeUsage = new JRadioButton();
        this.chbHighlightTasks = new JCheckBox();
        this.cmbFilterName = new JComboBox();
        this.cmbContentRule = new JComboBox();
        this.cmbContent = new JComboBox();
        this.txtContent = new JTextField();
        this.lblTotalTime = new JLabel();
        this.txtTotalTime = new JTextField();
        this.pnTasks = new JPanel();
        this.lblFilters = new JLabel();
        this.spFilters = new JScrollPane();
        this.tbFilters = new JTable();
        this.pnButtons = new JPanel();
        this.btAddFilter = new JButton();
        this.btEditFilter = new JButton();
        this.btRemoveFilter = new JButton();
        this.lblTasks = new JLabel();
        this.spTasks = new JScrollPane();
        this.tbTasks = new JTable();
        this.chbGroupTasks = new JCheckBox();
        this.pnTotalTime = new JPanel();
        this.lblFilteredTime = new JLabel();
        this.txtFilteredTime = new JTextField();
        this.pnProjects = new JPanel();
        this.spProjects = new JScrollPane();
        this.jtProjects = new JTree();
        this.pnDetails = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblTime = new JLabel();
        this.txtTime = new JTextField();
        this.lblPercentage = new JLabel();
        this.txtPercentage = new JTextField();
        this.lbTasks = new JLabel();
        this.txtTasks = new JTextField();
        this.lblPriority = new JLabel();
        this.txtPriority = new JTextField();
        this.lblState = new JLabel();
        this.txtState = new JTextField();
        this.pnShare = new JPanel();
        this.setName(Translator.getTranslation("HISTORYVIEW.TB_NAME"));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.lblPeriod.setDisplayedMnemonic(Translator.getMnemonic("HISTORYVIEW.LBL_PERIOD"));
        this.lblPeriod.setFont(this.getFont());
        this.lblPeriod.setLabelFor(this.cmbPeriod);
        this.lblPeriod.setText(Translator.getTranslation("HISTORYVIEW.LBL_PERIOD"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblPeriod, gridBagConstraints);
        this.cmbPeriod.setFont(this.getFont());
        this.cmbPeriod.setToolTipText(Translator.getTranslation("HISTORYVIEW.PERIOD_TOOLTIP"));
        this.cmbPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HistoryView.this.cmbPeriodItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cmbPeriod, gridBagConstraints);
        this.btReport.setFont(this.getFont());
        this.btReport.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/report.png")));
        this.btReport.setMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_REPORT"));
        this.btReport.setText(Translator.getTranslation("HISTORYVIEW.BT_REPORT"));
        this.btReport.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_REPORT_TOOLTIP"));
        this.btReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btReport, gridBagConstraints);
        this.spMinus.setFont(this.getFont());
        this.spMinus.setToolTipText(Translator.getTranslation("HISTORYVIEW.SP_MINUS_TOOLTIP"));
        this.spMinus.setPreferredSize(new Dimension(60, 23));
        this.spMinus.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistoryView.this.spMinusStateChanged(evt);
            }
        });
        this.pnPeriod.add(this.spMinus);
        this.btBackward.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/previous.png")));
        this.btBackward.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_BACKWARD_TOOLTIP"));
        this.btBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btBackwardActionPerformed(evt);
            }
        });
        this.pnPeriod.add(this.btBackward);
        this.txtDate.setEditable(false);
        this.txtDate.setFont(this.getFont());
        this.txtDate.setHorizontalAlignment(0);
        this.txtDate.setToolTipText(Translator.getTranslation("HISTORYVIEW.TXT_DATE_TOOLTIP"));
        this.txtDate.setPreferredSize(new Dimension(200, 23));
        this.txtDate.setRequestFocusEnabled(false);
        this.txtDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HistoryView.this.txtDateMouseClicked(evt);
            }
        });
        this.pnPeriod.add(this.txtDate);
        this.btForward.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/next.png")));
        this.btForward.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_FORWARD_TOOLTIP"));
        this.btForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btForwardActionPerformed(evt);
            }
        });
        this.pnPeriod.add(this.btForward);
        this.spPlus.setFont(this.getFont());
        this.spPlus.setToolTipText(Translator.getTranslation("HISTORYVIEW.SP_PLUS_TOOLTIP"));
        this.spPlus.setPreferredSize(new Dimension(60, 23));
        this.spPlus.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistoryView.this.spPlusStateChanged(evt);
            }
        });
        this.pnPeriod.add(this.spPlus);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnPeriod, gridBagConstraints);
        this.tpViews.setFont(this.getFont());
        this.pnTimes.setFont(this.getFont());
        this.pnTimes.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.pnTimesMouseMoved(evt);
            }
        });
        this.pnTimes.setLayout(new GridBagLayout());
        this.lblChartType.setDisplayedMnemonic(Translator.getMnemonic("HISTORYVIEW.LBL_CHART_TYPE"));
        this.lblChartType.setFont(this.getFont());
        this.lblChartType.setLabelFor(this.rbFromTo);
        this.lblChartType.setText(Translator.getTranslation("HISTORYVIEW.LBL_CHART_TYPE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.lblChartType, gridBagConstraints);
        this.rbTotal.setFont(this.getFont());
        this.rbTotal.setSelected(true);
        this.rbTotal.setText(Translator.getTranslation("HISTORYVIEW.TYPE_TOTAL"));
        this.rbTotal.setToolTipText(Translator.getTranslation("HISTORYVIEW.TYPE_TOTAL_TOOLTIP"));
        this.rbTotal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.rbTotalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.rbTotal, gridBagConstraints);
        this.rbFromTo.setFont(this.getFont());
        this.rbFromTo.setText(Translator.getTranslation("HISTORYVIEW.TYPE_FROM_TO"));
        this.rbFromTo.setToolTipText(Translator.getTranslation("HISTORYVIEW.TYPE_FROM_TO_TOOLTIP"));
        this.rbFromTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.rbFromToActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnTimes.add((Component)this.rbFromTo, gridBagConstraints);
        this.rbTimeUsage.setFont(this.getFont());
        this.rbTimeUsage.setText(Translator.getTranslation("HISTORYVIEW.TYPE_TIME_USAGE"));
        this.rbTimeUsage.setToolTipText(Translator.getTranslation("HISTORYVIEW.TYPE_TIME_USAGE_TOOLTIP"));
        this.rbTimeUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.rbTimeUsageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnTimes.add((Component)this.rbTimeUsage, gridBagConstraints);
        this.chbHighlightTasks.setFont(this.getFont());
        this.chbHighlightTasks.setMnemonic(Translator.getMnemonic("HISTORYVIEW.LBL_HIGHLIGHT_TASKS"));
        this.chbHighlightTasks.setText(Translator.getTranslation("HISTORYVIEW.LBL_HIGHLIGHT_TASKS"));
        this.chbHighlightTasks.setToolTipText(Translator.getTranslation("HISTORYVIEW.LBL_HIGHLIGHT_TASKS_TOOLTIP"));
        this.chbHighlightTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.chbHighlightTasksActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.chbHighlightTasks, gridBagConstraints);
        this.cmbFilterName.setFont(this.getFont());
        this.cmbFilterName.setToolTipText(Translator.getTranslation("FILTERDIALOG.NAME_TOOLTIP"));
        this.cmbFilterName.setEnabled(false);
        this.cmbFilterName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HistoryView.this.cmbFilterNameItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.cmbFilterName, gridBagConstraints);
        this.cmbContentRule.setFont(this.getFont());
        this.cmbContentRule.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_RULE_TOOLTIP"));
        this.cmbContentRule.setEnabled(false);
        this.cmbContentRule.setPreferredSize(new Dimension(100, 22));
        this.cmbContentRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HistoryView.this.cmbContentRuleItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.cmbContentRule, gridBagConstraints);
        this.cmbContent.setFont(this.getFont());
        this.cmbContent.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_TOOLTIP"));
        this.cmbContent.setEnabled(false);
        this.cmbContent.setPreferredSize(new Dimension(100, 22));
        this.cmbContent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HistoryView.this.cmbContentItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.cmbContent, gridBagConstraints);
        this.txtContent.setFont(this.getFont());
        this.txtContent.setToolTipText(Translator.getTranslation("FILTERDIALOG.CONTENT_TOOLTIP"));
        this.txtContent.setEnabled(false);
        this.txtContent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HistoryView.this.txtContentKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.txtContent, gridBagConstraints);
        this.lblTotalTime.setFont(this.getFont());
        this.lblTotalTime.setLabelFor(this.txtTotalTime);
        this.lblTotalTime.setText(Translator.getTranslation("HISTORYVIEW.LBL_TOTAL_TIME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.lblTotalTime, gridBagConstraints);
        this.txtTotalTime.setEditable(false);
        this.txtTotalTime.setFont(this.getFont());
        this.txtTotalTime.setHorizontalAlignment(4);
        this.txtTotalTime.setToolTipText(Translator.getTranslation("HISTORYVIEW.TXT_TOTAL_TIME_TOOLTIP"));
        this.txtTotalTime.setMinimumSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimes.add((Component)this.txtTotalTime, gridBagConstraints);
        this.tpViews.addTab(Translator.getTranslation("HISTORYVIEW.TIMES_TAB_NAME"), this.pnTimes);
        this.pnTasks.setFont(this.getFont());
        this.pnTasks.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.pnTasksMouseMoved(evt);
            }
        });
        this.pnTasks.setLayout(new GridBagLayout());
        this.lblFilters.setDisplayedMnemonic(Translator.getMnemonic("HISTORYVIEW.LBL_FILTERS"));
        this.lblFilters.setFont(this.getFont());
        this.lblFilters.setLabelFor(this.tbFilters);
        this.lblFilters.setText(Translator.getTranslation("HISTORYVIEW.LBL_FILTERS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.lblFilters, gridBagConstraints);
        this.spFilters.setMinimumSize(new Dimension(453, 80));
        this.spFilters.setPreferredSize(new Dimension(453, 80));
        this.spFilters.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.spFiltersMouseMoved(evt);
            }
        });
        this.tbFilters.setFont(this.getFont());
        this.tbFilters.setModel(new FiltersTableModel());
        this.tbFilters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HistoryView.this.tbFiltersMouseClicked(evt);
            }
        });
        this.tbFilters.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HistoryView.this.tbFiltersKeyReleased(evt);
            }
        });
        this.spFilters.setViewportView(this.tbFilters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.spFilters, gridBagConstraints);
        this.pnButtons.setLayout(new GridBagLayout());
        this.btAddFilter.setFont(this.getFont());
        this.btAddFilter.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/new_filter.png")));
        this.btAddFilter.setMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_ADD_FILTER"));
        this.btAddFilter.setText(Translator.getTranslation("HISTORYVIEW.BT_ADD_FILTER"));
        this.btAddFilter.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_ADD_FILTER_TOOLTIP"));
        this.btAddFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btAddFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btAddFilter, gridBagConstraints);
        this.btEditFilter.setFont(this.getFont());
        this.btEditFilter.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/edit_filter.png")));
        this.btEditFilter.setMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_EDIT_FILTER"));
        this.btEditFilter.setText(Translator.getTranslation("HISTORYVIEW.BT_EDIT_FILTER"));
        this.btEditFilter.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_EDIT_FILTER_TOOLTIP"));
        this.btEditFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btEditFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btEditFilter, gridBagConstraints);
        this.btRemoveFilter.setFont(this.getFont());
        this.btRemoveFilter.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/remove_filter.png")));
        this.btRemoveFilter.setMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_REMOVE_FILTER"));
        this.btRemoveFilter.setText(Translator.getTranslation("HISTORYVIEW.BT_REMOVE_FILTER"));
        this.btRemoveFilter.setToolTipText(Translator.getTranslation("HISTORYVIEW.BT_REMOVE_FILTER_TOOLTIP"));
        this.btRemoveFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.btRemoveFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btRemoveFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.pnButtons, gridBagConstraints);
        this.lblTasks.setDisplayedMnemonic(Translator.getMnemonic("HISTORYVIEW.LBL_TASKS"));
        this.lblTasks.setFont(this.getFont());
        this.lblTasks.setLabelFor(this.tbTasks);
        this.lblTasks.setText(Translator.getTranslation("HISTORYVIEW.LBL_TASKS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.lblTasks, gridBagConstraints);
        this.spTasks.setPreferredSize(new Dimension(453, 100));
        this.spTasks.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.spTasksMouseMoved(evt);
            }
        });
        this.tbTasks.setModel(new FilteredTasksTableModel());
        this.spTasks.setViewportView(this.tbTasks);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.spTasks, gridBagConstraints);
        this.chbGroupTasks.setFont(this.getFont());
        this.chbGroupTasks.setMnemonic(Translator.getMnemonic("HISTORYVIEW.CHB_GROUP_TASKS"));
        this.chbGroupTasks.setSelected(true);
        this.chbGroupTasks.setText(Translator.getTranslation("HISTORYVIEW.CHB_GROUP_TASKS"));
        this.chbGroupTasks.setToolTipText(Translator.getTranslation("HISTORYVIEW.CHB_GROUP_TASKS_TOOLTIP"));
        this.chbGroupTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryView.this.chbGroupTasksActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.chbGroupTasks, gridBagConstraints);
        this.pnTotalTime.setLayout(new GridBagLayout());
        this.lblFilteredTime.setFont(this.getFont());
        this.lblFilteredTime.setLabelFor(this.txtFilteredTime);
        this.lblFilteredTime.setText(Translator.getTranslation("HISTORYVIEW.LBL_FILTERED_TIME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTotalTime.add((Component)this.lblFilteredTime, gridBagConstraints);
        this.txtFilteredTime.setEditable(false);
        this.txtFilteredTime.setFont(this.getFont());
        this.txtFilteredTime.setHorizontalAlignment(4);
        this.txtFilteredTime.setToolTipText(Translator.getTranslation("HISTORYVIEW.TXT_FILTERED_TIME_TOOLTIP"));
        this.txtFilteredTime.setMinimumSize(new Dimension(80, 19));
        this.txtFilteredTime.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTotalTime.add((Component)this.txtFilteredTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTasks.add((Component)this.pnTotalTime, gridBagConstraints);
        this.tpViews.addTab(Translator.getTranslation("HISTORYVIEW.TASKS_TAB_NAME"), this.pnTasks);
        this.pnProjects.setFont(this.getFont());
        this.pnProjects.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.pnProjectsMouseMoved(evt);
            }
        });
        this.pnProjects.setLayout(new GridBagLayout());
        this.spProjects.setPreferredSize(new Dimension(81, 100));
        this.jtProjects.setFont(this.getFont());
        this.jtProjects.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                HistoryView.this.jtProjectsMouseMoved(evt);
            }
        });
        this.spProjects.setViewportView(this.jtProjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnProjects.add((Component)this.spProjects, gridBagConstraints);
        this.pnDetails.setBorder(BorderFactory.createTitledBorder(null, Translator.getTranslation("HISTORYVIEW.PN_DETAILS"), 0, 0, this.getFont(), new Color(0, 0, 255)));
        this.pnDetails.setLayout(new GridBagLayout());
        this.lblName.setFont(this.getFont());
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setEditable(false);
        this.txtName.setFont(this.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtName, gridBagConstraints);
        this.lblTime.setFont(this.getFont());
        this.lblTime.setLabelFor(this.txtTime);
        this.lblTime.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_TIME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lblTime, gridBagConstraints);
        this.txtTime.setEditable(false);
        this.txtTime.setFont(this.getFont());
        this.txtTime.setHorizontalAlignment(0);
        this.txtTime.setMinimumSize(new Dimension(70, 20));
        this.txtTime.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtTime, gridBagConstraints);
        this.lblPercentage.setFont(this.getFont());
        this.lblPercentage.setLabelFor(this.txtPercentage);
        this.lblPercentage.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_PERCENTAGE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lblPercentage, gridBagConstraints);
        this.txtPercentage.setEditable(false);
        this.txtPercentage.setFont(this.getFont());
        this.txtPercentage.setHorizontalAlignment(0);
        this.txtPercentage.setMinimumSize(new Dimension(80, 20));
        this.txtPercentage.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtPercentage, gridBagConstraints);
        this.lbTasks.setFont(this.getFont());
        this.lbTasks.setLabelFor(this.txtTasks);
        this.lbTasks.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_TASKS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lbTasks, gridBagConstraints);
        this.txtTasks.setEditable(false);
        this.txtTasks.setFont(this.getFont());
        this.txtTasks.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtTasks, gridBagConstraints);
        this.lblPriority.setFont(this.getFont());
        this.lblPriority.setLabelFor(this.txtPriority);
        this.lblPriority.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_PRIORITY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lblPriority, gridBagConstraints);
        this.txtPriority.setEditable(false);
        this.txtPriority.setFont(this.getFont());
        this.txtPriority.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtPriority, gridBagConstraints);
        this.lblState.setFont(this.getFont());
        this.lblState.setLabelFor(this.txtState);
        this.lblState.setText(Translator.getTranslation("HISTORYVIEW.LBL_DETAILS_STATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.lblState, gridBagConstraints);
        this.txtState.setEditable(false);
        this.txtState.setFont(this.getFont());
        this.txtState.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.txtState, gridBagConstraints);
        this.pnShare.setBorder(BorderFactory.createEtchedBorder());
        this.pnShare.setMinimumSize(new Dimension(100, 100));
        this.pnShare.setPreferredSize(new Dimension(100, 100));
        this.pnShare.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDetails.add((Component)this.pnShare, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnProjects.add((Component)this.pnDetails, gridBagConstraints);
        this.tpViews.addTab(Translator.getTranslation("HISTORYVIEW.PROJECTS_TAB_NAME"), this.pnProjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.tpViews, gridBagConstraints);
    }

    private void rbTimeUsageActionPerformed(ActionEvent evt) {
        this.rbTotal.setSelected(false);
        this.rbFromTo.setSelected(false);
        this.rbTimeUsage.setSelected(true);
        this.chbHighlightTasks.setEnabled(false);
        this.historyChart.setChartType(2);
        this.setComponents();
    }

    private void tbFiltersKeyReleased(KeyEvent evt) {
        this.checkButtons();
    }

    private void btReportActionPerformed(ActionEvent evt) {
        FiltersTableModel filtersTableModel = (FiltersTableModel)this.tbFilters.getModel();
        Vector<AbstractTaskFilter> selectFilters = new Vector<AbstractTaskFilter>();
        int count = filtersTableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            selectFilters.add(filtersTableModel.getFilter(i));
        }
        new ReportWizard(this.getDays(), this.historyChart, this.getFilter(), selectFilters).setVisible(true);
    }

    private void chbHighlightTasksActionPerformed(ActionEvent evt) {
        this.setComponents();
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void rbFromToActionPerformed(ActionEvent evt) {
        this.rbTotal.setSelected(false);
        this.rbTimeUsage.setSelected(false);
        this.rbFromTo.setSelected(true);
        this.chbHighlightTasks.setEnabled(false);
        this.historyChart.setChartType(1);
        this.setComponents();
    }

    private void rbTotalActionPerformed(ActionEvent evt) {
        this.rbTotal.setSelected(true);
        this.rbFromTo.setSelected(false);
        this.rbTimeUsage.setSelected(false);
        this.chbHighlightTasks.setEnabled(true);
        this.historyChart.setChartType(0);
        this.setComponents();
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void txtContentKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.historyChart.setHighlightingFilter(this.getFilter());
        }
    }

    private void cmbContentItemStateChanged(ItemEvent evt) {
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void cmbContentRuleItemStateChanged(ItemEvent evt) {
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void cmbFilterNameItemStateChanged(ItemEvent evt) {
        this.setComponents();
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void chbGroupTasksActionPerformed(ActionEvent evt) {
        FilteredTasksTableModel filteredTasksTableModel = (FilteredTasksTableModel)this.tbTasks.getModel();
        filteredTasksTableModel.setGroupSameTasks(this.chbGroupTasks.isSelected());
    }

    private void tbFiltersMouseClicked(MouseEvent evt) {
        this.checkButtons();
    }

    private void btEditFilterActionPerformed(ActionEvent evt) {
        int row = this.tbFilters.getSelectedRow();
        FiltersTableModel tableModel = (FiltersTableModel)this.tbFilters.getModel();
        AbstractTaskFilter taskFilter = tableModel.getFilter(row);
        FilterDialog dialog = new FilterDialog(tableModel, taskFilter);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.checkButtons();
        this.filterTasks();
    }

    private void btRemoveFilterActionPerformed(ActionEvent evt) {
        int row = this.tbFilters.getSelectedRow();
        FiltersTableModel tableModel = (FiltersTableModel)this.tbFilters.getModel();
        AbstractTaskFilter taskFilter = tableModel.getFilter(row);
        tableModel.removeFilter(taskFilter);
        this.checkButtons();
        this.filterTasks();
    }

    private void btAddFilterActionPerformed(ActionEvent evt) {
        FiltersTableModel tableModel = (FiltersTableModel)this.tbFilters.getModel();
        FilterDialog dialog = new FilterDialog(tableModel);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.checkButtons();
        this.filterTasks();
    }

    private void txtDateMouseClicked(MouseEvent evt) {
        this.period = new Date();
        this.cmbPeriodItemStateChanged(null);
    }

    private void cmbPeriodItemStateChanged(ItemEvent evt) {
        int scale = this.cmbPeriod.getSelectedIndex();
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        switch (scale) {
            case 3: {
                String format = Translator.getTranslation("FORMAT.YEAR");
                sdf.applyPattern(format);
                this.txtDate.setText(Tools.replaceAll(sdf.format(this.period), "|", (String)this.cmbPeriod.getSelectedItem()));
                break;
            }
            case 2: {
                String format = Translator.getTranslation("FORMAT.MONTH");
                sdf.applyPattern(format);
                this.txtDate.setText(sdf.format(this.period));
                break;
            }
            case 1: {
                String format = Translator.getTranslation("FORMAT.WEEK");
                sdf.applyPattern(format);
                this.txtDate.setText(Tools.replaceAll(sdf.format(this.period), "|", (String)this.cmbPeriod.getSelectedItem()));
                break;
            }
            default: {
                String format = Translator.getTranslation("FORMAT.DATE");
                sdf.applyPattern(format);
                this.txtDate.setText(sdf.format(this.period));
            }
        }
        if (this.historyChart != null) {
            this.historyChart.setDays(this.getDays());
        }
        this.filterTasks();
        this.updateTotalTime();
        ProjectsTreeModel model = (ProjectsTreeModel)this.jtProjects.getModel();
        model.setDays(this.getDays());
        this.jtProjects.setSelectionRow(0);
    }

    private void btForwardActionPerformed(ActionEvent evt) {
        this.period = this.shiftPeriod(1);
        this.cmbPeriodItemStateChanged(null);
        this.updateTotalTime();
        ProjectsTreeModel model = (ProjectsTreeModel)this.jtProjects.getModel();
        model.setDays(this.getDays());
        this.jtProjects.setSelectionRow(0);
    }

    private void btBackwardActionPerformed(ActionEvent evt) {
        this.period = this.shiftPeriod(-1);
        this.cmbPeriodItemStateChanged(null);
        this.updateTotalTime();
        ProjectsTreeModel model = (ProjectsTreeModel)this.jtProjects.getModel();
        model.setDays(this.getDays());
        this.jtProjects.setSelectionRow(0);
    }

    private void spPlusStateChanged(ChangeEvent evt) {
        Integer plus = (Integer)this.spPlus.getValue();
        int value = plus;
        if (value < 0) {
            this.spPlus.setValue(this.previousPlus);
        } else {
            this.previousPlus = plus;
        }
        this.historyChart.setDays(this.getDays());
        this.filterTasks();
        this.updateTotalTime();
        ProjectsTreeModel model = (ProjectsTreeModel)this.jtProjects.getModel();
        model.setDays(this.getDays());
        this.jtProjects.setSelectionRow(0);
    }

    private void spMinusStateChanged(ChangeEvent evt) {
        Integer minus = (Integer)this.spMinus.getValue();
        int value = minus;
        if (value > 0) {
            this.spMinus.setValue(this.previousMinus);
        } else {
            this.previousMinus = minus;
        }
        this.historyChart.setDays(this.getDays());
        this.filterTasks();
        this.updateTotalTime();
        ProjectsTreeModel model = (ProjectsTreeModel)this.jtProjects.getModel();
        model.setDays(this.getDays());
        this.jtProjects.setSelectionRow(0);
    }

    private void formMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void pnTimesMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void pnTasksMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void pnProjectsMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void jtProjectsMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void spFiltersMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void spTasksMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private Date shiftPeriod(int step) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.period);
        int scale = this.cmbPeriod.getSelectedIndex();
        switch (scale) {
            case 3: {
                calendar.add(1, step);
                break;
            }
            case 2: {
                calendar.add(2, step);
                break;
            }
            case 1: {
                calendar.add(3, step);
                break;
            }
            default: {
                calendar.add(6, step);
            }
        }
        return calendar.getTime();
    }

    private Date getDate(boolean date) {
        Calendar calendar = Calendar.getInstance();
        int offset = date ? this.previousMinus.intValue() : this.previousPlus.intValue();
        calendar.setTime(this.shiftPeriod(offset));
        int scale = this.cmbPeriod.getSelectedIndex();
        offset = 1;
        switch (scale) {
            case 3: {
                if (!date) {
                    offset = calendar.getActualMaximum(6);
                }
                calendar.set(6, offset);
                break;
            }
            case 2: {
                if (!date) {
                    offset = calendar.getActualMaximum(5);
                }
                calendar.set(5, offset);
                break;
            }
            case 1: {
                offset = calendar.getFirstDayOfWeek();
                if (!date) {
                    offset += 6;
                }
                calendar.set(7, offset);
            }
        }
        return calendar.getTime();
    }

    private Vector getDays() {
        Vector<Day> days = new Vector<Day>();
        Calendar calendar = Calendar.getInstance();
        Plan plan = Plan.getDefault();
        Date firstDate = this.getDate(true);
        Date lastDate = this.getDate(false);
        calendar.setTime(lastDate);
        String lastDayID = plan.getDayID(calendar);
        Day day = plan.getDay(firstDate);
        days.add(day);
        while (true) {
            calendar.setTime(day.getDate());
            if (plan.getDayID(calendar).equals(lastDayID)) break;
            day = plan.getDayAfter(day);
            days.add(day);
        }
        return days;
    }

    private void checkButtons() {
        int row = this.tbFilters.getSelectedRow();
        this.btRemoveFilter.setEnabled(row != -1);
        this.btEditFilter.setEnabled(row != -1);
    }

    private void filterTasks() {
        Vector filteredTasks = new Vector();
        for (Day day : this.getDays()) {
            filteredTasks.addAll(day.getTasks());
        }
        FiltersTableModel filtersTableModel = (FiltersTableModel)this.tbFilters.getModel();
        Vector filters = (Vector)filtersTableModel.getFilters().clone();
        filters.add(new IdleFilter(1, new Boolean(true)));
        for (AbstractTaskFilter abstractTaskFilter : filters) {
            filteredTasks = abstractTaskFilter.filterTasks(filteredTasks);
        }
        FilteredTasksTableModel filteredTasksTableModel = (FilteredTasksTableModel)this.tbTasks.getModel();
        filteredTasksTableModel.setTasks(filteredTasks);
        this.txtFilteredTime.setText(Tools.getTime(filteredTasksTableModel.getTotalTime()));
    }

    private void loadSetup() {
        Settings settings = Settings.getDefault();
        if (settings.getSetting("history.period") == null) {
            return;
        }
        this.cmbPeriod.setSelectedIndex(Integer.parseInt((String)settings.getSetting("history.period")));
        this.chbGroupTasks.setSelected(settings.getSetting("history.group").toString().equals("true"));
        int filtersCount = Integer.parseInt((String)settings.getSetting("history.filters"));
        for (int i = 0; i < filtersCount; ++i) {
            String filterData = (String)settings.getSetting("history.filter." + i);
            String filterName = filterData.substring(1, filterData.indexOf(","));
            String filterContentRule = filterData.substring(filterData.indexOf(",") + 1, filterData.lastIndexOf(","));
            String filterContent = filterData.substring(filterData.lastIndexOf(",") + 1, filterData.length() - 1);
            try {
                AbstractTaskFilter filter = (AbstractTaskFilter)Class.forName(filterName).newInstance();
                filter.setContentRule(Integer.parseInt(filterContentRule));
                filter.setContent(filterContent);
                FiltersTableModel filtersModel = (FiltersTableModel)this.tbFilters.getModel();
                filtersModel.addFilter(filter);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error: Cannot load this filter: " + filterData);
                exception.printStackTrace();
            }
        }
        this.filterTasks();
        this.rbTotal.setSelected(false);
        this.rbFromTo.setSelected(false);
        this.rbTimeUsage.setSelected(false);
        this.chbHighlightTasks.setEnabled(false);
        String chartType = (String)settings.getSetting("history.chart");
        if (chartType.equals("time")) {
            this.rbTotal.setSelected(true);
            this.chbHighlightTasks.setEnabled(true);
            this.historyChart.setChartType(0);
            this.chbHighlightTasks.setSelected(settings.getSetting("history.highlight").toString().equals("true"));
        }
        if (chartType.equals("from/to")) {
            this.rbFromTo.setSelected(true);
            this.historyChart.setChartType(1);
        }
        if (chartType.equals("usage")) {
            this.rbTimeUsage.setSelected(true);
            this.historyChart.setChartType(2);
        }
        if (!this.chbHighlightTasks.isSelected() || !this.chbHighlightTasks.isEnabled()) {
            this.cmbFilterName.setEnabled(false);
            this.cmbContentRule.setEnabled(false);
            this.txtContent.setEnabled(false);
            this.cmbContent.setEnabled(false);
            return;
        }
        this.cmbFilterName.setEnabled(true);
        this.cmbContentRule.setEnabled(true);
        this.cmbFilterName.setSelectedIndex(Integer.parseInt((String)settings.getSetting("history.filter")));
        AbstractTaskFilter taskFilter = this.getFilter();
        Vector contentRules = taskFilter.getContentRules();
        int length = contentRules.size();
        this.cmbContentRule.removeAllItems();
        for (int i = 0; i < length; ++i) {
            this.cmbContentRule.addItem(contentRules.get(i));
        }
        this.cmbContentRule.setSelectedIndex(Integer.parseInt((String)settings.getSetting("history.rule")));
        String content = (String)settings.getSetting("history.content");
        Vector contentValues = taskFilter.getContentValues();
        this.cmbContent.removeAllItems();
        if (contentValues != null) {
            length = contentValues.size();
            for (int i = 0; i < length; ++i) {
                this.cmbContent.addItem(contentValues.get(i));
            }
            this.cmbContent.setSelectedIndex(Integer.parseInt(content));
        } else {
            this.txtContent.setText(content);
        }
        this.cmbContent.setEnabled(contentValues != null);
        this.txtContent.setEnabled(contentValues == null);
        this.historyChart.setHighlightingFilter(this.getFilter());
    }

    private void setComponents() {
        if (!this.chbHighlightTasks.isSelected() || !this.chbHighlightTasks.isEnabled()) {
            this.cmbFilterName.setEnabled(false);
            this.cmbContentRule.setEnabled(false);
            this.txtContent.setEnabled(false);
            this.cmbContent.setEnabled(false);
            return;
        }
        this.cmbFilterName.setEnabled(true);
        this.cmbContentRule.setEnabled(true);
        AbstractTaskFilter taskFilter = this.getFilter();
        Vector contentRules = taskFilter.getContentRules();
        int length = contentRules.size();
        this.cmbContentRule.removeAllItems();
        for (int i = 0; i < length; ++i) {
            this.cmbContentRule.addItem(contentRules.get(i));
        }
        this.cmbContentRule.setSelectedIndex(0);
        Vector contentValues = taskFilter.getContentValues();
        this.cmbContent.removeAllItems();
        if (contentValues != null) {
            length = contentValues.size();
            for (int i = 0; i < length; ++i) {
                this.cmbContent.addItem(contentValues.get(i));
            }
            this.cmbContent.setSelectedIndex(0);
        } else {
            this.txtContent.setText("");
        }
        if (taskFilter instanceof DurationFilter) {
            this.txtContent.setText(Tools.getTime(0.0));
        }
        this.cmbContent.setEnabled(contentValues != null);
        this.txtContent.setEnabled(contentValues == null);
    }

    private AbstractTaskFilter getFilter() {
        if (!this.chbHighlightTasks.isSelected()) {
            return null;
        }
        String filterName = (String)this.cmbFilterName.getSelectedItem();
        AbstractTaskFilter taskFilter = null;
        if (new DescriptionFilter().toString().equals(filterName)) {
            taskFilter = new DescriptionFilter();
            taskFilter.setContent(this.txtContent.getText());
        }
        if (new KeywordFilter().toString().equals(filterName)) {
            taskFilter = new KeywordFilter();
            taskFilter.setContent(this.txtContent.getText());
        }
        if (new DurationFilter().toString().equals(filterName)) {
            taskFilter = new DurationFilter();
            taskFilter.setContent(Tools.getTime(0.0));
            try {
                String text = this.txtContent.getText();
                if (text.equals("")) {
                    text = Tools.getTime(0.0);
                    this.txtContent.setText(Tools.getTime(0.0));
                }
                if (text.length() != 8) {
                    throw new NumberFormatException("Error: invalid task duration specified: " + text);
                }
                taskFilter.setContent(Tools.getTime(Tools.getTime(text)));
            }
            catch (NumberFormatException e) {
                this.txtContent.setText(Tools.getTime(0.0));
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.INVALID_DURATION"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            }
        }
        if (new PriorityFilter().toString().equals(filterName)) {
            taskFilter = new PriorityFilter();
            taskFilter.setContent("" + this.cmbContent.getSelectedIndex());
        }
        if (new StateFilter().toString().equals(filterName)) {
            taskFilter = new StateFilter();
            taskFilter.setContent("" + this.cmbContent.getSelectedIndex());
        }
        if (new PrivateFilter().toString().equals(filterName)) {
            taskFilter = new PrivateFilter();
            taskFilter.setContent(Boolean.toString(this.cmbContent.getSelectedIndex() == 0));
        }
        taskFilter.setContentRule(this.cmbContentRule.getSelectedIndex());
        return taskFilter;
    }

    private void updateTotalTime() {
        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
        long totalTime = Tools.getTotalTime(false, includePrivateTime, this.getDays());
        this.txtTotalTime.setText(Tools.getTime(totalTime));
    }

    public void saveSetup() {
        Settings settings = Settings.getDefault();
        settings.setSetting("history.period", new Integer(this.cmbPeriod.getSelectedIndex()));
        if (this.rbFromTo.isSelected()) {
            settings.setSetting("history.chart", "from/to");
        }
        if (this.rbTotal.isSelected()) {
            settings.setSetting("history.chart", "time");
        }
        if (this.rbTimeUsage.isSelected()) {
            settings.setSetting("history.chart", "usage");
        }
        settings.setSetting("history.highlight", new Boolean(this.chbHighlightTasks.isSelected()));
        settings.setSetting("history.filter", new Integer(this.cmbFilterName.getSelectedIndex()));
        settings.setSetting("history.rule", new Integer(this.cmbContentRule.getSelectedIndex()));
        if (this.cmbContent.isEnabled()) {
            settings.setSetting("history.content", new Integer(this.cmbContent.getSelectedIndex()));
        } else {
            settings.setSetting("history.content", this.txtContent.getText());
        }
        settings.setSetting("history.group", new Boolean(this.chbGroupTasks.isSelected()));
        FiltersTableModel filtersModel = (FiltersTableModel)this.tbFilters.getModel();
        settings.setSetting("history.filters", new Integer(filtersModel.getRowCount()));
        Vector filters = filtersModel.getFilters();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            AbstractTaskFilter filter = (AbstractTaskFilter)filters.get(i);
            Vector contentValues = filter.getContentValues();
            String content = filter.getContent();
            settings.setSetting("history.filter." + i, "[" + filter.getClass().getName() + "," + filter.getContentRule() + "," + (contentValues == null ? content : "" + contentValues.indexOf(content)) + "]");
        }
        FilteredTasksTableModel model = (FilteredTasksTableModel)this.tbTasks.getModel();
        String columnWidths = "";
        for (int i = 0; i < 3; ++i) {
            int size = this.tbTasks.getColumnModel().getColumn(i).getWidth();
            columnWidths = columnWidths + "[" + size + "]";
        }
        settings.setSetting("history.columns", columnWidths);
        settings.setSetting("history.sortedColumn", "" + model.getSortedColumn() + model.getSortedOrder());
        settings.setSetting("history.range", "[" + this.spMinus.getValue() + "," + this.spPlus.getValue() + "]");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FilteredTasksTableModel filteredTasksTableModel = (FilteredTasksTableModel)this.tbTasks.getModel();
        filteredTasksTableModel.fireTableDataChanged();
        this.txtFilteredTime.setText(Tools.getTime(filteredTasksTableModel.getTotalTime()));
        this.historyChart.setDays(this.getDays());
        this.updateTotalTime();
    }

    public class MouseActionAdapter
    extends MouseAdapter
    implements ActionListener {
        private JPopupMenu popupMenu;
        private int row;
        Point pressedPoint;

        public MouseActionAdapter(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.pressedPoint = mouseevent.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            if (SwingUtilities.isRightMouseButton(mouseevent)) {
                if (!mouseevent.getPoint().equals(this.pressedPoint)) {
                    return;
                }
                int rowAtPoint = HistoryView.this.tbTasks.rowAtPoint(this.pressedPoint);
                if (rowAtPoint >= 0) {
                    this.row = rowAtPoint;
                    this.popupMenu.show(mouseevent.getComponent(), mouseevent.getX(), mouseevent.getY());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilteredTasksTableModel filteredTasksTableModel = (FilteredTasksTableModel)HistoryView.this.tbTasks.getModel();
            Task selectedTask = filteredTasksTableModel.getSimilarTask(this.row);
            Plan plan = Plan.getDefault();
            Day today = plan.getDay(new Date());
            if (today.getTask(selectedTask.getDescription()) == null) {
                Task clone = selectedTask.cloneTask();
                if (selectedTask instanceof RegularTask) {
                    clone = new Task(selectedTask.getDescription(), selectedTask.getKeyword(), selectedTask.getNotes(), selectedTask.getPriority(), Task.STATE_NEW, 0L, selectedTask.getNotificationTime(), selectedTask.automaticStart(), selectedTask.privateTask());
                }
                today.addTask(clone);
                return;
            }
        }
    }
}

