/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGImageWriter {
    CRC32 checksum;
    OutputStream outputStream;

    void write(int number) throws IOException {
        byte[] array = new byte[]{(byte)(number >> 24 & 0xFF), (byte)(number >> 16 & 0xFF), (byte)(number >> 8 & 0xFF), (byte)(number & 0xFF)};
        this.write(array);
    }

    void write(byte[] array) throws IOException {
        this.outputStream.write(array);
        this.checksum.update(array);
    }

    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        this.checksum = new CRC32();
        this.outputStream = outputStream;
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        byte[] id = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13};
        this.write(id);
        this.checksum.reset();
        this.write("IHDR".getBytes());
        this.write(width);
        this.write(height);
        byte[] head = null;
        head = new byte[]{8, 2, 0, 0, 0};
        this.write(head);
        this.write((int)this.checksum.getValue());
        ByteArrayOutputStream compressed = new ByteArrayOutputStream(65536);
        BufferedOutputStream bos = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)compressed, new Deflater(9)));
        for (int y = 0; y < height; ++y) {
            bos.write(0);
            for (int x = 0; x < width; ++x) {
                int pixel = image.getRGB(x, y);
                bos.write((byte)(pixel >> 16 & 0xFF));
                bos.write((byte)(pixel >> 8 & 0xFF));
                bos.write((byte)(pixel & 0xFF));
            }
        }
        bos.close();
        this.write(compressed.size());
        this.checksum.reset();
        this.write("IDAT".getBytes());
        this.write(compressed.toByteArray());
        this.write((int)this.checksum.getValue());
        this.write(0);
        this.checksum.reset();
        this.write("IEND".getBytes());
        this.write((int)this.checksum.getValue());
        outputStream.flush();
        outputStream.close();
    }
}

