/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

class ProjectsTreeModel
extends DefaultTreeModel {
    public static final int NODE_TYPE_ROOT = 1;
    public static final int NODE_TYPE_CATEGORY = 2;
    public static final int NODE_TYPE_TASK = 3;
    private Vector days;

    public ProjectsTreeModel(Vector days) {
        super(new DefaultMutableTreeNode(Translator.getTranslation("HISTORYVIEW.PROJECTS_TREE_ALL")));
        this.setDays(days);
    }

    public void setDays(Vector days) {
        this.days = days;
        this.initializeProjectTree();
    }

    public Object getSelectedNode(TreePath treePath) {
        DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return lastNode.getUserObject();
    }

    int getSelectedNodeType(TreePath treePath) {
        return treePath.getPathCount();
    }

    private CategoryNode getCategoryNode(Vector categories, String name) {
        for (CategoryNode categoryNode : categories) {
            if (!categoryNode.getName().equals(name)) continue;
            return categoryNode;
        }
        return null;
    }

    private Vector getCategoryNodes() {
        CategoryNode categoryNode = new CategoryNode(Translator.getTranslation("HISTORYVIEW.PROJECTS_TREE_UNCATEGORIZED"));
        Vector<CategoryNode> categories = new Vector<CategoryNode>();
        categories.add(categoryNode);
        for (Day day : this.days) {
            for (Task task : day.getTasks()) {
                if (task.getDuration() == 0L) continue;
                Iterator keywordIter = task.getKeywordIterator();
                if (keywordIter.hasNext()) {
                    while (keywordIter.hasNext()) {
                        String category = (String)keywordIter.next();
                        categoryNode = this.getCategoryNode(categories, category);
                        if (categoryNode != null) {
                            categoryNode.addTask(task);
                            continue;
                        }
                        categoryNode = new CategoryNode(category);
                        categoryNode.addTask(task);
                        categories.add(categoryNode);
                    }
                    continue;
                }
                categoryNode = this.getCategoryNode(categories, Translator.getTranslation("HISTORYVIEW.PROJECTS_TREE_UNCATEGORIZED"));
                if (task.getDuration() == 0L) continue;
                categoryNode.addTask(task);
            }
        }
        return categories;
    }

    private void initializeProjectTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        for (CategoryNode categoryNode : this.sortCategoryNodes(this.getCategoryNodes())) {
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(categoryNode);
            for (TaskNode taskNode : categoryNode.getTaskNodes()) {
                DefaultMutableTreeNode task = new DefaultMutableTreeNode(taskNode);
                category.add(task);
            }
            root.add(category);
        }
        this.setRoot(root);
    }

    private Vector sortCategoryNodes(Vector categoryNodesVector) {
        int categoryNodesCount = categoryNodesVector.size();
        Object[] categoryNodesArray = new CategoryNode[categoryNodesCount];
        for (int i = 0; i < categoryNodesCount; ++i) {
            categoryNodesArray[i] = (CategoryNode)categoryNodesVector.get(i);
        }
        Arrays.sort(categoryNodesArray);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        root.removeAllChildren();
        categoryNodesVector.removeAllElements();
        for (int i = 0; i < categoryNodesCount; ++i) {
            ((CategoryNode)categoryNodesArray[i]).sortTaskNodes();
            categoryNodesVector.add(categoryNodesArray[i]);
        }
        return categoryNodesVector;
    }

    class TaskNode
    implements Comparable {
        private String description;
        private Vector tasks;
        public static final int PROPERTY_PRIORITY = 0;
        public static final int PROPERTY_STATE = 1;

        TaskNode(Task task) {
            this.description = task.getDescription();
            this.tasks = new Vector();
            this.tasks.add(task);
        }

        private void addTask(Task task) {
            this.getTasks().add(task);
        }

        public String toString() {
            return this.description + " [" + Tools.getTimeShort(this.getTotalTime()) + "]";
        }

        public long getTotalTime() {
            Iterator iterator = this.getTasks().iterator();
            long duration = 0L;
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                duration += task.getDuration();
            }
            return duration;
        }

        public String getDescription() {
            return this.description;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            TaskNode taskNode = (TaskNode)object;
            if (taskNode.getTotalTime() > this.getTotalTime()) {
                return 1;
            }
            return -1;
        }

        public Vector getTasks() {
            return this.tasks;
        }

        public int getAverageValue(int property) {
            int totalProperty = 0;
            int numberOfTasks = 0;
            for (Task task : this.tasks) {
                totalProperty += property == 0 ? task.getPriority() : task.getState();
                ++numberOfTasks;
            }
            float averageProperty = (float)totalProperty / (float)numberOfTasks;
            if ((double)averageProperty < (double)Task.PRIORITY_MEDIUM - 0.66) {
                return Task.PRIORITY_HIGH;
            }
            if ((double)averageProperty > (double)Task.PRIORITY_MEDIUM + 0.66) {
                return Task.PRIORITY_LOW;
            }
            return Task.PRIORITY_MEDIUM;
        }
    }

    class CategoryNode
    implements Comparable {
        private String name;
        private Vector taskNodes;
        public static final int PROPERTY_PRIORITY = 0;
        public static final int PROPERTY_STATE = 1;

        CategoryNode(String name) {
            this.name = name;
            this.taskNodes = new Vector();
        }

        private void addTask(Task task) {
            TaskNode taskNode2;
            for (TaskNode taskNode2 : this.taskNodes) {
                if (!taskNode2.getDescription().equals(task.getDescription())) continue;
                taskNode2.addTask(task);
                return;
            }
            taskNode2 = new TaskNode(task);
            this.taskNodes.add(taskNode2);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            String text = this.name;
            text = text + " [" + Tools.getTimeShort(this.getTotalTime()) + "]";
            return text;
        }

        public Vector getTaskNodes() {
            return this.taskNodes;
        }

        public long getTotalTime() {
            Iterator iterator = this.taskNodes.iterator();
            long duration = 0L;
            while (iterator.hasNext()) {
                TaskNode taskNode = (TaskNode)iterator.next();
                duration += taskNode.getTotalTime();
            }
            return duration;
        }

        public int getAverageValue(int property) {
            Iterator taskNodesIterator = this.taskNodes.iterator();
            int totalProperty = 0;
            int numberOfTasks = 0;
            while (taskNodesIterator.hasNext()) {
                TaskNode taskNode = (TaskNode)taskNodesIterator.next();
                for (Task task : taskNode.getTasks()) {
                    totalProperty += property == 0 ? task.getPriority() : task.getState();
                    ++numberOfTasks;
                }
            }
            float averageProperty = (float)totalProperty / (float)numberOfTasks;
            if ((double)averageProperty < (double)Task.PRIORITY_MEDIUM - 0.66) {
                return Task.PRIORITY_HIGH;
            }
            if ((double)averageProperty > (double)Task.PRIORITY_MEDIUM + 0.66) {
                return Task.PRIORITY_LOW;
            }
            return Task.PRIORITY_MEDIUM;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            CategoryNode categoryNode = (CategoryNode)object;
            if (categoryNode.getTotalTime() > this.getTotalTime()) {
                return 1;
            }
            return -1;
        }

        public void sortTaskNodes() {
            int i;
            int taskNodesCount = this.taskNodes.size();
            Object[] taskNodesArray = new TaskNode[taskNodesCount];
            for (i = 0; i < taskNodesCount; ++i) {
                taskNodesArray[i] = (TaskNode)this.taskNodes.get(i);
            }
            Arrays.sort(taskNodesArray);
            this.taskNodes.removeAllElements();
            for (i = 0; i < taskNodesArray.length; ++i) {
                this.taskNodes.add(taskNodesArray[i]);
            }
        }
    }

    static class ProjectsTreeListener
    implements TreeSelectionListener {
        ProjectsTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
        }
    }
}

