/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.UjoPropertyList;
import org.ujoframework.core.DummyUjo;
import org.ujoframework.core.UjoActionImpl;
import org.ujoframework.core.UjoCoder;
import org.ujoframework.core.UjoPropertyListImpl;
import org.ujoframework.core.annot.Transient;
import org.ujoframework.core.annot.XmlAttribute;
import org.ujoframework.core.annot.XmlElementBody;
import org.ujoframework.extensions.ListUjoProperty;
import org.ujoframework.extensions.PathProperty;
import org.ujoframework.extensions.Property;
import org.ujoframework.extensions.PropertyModifier;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.extensions.UjoCloneable;
import org.ujoframework.extensions.UjoTextable;
import org.ujoframework.implementation.array.ArrayUjo;
import org.ujoframework.swing.UjoPropertyRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoManager
implements Comparator<UjoProperty> {
    public static final int PROPERTY_MODIFIER = 25;
    protected static UjoManager instance = new UjoManager();
    private final HashMap<Class, UjoPropertyList> propertiesCache = new HashMap();
    private HashMap<Class, UjoProperty> xmlBodyCache;
    private HashSet<UjoProperty> attributesCache = null;
    private HashSet<UjoProperty> transientCache = null;
    private Boolean arePropertiesReversed = null;
    private UjoCoder coder = new UjoCoder();

    public static final UjoManager getInstance() {
        return instance;
    }

    public void revertArray(Object[] objectArray) {
        int n = 0;
        for (int i = objectArray.length - 1; n < i; ++n, --i) {
            Object object = objectArray[n];
            objectArray[n] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public boolean isPropertiesReversed() {
        if (this.arePropertiesReversed == null) {
            this.arePropertiesReversed = (boolean)new DummyUjo().isPropertiesReversed();
        }
        return this.arePropertiesReversed;
    }

    protected boolean isAbstract(Class clazz) {
        boolean bl = Modifier.isAbstract(clazz.getModifiers());
        return bl;
    }

    public UjoPropertyList readProperties(Class clazz) {
        UjoPropertyList ujoPropertyList = this.propertiesCache.get(clazz);
        if (ujoPropertyList == null) {
            ujoPropertyList = new UjoPropertyListImpl(this.readPropertiesNocache(clazz, true));
            this.propertiesCache.put(clazz, ujoPropertyList);
        }
        return ujoPropertyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UjoProperty[] readPropertiesNocache(Class clazz, boolean bl) throws IllegalStateException {
        Object[] objectArray;
        ArrayList<UjoProperty> arrayList = new ArrayList<UjoProperty>(32);
        Field field = null;
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                Field[] fieldArray = clazz.getFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    field = fieldArray[i];
                    if (field.getModifiers() != 25 || !UjoProperty.class.isAssignableFrom(field.getType())) continue;
                    UjoProperty ujoProperty = (UjoProperty)field.get(null);
                    if (ujoProperty.isDirect()) {
                        arrayList.add(ujoProperty);
                        if (ujoProperty.getName() == null && ujoProperty instanceof Property) {
                            PropertyModifier.setName(field.getName(), (Property)ujoProperty);
                        }
                    }
                    Transient transient_ = field.getAnnotation(Transient.class);
                    XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
                    XmlElementBody xmlElementBody = field.getAnnotation(XmlElementBody.class);
                    if (transient_ != null) {
                        this.cacheTransientAttribute(ujoProperty);
                        continue;
                    }
                    if (xmlAttribute != null) {
                        this.cacheXmlAttribute(ujoProperty);
                        continue;
                    }
                    if (xmlElementBody == null) continue;
                    this.cacheXmlElementBody(clazz, ujoProperty);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(String.valueOf(field), illegalAccessException);
            }
            objectArray = arrayList.toArray(new UjoProperty[arrayList.size()]);
            if (bl) {
                if (this.isPropertiesReversed()) {
                    this.revertArray(objectArray);
                }
                Arrays.sort(objectArray, this);
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (object.getIndex() == i || !(object instanceof Property)) continue;
                    PropertyModifier.setIndex(i, (Property)object);
                }
            }
        }
        return objectArray;
    }

    @Override
    public int compare(UjoProperty ujoProperty, UjoProperty ujoProperty2) {
        int n;
        int n2 = ujoProperty.getIndex() >= 0 ? ujoProperty.getIndex() : Integer.MAX_VALUE;
        int n3 = n = ujoProperty2.getIndex() >= 0 ? ujoProperty2.getIndex() : Integer.MAX_VALUE;
        return n2 > n ? 1 : (n < n ? -1 : 0);
    }

    protected void sortProperties(Class clazz, UjoProperty[] ujoPropertyArray) {
        if (ujoPropertyArray.length > 0) {
            if (ArrayUjo.class.isAssignableFrom(clazz)) {
                Arrays.sort(ujoPropertyArray);
            } else if (this.isPropertiesReversed()) {
                this.revertArray(ujoPropertyArray);
            }
        }
    }

    public int getHash(Ujo ujo) {
        return this.getHash(ujo, ujo.readProperties());
    }

    public int getHash(Ujo ujo, UjoPropertyList ujoPropertyList) {
        int n = 0;
        if (ujo != null) {
            for (UjoProperty ujoProperty : ujoPropertyList) {
                Object object = UjoManager.getValue(ujo, ujoProperty);
                if (object == null) continue;
                n = (n >>> 3) + object.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return this.equalsArray(object, object2);
        }
        return object.equals(object2);
    }

    public boolean equalsUjo(Ujo ujo, Ujo ujo2) {
        return this.equalsUjo(ujo, ujo2, ujo != null ? ujo.readProperties() : null);
    }

    public boolean equalsUjo(Ujo ujo, Ujo ujo2, UjoPropertyList ujoPropertyList) {
        if (ujo == ujo2) {
            return true;
        }
        if (ujo == null || ujo2 == null) {
            return false;
        }
        if (ujo.getClass().equals(ujo2.getClass())) {
            for (int i = ujoPropertyList.size() - 1; i >= 0; --i) {
                Object object;
                UjoProperty ujoProperty = ujoPropertyList.get(i);
                Object object2 = UjoManager.getValue(ujo, ujoProperty);
                if (this.equals(object2, object = UjoManager.getValue(ujo2, ujoProperty))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsArray(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (Byte.TYPE == object.getClass().getComponentType()) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (Character.TYPE == object.getClass().getComponentType()) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        return object.equals(object2);
    }

    public Ujo clone(Ujo ujo, int n, Object object) throws IllegalStateException {
        UjoActionImpl ujoActionImpl = new UjoActionImpl(20, object);
        if (--n < 0 || ujo == null) {
            return ujo;
        }
        try {
            Ujo ujo2 = (Ujo)ujo.getClass().newInstance();
            for (UjoProperty ujoProperty : ujo.readProperties()) {
                Object object2;
                Object object3;
                if (!ujo.readAuthorization(ujoActionImpl, ujoProperty, object3 = ujo.readValue(ujoProperty))) continue;
                if (object3 instanceof UjoCloneable) {
                    object3 = ((UjoCloneable)object3).clone(n, object);
                } else if (object3 instanceof List) {
                    object2 = (List)object3.getClass().newInstance();
                    for (Object e : (List)object3) {
                        Object e2 = e instanceof Ujo ? this.clone((Ujo)e, n, object) : (e instanceof UjoCloneable ? ((UjoCloneable)e).clone(n, object) : e);
                        object2.add(e2);
                    }
                    object3 = object2;
                } else if (object3 != null && object3.getClass().isArray()) {
                    object2 = Array.newInstance(object3.getClass(), Array.getLength(object3));
                    System.arraycopy(object3, 0, object2, 0, Array.getLength(object3));
                    object3 = object2;
                }
                ujo2.writeValue(ujoProperty, object3);
            }
            return ujo2;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    public UjoProperty findProperty(Ujo ujo, String string, boolean bl) throws IllegalArgumentException {
        return ujo.readProperties().find(ujo, string, UjoAction.DUMMY, true, bl);
    }

    public UjoProperty findProperty(Ujo ujo, String string, UjoAction ujoAction, boolean bl, boolean bl2) throws IllegalArgumentException {
        return ujo.readProperties().find(ujo, string, ujoAction, bl, bl2);
    }

    public String toString(Ujo ujo) {
        return this.toString(ujo, ujo.readProperties());
    }

    public String toString(Ujo ujo, UjoPropertyList ujoPropertyList) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(ujo.getClass().getSimpleName());
        UjoActionImpl ujoActionImpl = new UjoActionImpl(22, this);
        int n = ujoPropertyList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            UjoProperty ujoProperty = ujoPropertyList.get(i);
            if (!ujo.readAuthorization(ujoActionImpl, ujoProperty, this)) continue;
            boolean bl = ujoProperty instanceof ListUjoProperty;
            String string2 = "";
            try {
                Object object = ujo.readValue(ujoProperty);
                String string3 = string2 = object instanceof CharSequence ? "\"" : "";
                string = bl ? ((ListUjoProperty)ujoProperty).getItemCount(ujo) + "]" : (object instanceof Ujo ? "UJO:" + object.hashCode() : (ujo instanceof UjoTextable ? ((UjoTextable)ujo).readValueString(ujoProperty, ujoActionImpl) : this.coder.encodeValue(ujo, false)));
            }
            catch (Throwable throwable) {
                string = throwable.getClass().getSimpleName();
            }
            stringBuilder.append(i == 0 ? "[" : ", ");
            stringBuilder.append(ujoProperty.getName());
            stringBuilder.append(bl ? "[" : "=");
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append(string2);
        }
        if (ujoPropertyList.size() > 0) {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public static boolean isUsable(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public final UjoProperty getXmlElementBody(Class clazz) {
        if (this.propertiesCache.get(clazz) == null) {
            this.readProperties(clazz);
        }
        UjoProperty ujoProperty = this.xmlBodyCache != null ? this.xmlBodyCache.get(clazz) : null;
        return ujoProperty;
    }

    public final boolean isXmlAttribute(UjoProperty ujoProperty) {
        boolean bl = this.attributesCache != null && this.attributesCache.contains(ujoProperty);
        return bl;
    }

    public final boolean isTransientProperty(UjoProperty ujoProperty) {
        boolean bl = this.transientCache != null && this.transientCache.contains(ujoProperty);
        return bl;
    }

    public final Object decodeValue(UjoProperty ujoProperty, String string, Class clazz) {
        return this.coder.decodeValue(ujoProperty, string, clazz);
    }

    public final Object decodeValue(UjoProperty ujoProperty, String string) {
        return this.coder.decodeValue(ujoProperty, string, null);
    }

    public final Object decodeValue(Class clazz, String string) {
        return this.coder.decodeValue(clazz, string);
    }

    public final String encodeValue(Object object, boolean bl) {
        return this.coder.encodeValue(object, bl);
    }

    private void cacheXmlAttribute(UjoProperty ujoProperty) {
        if (ujoProperty.isTypeOf(Ujo.class) || ujoProperty instanceof ListUjoProperty) {
            return;
        }
        if (this.attributesCache == null) {
            this.attributesCache = new HashSet();
        }
        this.attributesCache.add(ujoProperty);
    }

    private void cacheXmlElementBody(Class clazz, UjoProperty ujoProperty) {
        UjoProperty ujoProperty2;
        if (ujoProperty.isTypeOf(Ujo.class) || ujoProperty instanceof ListUjoProperty) {
            return;
        }
        if (this.xmlBodyCache == null) {
            this.xmlBodyCache = new HashMap(4);
        }
        if ((ujoProperty2 = this.xmlBodyCache.get(clazz)) == null || ujoProperty2.getIndex() < ujoProperty.getIndex()) {
            this.xmlBodyCache.put(clazz, ujoProperty);
        }
    }

    private void cacheTransientAttribute(UjoProperty ujoProperty) {
        if (this.transientCache == null) {
            this.transientCache = new HashSet();
        }
        this.transientCache.add(ujoProperty);
    }

    public boolean assertDirectAssign(UjoProperty ujoProperty, Object object) throws IllegalArgumentException {
        return this.assertDirect(ujoProperty, object) && this.assertAssign(ujoProperty, object);
    }

    public boolean assertDirect(UjoProperty ujoProperty, Object object) throws IllegalArgumentException {
        if (!ujoProperty.isDirect()) {
            String string = "The property \"" + ujoProperty + "\" type of \"" + ujoProperty.getType().getName() + "\" is not a direct type.";
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public boolean assertAssign(UjoProperty ujoProperty, Object object) throws IllegalArgumentException {
        boolean bl;
        boolean bl2 = bl = object == null || ujoProperty.getType().isInstance(object);
        if (!bl) {
            String string = "The property \"" + ujoProperty + "\" type of \"" + ujoProperty.getType().getName() + "\" can't contain value \"" + object + "\"" + (object != null ? " (" + object.getClass().getName() + ')' : "") + "\".";
            throw new IllegalArgumentException(string);
        }
        return bl;
    }

    public static void setValue(Ujo ujo, UjoProperty ujoProperty, Object object) {
        if (ujoProperty.isDirect()) {
            ujo.writeValue(ujoProperty, object);
        } else {
            ujoProperty.setValue(ujo, object);
        }
    }

    public Ujo setValue(Ujo ujo, UjoPropertyList ujoPropertyList, Object object) throws IllegalArgumentException {
        int n = ujoPropertyList.size() - 1;
        UjoProperty ujoProperty = ujoPropertyList.get(n);
        this.assertAssign(ujoProperty, object);
        for (int i = 0; i < n; ++i) {
            UjoProperty ujoProperty2 = ujoPropertyList.get(i);
            ujo = (Ujo)UjoManager.getValue(ujo, ujoProperty2);
        }
        UjoManager.setValue(ujo, ujoProperty, object);
        return ujo;
    }

    public static Object getValue(Ujo ujo, UjoProperty ujoProperty) {
        Object object = ujoProperty.isDirect() ? ujo.readValue(ujoProperty) : ujoProperty.getValue(ujo);
        return object;
    }

    public <VALUE> VALUE getValue(Ujo ujo, UjoProperty ... ujoPropertyArray) {
        Object object = ujo;
        for (UjoProperty ujoProperty : ujoPropertyArray) {
            object = UjoManager.getValue((Ujo)object, ujoProperty);
        }
        return (VALUE)object;
    }

    public UjoCoder getCoder() {
        return this.coder;
    }

    public void setCoder(UjoCoder ujoCoder) {
        this.coder = ujoCoder;
    }

    public String getText(Ujo ujo, UjoProperty ujoProperty, UjoAction ujoAction) {
        if (ujoProperty.isDirect()) {
            String string = ujo instanceof UjoTextable ? ((UjoTextable)ujo).readValueString(ujoProperty, ujoAction) : this.encodeValue(UjoManager.getValue(ujo, ujoProperty), false);
            return string;
        }
        PathProperty pathProperty = (PathProperty)ujoProperty;
        UjoProperty ujoProperty2 = pathProperty.getLastProperty();
        Ujo ujo2 = pathProperty.getSemifinalValue(ujo);
        return this.getText(ujo2, ujoProperty2, ujoAction);
    }

    public void setText(Ujo ujo, UjoProperty ujoProperty, String string, Class clazz, UjoAction ujoAction) {
        if (ujoProperty.isDirect()) {
            if (ujo instanceof UjoTextable) {
                ((UjoTextable)ujo).writeValueString(ujoProperty, string, clazz, ujoAction != null ? ujoAction : UjoAction.DUMMY);
            } else {
                Object object = this.decodeValue(ujoProperty, string, clazz);
                UjoManager.setValue(ujo, ujoProperty, object);
            }
        } else {
            PathProperty pathProperty = (PathProperty)ujoProperty;
            UjoProperty ujoProperty2 = pathProperty.getLastProperty();
            Ujo ujo2 = pathProperty.getSemifinalValue(ujo);
            this.setText(ujo2, ujoProperty2, string, clazz, ujoAction);
        }
    }

    public List<UjoPropertyRow> createPropertyList(Ujo ujo, UjoAction ujoAction) {
        UjoPropertyList ujoPropertyList = ujo.readProperties();
        ArrayList<UjoPropertyRow> arrayList = new ArrayList<UjoPropertyRow>(ujoPropertyList.size());
        for (UjoProperty ujoProperty : ujoPropertyList) {
            Object object;
            boolean bl = ujo.readAuthorization(ujoAction, ujoProperty, object = ujo.readValue(ujoProperty));
            if (!bl) continue;
            UjoPropertyRow ujoPropertyRow = new UjoPropertyRow(ujo, ujoProperty);
            arrayList.add(ujoPropertyRow);
        }
        return arrayList;
    }

    public void copy(Ujo ujo, Ujo ujo2, UjoAction ujoAction, UjoProperty ... ujoPropertyArray) {
        if (ujoPropertyArray == null) {
            ujoPropertyArray = ujo.readProperties().toArray();
        }
        for (UjoProperty ujoProperty : ujoPropertyArray) {
            Object object = ujo.readValue(ujoProperty);
            boolean bl = ujo.readAuthorization(ujoAction, ujoProperty, object);
            if (!bl) continue;
            UjoManager.setValue(ujo2, ujoProperty, object);
        }
    }

    public void copy(Ujo ujo, Ujo ujo2, UjoProperty ... ujoPropertyArray) {
        this.copy(ujo, ujo2, new UjoActionImpl(21, this), ujoPropertyArray);
    }

    public void copy(Ujo ujo, Ujo ujo2) {
        this.copy(ujo, ujo2, (UjoProperty[])null);
    }

    public Field getPropertyField(Ujo ujo, UjoProperty ujoProperty) {
        return this.getPropertyField(ujo.getClass(), ujoProperty);
    }

    public Field getPropertyField(Class clazz, UjoProperty ujoProperty) {
        Field field = null;
        try {
            Object object;
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; !(i >= fieldArray.length || (field = fieldArray[i]).getModifiers() == 25 && UjoProperty.class.isAssignableFrom(field.getType()) && (object = field.get(null)) == ujoProperty); ++i) {
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(String.valueOf(field), illegalAccessException);
        }
        return field;
    }

    protected void checkUniqueProperties(Class<? extends Ujo> clazz, boolean bl) throws IllegalStateException {
        HashSet<String> hashSet = new HashSet<String>(16);
        if (bl) {
            for (UjoProperty ujoProperty : this.readProperties(clazz)) {
                if (hashSet.add(ujoProperty.getName())) continue;
                throw new IllegalStateException("Property '" + ujoProperty + "' is duplicate in the " + clazz);
            }
        }
    }

    public void checkUniqueProperties(Class<? extends Ujo> clazz) throws IllegalStateException {
        UjoManager.getInstance().checkUniqueProperties(clazz, true);
    }

    public static String projectInfo() {
        Package package_ = Ujo.class.getPackage();
        String string = System.getProperty("line.separator");
        String string2 = package_.getSpecificationTitle() + string + "version " + UjoManager.projectVersion() + string + "http://ujoframework.org/" + string;
        return string2;
    }

    public static String projectVersion() {
        String string = Ujo.class.getPackage().getSpecificationVersion();
        return string != null ? string : "UNDEFINED";
    }

    public static void main(String[] stringArray) {
        System.out.println(UjoManager.projectInfo());
    }
}

