/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.util.Iterator;
import java.util.List;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.UjoPropertyList;
import org.ujoframework.core.UjoManager;
import org.ujoframework.extensions.UjoAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UjoPropertyListImpl
implements UjoPropertyList {
    public static final UjoProperty[] EMPTY = new UjoProperty[0];
    private final UjoProperty[] props;
    public final int length;

    public UjoPropertyListImpl(List<UjoProperty> list) {
        this(list.toArray(new UjoProperty[list.size()]));
    }

    public UjoPropertyListImpl(UjoProperty[] ujoPropertyArray) {
        this.props = ujoPropertyArray;
        this.length = ujoPropertyArray.length;
    }

    public UjoPropertyListImpl() {
        this(EMPTY);
    }

    @Override
    public UjoProperty find(String string, boolean bl) throws IllegalArgumentException {
        int n = string.hashCode();
        for (UjoProperty ujoProperty : this.props) {
            if (ujoProperty.getName().hashCode() != n || !ujoProperty.getName().equals(string)) continue;
            return ujoProperty;
        }
        if (bl) {
            throw new IllegalArgumentException("A name \"" + string + "\" was not found");
        }
        return null;
    }

    @Override
    public final UjoProperty find(Ujo ujo, String string, boolean bl) throws IllegalArgumentException {
        return this.find(ujo, string, UjoAction.DUMMY, true, bl);
    }

    @Override
    public UjoProperty find(Ujo ujo, String string, UjoAction ujoAction, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (ujo == null) {
            return null;
        }
        int n = string.hashCode();
        UjoManager ujoManager = UjoManager.getInstance();
        for (UjoProperty ujoProperty : this.props) {
            if (ujoProperty.getName().hashCode() != n || !ujoProperty.getName().equals(string)) continue;
            if ((ujoAction.getType() == 4 ? !ujoManager.isXmlAttribute(ujoProperty) : ujo.readAuthorization(ujoAction, ujoProperty, null)) != bl) continue;
            return ujoProperty;
        }
        if (bl2) {
            throw new IllegalArgumentException("A name \"" + string + "\" was not found in a " + ujo.getClass());
        }
        return null;
    }

    @Override
    public UjoProperty[] toArray() {
        UjoProperty[] ujoPropertyArray = new UjoProperty[this.length];
        System.arraycopy(this.props, 0, ujoPropertyArray, 0, this.length);
        return ujoPropertyArray;
    }

    @Override
    public UjoProperty last() {
        return this.props[this.length - 1];
    }

    @Override
    public UjoProperty get(int n) {
        return this.props[n];
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(UjoProperty ujoProperty) {
        for (UjoProperty ujoProperty2 : this.props) {
            if (ujoProperty2 != ujoProperty) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<UjoProperty> iterator() {
        Iterator<UjoProperty> iterator = new Iterator<UjoProperty>(){
            private int i = 0;

            @Override
            public final boolean hasNext() {
                return this.i < UjoPropertyListImpl.this.length;
            }

            @Override
            public final UjoProperty next() {
                return UjoPropertyListImpl.this.props[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        return iterator;
    }
}

