/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateConverter {
    private static final String DATE_DELIMITER = "-";
    private static final String TIME_DELIMITER = ":";
    private static final String DATETIME_DELIMITER = "T";
    private static final String UTC_TIMEZONE_OFFSET = "Z";

    public static double toJulianDate(Calendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            throw new IllegalArgumentException("Gregorian date has illegal value. (NULL)");
        }
        int month = gregorianCalendar.get(2) + 1;
        int year = gregorianCalendar.get(1);
        int day = gregorianCalendar.get(5);
        int hour = gregorianCalendar.get(11);
        int minute = gregorianCalendar.get(12);
        int seconds = gregorianCalendar.get(13);
        int tzOffset = (gregorianCalendar.get(16) + gregorianCalendar.get(15)) / 3600000;
        if (month < 3) {
            --year;
            month += 12;
        }
        double leapYear = Double.NaN;
        Calendar gregStartDate = Calendar.getInstance();
        gregStartDate.set(1583, 9, 16);
        if (gregorianCalendar.after(gregStartDate)) {
            leapYear = 2 - Math.round(year / 100) + Math.round(Math.round(year / 100) / 4);
        }
        Calendar gregBeginDate = Calendar.getInstance();
        gregBeginDate.set(1583, 9, 4);
        if (gregorianCalendar.before(gregBeginDate) || gregorianCalendar.equals(gregBeginDate)) {
            leapYear = 0.0;
        }
        if (Double.isNaN(leapYear)) {
            throw new IllegalArgumentException("Date is not valid. Due to gregorian calendar reformation after the 04.10.1583 follows the 16.10.1583.");
        }
        double fracSecs = (double)((hour - tzOffset) * 3600 + minute * 60 + seconds) / 86400.0;
        long c = (long)(365.25 * (double)(year + 4716));
        long d = (long)(30.6001 * (double)(month + 1));
        double julianDate = (double)((long)day + c + d) + fracSecs + leapYear - 1524.5;
        return julianDate;
    }

    public static Calendar toGregorianDate(double julianDate) {
        return DateConverter.toGregorianDate(julianDate, TimeZone.getTimeZone("GMT"));
    }

    public static Calendar toGregorianDate(double julianDate, TimeZone zone) {
        if (julianDate == Double.NaN || julianDate == Double.NEGATIVE_INFINITY || julianDate == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Julian Date has illegal value. (Value=" + julianDate + ")");
        }
        if (zone == null) {
            zone = TimeZone.getTimeZone("GMT");
        }
        int onlyDays = (int)Math.round(julianDate += 0.5);
        double onlyMinutes = julianDate - (double)onlyDays;
        double hours = 24.0 * onlyMinutes;
        int hour = (int)Math.round(hours);
        int minute = (int)((hours - (double)hour) * 60.0);
        int sec = (int)(((hours - (double)hour) * 60.0 - (double)minute) * 60.0);
        double leapYear100 = (int)(((double)onlyDays - 1867216.25) / 36524.25);
        double daysLeapYear = (double)(onlyDays + 1) + leapYear100 - (double)((int)(leapYear100 / 4.0));
        if (onlyDays < 2299161) {
            daysLeapYear = onlyDays;
        }
        double completeLeapDays = daysLeapYear + 1524.0;
        double completeYear = (int)((completeLeapDays - 122.1) / 365.25);
        double completeDays = (int)(365.25 * completeYear);
        double completeMonths = (int)((completeLeapDays - completeDays) / 30.6001);
        int day = (int)(completeLeapDays - completeDays - (double)((int)(30.6001 * completeMonths)) + onlyMinutes);
        int month = 0;
        month = completeMonths < 14.0 ? (int)completeMonths - 1 : (int)completeMonths - 13;
        int year = 0;
        year = month > 2 ? (int)completeYear - 4716 : (int)completeYear - 4715;
        Calendar gregorianDate = Calendar.getInstance(zone);
        gregorianDate.set(year, month - 1, day + 1);
        int offset = (gregorianDate.get(15) + gregorianDate.get(16)) / 3600000;
        gregorianDate.set(year, month - 1, day + 1, hour + offset, minute, sec);
        return gregorianDate;
    }

    public static String toISO8601(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        StringBuffer iso8601 = new StringBuffer();
        iso8601.append(calendar.get(1));
        iso8601.append(DATE_DELIMITER);
        iso8601.append(DateConverter.setLeadingZero(calendar.get(2) + 1));
        iso8601.append(DATE_DELIMITER);
        iso8601.append(DateConverter.setLeadingZero(calendar.get(5)));
        iso8601.append(DATETIME_DELIMITER);
        iso8601.append(DateConverter.setLeadingZero(calendar.get(11)));
        iso8601.append(TIME_DELIMITER);
        iso8601.append(DateConverter.setLeadingZero(calendar.get(12)));
        iso8601.append(TIME_DELIMITER);
        iso8601.append(DateConverter.setLeadingZero(calendar.get(13)));
        int offset = (calendar.get(15) + calendar.get(16)) / 1000 / 60;
        iso8601.append(DateConverter.formatTimezone(offset));
        return iso8601.toString();
    }

    public static Calendar toDate(String iso8601) throws NumberFormatException {
        if (iso8601 == null || "".equals(iso8601)) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(iso8601);
        String year = tokenizer.nextToken(DATE_DELIMITER);
        String month = tokenizer.nextToken(DATE_DELIMITER);
        String day = tokenizer.nextToken(DATETIME_DELIMITER);
        day = day.substring(1, day.length());
        String hour = tokenizer.nextToken(TIME_DELIMITER);
        hour = hour.substring(1, hour.length());
        hour = DateConverter.cutLeadingZeroAndPlus(hour);
        String minute = tokenizer.nextToken(TIME_DELIMITER);
        minute = DateConverter.cutLeadingZeroAndPlus(minute);
        String secAndTZ = iso8601.substring(iso8601.indexOf(TIME_DELIMITER) + 4, iso8601.length());
        String second = secAndTZ.substring(0, 2);
        second = DateConverter.cutLeadingZeroAndPlus(second);
        String timeZone = secAndTZ.substring(2, secAndTZ.length());
        int i_year = 0;
        int i_month = 0;
        int i_day = 0;
        int i_hour = 0;
        int i_minute = 0;
        int i_second = 0;
        String step = "";
        try {
            step = "year";
            i_year = Integer.parseInt(year);
            step = "month";
            i_month = Integer.parseInt(month) - 1;
            step = "day";
            i_day = Integer.parseInt(day);
            step = "hour";
            i_hour = Integer.parseInt(hour);
            step = "minute";
            i_minute = Integer.parseInt(minute);
            step = "second";
            i_second = Integer.parseInt(second);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Cannot generate ISO8601 date because " + step + " is malformed. ");
        }
        GregorianCalendar calendar = null;
        calendar = UTC_TIMEZONE_OFFSET.equals(timeZone) || "".equals(timeZone.trim()) ? new GregorianCalendar(new SimpleTimeZone(0, "GMT")) : new GregorianCalendar(DateConverter.createTimezone(timeZone));
        calendar.set(1, i_year);
        calendar.set(2, i_month);
        calendar.set(5, i_day);
        calendar.set(11, i_hour);
        calendar.set(12, i_minute);
        calendar.set(13, i_second);
        calendar.set(14, 0);
        return calendar;
    }

    private static TimeZone createTimezone(String timeZone) throws NumberFormatException {
        String h = timeZone.substring(0, timeZone.indexOf(TIME_DELIMITER));
        if (h.startsWith("+")) {
            h = DateConverter.cutLeadingZeroAndPlus(h);
        }
        String m = timeZone.substring(timeZone.indexOf(TIME_DELIMITER) + 1, timeZone.length());
        int hour = 0;
        int minute = 0;
        try {
            hour = Integer.parseInt(h);
            minute = Integer.parseInt(m);
        }
        catch (NumberFormatException nfe) {
            new NumberFormatException("Cannot generate ISO8601 date because timezones hour or minute value is malformed. ");
        }
        SimpleTimeZone tz = null;
        int offset = 0;
        if (hour == 0) {
            offset = hour * 3600 * 1000 + minute * 1000 * 60;
            tz = new SimpleTimeZone(offset, "");
        } else {
            offset = hour * 3600 * 1000 + minute * 1000 * 60 * (hour / Math.abs(hour));
            tz = new SimpleTimeZone(offset, "");
        }
        tz.setDSTSavings(1);
        return tz;
    }

    public static String setLeadingZero(int value) {
        if (value <= 9 && value >= -9) {
            if (value < 0) {
                return "-0" + Math.abs(value);
            }
            return "0" + Math.abs(value);
        }
        return "" + value;
    }

    public static String setLeadingZero(double value) {
        if (value <= 9.0 && value >= -9.0) {
            if (value < 0.0) {
                return "-0" + Math.abs(value);
            }
            return "0" + Math.abs(value);
        }
        return "" + value;
    }

    private static String cutLeadingZeroAndPlus(String value) {
        if (value.startsWith("+0")) {
            return value.substring(2, value.length());
        }
        if (value.startsWith("-0")) {
            return DATE_DELIMITER + value.substring(2, value.length());
        }
        if (value.startsWith("+")) {
            value = value.substring(1, value.length());
        }
        return value;
    }

    private static String formatTimezone(int min) {
        int hour = min / 60;
        int minutes = hour * 60 - min;
        if (hour == 0 && minutes == 0) {
            return UTC_TIMEZONE_OFFSET;
        }
        String hourOffset = DateConverter.setLeadingZero(hour);
        if (hour > -1) {
            hourOffset = "+" + hourOffset;
        }
        String minOffset = DateConverter.setLeadingZero(Math.abs(minutes));
        return hourOffset + TIME_DELIMITER + minOffset;
    }
}

