/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.util;

import de.lehmannet.om.Angle;
import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IScope;

public class OpticsUtil {
    public static float getExitPupil(IScope scope, float eyepieceFL, ILens lens) {
        if (scope == null) {
            return Float.NaN;
        }
        float mag = OpticsUtil.getMagnification(scope, eyepieceFL, lens);
        if (Float.isNaN(mag)) {
            return Float.NaN;
        }
        return scope.getAperture() / mag;
    }

    public static float getExitPupil(IScope scope) {
        return OpticsUtil.getExitPupil(scope, -1.0f, null);
    }

    public static Angle getTrueFieldOfView(IScope scope, float eyepieceFL, IEyepiece eyepiece, ILens lens) {
        float mag;
        if (scope == null) {
            return null;
        }
        if (Float.isNaN(eyepieceFL) && eyepiece == null && scope.getTrueFieldOfView() == null) {
            return null;
        }
        if (scope.getTrueFieldOfView() != null) {
            return new Angle(scope.getTrueFieldOfView().toDegree(), "deg");
        }
        if (eyepiece == null) {
            return null;
        }
        if (Float.isNaN(eyepieceFL)) {
            eyepieceFL = eyepiece.getFocalLength();
        }
        if (Float.isNaN(mag = OpticsUtil.getMagnification(scope, eyepieceFL, lens))) {
            return null;
        }
        Angle aFoV = eyepiece.getApparentFOV();
        if (aFoV != null) {
            return new Angle(aFoV.toArcMin() / (double)mag, "arcmin");
        }
        return null;
    }

    public static float getMagnification(IScope scope, float eyepieceFL) {
        if (scope == null) {
            return Float.NaN;
        }
        if (Float.isNaN(scope.getFocalLength())) {
            return scope.getMagnification();
        }
        if (Float.isNaN(eyepieceFL)) {
            return Float.NaN;
        }
        return scope.getFocalLength() / eyepieceFL;
    }

    public static float getMagnification(IScope scope, float eyepieceFL, ILens lens) {
        if (scope == null) {
            return Float.NaN;
        }
        if (Float.isNaN(scope.getFocalLength())) {
            return scope.getMagnification();
        }
        if (Float.isNaN(eyepieceFL)) {
            return Float.NaN;
        }
        if (lens != null) {
            return scope.getFocalLength() * lens.getFactor() / eyepieceFL;
        }
        return scope.getFocalLength() / eyepieceFL;
    }

    public static float getActualFocalLength(IScope scope, ILens lens, float magnification) {
        if (scope == null || Float.isNaN(scope.getFocalLength())) {
            return Float.NaN;
        }
        float F = scope.getFocalLength();
        float p = 1.0f;
        if (lens != null) {
            p = lens.getFactor();
        }
        return F * p / magnification;
    }
}

