/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EquPositionReferenceFrame {
    public static final String ORIGIN_GEOCENTRIC = "geocentric";
    public static final String ORIGIN_TOPOCENTRIC = "topocentric";
    public static final String EQUINOX_2000 = "J2000.0";
    public static final double EQUINOX_2000_JULIANDATE = 2451545.0;
    private static final String XML_ELEMENT_REFERENCEFRAME = "referenceFrame";
    private static final String XML_ELEMENT_ORIGIN = "origin";
    private static final String XML_ELEMENT_EQUINOX = "equinox";
    private String origin = new String("geocentric");
    private String equinox = new String("J2000.0");

    public EquPositionReferenceFrame(String origin, String equinox) throws IllegalArgumentException {
        if (origin == null || equinox == null) {
            throw new IllegalArgumentException("Origin or equinox cannot be null. ");
        }
        if (!ORIGIN_GEOCENTRIC.equals(origin) && !ORIGIN_TOPOCENTRIC.equals(origin)) {
            throw new IllegalArgumentException("Origin did not have valid value. ");
        }
        this.setEquinox(equinox);
        this.setOrigin(origin);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getOrigin());
        buffer.append(" ");
        buffer.append(this.getEquinox());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EquPositionReferenceFrame)) {
            return false;
        }
        EquPositionReferenceFrame frame = (EquPositionReferenceFrame)obj;
        return frame.getEquinox().toLowerCase().trim().equals(this.equinox.toLowerCase().trim()) && frame.getOrigin().toLowerCase().trim().equals(this.origin.toLowerCase().trim());
    }

    public Element addToXmlElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Frame = ownerDoc.createElement(XML_ELEMENT_REFERENCEFRAME);
        Element e_Origin = ownerDoc.createElement(XML_ELEMENT_ORIGIN);
        e_Origin.setNodeValue(this.origin);
        e_Frame.appendChild(e_Origin);
        Element e_Equinox = ownerDoc.createElement(XML_ELEMENT_EQUINOX);
        e_Equinox.setNodeValue(this.equinox);
        e_Frame.appendChild(e_Equinox);
        parent.appendChild(e_Frame);
        return parent;
    }

    public String getEquinox() {
        return this.equinox;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setEquinox(String equinox) throws IllegalArgumentException {
        if (equinox == null) {
            throw new IllegalArgumentException("Equinox cannot be null. ");
        }
        this.equinox = equinox;
    }

    public void setOrigin(String origin) throws IllegalArgumentException {
        if (origin == null) {
            throw new IllegalArgumentException("Origin cannot be null. ");
        }
        if (!ORIGIN_GEOCENTRIC.equals(origin) && !ORIGIN_TOPOCENTRIC.equals(origin)) {
            throw new IllegalArgumentException("Origin did not have valid value. ");
        }
        this.origin = origin;
    }
}

