/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IFinding;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Finding
extends SchemaElement
implements IFinding {
    private String description = null;
    private String lang = null;
    private boolean targetSeen = true;

    protected Finding(Node findingElement) throws SchemaException {
        String language;
        if (findingElement == null) {
            throw new SchemaException("Given element cannot be NULL. ");
        }
        Element finding = (Element)findingElement;
        String xsiType = finding.getAttribute("xsi:type");
        if (xsiType != null) {
            Element child = null;
            NodeList children = null;
            children = finding.getElementsByTagName("description");
            if (children == null || children.getLength() != 1) {
                throw new SchemaException("Finding must have exact one description. ");
            }
            child = (Element)children.item(0);
            String description = null;
            if (child == null) {
                throw new SchemaException("Finding must have a description. ");
            }
            NodeList childrenNodeList = child.getChildNodes();
            if (childrenNodeList != null) {
                description = "";
                for (int i = 0; i < childrenNodeList.getLength(); ++i) {
                    description = description + childrenNodeList.item(i).getNodeValue();
                }
                this.setDescription(description);
            } else {
                throw new SchemaException("Finding must have a description. ");
            }
        }
        if ((language = finding.getAttribute("lang")) != null && !"".equals(language.trim())) {
            this.setLanguage(language);
        }
    }

    protected Finding(String ID, String description) throws IllegalArgumentException {
        super(ID);
        if (description == null) {
            throw new IllegalArgumentException("Description cannot be null. ");
        }
        this.description = description;
    }

    protected Finding(String description) throws IllegalArgumentException {
        if (description == null) {
            throw new IllegalArgumentException("Description cannot be null. ");
        }
        this.description = description;
    }

    public abstract Element addToXmlElement(Element var1);

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws IllegalArgumentException {
        if (description == null) {
            throw new IllegalArgumentException("Description cannot be null. ");
        }
        this.description = description;
    }

    public String getLanguage() {
        return this.lang;
    }

    public void setLanguage(String language) {
        if (language != null && "".equals(language.trim())) {
            this.lang = null;
            return;
        }
        this.lang = language;
    }

    public boolean wasSeen() {
        return this.targetSeen;
    }

    public void setSeen(boolean seen) {
        this.targetSeen = seen;
    }

    protected Element createXmlFindingElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Finding = ownerDoc.createElement("result");
        Element e_Description = ownerDoc.createElement("description");
        CDATASection n_DescriptionText = ownerDoc.createCDATASection(this.description);
        e_Description.appendChild(n_DescriptionText);
        e_Finding.appendChild(e_Description);
        if (this.lang != null) {
            e_Finding.setAttribute("lang", this.lang);
        }
        return e_Finding;
    }
}

