/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.Constellation;
import de.lehmannet.om.EquPosition;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.SchemaException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Target
extends SchemaElement
implements ITarget {
    private static final String ALIASNAMES_DELIMITER = ",";
    private String name = new String();
    private List aliasNames = new LinkedList();
    private EquPosition position = null;
    private Constellation constellation = null;
    private String dataSource = null;
    private IObserver observer = null;
    private String notes = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Target(Node targetElement, IObserver[] observers) throws SchemaException {
        int te;
        if (targetElement == null) {
            throw new SchemaException("Given element is NULL. ");
        }
        Element child = null;
        NodeList children = null;
        Element target = (Element)targetElement;
        String ID = target.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Target must have a ID. ");
        }
        super.setID(ID);
        children = target.getElementsByTagName("name");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Target must have exact one name. ");
        }
        child = (Element)children.item(0);
        String name = "";
        if (child == null) {
            throw new SchemaException("Target must have a name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Target cannot have an empty name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te2 = 0; te2 < textElements.getLength(); ++te2) {
                name = name + textElements.item(te2).getNodeValue();
            }
            this.setName(name);
        }
        children = target.getElementsByTagName("datasource");
        String datasource = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                NodeList textElements2 = child.getChildNodes();
                if (textElements2 != null && textElements2.getLength() > 0) {
                    datasource = "";
                    for (int te3 = 0; te3 < textElements2.getLength(); ++te3) {
                        datasource = datasource + textElements2.item(te3).getNodeValue();
                    }
                    this.setDatasource(datasource);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Target can only have one datasource entry. ");
            }
        }
        if ((children = target.getElementsByTagName("observer")) != null) {
            if (children.getLength() == 1 && datasource == null) {
                child = (Element)children.item(0);
                String observerID = child.getFirstChild().getNodeValue();
                if (observers == null || observers.length <= 0) throw new SchemaException("Passed IObserver array is empty or NULL. As no datasource is given, this is invalid. ");
                boolean found = false;
                for (int j = 0; j < observers.length; ++j) {
                    if (!observers[j].getID().equals(observerID)) continue;
                    found = true;
                    this.setObserver(observers[j]);
                    break;
                }
                if (!found) {
                    throw new SchemaException("Target observer links to not existing observer element. ");
                }
            } else {
                if (children.getLength() > 1) {
                    throw new SchemaException("Target can only have one observer entry. ");
                }
                if (datasource == null) {
                    throw new SchemaException("Target can only have a observer entry or a datasource entry. ");
                }
            }
        } else if (datasource == null) {
            throw new SchemaException("Target must have datasource or observer specified as target origin. ");
        }
        if ((children = target.getElementsByTagName("alias")) != null && children.getLength() >= 1) {
            for (int j = 0; j < children.getLength(); ++j) {
                child = (Element)children.item(j);
                String aliasNameEntry = "";
                NodeList textElements3 = child.getChildNodes();
                if (textElements3 == null || textElements3.getLength() <= 0) continue;
                for (te = 0; te < textElements3.getLength(); ++te) {
                    aliasNameEntry = aliasNameEntry + textElements3.item(te).getNodeValue();
                }
                this.addAliasName(aliasNameEntry);
            }
        }
        children = target.getElementsByTagName("position");
        EquPosition position = null;
        if (children != null) {
            if (children.getLength() == 1) {
                try {
                    position = new EquPosition(children.item(0));
                }
                catch (SchemaException schema) {
                    throw new SchemaException("Target cannot set position from element: " + name, (Throwable)schema);
                }
                this.setPosition(position);
            } else if (children.getLength() > 1) {
                throw new SchemaException("Target can only have one position. ");
            }
        }
        children = target.getElementsByTagName("constellation");
        String constellation = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                NodeList textElements4 = child.getChildNodes();
                if (textElements4 != null && textElements4.getLength() > 0) {
                    for (te = 0; te < textElements4.getLength(); ++te) {
                        constellation = constellation + textElements4.item(te).getNodeValue();
                    }
                    this.setConstellation(constellation);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Target can only have one constellation. ");
            }
        }
        children = target.getElementsByTagName("notes");
        String notes = "";
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            NodeList textElements5 = child.getChildNodes();
            if (textElements5 == null || textElements5.getLength() <= 0) return;
            for (int te4 = 0; te4 < textElements5.getLength(); ++te4) {
                notes = notes + textElements5.item(te4).getNodeValue();
            }
            this.setNotes(notes);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Target can only have one notes element. ");
        }
    }

    protected Target(String name, String datasource) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null. ");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("Datasource cannot be null. ");
        }
        this.dataSource = datasource;
        this.setName(name);
    }

    protected Target(String name, IObserver observer) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null. ");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Observer cannot be null. ");
        }
        this.observer = observer;
        this.setName(name);
    }

    public String getDisplayName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        String targetName;
        if (obj == null || !(obj instanceof ITarget)) {
            return false;
        }
        ITarget target = (ITarget)obj;
        if (this.getDatasource() != null && !"".equals(this.getDatasource())) {
            String dataSource = target.getDatasource();
            if (dataSource == null) return false;
            if (!this.getDatasource().toLowerCase().trim().equals(dataSource.toLowerCase().trim())) {
                return false;
            }
        } else {
            if (this.getObserver() == null) return false;
            IObserver observer = target.getObserver();
            if (!this.getObserver().equals(observer)) {
                return false;
            }
        }
        if ((targetName = target.getName()) != null) return this.getName().toLowerCase().equals(targetName.toLowerCase()) && this.getXSIType().equals(target.getXSIType());
        return false;
    }

    public boolean equalsID(Object o) {
        return o instanceof ITarget && this.getID().equals(((ITarget)o).getID());
    }

    public abstract Element addToXmlElement(Element var1);

    public Element addAsLinkToXmlElement(Element element, String xmlElementName, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        if (xmlElementName == null || "".equals(xmlElementName.trim())) {
            xmlElementName = "target";
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement(xmlElementName);
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element container = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("targets");
            container = nodeList.getLength() == 0 ? ownerDoc.createElement("targets") : (Element)nodeList.item(0);
            this.addToXmlElement(container);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, String xmlElementName) {
        return this.addAsLinkToXmlElement(element, xmlElementName, false);
    }

    public boolean addAliasName(String newAliasName) {
        if (newAliasName == null || "".equals(newAliasName)) {
            return false;
        }
        this.aliasNames.add(newAliasName);
        return true;
    }

    public void setAliasNames(String[] newAliasNames) {
        if (newAliasNames == null || newAliasNames.length == 0) {
            this.aliasNames.clear();
            return;
        }
        this.aliasNames.clear();
        for (int i = 0; i < newAliasNames.length; ++i) {
            if (newAliasNames[i] == null || newAliasNames[i].trim().equals("")) continue;
            this.aliasNames.add(newAliasNames[i]);
        }
    }

    public String[] getAliasNames() {
        if (this.aliasNames.size() == 0) {
            return null;
        }
        return this.aliasNames.toArray(new String[0]);
    }

    public boolean removeAliasName(String aliasName) {
        if (aliasName == null || "".equals(aliasName)) {
            return false;
        }
        if (this.aliasNames.contains(aliasName)) {
            this.aliasNames.remove(aliasName);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Constellation getConstellation() {
        return this.constellation;
    }

    public void setConstellation(String constellation) {
        this.constellation = Constellation.getInstance(constellation);
    }

    public void setConstellation(Constellation constellation) {
        this.constellation = constellation;
    }

    public void setName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null. ");
        }
        this.name = name;
    }

    public EquPosition getPosition() {
        return this.position;
    }

    public IObserver getObserver() {
        return this.observer;
    }

    public String getDatasource() {
        return this.dataSource;
    }

    public void setPosition(EquPosition position) {
        this.position = position;
    }

    public void setDatasource(String datasource) {
        if (datasource != null) {
            this.observer = null;
            this.dataSource = datasource;
        }
    }

    public void setObserver(IObserver observer) {
        if (observer != null) {
            this.dataSource = null;
            this.observer = observer;
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    protected Element createXmlTargetElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Target = ownerDoc.createElement("target");
        e_Target.setAttribute("id", super.getID());
        parent.appendChild(e_Target);
        if (this.dataSource != null) {
            Element e_DataSource = ownerDoc.createElement("datasource");
            this.convertDataSource();
            CDATASection n_DataSourceText = ownerDoc.createCDATASection(this.dataSource);
            e_DataSource.appendChild(n_DataSourceText);
            e_Target.appendChild(e_DataSource);
        } else {
            this.observer.addAsLinkToXmlElement(e_Target, "observer");
        }
        Element e_Name = ownerDoc.createElement("name");
        CDATASection n_NameText = ownerDoc.createCDATASection(this.name);
        e_Name.appendChild(n_NameText);
        e_Target.appendChild(e_Name);
        if (this.aliasNames.size() != 0) {
            Element e_Alias = null;
            ListIterator iterator = this.aliasNames.listIterator();
            String alias = null;
            while (iterator.hasNext()) {
                alias = (String)iterator.next();
                e_Alias = ownerDoc.createElement("alias");
                CDATASection n_AliasText = ownerDoc.createCDATASection(alias);
                e_Alias.appendChild(n_AliasText);
                e_Target.appendChild(e_Alias);
            }
        }
        if (this.position != null) {
            e_Target = this.position.addToXmlElement(e_Target);
        }
        if (this.constellation != null) {
            Element e_Constellation = ownerDoc.createElement("constellation");
            CDATASection n_ConstellationText = ownerDoc.createCDATASection(this.constellation.getName());
            e_Constellation.appendChild(n_ConstellationText);
            e_Target.appendChild(e_Constellation);
        }
        if (this.notes != null) {
            Element e_Notes = ownerDoc.createElement("notes");
            CDATASection n_NotesText = ownerDoc.createCDATASection(this.notes);
            e_Notes.appendChild(n_NotesText);
            e_Target.appendChild(e_Notes);
        }
        return e_Target;
    }

    private void convertDataSource() {
        if (this.dataSource.startsWith("The NGC/IC Project LLC (http://www.ngcic.org) - Imported by ObservationManager")) {
            this.dataSource = "The NGC/IC Project LLC (http://www.ngcic.org) - Ver 1.11";
            return;
        }
        if (this.dataSource.endsWith("Messier Catalog Extension")) {
            this.dataSource = "ObservationManager - Messier Catalog 1.0";
            return;
        }
        if (this.dataSource.endsWith("Caldwell Catalog Extension")) {
            this.dataSource = "ObservationManager - Caldwell Catalog 1.0";
            return;
        }
        if (this.dataSource.endsWith("SolarSystem Extension")) {
            this.dataSource = "ObservationManager - SolarSystem Catalog 1.0";
            return;
        }
    }

    public boolean addAliasNames(String aliasNames) {
        if (aliasNames == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(aliasNames, ALIASNAMES_DELIMITER);
        String token = null;
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            this.aliasNames.add(token);
        }
        return true;
    }
}

