/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsASCIITableData;
import eap.fits.FitsBinTableData;
import eap.fits.FitsCardException;
import eap.fits.FitsException;
import eap.fits.FitsHeader;
import eap.fits.FitsImageData;
import eap.fits.NoSuchFitsCardException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class FitsData {
    public static final int PADDING = 0;
    protected byte[] data;
    protected int valid_bytes;
    protected boolean isComplete;
    protected DataInputStream interpreter;
    private ByteArrayInputStream reader;
    protected DataOutputStream setter;
    private InternalOutputStream writer;

    public FitsData(int n) {
        this.data = new byte[n];
        this.reader = new ByteArrayInputStream(this.data);
        this.interpreter = new DataInputStream(this.reader);
        this.writer = new InternalOutputStream();
        this.setter = new DataOutputStream(this.writer);
    }

    public FitsData(FitsHeader fitsHeader) throws FitsCardException {
        this(fitsHeader.dataSize());
    }

    public int blockCount() {
        return (this.data.length + 2880 - 1) / 2880;
    }

    protected byte[] data() {
        return this.data;
    }

    public void setValidBytes(int n) throws FitsException {
        if (n >= this.data.length) {
            this.valid_bytes = this.data.length;
            this.isComplete = true;
        } else {
            this.valid_bytes = n;
        }
    }

    public void incrementValidBytes(int n) throws FitsException {
        this.setValidBytes(this.valid_bytes + n);
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public static FitsData createFrom(FitsHeader fitsHeader) throws FitsException {
        String string;
        try {
            string = fitsHeader.card("XTENSION").stringValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            string = "IMAGE";
        }
        catch (FitsCardException fitsCardException) {
            string = "";
        }
        if (string.equals("IMAGE")) {
            return new FitsImageData(fitsHeader);
        }
        if (string.equals("BINTABLE")) {
            return new FitsBinTableData(fitsHeader);
        }
        if (string.equals("TABLE")) {
            return new FitsASCIITableData(fitsHeader);
        }
        return new FitsData(fitsHeader);
    }

    public void goToByte(long l) {
        long l2 = this.data.length - this.reader.available();
        if (l < l2) {
            this.reader.reset();
            l2 = this.reader.skip(l);
        } else {
            this.reader.skip(l - l2);
        }
        this.writer.goTo((int)l);
    }

    protected int available() {
        return this.reader.available();
    }

    private class InternalOutputStream
    extends OutputStream {
        int position;

        private InternalOutputStream() {
        }

        public void write(int n) {
            FitsData.this.data[this.position] = (byte)n;
            ++this.position;
        }

        public void goTo(int n) {
            this.position = n;
        }
    }
}

