/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.comparator;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.comparator.ObserverComparator;
import de.lehmannet.om.ui.comparator.TargetComparator;
import java.util.Calendar;
import java.util.Comparator;

public class ObservationComparator
implements Comparator {
    private boolean reverse = false;

    public ObservationComparator() {
    }

    public ObservationComparator(boolean reverse) {
        this.reverse = reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object o1, Object o2) {
        ITarget ob2T;
        ITarget ob1T;
        TargetComparator targetComparator;
        int retValue;
        if (!(o1 instanceof IObservation) || !(o2 instanceof IObservation)) return 0;
        IObservation ob1 = null;
        IObservation ob2 = null;
        if (this.reverse) {
            ob1 = (IObservation)o1;
            ob2 = (IObservation)o2;
        } else {
            ob2 = (IObservation)o1;
            ob1 = (IObservation)o2;
        }
        Calendar ob1B = ob1.getBegin();
        Calendar ob2B = ob2.getBegin();
        if (ob1B.before(ob2B)) {
            return -1;
        }
        if (ob1B.after(ob2B)) {
            return 1;
        }
        if (!ob1B.equals(ob2B)) return 0;
        Calendar ob1E = ob1.getEnd();
        Calendar ob2E = ob2.getEnd();
        if (ob1E != null) {
            if (ob2E == null) return 1;
            if (ob1E.before(ob2E)) {
                return -1;
            }
            if (ob1E.after(ob2E)) {
                return 1;
            }
        } else if (ob2E != null) {
            return -1;
        }
        if ((retValue = (targetComparator = new TargetComparator()).compare(ob1T = ob1.getTarget(), ob2T = ob2.getTarget())) != 0) return retValue;
        IObserver ob1O = ob1.getObserver();
        IObserver ob2O = ob2.getObserver();
        ObserverComparator observerComparator = new ObserverComparator();
        return observerComparator.compare(ob1O, ob2O);
    }
}

