/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class DidYouKnowDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = -8770733425729217836L;
    private static final String TEXT_PATH = "help" + File.separatorChar + "hints";
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private JButton close = new JButton(this.bundle.getString("dialog.button.ok"));
    private JButton next = new JButton(this.bundle.getString("didyouknow.button.next"));
    private JCheckBox showOnStartup = new JCheckBox(this.bundle.getString("didyouknow.checkbox.showOnStartup"));
    private JTextArea text = null;

    public DidYouKnowDialog(ObservationManager om) {
        super(om);
        this.om = om;
        super.setTitle(this.bundle.getString("didyouknow.title"));
        super.setSize(-8770733425729217836L, 440, 211);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.close)) {
                boolean show = this.showOnStartup.isSelected();
                this.om.getConfiguration().setConfig("om.help.hints.showOnStartup", Boolean.toString(show));
                this.dispose();
            }
            if (source.equals(this.next)) {
                this.text.setText(this.getText());
            }
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 10, 20);
        constraints.anchor = 10;
        constraints.fill = 0;
        Icon icon = UIManager.getIcon("OptionPane.questionIcon");
        JLabel iconLabel = new JLabel(icon);
        gridbag.setConstraints(iconLabel, constraints);
        super.getContentPane().add(iconLabel);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 2, 3, 70, 70);
        constraints.anchor = 13;
        constraints.fill = 1;
        this.text = new JTextArea();
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setEditable(false);
        this.text.setText(this.getText());
        JScrollPane scrollPane = new JScrollPane(this.text, 20, 31);
        gridbag.setConstraints(scrollPane, constraints);
        super.getContentPane().add(scrollPane);
        ConstraintsBuilder.buildConstraints(constraints, 1, 3, 2, 1, 10, 5);
        constraints.anchor = 15;
        constraints.fill = 2;
        this.showOnStartup.setSelected(Boolean.valueOf(this.om.getConfiguration().getConfig("om.help.hints.showOnStartup", "true")));
        gridbag.setConstraints(this.showOnStartup, constraints);
        super.getContentPane().add(this.showOnStartup);
        ConstraintsBuilder.buildConstraints(constraints, 1, 4, 1, 1, 6, 5);
        constraints.anchor = 15;
        constraints.fill = 2;
        this.next.addActionListener(this);
        gridbag.setConstraints(this.next, constraints);
        super.getContentPane().add(this.next);
        ConstraintsBuilder.buildConstraints(constraints, 2, 4, 1, 1, 10, 5);
        constraints.anchor = 15;
        constraints.fill = 2;
        this.close.addActionListener(this);
        gridbag.setConstraints(this.close, constraints);
        super.getContentPane().add(this.close);
    }

    private String getText() {
        double dNumber;
        String path = this.om.getInstallDir().getAbsolutePath() + File.separatorChar + TEXT_PATH + File.separatorChar + Locale.getDefault().getLanguage().toLowerCase() + File.separatorChar;
        File textDir = new File(path);
        File[] files = textDir.listFiles();
        if (files == null || files.length == 0) {
            return "No hint files found in " + path;
        }
        int iNumber = 0;
        while (!files[iNumber = (int)Math.round((dNumber = Math.random()) * (double)(files.length - 1))].isFile()) {
        }
        String current = null;
        StringBuffer text = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(files[iNumber]));
            current = br.readLine();
            while (current != null) {
                current = this.loadConvert(current);
                text.append(current);
                current = br.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Cannot find hint file: " + files[iNumber]);
        }
        catch (IOException ioe) {
            System.err.println("Error while reading file: " + files[iNumber] + "\nLast read line was: " + current);
        }
        return text.toString();
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

