/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IImager;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.tableModel.ExtendedSchemaTableModel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SchemaElementSelectorPopup
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = -8232319636708320688L;
    private JButton ok = null;
    private JButton cancel = null;
    private ExtendedSchemaTableModel tableModel = null;
    private boolean multipleSelection = false;

    public SchemaElementSelectorPopup(ObservationManager om, String title, String xsiType, List preSelectedElements, boolean multipleSelection, int schemaElement) throws IllegalArgumentException, NoSuchElementException {
        super(om);
        super.setTitle(title);
        super.setSize(-8232319636708320688L, 660, 250);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        this.multipleSelection = multipleSelection;
        IImager[] elements = null;
        switch (schemaElement) {
            case 3: {
                elements = om.getXmlCache().getImagers();
                break;
            }
            case 0: {
                elements = om.getXmlCache().getEyepieces();
                break;
            }
            case 8: {
                elements = om.getXmlCache().getFilters();
                break;
            }
            case 9: {
                elements = om.getXmlCache().getLenses();
                break;
            }
            case 2: {
                elements = om.getXmlCache().getObservations();
                break;
            }
            case 6: {
                elements = om.getXmlCache().getObservers();
                break;
            }
            case 1: {
                elements = om.getXmlCache().getScopes();
                break;
            }
            case 5: {
                elements = om.getXmlCache().getSessions();
                break;
            }
            case 4: {
                elements = om.getXmlCache().getSites();
                break;
            }
            case 7: {
                elements = om.getXmlCache().getTargets();
                break;
            }
            default: {
                throw new IllegalArgumentException("Passed schemaElement ID was wrong. Use SchemaElementConstants for retriving ID.");
            }
        }
        if (elements == null) {
            throw new NoSuchElementException("No element of type: " + schemaElement + " found in XML cache");
        }
        this.tableModel = new ExtendedSchemaTableModel((ISchemaElement[])elements, schemaElement, xsiType, multipleSelection, preSelectedElements);
        this.initDialog();
        super.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton sourceButton = (JButton)source;
            if (sourceButton.equals(this.ok)) {
                super.dispose();
            } else if (sourceButton.equals(this.cancel)) {
                super.dispose();
                this.tableModel = null;
            }
        }
    }

    public List getAllSelectedElements() {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getAllSelectedElements();
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 90, 90);
        constraints.fill = 1;
        JTable table = new JTable(this.tableModel);
        table.setEnabled(true);
        table.setEditingColumn(1);
        table.setRowSelectionAllowed(true);
        table.setSelectionMode(0);
        table.setDoubleBuffered(true);
        table.setToolTipText(AbstractDialog.bundle.getString("popup.targetSelector.table.tooltip"));
        JScrollPane scrollPane = new JScrollPane(table);
        gridbag.setConstraints(scrollPane, constraints);
        super.getContentPane().add(scrollPane);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 5, 5);
        constraints.fill = 2;
        this.ok = new JButton(AbstractDialog.bundle.getString("dialog.button.ok"));
        this.ok.addActionListener(this);
        gridbag.setConstraints(this.ok, constraints);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 5, 5);
        constraints.fill = 2;
        this.cancel = new JButton(AbstractDialog.bundle.getString("dialog.button.cancel"));
        this.cancel.addActionListener(this);
        gridbag.setConstraints(this.cancel, constraints);
        super.getContentPane().add(this.cancel);
    }
}

