/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IFinding;
import de.lehmannet.om.IImager;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class SimpleSchemaElementModel
extends AbstractSchemaTableModel {
    private static final String MODEL_ID = "SimpleSE";
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());

    public SimpleSchemaElementModel(ISchemaElement[] elements) {
        this.elements = elements;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getID() {
        return MODEL_ID;
    }

    public int getRowCount() {
        if (this.elements == null) {
            return 5;
        }
        return this.elements.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = "";
        if (this.elements == null) {
            return value;
        }
        ISchemaElement element = this.elements[rowIndex];
        if (element instanceof IEyepiece) {
            value = this.bundle.getString("eyepiece");
        } else if (element instanceof IObservation) {
            value = this.bundle.getString("observation");
        } else if (element instanceof IFilter) {
            value = this.bundle.getString("filter");
        } else if (element instanceof IFinding) {
            value = this.bundle.getString("finding");
        } else if (element instanceof IImager) {
            value = this.bundle.getString("imager");
        } else if (element instanceof IObserver) {
            value = this.bundle.getString("observer");
        } else if (element instanceof IScope) {
            value = this.bundle.getString("scope");
        } else if (element instanceof ISession) {
            value = this.bundle.getString("session");
        } else if (element instanceof ISite) {
            value = this.bundle.getString("site");
        } else if (element instanceof ITarget) {
            value = this.bundle.getString("target");
        }
        switch (columnIndex) {
            case 0: {
                value = value + " " + element.getDisplayName();
            }
        }
        return value;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = this.bundle.getString("table.header.tableElements.element");
            }
        }
        return name;
    }
}

