/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.extension;

import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.extension.IExtension;
import de.lehmannet.om.ui.extension.PopupMenuExtension;
import de.lehmannet.om.ui.preferences.PreferencesPanel;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JMenu;
import org.w3c.dom.Element;

public class GenericExtension
implements IExtension {
    public static final String NAME = "Build-In extension";
    private static final float VERSION = 0.8f;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("genericTargetDisplayNames", Locale.getDefault());
    private final HashMap findingPanels = new HashMap();
    private final HashMap targetPanels = new HashMap();
    private final HashMap targetDialogs = new HashMap();

    public GenericExtension() {
        this.initFindingPanels();
        this.initTargetDialogs();
        this.initTargetPanels();
    }

    public boolean addOALExtensionElement(Element docElement) {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public float getVersion() {
        return 0.8f;
    }

    public void reloadLanguage() {
        this.bundle = (PropertyResourceBundle)ResourceBundle.getBundle("genericTargetDisplayNames", Locale.getDefault());
    }

    public JMenu getMenu() {
        return null;
    }

    public PreferencesPanel getPreferencesPanel() {
        return null;
    }

    public ICatalog[] getCatalogs(File catalogDir) {
        return null;
    }

    public Set getAllSupportedXSITypes() {
        HashSet result = new HashSet();
        result.addAll(this.getSupportedFindingXSITypes());
        result.addAll(this.getSupportedTargetXSITypes());
        return result;
    }

    public Set getSupportedXSITypes(int schemaElementConstant) {
        Set result = null;
        if (7 == schemaElementConstant) {
            result = this.getSupportedTargetXSITypes();
        } else if (10 == schemaElementConstant) {
            result = this.getSupportedFindingXSITypes();
        }
        return result;
    }

    private Set getSupportedTargetXSITypes() {
        HashSet<String> result = new HashSet<String>();
        result.add("oal:observationTargetType");
        result.add("oal:starTargetType");
        return result;
    }

    private Set getSupportedFindingXSITypes() {
        HashSet<String> result = new HashSet<String>();
        result.add("oal:findingsType");
        return result;
    }

    public String getPanelForXSIType(String xsiType, int schemaElementConstants) {
        if (10 == schemaElementConstants) {
            return (String)this.findingPanels.get(xsiType);
        }
        if (7 == schemaElementConstants) {
            return (String)this.targetPanels.get(xsiType);
        }
        return null;
    }

    public String getDialogForXSIType(String xsiType, int schemaElementConstants) {
        if (7 == schemaElementConstants) {
            return (String)this.targetDialogs.get(xsiType);
        }
        return null;
    }

    public boolean isCreationAllowed(String xsiType) {
        return true;
    }

    public String getDisplayNameForXSIType(String xsiType) {
        try {
            return this.bundle.getString(xsiType);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    private void initFindingPanels() {
        this.findingPanels.put("oal:observationTargetType", "de.lehmannet.om.ui.panel.GenericFindingPanel");
        this.findingPanels.put("oal:findingsType", "de.lehmannet.om.ui.panel.GenericFindingPanel");
        this.findingPanels.put("oal:starTargetType", "de.lehmannet.om.ui.panel.GenericFindingPanel");
    }

    private void initTargetPanels() {
        this.targetPanels.put("oal:starTargetType", "de.lehmannet.om.ui.panel.TargetStarPanel");
        this.targetPanels.put("oal:observationTargetType", "de.lehmannet.om.ui.panel.GenericTargetPanel");
    }

    private void initTargetDialogs() {
        this.targetDialogs.put("oal:observationTargetType", "de.lehmannet.om.ui.dialog.GenericTargetDialog");
        this.targetDialogs.put("oal:starTargetType", "de.lehmannet.om.ui.dialog.TargetStarDialog");
    }

    public PopupMenuExtension getPopupMenu() {
        return null;
    }

    public URL getUpdateInformationURL() {
        return null;
    }
}

