/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ui.catalog.IListableCatalog;
import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.dialog.SchemaElementSelectorPopup;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.statistics.CatalogChecker;
import de.lehmannet.om.ui.statistics.CatalogTargets;
import de.lehmannet.om.ui.statistics.ObservationStatisticsTableModel;
import de.lehmannet.om.ui.statistics.StatisticsDetailsDialog;
import de.lehmannet.om.ui.statistics.StatisticsQueryDialog;
import de.lehmannet.om.ui.statistics.UpdateRunnable;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class StatisticsDialog
extends OMDialog
implements ActionListener,
ComponentListener {
    private static final long serialVersionUID = 6609511333362846103L;
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private List observers = null;
    private CatalogTargets[] catalogTargets = null;
    private JLabel[] resultLabels = new JLabel[0];
    private JButton[] catButtons = new JButton[0];
    private JProgressBar[] catProgress = new JProgressBar[0];
    private Thread[] checkersThreads = new Thread[0];
    CatalogChecker[] checkers = new CatalogChecker[0];
    private UpdateRunnable updateUIRunnable = null;
    private ObservationManager om = null;
    private List selectedCatalogs = null;
    protected JButton close = new JButton(this.bundle.getString("dialog.button.ok"));

    public StatisticsDialog(ObservationManager om) {
        super(om);
        StatisticsQueryDialog queryDialog = new StatisticsQueryDialog(om);
        this.selectedCatalogs = queryDialog.getSelectedCatalogs();
        Cursor defaultCursor = new Cursor(0);
        om.setCursor(defaultCursor);
        super.setCursor(defaultCursor);
        if (this.selectedCatalogs == null || this.selectedCatalogs.isEmpty()) {
            return;
        }
        this.om = om;
        super.setSize(6609511333362846103L, 600, 170);
        super.addComponentListener(this);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        IObserver[] observers = om.getXmlCache().getObservers();
        if (observers == null || observers.length == 0) {
            return;
        }
        if (observers.length > 1) {
            String defaultObserverDisplayName = this.om.getConfiguration().getConfig("om.default.observer");
            ArrayList<IObserver> preselectedObserver = new ArrayList<IObserver>();
            for (int i = 0; i < observers.length; ++i) {
                if (!observers[i].getDisplayName().equals(defaultObserverDisplayName)) continue;
                preselectedObserver.add(observers[i]);
                break;
            }
            SchemaElementSelectorPopup popup = new SchemaElementSelectorPopup(this.om, this.bundle.getString("dialog.statistics.observerPopup.title"), null, preselectedObserver, true, 6);
            this.observers = popup.getAllSelectedElements();
            if (this.observers == null || this.observers.isEmpty()) {
                return;
            }
        } else {
            this.observers = Arrays.asList(observers);
        }
        super.setTitle(this.bundle.getString("dialog.statistics.title.prefix"));
        this.initDialog();
        this.pack();
        this.createCatalogueStatistics();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.close)) {
                for (int j = 0; j < this.checkersThreads.length; ++j) {
                    if (!this.checkersThreads[j].isAlive()) continue;
                    this.checkers[j].stop();
                }
                if (this.updateUIRunnable != null) {
                    this.updateUIRunnable.stop();
                }
                this.dispose();
            } else {
                JButton current = null;
                for (int i = 0; i < this.catButtons.length; ++i) {
                    current = this.catButtons[i];
                    if (!source.equals(current)) continue;
                    ListIterator iterator = this.selectedCatalogs.listIterator();
                    boolean found = false;
                    IListableCatalog currentCat = null;
                    while (iterator.hasNext() && !found) {
                        currentCat = (IListableCatalog)iterator.next();
                        if (!current.getActionCommand().equals(currentCat.getName())) continue;
                        found = true;
                    }
                    this.getObservationsForCatalog(currentCat);
                }
            }
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            for (int j = 0; j < this.checkersThreads.length; ++j) {
                if (!this.checkersThreads[j].isAlive()) continue;
                this.checkers[j].stop();
            }
            this.updateUIRunnable.stop();
            this.dispose();
        }
    }

    public void componentResized(ComponentEvent e) {
        int MIN_WIDTH = 600;
        int width = this.getWidth();
        boolean resize = false;
        if (width < 600) {
            resize = true;
            width = 600;
        }
        if (resize) {
            this.setSize(width, this.getHeight());
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private void createCatalogueStatistics() {
        Iterator iterator = this.selectedCatalogs.iterator();
        IListableCatalog current = null;
        IObservation[] observations = this.om.getXmlCache().getObservations();
        boolean useCoObservers = Boolean.valueOf(this.om.getConfiguration().getConfig("om.statistics.useCoObservers"));
        this.checkers = new CatalogChecker[this.selectedCatalogs.size()];
        this.checkersThreads = new Thread[this.selectedCatalogs.size()];
        int i = 0;
        while (iterator.hasNext()) {
            current = (IListableCatalog)iterator.next();
            this.checkers[i] = new CatalogChecker(current, observations, this.observers, useCoObservers, this.catProgress[i]);
            this.checkersThreads[i] = new Thread((Runnable)this.checkers[i], current.getName());
            this.checkersThreads[i++].start();
        }
        this.updateUIRunnable = new UpdateRunnable(this);
        Thread updateUI = new Thread((Runnable)this.updateUIRunnable, "Update Statistics UI");
        updateUI.start();
    }

    boolean showButton(int index) {
        if (this.catProgress[index] == null) {
            return false;
        }
        this.catalogTargets[index] = this.checkers[index].getCatalogTargets();
        int observed = this.catalogTargets[index].numberOfObservations();
        int total = this.checkers[index].getCatalog().getCatalogIndex().length;
        int percentage = (int)(100.0 / (double)total * (double)observed);
        String resultText = observed + "/" + total + " (" + percentage + "%)\n";
        this.resultLabels[index].setText(resultText);
        GridBagLayout gridbag = (GridBagLayout)super.getContentPane().getLayout();
        GridBagConstraints constraints = gridbag.getConstraints(this.catProgress[index]);
        super.getContentPane().remove(this.catProgress[index]);
        this.catProgress[index] = null;
        gridbag.setConstraints(this.catButtons[index], constraints);
        super.getContentPane().add(this.catButtons[index]);
        if (super.getGraphics() != null) {
            super.getContentPane().update(super.getGraphics());
        }
        super.invalidate();
        super.validate();
        super.pack();
        super.repaint();
        return true;
    }

    private void getObservationsForCatalog(IListableCatalog cat) {
        for (int i = 0; i < this.catalogTargets.length; ++i) {
            if (this.catalogTargets[i] == null || !this.catalogTargets[i].getCatalog().equals(cat)) continue;
            ObservationStatisticsTableModel tableModel = new ObservationStatisticsTableModel(this.catalogTargets[i]);
            new StatisticsDetailsDialog(this.om, tableModel);
            break;
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        super.getContentPane().setLayout(gridbag);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 4, 1, 100, 1);
        JLabel headerLabel = new JLabel(this.bundle.getString("dialog.statistics.label.catalogs"));
        gridbag.setConstraints(headerLabel, constraints);
        super.getContentPane().add(headerLabel);
        constraints.fill = 2;
        constraints.anchor = 10;
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 50, 1);
        JLabel catNameLabel = new JLabel(this.bundle.getString("dialog.statistics.label.catalogName"));
        catNameLabel.setFont(new Font("Arial", 3, 12));
        gridbag.setConstraints(catNameLabel, constraints);
        super.getContentPane().add(catNameLabel);
        ConstraintsBuilder.buildConstraints(constraints, 2, 1, 1, 1, 50, 1);
        JLabel catResultLabel = new JLabel(this.bundle.getString("dialog.statistics.label.result"));
        catResultLabel.setFont(new Font("Arial", 3, 12));
        gridbag.setConstraints(catResultLabel, constraints);
        super.getContentPane().add(catResultLabel);
        constraints.anchor = 17;
        int size = this.selectedCatalogs.size();
        JLabel[] catLabels = new JLabel[size];
        this.resultLabels = new JLabel[size];
        this.catButtons = new JButton[size];
        this.catProgress = new JProgressBar[size];
        this.catalogTargets = new CatalogTargets[size];
        IListableCatalog current = null;
        int i = 0;
        ListIterator iterator = this.selectedCatalogs.listIterator();
        while (iterator.hasNext()) {
            current = (IListableCatalog)iterator.next();
            ConstraintsBuilder.buildConstraints(constraints, 1, i + 2, 1, 1, 33, 1);
            catLabels[i] = new JLabel(current.getName());
            catLabels[i].setFont(new Font("Arial", 0, 12));
            gridbag.setConstraints(catLabels[i], constraints);
            super.getContentPane().add(catLabels[i]);
            ConstraintsBuilder.buildConstraints(constraints, 2, i + 2, 1, 1, 33, 1);
            this.resultLabels[i] = new JLabel();
            this.resultLabels[i].setFont(new Font("Arial", 0, 12));
            gridbag.setConstraints(this.resultLabels[i], constraints);
            super.getContentPane().add(this.resultLabels[i]);
            this.catButtons[i] = new JButton(this.bundle.getString("dialog.statistics.button.details"));
            this.catButtons[i].addActionListener(this);
            this.catButtons[i].setActionCommand(current.getName());
            ConstraintsBuilder.buildConstraints(constraints, 3, i + 2, 1, 1, 33, 1);
            this.catProgress[i] = new JProgressBar();
            this.catProgress[i].setStringPainted(true);
            gridbag.setConstraints(this.catProgress[i], constraints);
            super.getContentPane().add(this.catProgress[i]);
            ++i;
        }
        ConstraintsBuilder.buildConstraints(constraints, 0, i + 2, 4, 1, 100, 1);
        this.close.addActionListener(this);
        gridbag.setConstraints(this.close, constraints);
        super.getContentPane().add(this.close);
    }
}

