/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.update;

import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.dialog.ProgressDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.update.DownloadTask;
import de.lehmannet.om.ui.update.UpdateTableModel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class UpdateInfoDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = -6681965343558223755L;
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private JButton close = new JButton(this.bundle.getString("dialog.button.cancel"));
    private JButton download = new JButton(this.bundle.getString("updateInfo.button.download"));
    private JTable infoTable = null;
    private ObservationManager om = null;
    private List updateEntries = null;

    public UpdateInfoDialog(ObservationManager om, List updateEntryList) {
        super(om);
        this.om = om;
        this.updateEntries = updateEntryList;
        super.setTitle(this.bundle.getString("updateInfo.title"));
        super.setSize(-6681965343558223755L, 390, 180);
        super.setModal(true);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            List downloadList;
            if (source.equals(this.close)) {
                this.dispose();
            } else if (source.equals(this.download) && (downloadList = ((UpdateTableModel)this.infoTable.getModel()).getSelected()) != null && !downloadList.isEmpty()) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(this);
                File directory = null;
                if (returnVal == 0) {
                    directory = chooser.getSelectedFile();
                    boolean result = this.downloadFiles(downloadList, directory);
                    if (result) {
                        this.om.createInfo(this.bundle.getString("updateInfo.download.success"));
                        this.dispose();
                    } else {
                        this.om.createWarning(this.bundle.getString("updateInfo.download.error"));
                    }
                } else {
                    return;
                }
            }
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 5, 20, 98);
        constraints.anchor = 17;
        constraints.fill = 1;
        this.infoTable = new JTable(new UpdateTableModel(this.updateEntries, this.download));
        this.infoTable.setRowSelectionAllowed(false);
        this.infoTable.setDefaultRenderer(String.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (column == 2 || column == 3) {
                    cr.setHorizontalAlignment(0);
                }
                cr.setText(value.toString());
                return cr;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.infoTable);
        gridbag.setConstraints(scrollPane, constraints);
        super.getContentPane().add(scrollPane);
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 1, 1, 20, 1);
        constraints.fill = 2;
        this.download.addActionListener(this);
        gridbag.setConstraints(this.download, constraints);
        super.getContentPane().add(this.download);
        ConstraintsBuilder.buildConstraints(constraints, 1, 5, 1, 1, 50, 1);
        constraints.fill = 2;
        this.close.addActionListener(this);
        gridbag.setConstraints(this.close, constraints);
        super.getContentPane().add(this.close);
    }

    private boolean downloadFiles(List updateEntries, File directory) {
        DownloadTask downloadTask = new DownloadTask(updateEntries, directory);
        new ProgressDialog(this.om, this.bundle.getString("updateInfo.downloadProgress.title"), this.bundle.getString("updateInfo.downloadProgress.information"), downloadTask);
        return downloadTask.getReturnType() == 0;
    }
}

