/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ITargetContaining;
import de.lehmannet.om.OALException;
import de.lehmannet.om.RootElement;
import de.lehmannet.om.ui.comparator.EyepieceComparator;
import de.lehmannet.om.ui.comparator.FilterComparator;
import de.lehmannet.om.ui.comparator.ImagerComparator;
import de.lehmannet.om.ui.comparator.LensComparator;
import de.lehmannet.om.ui.comparator.ObservationComparator;
import de.lehmannet.om.ui.comparator.ObserverComparator;
import de.lehmannet.om.ui.comparator.ScopeComparator;
import de.lehmannet.om.ui.comparator.SessionComparator;
import de.lehmannet.om.ui.comparator.SiteComparator;
import de.lehmannet.om.ui.comparator.TargetComparator;
import de.lehmannet.om.ui.util.CacheEntry;
import de.lehmannet.om.util.SchemaException;
import de.lehmannet.om.util.SchemaLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;

public class XMLFileLoader {
    private ArrayList cache = null;
    private File schemaPath = null;
    private SchemaLoader loader = new SchemaLoader();

    public XMLFileLoader(File schemaFile) {
        this.cache = new ArrayList();
        this.schemaPath = schemaFile;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean isEmpty() {
        RootElement root = this.getRootElement();
        return root == null;
    }

    public boolean save(String path) {
        return this.saveAs(null, path);
    }

    public boolean saveAs(String oldPath, String newPath) {
        RootElement root = this.getRootElement();
        try {
            root.serializeAsXml(new File(newPath));
            ((CacheEntry)this.cache.iterator().next()).setXMLPath(newPath);
        }
        catch (SchemaException se) {
            System.err.println("Unable to write file: " + newPath + "\n" + (Object)((Object)se));
            return false;
        }
        return true;
    }

    public Document getDocument() {
        RootElement root = this.getRootElement();
        try {
            if (root != null) {
                return root.getDocument();
            }
            System.err.println("Unable to retrieve DOM Document\n");
        }
        catch (SchemaException se) {
            System.err.println("Unable to retrieve DOM Document\n" + (Object)((Object)se));
        }
        return null;
    }

    public String getXMLFileForSchemaElement(ISchemaElement schemaElement) {
        if (this.cache.isEmpty()) {
            return null;
        }
        return ((CacheEntry)this.cache.listIterator().next()).getXmlPath();
    }

    public String getXMLPathForSchemaElement(ISchemaElement schemaElement) {
        return new File(this.getXMLFileForSchemaElement(schemaElement)).getParent();
    }

    public Document getDocumentForSchemaElement(ISchemaElement schemaElement) {
        if (schemaElement == null) {
            return null;
        }
        RootElement root = new RootElement();
        if (schemaElement instanceof IObservation) {
            this.addObservationAndDependentToRoot((IObservation)schemaElement, root);
        } else {
            IObservation[] observations = this.getObservations(schemaElement);
            if (observations == null || observations.length == 0) {
                return null;
            }
            this.addObservationsAndDependentToRoot(Arrays.asList(observations), root);
        }
        try {
            if (root != null) {
                return root.getDocument();
            }
            System.err.println("Unable to retrieve DOM Document for " + schemaElement);
        }
        catch (SchemaException se) {
            System.err.println("Unable to retrieve DOM Document for " + schemaElement + "\n" + (Object)((Object)se));
        }
        return null;
    }

    public void addSchemaElement(ISchemaElement element) {
        if (element == null) {
            return;
        }
        CacheEntry entry = null;
        if (this.cache.isEmpty()) {
            entry = new CacheEntry();
            this.cache.add(entry);
        } else {
            entry = (CacheEntry)this.cache.iterator().next();
        }
        if (element instanceof IObserver) {
            entry.addObserver((IObserver)element);
        } else if (element instanceof IEyepiece) {
            entry.addEyepiece((IEyepiece)element);
        } else if (element instanceof IImager) {
            entry.addImager((IImager)element);
        } else if (element instanceof IFilter) {
            entry.addFilter((IFilter)element);
        } else if (element instanceof IObservation) {
            entry.addObservation((IObservation)element);
        } else if (element instanceof IScope) {
            entry.addScope((IScope)element);
        } else if (element instanceof ISite) {
            entry.addSite((ISite)element);
        } else if (element instanceof ISession) {
            entry.addSession((ISession)element);
        } else if (element instanceof ITarget) {
            entry.addTarget((ITarget)element);
        } else if (element instanceof ILens) {
            entry.addLens((ILens)element);
        } else {
            System.out.print("Unknown element: " + element);
        }
    }

    public void addSchemaElement(ISchemaElement element, boolean dependend) {
        if (element == null) {
            return;
        }
        CacheEntry entry = null;
        if (this.cache.isEmpty()) {
            entry = new CacheEntry();
            this.cache.add(entry);
        } else {
            entry = (CacheEntry)this.cache.iterator().next();
        }
        if (element instanceof IObserver) {
            entry.addObserver((IObserver)element);
        } else if (element instanceof IEyepiece) {
            entry.addEyepiece((IEyepiece)element);
        } else if (element instanceof IImager) {
            entry.addImager((IImager)element);
        } else if (element instanceof IFilter) {
            entry.addFilter((IFilter)element);
        } else if (element instanceof IObservation) {
            entry.addObservation((IObservation)element);
            IObservation observation = (IObservation)element;
            if (observation.getObserver() != null) {
                entry.addObserver(observation.getObserver());
            }
            if (observation.getEyepiece() != null) {
                entry.addEyepiece(observation.getEyepiece());
            }
            if (observation.getImager() != null) {
                entry.addImager(observation.getImager());
            }
            if (observation.getFilter() != null) {
                entry.addFilter(observation.getFilter());
            }
            if (observation.getScope() != null) {
                entry.addScope(observation.getScope());
            }
            if (observation.getSite() != null) {
                entry.addSite(observation.getSite());
            }
            if (observation.getSession() != null) {
                entry.addSession(observation.getSession());
                ISession session = observation.getSession();
                if (session.getCoObservers() != null) {
                    ListIterator iterator = session.getCoObservers().listIterator();
                    while (iterator.hasNext()) {
                        entry.addObserver((IObserver)iterator.next());
                    }
                }
                if (session.getSite() != null) {
                    entry.addSite(session.getSite());
                }
            }
            if (observation.getTarget() != null) {
                entry.addTarget(observation.getTarget());
            }
            if (observation.getLens() != null) {
                entry.addLens(observation.getLens());
            }
        } else if (element instanceof IScope) {
            entry.addScope((IScope)element);
        } else if (element instanceof ISite) {
            entry.addSite((ISite)element);
        } else if (element instanceof ISession) {
            entry.addSession((ISession)element);
            ISession session = (ISession)element;
            if (session.getCoObservers() != null) {
                ListIterator iterator = session.getCoObservers().listIterator();
                while (iterator.hasNext()) {
                    entry.addObserver((IObserver)iterator.next());
                }
            }
            if (session.getSite() != null) {
                entry.addSite(session.getSite());
            }
        } else if (element instanceof ITarget) {
            entry.addTarget((ITarget)element);
        } else if (element instanceof ILens) {
            entry.addLens((ILens)element);
        } else {
            System.out.print("Unknown element: " + element);
        }
    }

    public List removeSchemaElement(ISchemaElement element) {
        List resultList = new ArrayList();
        CacheEntry entry = null;
        if (this.cache.isEmpty()) {
            return resultList;
        }
        entry = (CacheEntry)this.cache.iterator().next();
        if (element instanceof IObserver) {
            resultList = entry.removeObserver((IObserver)element);
        } else if (element instanceof IEyepiece) {
            resultList = entry.removeEyepiece((IEyepiece)element);
        } else if (element instanceof IImager) {
            resultList = entry.removeImager((IImager)element);
        } else if (element instanceof IFilter) {
            resultList = entry.removeFilter((IFilter)element);
        } else if (element instanceof IObservation) {
            resultList = entry.removeObservation((IObservation)element);
        } else if (element instanceof IScope) {
            resultList = entry.removeScope((IScope)element);
        } else if (element instanceof ISite) {
            resultList = entry.removeSite((ISite)element);
        } else if (element instanceof ISession) {
            resultList = entry.removeSession((ISession)element);
        } else if (element instanceof ITarget) {
            resultList = entry.removeTarget((ITarget)element);
        } else if (element instanceof ILens) {
            resultList = entry.removeLens((ILens)element);
        } else {
            System.out.print("Unknown element for deletion: " + element);
            return null;
        }
        return resultList;
    }

    public void updateSchemaElement(ISchemaElement element) {
        if (element instanceof IObservation) {
            IObservation observation = (IObservation)element;
            CacheEntry entry = null;
            if (this.cache.isEmpty()) {
                return;
            }
            entry = (CacheEntry)this.cache.iterator().next();
            entry.updateObservation(observation);
        } else if (element instanceof ISession) {
            ISession session = (ISession)element;
            CacheEntry entry = null;
            if (this.cache.isEmpty()) {
                return;
            }
            entry = (CacheEntry)this.cache.iterator().next();
            IObservation[] observations = this.getObservations(element);
            if (observations != null && observations.length > 0) {
                entry.updateSession(observations, session);
            }
        } else if (element instanceof ITarget && element instanceof ITargetContaining) {
            ITarget target = (ITarget)element;
            CacheEntry entry = null;
            if (this.cache.isEmpty()) {
                return;
            }
            entry = (CacheEntry)this.cache.iterator().next();
            entry.updateTarget(target);
        }
    }

    public String[] getAllOpenedFiles() {
        String[] files = new String[this.cache.size()];
        ListIterator iterator = this.cache.listIterator();
        int x = 0;
        String path = null;
        while (iterator.hasNext()) {
            path = ((CacheEntry)iterator.next()).getXmlPath();
            if (path == null) continue;
            files[x++] = path;
        }
        if (files.length == 1 && files[0] == null) {
            return null;
        }
        return files;
    }

    public IObserver[] getObservers() {
        IObserver[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getObservers();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IObserver[] currentArray = null;
            IObserver[][] o = new IObserver[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getObservers();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IObserver[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ObserverComparator());
        return result;
    }

    public IEyepiece[] getEyepieces() {
        IEyepiece[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getEyepieces();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IEyepiece[] currentArray = null;
            IEyepiece[][] o = new IEyepiece[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getEyepieces();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IEyepiece[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new EyepieceComparator());
        return result;
    }

    public IImager[] getImagers() {
        IImager[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getImagers();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IImager[] currentArray = null;
            IImager[][] o = new IImager[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getImagers();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IImager[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ImagerComparator());
        return result;
    }

    public IFilter[] getFilters() {
        IFilter[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getFilters();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IFilter[] currentArray = null;
            IFilter[][] o = new IFilter[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getFilters();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IFilter[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new FilterComparator());
        return result;
    }

    public IObservation[] getObservations() {
        IObservation[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getObservations();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IObservation[] currentArray = null;
            IObservation[][] o = new IObservation[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getObservations();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IObservation[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ObservationComparator());
        return result;
    }

    public IObservation[] getObservations(ISchemaElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IObservation) {
            return this.getObservations();
        }
        IObservation[] result = null;
        if (this.cache.size() == 1) {
            List list = ((CacheEntry)this.cache.get(0)).getReferedElements(element);
            if (list == null) {
                return null;
            }
            result = list.toArray(new IObservation[0]);
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IObservation[] currentArray = null;
            IObservation[][] o = new IObservation[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                List list = current.getReferedElements(element);
                if (list == null) {
                    return null;
                }
                currentArray = list.toArray(new IObservation[0]);
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IObservation[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ObservationComparator());
        return result;
    }

    public IObservation[] getCoObserverObservations(IObserver observer) {
        if (observer == null) {
            return null;
        }
        IObservation[] result = null;
        if (this.cache.size() == 1) {
            List list = ((CacheEntry)this.cache.get(0)).getReferencedObservationsForCoObserver(observer);
            if (list == null) {
                return null;
            }
            result = list.toArray(new IObservation[0]);
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IObservation[] currentArray = null;
            IObservation[][] o = new IObservation[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                List list = current.getReferencedObservationsForCoObserver(observer);
                if (list == null) {
                    return null;
                }
                currentArray = list.toArray(new IObservation[0]);
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IObservation[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ObservationComparator());
        return result;
    }

    public IScope[] getScopes() {
        IScope[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getScopes();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            IScope[] currentArray = null;
            IScope[][] o = new IScope[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getScopes();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new IScope[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new ScopeComparator());
        return result;
    }

    public ISession[] getSessions() {
        ISession[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getSessions();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            ISession[] currentArray = null;
            ISession[][] o = new ISession[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getSessions();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new ISession[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new SessionComparator());
        return result;
    }

    public ISite[] getSites() {
        ISite[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getSites();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            ISite[] currentArray = null;
            ISite[][] o = new ISite[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getSites();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new ISite[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new SiteComparator());
        return result;
    }

    public ITarget[] getTargets() {
        ITarget[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getTargets();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            ITarget[] currentArray = null;
            ITarget[][] o = new ITarget[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getTargets();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new ITarget[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new TargetComparator());
        return result;
    }

    public ILens[] getLenses() {
        ILens[] result = null;
        if (this.cache.size() == 1) {
            result = ((CacheEntry)this.cache.get(0)).getLenses();
        } else {
            ListIterator iterator = this.cache.listIterator();
            CacheEntry current = null;
            ILens[] currentArray = null;
            ILens[][] o = new ILens[this.cache.size()][];
            int i = 0;
            int resultSize = 0;
            while (iterator.hasNext()) {
                current = (CacheEntry)iterator.next();
                currentArray = current.getLenses();
                if (currentArray == null || currentArray.length <= 0) continue;
                o[i++] = currentArray;
                resultSize += currentArray.length;
            }
            result = new ILens[resultSize];
            if (resultSize == 0) {
                return result;
            }
            int j = 0;
            for (int x = 0; x < o.length; ++x) {
                currentArray = o[x];
                for (int y = 0; y < currentArray.length; ++y) {
                    result[j++] = currentArray[y];
                }
            }
        }
        Arrays.sort(result, new LensComparator());
        return result;
    }

    public boolean loadObservations(String xmlPath) {
        try {
            this.loader.load(new File(xmlPath), this.schemaPath);
            IObservation[] obs = this.loader.getObservations();
            IEyepiece[] eye = this.loader.getEyepieces();
            IFilter[] fil = this.loader.getFilters();
            IImager[] imager = this.loader.getImagers();
            IObserver[] observers = this.loader.getObservers();
            IScope[] scopes = this.loader.getScopes();
            ISession[] sessions = this.loader.getSessions();
            ISite[] sites = this.loader.getSites();
            ITarget[] targets = this.loader.getTargets();
            ILens[] lenses = this.loader.getLenses();
            this.cache.clear();
            this.cache.add(new CacheEntry(xmlPath, obs, eye, fil, imager, observers, scopes, sessions, sites, targets, lenses));
        }
        catch (OALException oal) {
            System.err.print("Cannot load: " + xmlPath + "\nNested Exception is: " + oal.getMessage());
            return false;
        }
        return true;
    }

    private RootElement getRootElement() {
        RootElement root = new RootElement();
        if (this.cache.isEmpty()) {
            return null;
        }
        CacheEntry entry = (CacheEntry)this.cache.listIterator().next();
        try {
            ILens[] len;
            IObservation[] obsera;
            ISession[] sea;
            ITarget[] ta;
            IImager[] ia;
            IFilter[] fil;
            IEyepiece[] ea;
            IObserver[] oa;
            ISite[] sia;
            IScope[] sa = entry.getScopes();
            if (sa != null && sa.length > 0) {
                root.addScopes(Arrays.asList(sa));
            }
            if ((sia = entry.getSites()) != null && sia.length > 0) {
                root.addSites(Arrays.asList(sia));
            }
            if ((oa = entry.getObservers()) != null && oa.length > 0) {
                root.addObservers(Arrays.asList(oa));
            }
            if ((ea = entry.getEyepieces()) != null && ea.length > 0) {
                root.addEyepieces(Arrays.asList(ea));
            }
            if ((fil = entry.getFilters()) != null && fil.length > 0) {
                root.addFilters(Arrays.asList(fil));
            }
            if ((ia = entry.getImagers()) != null && ia.length > 0) {
                root.addImagers(Arrays.asList(ia));
            }
            if ((ta = entry.getTargets()) != null && ta.length > 0) {
                root.addTargets(Arrays.asList(ta));
            }
            if ((sea = entry.getSessions()) != null && sea.length > 0) {
                root.addSessions(Arrays.asList(sea));
            }
            if ((obsera = entry.getObservations()) != null && obsera.length > 0) {
                root.addObservations(Arrays.asList(obsera));
            }
            if ((len = entry.getLenses()) != null && len.length > 0) {
                root.addLenses(Arrays.asList(len));
            }
        }
        catch (SchemaException se) {
            System.err.println("Unable to add elements\n" + (Object)((Object)se));
        }
        return root;
    }

    private void addObservationsAndDependentToRoot(List observations, RootElement root) {
        ListIterator iterator = observations.listIterator();
        while (iterator.hasNext()) {
            this.addObservationAndDependentToRoot((IObservation)iterator.next(), root);
        }
    }

    private void addObservationAndDependentToRoot(IObservation observation, RootElement root) {
        try {
            ILens lens;
            ISession session;
            ITarget target;
            IImager imager;
            IFilter filter;
            IEyepiece eyepiece;
            IObserver observer;
            ISite site;
            IScope scope = observation.getScope();
            if (scope != null) {
                root.addScope(scope);
            }
            if ((site = observation.getSite()) != null) {
                root.addSite(site);
            }
            if ((observer = observation.getObserver()) != null) {
                root.addObserver(observer);
            }
            if ((eyepiece = observation.getEyepiece()) != null) {
                root.addEyepiece(eyepiece);
            }
            if ((filter = observation.getFilter()) != null) {
                root.addFilter(filter);
            }
            if ((imager = observation.getImager()) != null) {
                root.addImager(imager);
            }
            if ((target = observation.getTarget()) != null) {
                root.addTarget(target);
            }
            if ((session = observation.getSession()) != null) {
                root.addSession(session);
            }
            if ((lens = observation.getLens()) != null) {
                root.addLens(lens);
            }
            root.addObservation(observation);
        }
        catch (SchemaException se) {
            System.err.println("Unable to add element\n" + (Object)((Object)se));
        }
    }
}

