/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.bild;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.NoTriangleException;
import de.andreasroerig.bild.RGBBild;
import de.andreasroerig.match.Star;
import de.andreasroerig.match.StarTriangle;
import de.andreasroerig.util.RegParams;

public class MatchFinder
implements Runnable {
    private RGBBild bild1;
    private RGBBild bild2;
    private RGBBild registeredImage;
    private Star[] sa1;
    private Star[] sa2;
    private RegParams theParams = RegParams.instance();

    public MatchFinder() {
    }

    public MatchFinder(RGBBild b1, RGBBild b2) {
        this();
        this.bild1 = b1;
        this.bild2 = b2;
        this.registeredImage = null;
        this.sa1 = b1.getStarArray();
        this.sa2 = b2.getStarArray();
    }

    public MatchFinder(Bild b1, Bild b2) {
        this();
    }

    public void run() {
    }

    public RGBBild registerSun() {
        Star s1 = this.bild1.findSunCenter();
        Star s2 = this.bild2.findSunCenter();
        int xoff = s1.getX() - s2.getX();
        int yoff = s1.getY() - s2.getY();
        System.out.println("xoff = " + xoff);
        System.out.println("yoff = " + yoff);
        RGBBild resImg = this.bild2.shiftXY(this.bild1.getWidth(), this.bild1.getLen(), xoff, yoff);
        return resImg;
    }

    protected double calcAngle(double a, double b, double c) {
        double cosine = (Math.pow(b, 2.0) + Math.pow(c, 2.0) - Math.pow(a, 2.0)) / (2.0 * b * c);
        return Math.toDegrees(Math.acos(cosine));
    }

    public void findMatch() {
        int matchCount = 0;
        int maxLoopIdx = this.theParams.getMaxNumStars();
        int maxIdx1 = Math.min(this.bild1.getStarCount() - 3, maxLoopIdx);
        int maxIdx2 = Math.min(this.bild2.getStarCount() - 3, maxLoopIdx);
        StarTriangle st1 = new StarTriangle();
        StarTriangle st2 = new StarTriangle();
        System.out.println("findMatch started!");
        try {
            int j;
            int i;
            if (this.theParams.getSearchBrightness()) {
                this.bild1.sortStarArray(2);
                this.bild2.sortStarArray(2);
                i = 0;
                while (i < maxIdx1) {
                    try {
                        st1 = this.getBrightStarTriangle(i, this.sa1);
                        if (!st1.isFlat()) {
                            this.bild1.setSt(st1);
                            j = 0;
                            while (j < maxIdx2) {
                                st2 = this.getBrightStarTriangle(j, this.sa2);
                                this.bild2.setSt(st2);
                                if (st1.equals(st2)) {
                                    System.out.println("Match found! i=" + i + " j=" + j);
                                    this.bild1.addMatch(st1);
                                    this.bild2.addMatch(st2);
                                    ++matchCount;
                                }
                                ++j;
                            }
                        }
                    }
                    catch (NoTriangleException e) {
                        System.out.println("NoTriangleException.");
                    }
                    ++i;
                }
                System.out.println("--------------------------------------------------------");
                System.out.println("findMatch after first section! matchCount=" + matchCount);
                System.out.println("--------------------------------------------------------");
                this.verifyMatches();
                this.bild1.removeInvalidMatches();
                this.bild2.removeInvalidMatches();
                matchCount = this.bild1.getNumMatches();
            }
            if (this.theParams.getSearchCenterDistance() && matchCount < 50) {
                this.bild1.sortStarArray(1);
                this.bild2.sortStarArray(1);
                i = 0;
                while (i < maxIdx1) {
                    try {
                        st1 = this.getCloseStarTriangle(i, this.sa1);
                        if (!st1.isFlat()) {
                            j = 0;
                            while (j < maxIdx2) {
                                st2 = this.getCloseStarTriangle(j, this.sa2);
                                if (st1.equals(st2)) {
                                    System.out.println("Match found! i=" + i + " j=" + j);
                                    this.bild1.addMatch(st1);
                                    this.bild2.addMatch(st2);
                                    ++matchCount;
                                }
                                ++j;
                            }
                            Thread.sleep(1L);
                        }
                    }
                    catch (NoTriangleException e) {
                        System.out.println("NoTriangleException");
                    }
                    ++i;
                }
                System.out.println("--------------------------------------------------------");
                System.out.println("findMatch after second section! matchCount=" + matchCount);
                System.out.println("--------------------------------------------------------");
            }
            if (this.theParams.getSearchOriginDistance() && matchCount < 50) {
                this.bild1.sortStarArray(0);
                this.bild2.sortStarArray(0);
                i = 0;
                while (i < maxIdx1) {
                    try {
                        st1 = this.getCloseStarTriangle(i, this.sa1);
                        if (!st1.isFlat()) {
                            j = 0;
                            while (j < maxIdx2) {
                                st2 = this.getCloseStarTriangle(j, this.sa2);
                                if (st1.equals(st2)) {
                                    System.out.println("Match found! i=" + i + " j=" + j);
                                    this.bild1.addMatch(st1);
                                    this.bild2.addMatch(st2);
                                    ++matchCount;
                                }
                                ++j;
                            }
                            Thread.sleep(1L);
                        }
                    }
                    catch (NoTriangleException e) {
                        System.out.println("NoTriangleException");
                    }
                    ++i;
                }
            }
            System.out.println("--------------------------------------------------------");
            System.out.println("findMatch matchCount=" + matchCount);
            this.verifyMatches();
            this.bild1.removeInvalidMatches();
            this.bild2.removeInvalidMatches();
            System.out.println("findMatch ended! Final matchCount=" + this.bild1.getNumMatches());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void verifyMatches() {
        int vecSize = this.bild1.getNumMatches();
        int i = 0;
        try {
            i = 0;
            while (i < vecSize) {
                StarTriangle b1m1 = this.bild1.getMatch(i);
                StarTriangle b2m1 = this.bild2.getMatch(i);
                this.bild1.setSt(b1m1);
                this.bild2.setSt(b2m1);
                int j = vecSize - 1;
                while (j >= 0) {
                    if (i != j) {
                        StarTriangle b1m2 = this.bild1.getMatch(j);
                        StarTriangle b2m2 = this.bild2.getMatch(j);
                        if (!b1m1.equals(b1m2) && !b2m1.equals(b2m2)) {
                            try {
                                StarTriangle st2;
                                Star s1 = b1m1.getS1();
                                Star s2 = b1m2.getS2();
                                Star s3 = b1m2.getS3();
                                if (s1.isSamePos(s2)) {
                                    s2 = b1m1.getS2();
                                }
                                if (s1.isSamePos(s3)) {
                                    s3 = b1m2.getS1();
                                }
                                StarTriangle st1 = new StarTriangle(s1, s2, s3);
                                s1 = b2m1.getS1();
                                s2 = b2m2.getS2();
                                s3 = b2m2.getS3();
                                if (s1.isSamePos(s2)) {
                                    s2 = b2m1.getS2();
                                }
                                if (s1.isSamePos(s3)) {
                                    s3 = b2m2.getS1();
                                }
                                if (st1.equals(st2 = new StarTriangle(s1, s2, s3))) {
                                    System.out.println("Match verified! i=" + i);
                                    st1.debug();
                                    st2.debug();
                                    b1m1.setVerified(true);
                                    b2m1.setVerified(true);
                                    break;
                                }
                            }
                            catch (NoTriangleException e) {
                                System.out.println("NoTriangleException!");
                            }
                        }
                    }
                    --j;
                }
                System.out.println("verify! i=" + i);
                Thread.sleep(1L);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("vecsize = " + vecSize + ", i = " + i);
        }
    }

    private StarTriangle getCloseStarTriangle(int sIdx, Star[] ar) throws NoTriangleException {
        double closest = Double.MAX_VALUE;
        double secondclosest = Double.MAX_VALUE;
        int closestIdx = 0;
        int secondIdx = 0;
        int hI = this.theParams.getHalfIntervall();
        int startIdx = sIdx - hI < 0 ? 0 : sIdx - hI;
        int endIdx = sIdx + hI >= ar.length ? ar.length - 1 : sIdx + hI;
        int i = startIdx;
        while (i < endIdx) {
            double curDist = ar[sIdx].calcDistance(ar[i]);
            if (curDist <= closest && i != sIdx) {
                secondIdx = closestIdx;
                secondclosest = closest;
                closestIdx = i;
                closest = curDist;
            } else if (curDist <= secondclosest && i != sIdx) {
                secondIdx = i;
                secondclosest = curDist;
            }
            ++i;
        }
        return new StarTriangle(ar[sIdx], ar[closestIdx], ar[secondIdx]);
    }

    private StarTriangle getBrightStarTriangle(int sIdx, Star[] ar) throws NoTriangleException {
        if (sIdx < ar.length - 3) {
            return new StarTriangle(ar[sIdx], ar[sIdx + 1], ar[sIdx + 2]);
        }
        return null;
    }

    public RGBBild getRegisteredImage() {
        return this.registeredImage;
    }
}

