/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.bild;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.IllegalDimensionException;
import de.andreasroerig.bild.SigmaClipper;
import de.andreasroerig.fits.FitsConst;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsFile;
import de.andreasroerig.fits.FitsHDUnit;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsMatrix;
import de.andreasroerig.match.Star;
import de.andreasroerig.match.Trans;
import de.andreasroerig.tiff.TiffOutputStream;
import de.andreasroerig.tiff.TiffReader;
import de.andreasroerig.util.SLogger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;

public class RGBBild
extends Bild {
    private int[][] r;
    private int[][] g;
    private int[][] b;

    public RGBBild() {
        this.photometric = 2;
        this.theStars = null;
        this.st = null;
        this.sampPerPix = 3;
    }

    public RGBBild(int len, int width) {
        this();
        this.r = new int[len][width];
        this.g = new int[len][width];
        this.b = new int[len][width];
        this.len = len;
        this.width = width;
    }

    public RGBBild(RGBBild aBild) {
        this();
        this.r = new int[aBild.len][aBild.width];
        this.g = new int[aBild.len][aBild.width];
        this.b = new int[aBild.len][aBild.width];
        this.len = aBild.len;
        this.width = aBild.width;
        this.bitsPerSamp = aBild.bitsPerSamp;
        this.bigEnd = aBild.bigEnd;
        this.sampPerPix = aBild.sampPerPix;
        this.type = aBild.type;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                this.r[i][j] = aBild.r[i][j];
                this.g[i][j] = aBild.g[i][j];
                this.b[i][j] = aBild.b[i][j];
                ++j;
            }
            ++i;
        }
        this.fname = aBild.getFname();
        this.calcStats();
    }

    public RGBBild(TiffReader tr) {
        super(tr);
        this.photometric = 2;
        this.theStars = null;
        this.st = null;
    }

    public void getDataFromTiffReader(TiffReader tr) {
        this.r = tr.getR();
        this.g = tr.getG();
        this.b = tr.getB();
    }

    protected void destroyData() {
        this.r = null;
        this.g = null;
        this.b = null;
    }

    public void writeAsSplitedFits(String dir, String fname) {
        String extension = ".fit";
        double zero = Math.abs(Short.MIN_VALUE);
        try {
            int j;
            int[] naxis = new int[]{this.width, this.len};
            int nax = naxis[0] * naxis[1];
            short[] data = new short[nax];
            int n = 0;
            int i = 0;
            while (i < this.len) {
                j = 0;
                while (j < this.width) {
                    data[n] = (short)(this.r[i][j] + Short.MIN_VALUE);
                    ++n;
                    ++j;
                }
                ++i;
            }
            FitsHDUnit hdu0 = null;
            FitsMatrix mtx0 = new FitsMatrix(16, naxis);
            mtx0.setShortValues(0, data);
            FitsHeader hdr0 = mtx0.getHeader();
            hdr0.addKeyword(new FitsKeyword("BSCALE", 1.0, "BSCALE value"));
            hdr0.addKeyword(new FitsKeyword("BZERO", zero, "BZERO value"));
            hdr0.addKeyword(new FitsKeyword("", ""));
            hdr0.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            hdu0 = new FitsHDUnit(hdr0, mtx0);
            FitsFile file = new FitsFile();
            file.addHDUnit(hdu0);
            int noHDU = file.getNoHDUnits();
            SLogger.debug("FITS file has " + noHDU + " HDUnits");
            file.writeFile(String.valueOf(dir) + "R_" + fname + extension);
            naxis = new int[]{this.width, this.len};
            nax = naxis[0] * naxis[1];
            data = new short[nax];
            n = 0;
            n = 0;
            i = 0;
            while (i < this.len) {
                j = 0;
                while (j < this.width) {
                    data[n] = (short)(this.g[i][j] + Short.MIN_VALUE);
                    ++n;
                    ++j;
                }
                ++i;
            }
            hdu0 = null;
            mtx0 = new FitsMatrix(16, naxis);
            mtx0.setShortValues(0, data);
            hdr0 = mtx0.getHeader();
            hdr0.addKeyword(new FitsKeyword("BSCALE", 1.0, "BSCALE value"));
            hdr0.addKeyword(new FitsKeyword("BZERO", zero, "BZERO value"));
            hdr0.addKeyword(new FitsKeyword("", ""));
            hdr0.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            hdu0 = new FitsHDUnit(hdr0, mtx0);
            file = new FitsFile();
            file.addHDUnit(hdu0);
            noHDU = file.getNoHDUnits();
            SLogger.debug("FITS file has " + noHDU + " HDUnits");
            file.writeFile(String.valueOf(dir) + "G_" + fname + extension);
            naxis = new int[]{this.width, this.len};
            nax = naxis[0] * naxis[1];
            data = new short[nax];
            n = 0;
            n = 0;
            i = 0;
            while (i < this.len) {
                j = 0;
                while (j < this.width) {
                    data[n] = (short)(this.b[i][j] + Short.MIN_VALUE);
                    ++n;
                    ++j;
                }
                ++i;
            }
            hdu0 = null;
            mtx0 = new FitsMatrix(16, naxis);
            mtx0.setShortValues(0, data);
            hdr0 = mtx0.getHeader();
            hdr0.addKeyword(new FitsKeyword("BSCALE", 1.0, "BSCALE value"));
            hdr0.addKeyword(new FitsKeyword("BZERO", zero, "BZERO value"));
            hdr0.addKeyword(new FitsKeyword("", ""));
            hdr0.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            hdu0 = new FitsHDUnit(hdr0, mtx0);
            file = new FitsFile();
            file.addHDUnit(hdu0);
            noHDU = file.getNoHDUnits();
            SLogger.debug("FITS file has " + noHDU + " HDUnits");
            file.writeFile(String.valueOf(dir) + "B_" + fname + extension);
        }
        catch (FitsException e) {
            System.err.println("Error: FITS problem in writing >" + fname + "<");
        }
        catch (IOException e) {
            System.err.println("Error: cannot write file >" + fname + "<");
        }
        SLogger.debug("RGBBild.writeAsFits() beendet!");
    }

    protected void writeTiffStrip(TiffOutputStream ras) throws IOException {
        int[] theBytes = new int[3];
        int y = 0;
        while (y < this.len) {
            int x = 0;
            while (x < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes = this.getByteArray(this.r[y][x]);
                    ras.write(theBytes[0]);
                    ras.write(theBytes[1]);
                    theBytes = this.getByteArray(this.g[y][x]);
                    ras.write(theBytes[0]);
                    ras.write(theBytes[1]);
                    theBytes = this.getByteArray(this.b[y][x]);
                    ras.write(theBytes[0]);
                    ras.write(theBytes[1]);
                } else if (this.bitsPerSamp == 8) {
                    ras.write(this.r[y][x]);
                    ras.write(this.g[y][x]);
                    ras.write(this.b[y][x]);
                }
                ++x;
            }
            this.sleep(0);
            SLogger.print(".");
            ++y;
        }
        SLogger.println("#");
    }

    public void readFromTiff(String fname) throws IOException {
        this.fname = fname;
        try {
            TiffReader tr = new TiffReader(fname);
            this.type = 0;
            tr.readFromTiff();
            this.r = tr.getR();
            this.g = tr.getG();
            this.b = tr.getB();
            this.width = tr.getWidth();
            this.len = tr.getLen();
            this.bitsPerSamp = tr.getBitsPerSamp();
            this.sampPerPix = tr.getSampPerPix();
            this.calcStats();
        }
        catch (IOException e) {
            SLogger.debug("RGBBild.readFromTiff() IOException! " + e.getMessage());
            throw e;
        }
    }

    public void readFromFits(String fname) throws IOException {
        this.fname = fname;
        FitsFile file = null;
        this.type = 2;
        try {
            file = new FitsFile(fname);
            int noHDU = file.getNoHDUnits();
            SLogger.debug("FITS file has " + noHDU + " HDUnits");
            int i = 0;
            while (i < noHDU) {
                FitsHDUnit hdu = file.getHDUnit(i);
                FitsHeader hdr = hdu.getHeader();
                int noKw = hdr.getNoKeywords();
                int type = hdr.getType();
                int size = (int)hdr.getDataSize();
                SLogger.debug("  " + i + ": >" + hdr.getName() + "< of type >" + FitsConst.getType(type) + "< with " + noKw + " keywords" + " and " + size + " bytes of data");
                SLogger.debug("   Keywords:");
                Enumeration enumeration = hdr.getKeywords();
                while (enumeration.hasMoreElements()) {
                    FitsKeyword kw = (FitsKeyword)enumeration.nextElement();
                    SLogger.debug("     " + kw.getName());
                    switch (kw.getType()) {
                        case 1: {
                            SLogger.debug("(C) " + kw.getComment());
                            break;
                        }
                        case 2: {
                            SLogger.debug("(S)= '" + kw.getString() + "'");
                            break;
                        }
                        case 3: {
                            SLogger.debug("(B)= " + kw.getBool());
                            break;
                        }
                        case 4: {
                            SLogger.debug("(I)= " + kw.getInt());
                            break;
                        }
                        case 5: {
                            SLogger.debug("(R)= " + kw.getReal());
                            break;
                        }
                        case 6: {
                            SLogger.debug("(D)= " + kw.getString());
                        }
                    }
                    if (kw.getComment().length() <= 0 || kw.getType() == 1) continue;
                    System.out.print(" / " + kw.getComment());
                }
                if (type == 1) {
                    SLogger.debug("\n  Check data matrix - compute mean and rms");
                    FitsMatrix dm = (FitsMatrix)hdu.getData();
                    int[] naxis = dm.getNaxis();
                    double[] crval = dm.getCrval();
                    double[] crpix = dm.getCrpix();
                    double[] cdelt = dm.getCdelt();
                    SLogger.debug("  Dimension of matrix: " + naxis.length);
                    int n = 0;
                    while (n < naxis.length) {
                        SLogger.debug("   Axis " + n + ": " + naxis[n] + ",  " + crpix[n] + ",  " + crval[n] + ",  " + cdelt[n]);
                        ++n;
                    }
                    int nval = dm.getNoValues();
                    if (nval > 0) {
                        int ncol = naxis[0];
                        int nrow = nval / ncol;
                        this.width = ncol;
                        this.len = nrow;
                        this.r = new int[this.len][this.width];
                        this.g = new int[this.len][this.width];
                        this.b = new int[this.len][this.width];
                        this.bitsPerSamp = 16;
                        this.sampPerPix = 1;
                        SLogger.debug(" Npixel,row,col: " + nval + ", " + nrow + ", " + ncol);
                        float[] data = new float[ncol];
                        int npix = 0;
                        int nv = 0;
                        int off = 0;
                        double rms = 0.0;
                        double mean = 0.0;
                        long time = System.currentTimeMillis();
                        int nr = 0;
                        while (nr < nrow) {
                            try {
                                dm.getFloatValues(off, ncol, data);
                                int n2 = 0;
                                while (n2 < ncol) {
                                    int n3 = (int)Math.rint(data[n2]);
                                    this.b[nr][n2] = n3;
                                    this.g[nr][n2] = n3;
                                    this.r[nr][n2] = n3;
                                    ++n2;
                                }
                            }
                            catch (FitsException fitsException) {
                                // empty catch block
                            }
                            off += ncol;
                            ++nr;
                        }
                        rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                        float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nval);
                        SLogger.debug("  Mean: " + (float)mean + ", rms: " + (float)rms + ", Time: " + dtime + " S/Mp, Pixels: " + npix);
                    }
                }
                ++i;
            }
        }
        catch (FitsException e) {
            SLogger.debug("RGBBild.readFromTiff() FitsException! " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            SLogger.debug("RGBBild.readFromTiff() IOException! " + e.getMessage());
            throw e;
        }
        this.calcStats();
    }

    public Bild subtract(Bild sub) throws IllegalDimensionException {
        RGBBild rgb = (RGBBild)sub;
        RGBBild resImg = new RGBBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.type = this.type;
        this.checkDimensions(this, sub);
        int y = 0;
        while (y < this.len) {
            SLogger.print("~");
            int x = 0;
            while (x < this.width) {
                resImg.r[y][x] = this.r[y][x] - rgb.r[y][x] >= 0 ? this.r[y][x] - rgb.r[y][x] : 0;
                resImg.g[y][x] = this.g[y][x] - rgb.g[y][x] >= 0 ? this.g[y][x] - rgb.g[y][x] : 0;
                resImg.b[y][x] = this.b[y][x] - rgb.b[y][x] >= 0 ? this.b[y][x] - rgb.b[y][x] : 0;
                ++x;
            }
            ++y;
        }
        SLogger.println("#");
        resImg.calcStats();
        return resImg;
    }

    public void blendFiles(File[] files) throws IllegalDimensionException, IOException {
        int numfiles = files.length;
        SLogger.debug("blending Files...");
        TiffReader[] tr = new TiffReader[numfiles];
        int[][][] rows = new int[numfiles][][];
        try {
            int i = 0;
            while (i < numfiles) {
                tr[i] = new TiffReader(files[i].getAbsolutePath());
                tr[i].readTiffHeader();
                tr[i].readIfd();
                if (i == 0) {
                    this.width = tr[i].getWidth();
                    this.len = tr[i].getLen();
                    this.r = new int[this.len][this.width];
                    this.g = new int[this.len][this.width];
                    this.b = new int[this.len][this.width];
                    this.bitsPerSamp = tr[i].getBitsPerSamp();
                    this.sampPerPix = tr[i].getSampPerPix();
                } else {
                    if (this.width != tr[i].getWidth() || this.len != tr[i].getLen()) {
                        throw new IllegalDimensionException(tr[i].getFname());
                    }
                    if (tr[i].getImgType() != 0) {
                        throw new IllegalDimensionException("Images have different types!");
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = tr[i].readRow();
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    double blau = 0.0;
                    double gruen = 0.0;
                    double rot = 0.0;
                    i = 0;
                    while (i < numfiles) {
                        rot += (double)rows[i][k][0];
                        gruen += (double)rows[i][k][1];
                        blau += (double)rows[i][k][2];
                        ++i;
                    }
                    this.r[j][k] = (int)(rot / (double)numfiles);
                    this.g[j][k] = (int)(gruen / (double)numfiles);
                    this.b[j][k] = (int)(blau / (double)numfiles);
                    ++k;
                }
                ++j;
            }
            SLogger.println("#");
            this.calcStats();
            this.setFname("BlendedFiles.tif");
            SLogger.debug("blending Files finished!");
        }
        catch (IOException e) {
            SLogger.debug("blendFiles Exception: " + e);
            throw e;
        }
    }

    public void sigmaCombineFiles(File[] files) throws IllegalDimensionException, IOException {
        int numfiles = files.length;
        double sigma = this.theParams.getCombineSigma();
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        int[] rdata = new int[numfiles];
        int[] gdata = new int[numfiles];
        int[] bdata = new int[numfiles];
        SLogger.debug("blending Files...");
        TiffReader[] tr = new TiffReader[numfiles];
        int[][][] rows = new int[numfiles][][];
        try {
            int i = 0;
            while (i < numfiles) {
                tr[i] = new TiffReader(files[i].getAbsolutePath());
                tr[i].readTiffHeader();
                tr[i].readIfd();
                if (i == 0) {
                    this.width = tr[i].getWidth();
                    this.len = tr[i].getLen();
                    this.r = new int[this.len][this.width];
                    this.g = new int[this.len][this.width];
                    this.b = new int[this.len][this.width];
                    this.bitsPerSamp = tr[i].getBitsPerSamp();
                    this.sampPerPix = tr[i].getSampPerPix();
                } else {
                    if (this.width != tr[i].getWidth() || this.len != tr[i].getLen()) {
                        throw new IllegalDimensionException(tr[i].getFname());
                    }
                    if (tr[i].getImgType() != 0) {
                        throw new IllegalDimensionException("Images have different types!");
                    }
                }
                ++i;
            }
            SigmaClipper sc = new SigmaClipper(sigma, ignoreBlackBorder);
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = tr[i].readRow();
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    i = 0;
                    while (i < numfiles) {
                        rdata[i] = rows[i][k][0];
                        gdata[i] = rows[i][k][1];
                        bdata[i] = rows[i][k][2];
                        ++i;
                    }
                    this.r[j][k] = sc.calcSigmaClip(rdata);
                    this.g[j][k] = sc.calcSigmaClip(gdata);
                    this.b[j][k] = sc.calcSigmaClip(bdata);
                    ++k;
                }
                ++j;
            }
            this.calcStats();
            sc.printStats();
            this.setFname("SigmaCombinedFiles.tif");
            SLogger.println("#");
            SLogger.debug("sigma combining Files finished!");
        }
        catch (IOException e) {
            SLogger.debug("sigmaCombineFiles Exception: " + e);
            throw e;
        }
    }

    protected Bild doBlend(Bild[] bilder, int[] frameIndices, double[] weight) {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        RGBBild resImg = this.cpyBildParam();
        RGBBild[] tmp = this.cpyBildArray(bilder);
        double sumWeight = this.calcSumWeight(weight, frameIndices.length);
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                double blau = 0.0;
                double gruen = 0.0;
                double rot = 0.0;
                double tempSumWeight = sumWeight;
                int i = 0;
                while (i < frameIndices.length) {
                    double tr = tmp[frameIndices[i]].r[l][w];
                    double tg = tmp[frameIndices[i]].g[l][w];
                    double tb = tmp[frameIndices[i]].b[l][w];
                    if (ignoreBlackBorder && tr <= 0.0 && tg <= 0.0 && tb <= 0.0) {
                        tempSumWeight -= weight[i];
                    } else {
                        rot += tr * weight[i];
                        gruen += tg * weight[i];
                        blau += tb * weight[i];
                    }
                    ++i;
                }
                resImg.r[l][w] = (int)(rot / tempSumWeight);
                resImg.g[l][w] = (int)(gruen / tempSumWeight);
                resImg.b[l][w] = (int)(blau / tempSumWeight);
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    public Bild doSigmaCombine(Bild[] bilder, int[] frameIndices) throws IllegalDimensionException {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        double sigma = this.theParams.getCombineSigma();
        RGBBild resImg = this.cpyBildParam();
        RGBBild[] tmp = this.cpyBildArray(bilder);
        int[] rtmparray = new int[frameIndices.length];
        int[] gtmparray = new int[frameIndices.length];
        int[] btmparray = new int[frameIndices.length];
        int i = 0;
        while (i < frameIndices.length) {
            SLogger.debug("frameInices[" + i + "]=" + frameIndices[i]);
            if (tmp[frameIndices[i]].len != this.len || tmp[frameIndices[i]].width != this.width) {
                throw new IllegalDimensionException(tmp[frameIndices[i]].getFname());
            }
            if (!tmp[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        SigmaClipper sc = new SigmaClipper(sigma, ignoreBlackBorder);
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                i = 0;
                while (i < frameIndices.length) {
                    rtmparray[i] = tmp[frameIndices[i]].r[l][w];
                    gtmparray[i] = tmp[frameIndices[i]].g[l][w];
                    btmparray[i] = tmp[frameIndices[i]].b[l][w];
                    ++i;
                }
                resImg.r[l][w] = sc.calcSigmaClip(rtmparray);
                resImg.g[l][w] = sc.calcSigmaClip(gtmparray);
                resImg.b[l][w] = sc.calcSigmaClip(btmparray);
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        sc.printStats();
        return resImg;
    }

    private RGBBild cpyBildParam() {
        RGBBild resImg = new RGBBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.compression = this.compression;
        resImg.photometric = this.photometric;
        resImg.type = this.type;
        return resImg;
    }

    public void medianCombineFiles(File[] files) throws IOException, IllegalDimensionException {
        int numfiles = files.length;
        SLogger.debug("median Combine Files...");
        boolean oddIndices = numfiles / 2 * 2 != numfiles;
        int medIndex = numfiles / 2;
        if (numfiles == 2) {
            medIndex = 0;
        }
        int[] rot = new int[numfiles];
        int[] gruen = new int[numfiles];
        int[] blau = new int[numfiles];
        TiffReader[] tr = new TiffReader[numfiles];
        int[][][] rows = new int[numfiles][][];
        try {
            int i = 0;
            while (i < numfiles) {
                tr[i] = new TiffReader(files[i].getAbsolutePath());
                tr[i].readTiffHeader();
                tr[i].readIfd();
                if (i == 0) {
                    this.width = tr[i].getWidth();
                    this.len = tr[i].getLen();
                    this.r = new int[this.len][this.width];
                    this.g = new int[this.len][this.width];
                    this.b = new int[this.len][this.width];
                    this.bitsPerSamp = tr[i].getBitsPerSamp();
                    this.sampPerPix = tr[i].getSampPerPix();
                } else {
                    if (this.width != tr[i].getWidth() || this.len != tr[i].getLen()) {
                        throw new IllegalDimensionException(tr[i].getFname());
                    }
                    if (tr[i].getImgType() != 0) {
                        throw new IllegalDimensionException("Images have different types!");
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = tr[i].readRow();
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    i = 0;
                    while (i < numfiles) {
                        rot[i] = rows[i][k][0];
                        gruen[i] = rows[i][k][1];
                        blau[i] = rows[i][k][2];
                        ++i;
                    }
                    Arrays.sort(rot);
                    Arrays.sort(gruen);
                    Arrays.sort(blau);
                    if (oddIndices) {
                        this.r[j][k] = rot[medIndex];
                        this.g[j][k] = gruen[medIndex];
                        this.b[j][k] = blau[medIndex];
                    } else {
                        this.r[j][k] = (rot[medIndex] + rot[medIndex + 1]) / 2;
                        this.g[j][k] = (gruen[medIndex] + gruen[medIndex + 1]) / 2;
                        this.b[j][k] = (blau[medIndex] + blau[medIndex + 1]) / 2;
                    }
                    ++k;
                }
                ++j;
            }
            this.calcStats();
            this.setFname("medianCombinedFiles.tif");
            SLogger.println("#");
            SLogger.debug("median Combine Files finished!");
        }
        catch (IOException e) {
            SLogger.debug("medianCombineFiles Exception: " + e);
            throw e;
        }
        rows = null;
        tr = null;
        rot = null;
        gruen = null;
        blau = null;
        System.gc();
    }

    public Bild medianCombine(Bild[] bilder, int[] frameIndices) throws IllegalDimensionException {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        RGBBild[] tmp = this.cpyBildArray(bilder);
        SLogger.debug("calc Median of images...");
        boolean oddIndices = frameIndices.length / 2 * 2 != frameIndices.length;
        int medIndex = frameIndices.length / 2;
        if (frameIndices.length == 2) {
            medIndex = 0;
        }
        RGBBild resImg = this.cpyBildParam();
        int[] rot = new int[frameIndices.length];
        int[] gruen = new int[frameIndices.length];
        int[] blau = new int[frameIndices.length];
        double sumWeight = 0.0;
        int i = 0;
        while (i < frameIndices.length) {
            SLogger.debug("frameInices[" + i + "]=" + frameIndices[i]);
            if (bilder[frameIndices[i]].len != this.len || bilder[frameIndices[i]].width != this.width) {
                throw new IllegalDimensionException(bilder[frameIndices[i]].getFname());
            }
            if (!bilder[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                int tfi = frameIndices.length;
                int j = 0;
                i = 0;
                while (i < tfi) {
                    int tr = tmp[frameIndices[i]].r[l][w];
                    int tg = tmp[frameIndices[i]].g[l][w];
                    int tb = tmp[frameIndices[i]].b[l][w];
                    rot[i] = tr;
                    gruen[i] = tg;
                    blau[i] = tb;
                    if (!ignoreBlackBorder || tr > 0 || tg > 0 || tb > 0) {
                        ++j;
                    }
                    ++i;
                }
                if (j == 0) {
                    j = frameIndices.length;
                }
                Arrays.sort(rot);
                Arrays.sort(gruen);
                Arrays.sort(blau);
                oddIndices = j / 2 * 2 != j;
                medIndex = j / 2;
                medIndex = frameIndices.length - medIndex - 1;
                if (j == 2) {
                    medIndex = frameIndices.length - 2;
                }
                if (j == 1) {
                    medIndex = frameIndices.length - 1;
                }
                if (oddIndices) {
                    resImg.r[l][w] = rot[medIndex];
                    resImg.g[l][w] = gruen[medIndex];
                    resImg.b[l][w] = blau[medIndex];
                } else {
                    resImg.r[l][w] = (rot[medIndex] + rot[medIndex + 1]) / 2;
                    resImg.g[l][w] = (gruen[medIndex] + gruen[medIndex + 1]) / 2;
                    resImg.b[l][w] = (blau[medIndex] + blau[medIndex + 1]) / 2;
                }
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    public void chnlMultiplikation(RGBBild aBild, double fr, double fg, double fb) {
        int high = 255;
        if (this.bitsPerSamp == 16) {
            high = 65535;
        }
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                int val = (int)((double)aBild.r[l][w] * fr);
                this.r[l][w] = val > high ? high : val;
                val = (int)((double)aBild.g[l][w] * fg);
                this.g[l][w] = val > high ? high : val;
                val = (int)((double)aBild.b[l][w] * fb);
                this.b[l][w] = val > high ? high : val;
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
    }

    public void toBW() {
        int l = 0;
        while (l < this.len) {
            int w = 0;
            while (w < this.width) {
                int val;
                int n = val = (int)Math.round((double)(this.r[l][w] + this.g[l][w] + this.b[l][w]) / 3.0);
                this.b[l][w] = n;
                this.g[l][w] = n;
                this.r[l][w] = n;
                ++w;
            }
            ++l;
        }
    }

    public Bild doFlat(Bild flat) {
        int maxval = 256;
        RGBBild myFlat = (RGBBild)flat;
        RGBBild resImg = new RGBBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.compression = this.compression;
        resImg.photometric = this.photometric;
        resImg.type = this.type;
        flat.calcStats();
        if (this.bitsPerSamp == 16) {
            maxval = 65535;
        }
        int l = 0;
        while (l < this.len) {
            SLogger.print("-");
            int w = 0;
            while (w < this.width) {
                int val = (int)Math.round(flat.avgBrightness * (double)this.r[l][w] / (double)myFlat.r[l][w]);
                resImg.r[l][w] = val <= maxval ? val : maxval;
                val = (int)Math.round(flat.avgBrightness * (double)this.g[l][w] / (double)myFlat.g[l][w]);
                resImg.g[l][w] = val <= maxval ? val : maxval;
                val = (int)Math.round(flat.avgBrightness * (double)this.b[l][w] / (double)myFlat.b[l][w]);
                resImg.b[l][w] = val <= maxval ? val : maxval;
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    public BufferedImage getBufferedImage(int black, int white, int zoom) {
        int rgb;
        int tb;
        int tg;
        int tr;
        int jz;
        int j;
        int iz;
        int i;
        this.zoom = zoom;
        this.screenWidth = this.width / zoom;
        this.screenLen = this.len / zoom;
        BufferedImage bi = new BufferedImage(this.screenWidth, this.screenLen, 1);
        double mult = white - black != 0 ? 255.0 / (double)(white - black) : 255.0;
        if (this.bitsPerSamp == 8) {
            i = 0;
            while (i < this.screenLen) {
                iz = i * zoom;
                j = 0;
                while (j < this.screenWidth) {
                    jz = j * zoom;
                    tr = (int)((double)(this.r[iz][jz] - black) * mult);
                    tg = (int)((double)(this.g[iz][jz] - black) * mult);
                    tb = (int)((double)(this.b[iz][jz] - black) * mult);
                    tr = tr > 0 ? tr : 0;
                    tg = tg > 0 ? tg : 0;
                    tb = tb > 0 ? tb : 0;
                    tr = tr < 256 ? tr : 255;
                    tg = tg < 256 ? tg : 255;
                    tb = tb < 256 ? tb : 255;
                    rgb = tr * 65536 + tg * 256 + tb;
                    bi.setRGB(j, i, rgb);
                    ++j;
                }
                ++i;
            }
        }
        if (this.bitsPerSamp == 16) {
            i = 0;
            while (i < this.screenLen) {
                iz = i * zoom;
                j = 0;
                while (j < this.screenWidth) {
                    jz = j * zoom;
                    tr = (int)((double)(this.r[iz][jz] / 256 - black) * mult);
                    tg = (int)((double)(this.g[iz][jz] / 256 - black) * mult);
                    tb = (int)((double)(this.b[iz][jz] / 256 - black) * mult);
                    tr = tr > 0 ? tr : 0;
                    tg = tg > 0 ? tg : 0;
                    tb = tb > 0 ? tb : 0;
                    tr = tr < 256 ? tr : 255;
                    tg = tg < 256 ? tg : 255;
                    tb = tb < 256 ? tb : 255;
                    rgb = tr * 65536 + tg * 256 + tb;
                    bi.setRGB(j, i, rgb);
                    ++j;
                }
                ++i;
            }
        }
        return bi;
    }

    public BufferedImage getBufferedImage(int black, int white) {
        if (this.width > 1024 || this.len > 800) {
            this.zoom = 2;
        }
        if (this.width > 1200 || this.len > 1000) {
            this.zoom = 3;
        }
        if (this.width > 2200 || this.len > 2000) {
            this.zoom = 4;
        }
        return this.getBufferedImage(black, white, this.zoom);
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(0, 255);
    }

    public void createTestImage() {
        this.width = 256;
        this.len = 256;
        this.bitsPerSamp = 16;
        this.bigEnd = true;
        this.sampPerPix = 3;
        this.type = 0;
        this.r = new int[this.len][this.width];
        this.g = new int[this.len][this.width];
        this.b = new int[this.len][this.width];
        int val = 0;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                int n = val++;
                this.b[i][j] = n;
                this.g[i][j] = n;
                this.r[i][j] = n;
                ++j;
            }
            ++i;
        }
        this.setFname("testimg.tif");
        this.calcStats();
    }

    public Star findSunCenter() {
        int xmin = 999999;
        int xmax = 0;
        int ymin = 999999;
        int ymax = 0;
        int y = 0;
        int x = 0;
        double curBright = 0.0;
        boolean yflag = false;
        int i = 0;
        while (i < this.len) {
            boolean flag = false;
            int j = 0;
            while (j < this.width) {
                curBright = this.calcBrightnes(j, i);
                if (curBright > this.maxBrightness / 3.0) {
                    if (!flag && j < xmin) {
                        xmin = j;
                        flag = true;
                    }
                    if (!yflag) {
                        ymin = i;
                        yflag = true;
                    }
                    ymax = i;
                } else if (flag && j > xmax) {
                    xmax = j;
                    flag = false;
                    break;
                }
                ++j;
            }
            ++i;
        }
        SLogger.debug("xmin = " + xmin);
        SLogger.debug("xmax = " + xmax);
        SLogger.debug("y = " + y);
        x = xmin + (xmax - xmin) / 2;
        y = ymin + (ymax - ymin) / 2;
        return new Star(x, y, curBright);
    }

    protected double calcBrightnes(int x, int y) {
        double erg = 0.0;
        try {
            try {
                erg = (double)(this.r[y][x] + this.g[y][x] + this.b[y][x]) / 3.0;
            }
            catch (Exception e) {
                SLogger.debug("Exception: calcBrightness, x=" + x + ", y=" + y);
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return erg;
    }

    public RGBBild shiftXY(int nw, int nh, int x, int y) {
        long st = System.currentTimeMillis();
        SLogger.debug("shifting image...");
        SLogger.debug("nw=" + nw);
        SLogger.debug("nh=" + nh);
        SLogger.debug("x=" + x);
        SLogger.debug("y=" + y);
        x = -x;
        y = -y;
        RGBBild resImg = new RGBBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.type = this.type;
        int iy = 0;
        while (iy < nh) {
            int iyy = iy + y;
            int ix = 0;
            while (ix < nw) {
                int ixx = ix + x;
                if (ixx >= 0 && iyy >= 0 && ixx < this.width && iyy < this.len) {
                    resImg.r[iy][ix] = this.r[iyy][ixx];
                    resImg.g[iy][ix] = this.g[iyy][ixx];
                    resImg.b[iy][ix] = this.b[iyy][ixx];
                } else {
                    resImg.r[iy][ix] = 0;
                    resImg.g[iy][ix] = 0;
                    resImg.b[iy][ix] = 0;
                }
                ++ix;
            }
            this.sleep(0);
            ++iy;
        }
        long et = System.currentTimeMillis();
        SLogger.debug("ShiftXY done in " + (et - st) + "ms");
        return resImg;
    }

    public Bild transform(Trans t, int nw, int nh) {
        SLogger.debug("transformation start");
        long t1 = System.currentTimeMillis();
        RGBBild resImg = new RGBBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                double cx = t.calcX(x, y);
                double cy = t.calcY(x, y);
                int ix = (int)cx;
                int iy = (int)cy;
                if (ix >= 0 && iy >= 0 && ix < this.width && iy < this.len) {
                    resImg.b[y][x] = this.b[iy][ix];
                    resImg.g[y][x] = this.g[iy][ix];
                    resImg.r[y][x] = this.r[iy][ix];
                }
                ++x;
            }
            SLogger.print(".");
            ++y;
        }
        long t2 = System.currentTimeMillis();
        long tt = t2 - t1;
        SLogger.debug("");
        SLogger.debug("transformation end, time elapsed=" + tt);
        return resImg;
    }

    public Bild transformInterpol(Trans t, int nw, int nh) {
        SLogger.debug("transformation start");
        long t1 = System.currentTimeMillis();
        RGBBild resImg = new RGBBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                double blau = 0.0;
                double gruen = 0.0;
                double rot = 0.0;
                double cx = t.calcX(x, y);
                double cy = t.calcY(x, y);
                int ix = (int)cx;
                int iy = (int)cy;
                double dx = cx - (double)ix;
                double dy = cy - (double)iy;
                blau = 0.0;
                gruen = 0.0;
                rot = 0.0;
                int m = -1;
                while (m < 3) {
                    int ixPlusM = ix + m;
                    double mdx = (double)m - dx;
                    double frmdx = this.fr(mdx);
                    int n = -1;
                    while (n < 3) {
                        int iyn = iy + n;
                        double ndy = (double)n - dy;
                        if (ixPlusM >= 0 && iyn >= 0 && ixPlusM < this.width && iyn < this.len) {
                            double frndy = this.fr(ndy);
                            double frmdxfrndy = frmdx * frndy;
                            blau += (double)this.b[iyn][ixPlusM] * frmdxfrndy;
                            gruen += (double)this.g[iyn][ixPlusM] * frmdxfrndy;
                            rot += (double)this.r[iyn][ixPlusM] * frmdxfrndy;
                        }
                        ++n;
                    }
                    ++m;
                }
                resImg.b[y][x] = (int)Math.rint(blau);
                resImg.g[y][x] = (int)Math.rint(gruen);
                resImg.r[y][x] = (int)Math.rint(rot);
                ++x;
            }
            SLogger.print(".");
            ++y;
        }
        long t2 = System.currentTimeMillis();
        long tt = t2 - t1;
        SLogger.debug("");
        SLogger.debug("transformation end, time elapsed=" + tt);
        return resImg;
    }

    public Bild rotate(int nw, int nh, boolean left) {
        RGBBild resImg = new RGBBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                int ix;
                int iy;
                if (left) {
                    iy = x;
                    ix = nh - y - 1;
                } else {
                    iy = nw - x - 1;
                    ix = y;
                }
                resImg.b[y][x] = this.b[iy][ix];
                resImg.g[y][x] = this.g[iy][ix];
                resImg.r[y][x] = this.r[iy][ix];
                ++x;
            }
            this.sleep(0);
            SLogger.print(".");
            ++y;
        }
        resImg.setFname("rotatedImg");
        this.calcStats();
        return resImg;
    }

    public RGBBild sharpen(int n) {
        RGBBild resImg = new RGBBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.type = this.type;
        try {
            int xi;
            double[][] w = new double[n * 2 + 1][n * 2 + 1];
            double sm = 0.0;
            double s = 0.0;
            int yi = -n;
            while (yi <= n) {
                xi = -n;
                while (xi <= n) {
                    double ra = Math.sqrt(Math.pow(xi, 2.0) + Math.pow(yi, 2.0)) / (double)n;
                    ra = Math.exp(-2.0 * Math.pow(ra, 2.0));
                    w[xi + n][yi + n] = -ra;
                    if (xi != 0 || yi != 0) {
                        sm += ra;
                    }
                    ++xi;
                }
                ++yi;
            }
            yi = -n;
            while (yi <= n) {
                xi = -n;
                while (xi <= n) {
                    w[xi + n][yi + n] = w[xi + n][yi + n] / sm;
                    System.out.print("W[" + (xi + n) + "][" + (yi + n) + "]=" + w[xi + n][yi + n] + "  ");
                    ++xi;
                }
                SLogger.debug("");
                ++yi;
            }
            w[n][n] = 2.0;
            SLogger.debug("sm = " + sm);
            int y = n;
            while (y < this.len - n) {
                int x = n;
                while (x < this.width - n) {
                    double blue = 0.0;
                    double green = 0.0;
                    double red = 0.0;
                    yi = -n;
                    while (yi <= n) {
                        xi = -n;
                        while (xi <= n) {
                            red += w[xi + n][yi + n] * (double)this.r[y + yi][x + xi];
                            green += w[xi + n][yi + n] * (double)this.g[y + yi][x + xi];
                            blue += w[xi + n][yi + n] * (double)this.b[y + yi][x + xi];
                            ++xi;
                        }
                        ++yi;
                    }
                    resImg.r[y][x] = (int)red;
                    resImg.g[y][x] = (int)green;
                    resImg.b[y][x] = (int)blue;
                    ++x;
                }
                ++y;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resImg;
    }

    private RGBBild[] cpyBildArray(Bild[] bilder) {
        int n = bilder.length;
        RGBBild[] tmp = new RGBBild[n];
        int i = 0;
        while (i < n) {
            tmp[i] = (RGBBild)bilder[i];
            ++i;
        }
        return tmp;
    }

    public int[][] getB() {
        return this.b;
    }

    public void setB(int[][] b) {
        this.b = b;
    }

    public int[][] getG() {
        return this.g;
    }

    public void setG(int[][] g) {
        this.g = g;
    }

    public int[][] getR() {
        return this.r;
    }

    public void setR(int[][] r) {
        this.r = r;
    }
}

