/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.bild;

import de.andreasroerig.util.SLogger;
import java.util.Arrays;

public class SigmaClipper {
    private long rejected = 0L;
    private double avgStdDev = 0.0;
    private double sigma;
    private boolean ignoreZero;
    private long count = 0L;

    public SigmaClipper(double sigma, boolean ignoreZero) {
        this.sigma = sigma;
        this.ignoreZero = ignoreZero;
    }

    public double calcMedian(int[] thedata) {
        double res = 0.0;
        int j = 0;
        int i = 0;
        while (i < thedata.length) {
            if (!this.ignoreZero || thedata[i] > 0) {
                ++j;
            }
            ++i;
        }
        if (j == 0) {
            j = thedata.length;
        }
        boolean oddIndices = j / 2 * 2 != j;
        int medIndex = j / 2;
        medIndex = thedata.length - medIndex - 1;
        if (j == 2) {
            medIndex = thedata.length - 2;
        }
        if (j == 1) {
            medIndex = thedata.length - 1;
        }
        res = oddIndices ? (double)thedata[medIndex] : (double)((thedata[medIndex] + thedata[medIndex + 1]) / 2);
        return res;
    }

    public double calcAvg(int[] thedata) {
        double res = 0.0;
        int j = 0;
        int i = 0;
        while (i < thedata.length) {
            if (!this.ignoreZero || thedata[i] > 0) {
                res += (double)thedata[i];
                ++j;
            }
            ++i;
        }
        if (j > 0) {
            res /= (double)j;
        }
        return res;
    }

    public double calcStdDev(int[] thedata) {
        double res = 0.0;
        int j = 0;
        double avg = this.calcAvg(thedata);
        int i = 0;
        while (i < thedata.length) {
            if (!this.ignoreZero || thedata[i] > 0) {
                res += Math.pow(thedata[i], 2.0);
                ++j;
            }
            ++i;
        }
        res -= (double)j * Math.pow(avg, 2.0);
        if (j > 1) {
            res /= (double)(j - 1);
        }
        res = Math.sqrt(res);
        return res;
    }

    public int calcSigmaClip(int[] thedata) {
        int res = 0;
        Arrays.sort(thedata);
        double median = this.calcMedian(thedata);
        double stdDev = this.calcStdDev(thedata);
        this.avgStdDev += stdDev;
        ++this.count;
        double ll = median - stdDev * this.sigma;
        if (this.ignoreZero && ll <= 0.0) {
            ll = 1.0E-7;
        }
        double ul = median + stdDev * this.sigma;
        int n = thedata.length;
        int m = 0;
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            if ((double)thedata[i] >= ll && (double)thedata[i] <= ul) {
                sum += (double)thedata[i];
                ++m;
            } else {
                ++this.rejected;
            }
            ++i;
        }
        sum = m > 0 ? (sum /= (double)m) : median;
        res = (int)Math.rint(sum);
        return res;
    }

    public void printStats() {
        SLogger.log("Sigma clipping stats:");
        SLogger.log("Sigma                  = " + this.sigma);
        SLogger.log("Ignore zero            = " + this.ignoreZero);
        SLogger.log("Rejected               = " + this.rejected);
        SLogger.log("Avg Standard Deviation = " + this.avgStdDev);
    }

    public static void main(String[] args) {
        SigmaClipper sc = new SigmaClipper(2.5, true);
        int[] nArray = new int[18];
        nArray[0] = 165;
        nArray[2] = 173;
        nArray[3] = 30000;
        nArray[4] = 174;
        nArray[5] = 173;
        nArray[6] = 169;
        nArray[7] = 164;
        nArray[8] = 170;
        nArray[9] = 165;
        nArray[10] = 171;
        nArray[11] = 168;
        nArray[12] = 172;
        nArray[13] = 170;
        nArray[15] = 177;
        nArray[16] = 168;
        nArray[17] = 171;
        int[] a = nArray;
        sc.calcSigmaClip(a);
    }

    public double getAvgStdDev() {
        return this.avgStdDev / (double)this.count;
    }

    public long getRejected() {
        return this.rejected;
    }

    public long getCount() {
        return this.count;
    }
}

