/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FitsData {
    protected int type;
    protected int[] naxis;
    protected long size;
    protected int bitpix = 0;
    protected int noParm = 0;
    protected int noGroup = 1;
    protected boolean changeData = false;
    protected RandomAccessFile dataFile = null;
    protected long dataOffset = 0L;
    protected byte[] dataArray = null;
    protected boolean isRAFile = false;

    public FitsData(FitsHeader header, DataInput file, boolean sflag) throws FitsException {
        if (file instanceof RandomAccessFile) {
            this.dataFile = (RandomAccessFile)file;
            try {
                this.dataOffset = this.dataFile.getFilePointer();
            }
            catch (IOException e) {
                throw new FitsException("Cannot read data offset", 1);
            }
            this.isRAFile = true;
        }
        this.size = header.getDataSize();
        this.type = header.getType();
        long skip = this.size;
        if (this.size % 2880L != 0L) {
            skip = (this.size / 2880L + 1L) * 2880L;
        }
        try {
            if (sflag && !this.isRAFile) {
                this.dataArray = new byte[(int)skip];
                file.readFully(this.dataArray);
            } else {
                file.skipBytes((int)skip);
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot read/skip over data matrix", 1);
        }
        this.decodeBasicHeader(header);
    }

    public FitsData(int bitpix, int[] nax) throws FitsException {
        switch (bitpix) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                this.bitpix = bitpix;
                break;
            }
            default: {
                throw new FitsException("Invalid BITPIX value", 5);
            }
        }
        this.type = 0;
        this.size = 1L;
        this.naxis = new int[nax.length];
        int n = 0;
        while (n < nax.length) {
            this.naxis[n] = nax[n];
            this.size *= (long)this.naxis[n];
            ++n;
        }
        this.size *= (long)(Math.abs(this.bitpix) / 8);
        if (this.size < 0L) {
            throw new FitsException("Data size less than zero", 5);
        }
        long skip = this.size;
        if (this.size % 2880L != 0L) {
            skip = (this.size / 2880L + 1L) * 2880L;
        }
        this.dataArray = new byte[(int)skip];
    }

    private void decodeBasicHeader(FitsHeader header) throws FitsException {
        FitsKeyword kw = header.getKeyword("NAXIS");
        if (kw == null) {
            throw new FitsException("Missing NAXIS keyword", 4);
        }
        int nax = kw.getInt();
        this.naxis = new int[nax];
        kw = header.getKeyword("BITPIX");
        if (kw == null) {
            throw new FitsException("Missing BITPIX keyword", 4);
        }
        this.bitpix = kw.getInt();
        int n = 1;
        while (n <= nax) {
            kw = header.getKeyword("NAXIS" + n);
            if (kw == null) {
                throw new FitsException("Missing NAXISn keyword", 4);
            }
            this.naxis[n - 1] = kw.getInt();
            ++n;
        }
        kw = header.getKeyword("GCOUNT");
        this.noGroup = kw == null ? 1 : kw.getInt();
        kw = header.getKeyword("PCOUNT");
        this.noParm = kw == null ? 0 : kw.getInt();
        this.changeData = false;
    }

    public FitsHeader getHeader() {
        FitsHeader hdr = new FitsHeader();
        hdr.addKeyword(new FitsKeyword("SIMPLE", true, "Standard FITS format; NOST 100-2.0"));
        hdr.addKeyword(new FitsKeyword("BITPIX", this.bitpix, "No. of bits per pixel"));
        hdr.addKeyword(new FitsKeyword("NAXIS", this.naxis.length, "No. of axes in image"));
        int n = 1;
        while (n <= this.naxis.length) {
            hdr.addKeyword(new FitsKeyword("NAXIS" + n, this.naxis[n - 1], "No. of pixels"));
            ++n;
        }
        hdr.addKeyword(new FitsKeyword("PCOUNT", 0, "Parameter count"));
        hdr.addKeyword(new FitsKeyword("GCOUNT", 1, "Groupe count"));
        return hdr;
    }

    public void writeFile(DataOutput file) throws IOException, FitsException {
        byte[] buf;
        int nbytes = 0;
        int block = 28800;
        if (this.isRAFile) {
            buf = new byte[block];
            this.dataFile.seek(this.dataOffset);
            int nrec = (int)this.size / block;
            while (nrec-- > 0) {
                this.dataFile.read(buf);
                file.write(buf);
            }
            nbytes = (int)this.size % block;
            if (nbytes == 0) {
                return;
            }
            buf = new byte[nbytes];
            this.dataFile.read(buf);
            file.write(buf);
        } else if (this.dataArray != null) {
            file.write(this.dataArray);
        }
        if (nbytes % 2880 != 0) {
            nbytes = 2880 * (nbytes / 2880 + 1) - nbytes;
            buf = new byte[nbytes];
            if (this.type == 3) {
                int n = 0;
                while (n < nbytes) {
                    buf[n] = 32;
                    ++n;
                }
            }
            file.write(buf);
        }
    }

    public void closeFile() {
        this.dataFile = null;
        this.dataOffset = 0L;
        this.size = 0L;
        this.type = 0;
    }

    public int getNoAxes() {
        return this.naxis.length;
    }

    public int getType() {
        return this.type;
    }

    public int[] getNaxis() {
        return this.naxis;
    }
}

