/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsColumn;
import de.andreasroerig.fits.FitsConst;
import de.andreasroerig.fits.FitsData;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsFile;
import de.andreasroerig.fits.FitsHDUnit;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsMatrix;
import de.andreasroerig.fits.FitsTable;
import java.io.IOException;
import java.util.Enumeration;

public class TestFits {
    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("Error: must have at least one argument");
            System.exit(1);
        }
        System.out.println("-- Test FITS files --------");
        FitsFile file = null;
        int na = 0;
        while (na < argv.length) {
            block33: {
                try {
                    file = new FitsFile(argv[na]);
                }
                catch (FitsException e) {
                    System.out.println("Error: is not a FITS file >" + argv[na] + "<");
                    break block33;
                }
                catch (IOException e) {
                    System.out.println("Error: cannot open file >" + argv[na] + "<");
                    break block33;
                }
                int noHDU = file.getNoHDUnits();
                System.out.println("FITS file has " + noHDU + " HDUnits");
                int i = 0;
                while (i < noHDU) {
                    FitsData dm;
                    FitsHDUnit hdu = file.getHDUnit(i);
                    FitsHeader hdr = hdu.getHeader();
                    int noKw = hdr.getNoKeywords();
                    int type = hdr.getType();
                    int size = (int)hdr.getDataSize();
                    System.out.println("  " + i + ": >" + hdr.getName() + "< of type >" + FitsConst.getType(type) + "< with " + noKw + " keywords" + " and " + size + " bytes of data");
                    System.out.println("   Keywords:");
                    Enumeration enumeration = hdr.getKeywords();
                    while (enumeration.hasMoreElements()) {
                        FitsKeyword kw = (FitsKeyword)enumeration.nextElement();
                        System.out.print("     " + kw.getName());
                        switch (kw.getType()) {
                            case 1: {
                                System.out.print("(C) " + kw.getComment());
                                break;
                            }
                            case 2: {
                                System.out.print("(S)= '" + kw.getString() + "'");
                                break;
                            }
                            case 3: {
                                System.out.print("(B)= " + kw.getBool());
                                break;
                            }
                            case 4: {
                                System.out.print("(I)= " + kw.getInt());
                                break;
                            }
                            case 5: {
                                System.out.print("(R)= " + kw.getReal());
                                break;
                            }
                            case 6: {
                                System.out.print("(D)= " + kw.getString());
                            }
                        }
                        if (kw.getComment().length() > 0 && kw.getType() != 1) {
                            System.out.print(" / " + kw.getComment());
                        }
                        System.out.println();
                    }
                    if (type == 1) {
                        System.out.println("\n  Check data matrix - compute mean and rms");
                        dm = (FitsMatrix)hdu.getData();
                        int[] naxis = dm.getNaxis();
                        double[] crval = ((FitsMatrix)dm).getCrval();
                        double[] crpix = ((FitsMatrix)dm).getCrpix();
                        double[] cdelt = ((FitsMatrix)dm).getCdelt();
                        System.out.println("  Dimension of matrix: " + naxis.length);
                        int n = 0;
                        while (n < naxis.length) {
                            System.out.println("   Axis " + n + ": " + naxis[n] + ",  " + crpix[n] + ",  " + crval[n] + ",  " + cdelt[n]);
                            ++n;
                        }
                        System.out.println("\n");
                        int nval = ((FitsMatrix)dm).getNoValues();
                        if (nval > 0) {
                            int ncol = naxis[0];
                            int nrow = nval / ncol;
                            System.out.println(" Npixel,row,col: " + nval + ", " + nrow + ", " + ncol);
                            float[] data = new float[ncol];
                            int npix = 0;
                            int nv = 0;
                            int off = 0;
                            double rms = 0.0;
                            double mean = 0.0;
                            long time = System.currentTimeMillis();
                            int nr = 0;
                            while (nr < nrow) {
                                try {
                                    ((FitsMatrix)dm).getFloatValues(off, ncol, data);
                                    int n2 = 0;
                                    while (n2 < ncol) {
                                        double val = data[n2];
                                        ++npix;
                                        mean += val;
                                        rms += val * val;
                                        ++n2;
                                    }
                                }
                                catch (FitsException fitsException) {
                                    // empty catch block
                                }
                                off += ncol;
                                ++nr;
                            }
                            rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                            float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nval);
                            System.out.println("  Mean: " + (float)mean + ", rms: " + (float)rms + ", Time: " + dtime + " S/Mp, Pixels: " + npix);
                        }
                    } else if (type == 2 || type == 3) {
                        System.out.println("\n  Check table data - list columns");
                        dm = (FitsTable)hdu.getData();
                        int nrow = ((FitsTable)dm).getNoRows();
                        int ncol = ((FitsTable)dm).getNoColumns();
                        FitsColumn[] col = new FitsColumn[ncol];
                        System.out.println("  Columns: " + ncol + ", Rows: " + nrow);
                        int n = 0;
                        while (n < ncol) {
                            double val;
                            long time;
                            double mean;
                            double rms;
                            int npix;
                            col[n] = ((FitsTable)dm).getColumn(n);
                            System.out.print("  " + n + " >" + col[n].getLabel() + "<, ");
                            System.out.print(String.valueOf(col[n].getRepeat()) + " ");
                            System.out.print(String.valueOf(col[n].getDataType()) + ", >");
                            System.out.print(String.valueOf(col[n].getDisplay()) + "<, >");
                            System.out.println(String.valueOf(col[n].getUnit()) + "<");
                            if (col[n].getDataType() == 'F' || col[n].getDataType() == 'E' || col[n].getDataType() == 'D') {
                                npix = 0;
                                rms = 0.0;
                                mean = 0.0;
                                time = System.currentTimeMillis();
                                int nr = 0;
                                while (nr < nrow) {
                                    val = col[n].getReal(nr);
                                    if (!Double.isNaN(val)) {
                                        ++npix;
                                        mean += val;
                                        rms += val * val;
                                    }
                                    ++nr;
                                }
                                float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nrow);
                                rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                                System.out.println("      no,mean,rms: " + npix + ", " + (float)mean + ", " + (float)rms + "; " + dtime + " S/Mp");
                            } else if (col[n].getDataType() == 'I' || col[n].getDataType() == 'J' || col[n].getDataType() == 'B') {
                                npix = 0;
                                rms = 0.0;
                                mean = 0.0;
                                time = System.currentTimeMillis();
                                int nr = 0;
                                while (nr < nrow) {
                                    val = col[n].getInt(nr);
                                    if (val != -9.223372036854776E18) {
                                        ++npix;
                                        mean += val;
                                        rms += val * val;
                                    }
                                    ++nr;
                                }
                                float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nrow);
                                rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                                System.out.println("      no,mean,rms: " + npix + ", " + (float)mean + ", " + (float)rms + "; " + dtime + " S/Mp");
                            }
                            ++n;
                        }
                    }
                    ++i;
                }
                System.out.println("-- Test finished -----------------");
            }
            ++na;
        }
        System.exit(0);
    }
}

