/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.match;

import java.awt.Dimension;
import java.util.Comparator;

public class Star
implements Comparator {
    protected int x;
    protected int y;
    protected double dx;
    protected double dy;
    protected int index;
    protected double fwhm;
    protected double bright;
    private int matchId;
    private double originDistance;
    private double centerDistance = 0.0;
    private int sortCriteria = 1;
    public static final int SORT_ORIGIN_DISTANCE = 0;
    public static final int SORT_CENTER_DISTANCE = 1;
    public static final int SORT_BRIGHTNESS = 2;
    public static final int SORT_FWHM = 3;

    public Star() {
    }

    public Star(double x, double y) {
        this();
        this.x = (int)Math.round(x);
        this.y = (int)Math.round(y);
        this.dx = x;
        this.dy = y;
        this.fwhm = 0.0;
        this.bright = 0.0;
    }

    public Star(int x, int y, double f, double b) {
        this();
        this.x = x;
        this.y = y;
        this.fwhm = f;
        this.bright = b;
        this.originDistance = this.calcOriginDistance();
    }

    public Star(int x, int y, double b) {
        this();
        this.x = x;
        this.y = y;
        this.fwhm = 0.0;
        this.bright = b;
        this.originDistance = this.calcOriginDistance();
    }

    public Dimension getPos() {
        return new Dimension(this.x, this.y);
    }

    public int compare(Object a, Object b) {
        int erg = 0;
        Star as = (Star)a;
        Star bs = (Star)b;
        switch (this.sortCriteria) {
            case 0: {
                if (as.originDistance > bs.originDistance) {
                    erg = 1;
                    break;
                }
                if (as.originDistance < bs.originDistance) {
                    erg = -1;
                    break;
                }
                erg = 0;
                break;
            }
            case 2: {
                if (as.bright < bs.bright) {
                    erg = -1;
                    break;
                }
                if (as.bright > bs.bright) {
                    erg = 1;
                    break;
                }
                erg = 0;
                break;
            }
            case 3: {
                if (as.fwhm < bs.fwhm) {
                    erg = 1;
                    break;
                }
                if (as.fwhm > bs.fwhm) {
                    erg = -1;
                    break;
                }
                erg = 0;
                break;
            }
            case 1: {
                erg = as.centerDistance > bs.centerDistance ? 1 : (as.centerDistance < bs.centerDistance ? -1 : 0);
            }
        }
        return erg;
    }

    public boolean isSamePos(Star st) {
        return st.x == this.x && st.y == this.y;
    }

    public double calcDistance(Star st2) {
        double aQuadrat = this.dx - st2.dx;
        aQuadrat *= aQuadrat;
        double bQuadrat = this.dy - st2.dy;
        bQuadrat *= bQuadrat;
        double distance = Math.sqrt(aQuadrat + bQuadrat);
        return distance;
    }

    public double calcOriginDistance() {
        double aQuadrat = this.getDx();
        aQuadrat *= aQuadrat;
        double bQuadrat = this.getDy();
        bQuadrat *= bQuadrat;
        return Math.sqrt(aQuadrat + bQuadrat);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public double getFwhm() {
        return this.fwhm;
    }

    public void setFwhm(double fwhm) {
        this.fwhm = fwhm;
    }

    public double getBright() {
        return this.bright;
    }

    public void setBright(double bright) {
        this.bright = bright;
    }

    public double getOriginDistance() {
        return this.originDistance;
    }

    public void setOriginDistance(double originDistance) {
        this.originDistance = originDistance;
    }

    public double getCenterDistance() {
        return this.centerDistance;
    }

    public void setCenterDistance(double centerDistance) {
        this.centerDistance = centerDistance;
    }

    public int getSortCriteria() {
        return this.sortCriteria;
    }

    public void setSortCriteria(int sortCriteria) {
        this.sortCriteria = sortCriteria;
    }

    public double getDx() {
        return this.dx;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public int getMatchId() {
        return this.matchId;
    }

    public void setMatchId(int matchId) {
        this.matchId = matchId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

