/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class MosfetElm
extends CircuitElm {
    int pnp;
    int FLAG_PNP = 1;
    int FLAG_SHOWVT = 2;
    int FLAG_DIGITAL = 4;
    double vt;
    final int hs = 16;
    int pcircler;
    Point[] src;
    Point[] drn;
    Point[] gate;
    Point pcircle;
    Polygon arrowPoly;
    double lastv1;
    double lastv2;
    double ids;
    int mode = 0;
    double gm = 0.0;

    MosfetElm(int n, int n2, boolean bl) {
        super(n, n2);
        this.pnp = bl ? -1 : 1;
        this.flags = bl ? this.FLAG_PNP : 0;
        this.noDiagonal = true;
        this.vt = this.getDefaultThreshold();
    }

    public MosfetElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.pnp = (n5 & this.FLAG_PNP) != 0 ? -1 : 1;
        this.noDiagonal = true;
        this.vt = this.getDefaultThreshold();
        try {
            this.vt = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    double getDefaultThreshold() {
        return 1.5;
    }

    double getBeta() {
        return 0.02;
    }

    boolean nonLinear() {
        return true;
    }

    boolean drawDigital() {
        return (this.flags & this.FLAG_DIGITAL) != 0;
    }

    void reset() {
        this.curcount = 0.0;
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.lastv2 = 0.0;
        this.lastv1 = 0.0;
    }

    String dump() {
        return super.dump() + " " + this.vt;
    }

    int getDumpType() {
        return 102;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 16.0);
        this.setVoltageColor(graphics, this.volts[1]);
        MosfetElm.drawThickLine(graphics, this.src[0], this.src[1]);
        this.setVoltageColor(graphics, this.volts[2]);
        MosfetElm.drawThickLine(graphics, this.drn[0], this.drn[1]);
        int n = 6;
        this.setPowerColor(graphics, true);
        double d = 1.0 / (double)n;
        for (int i = 0; i != n; ++i) {
            double d2 = this.volts[1] + (this.volts[2] - this.volts[1]) * (double)i / (double)n;
            this.setVoltageColor(graphics, d2);
            this.interpPoint(this.src[1], this.drn[1], ps1, (double)i * d);
            this.interpPoint(this.src[1], this.drn[1], ps2, (double)(i + 1) * d);
            MosfetElm.drawThickLine(graphics, ps1, ps2);
        }
        this.setVoltageColor(graphics, this.volts[1]);
        MosfetElm.drawThickLine(graphics, this.src[1], this.src[2]);
        this.setVoltageColor(graphics, this.volts[2]);
        MosfetElm.drawThickLine(graphics, this.drn[1], this.drn[2]);
        if (!this.drawDigital()) {
            this.setVoltageColor(graphics, this.pnp == 1 ? this.volts[1] : this.volts[2]);
            graphics.fillPolygon(this.arrowPoly);
        }
        if (MosfetElm.sim.powerCheckItem.getState()) {
            graphics.setColor(Color.gray);
        }
        this.setVoltageColor(graphics, this.volts[0]);
        MosfetElm.drawThickLine(graphics, this.point1, this.gate[1]);
        MosfetElm.drawThickLine(graphics, this.gate[0], this.gate[2]);
        if (this.drawDigital() && this.pnp == -1) {
            MosfetElm.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, this.pcircler);
        }
        if ((this.flags & this.FLAG_SHOWVT) != 0) {
            String string = "" + this.vt * (double)this.pnp;
            graphics.setColor(whiteColor);
            graphics.setFont(unitsFont);
            this.drawCenteredText(graphics, string, this.x2 + 2, this.y2, false);
        }
        if ((this.needsHighlight() || MosfetElm.sim.dragElm == this) && this.dy == 0) {
            graphics.setColor(Color.white);
            graphics.setFont(unitsFont);
            int n2 = MosfetElm.sign(this.dx);
            graphics.drawString("G", this.gate[1].x - 10 * n2, this.gate[1].y - 5);
            graphics.drawString(this.pnp == -1 ? "D" : "S", this.src[0].x - 3 + 9 * n2, this.src[0].y + 4);
            graphics.drawString(this.pnp == -1 ? "S" : "D", this.drn[0].x - 3 + 9 * n2, this.drn[0].y + 4);
        }
        this.curcount = this.updateDotCount(-this.ids, this.curcount);
        this.drawDots(graphics, this.src[0], this.src[1], this.curcount);
        this.drawDots(graphics, this.src[1], this.drn[1], this.curcount);
        this.drawDots(graphics, this.drn[1], this.drn[0], this.curcount);
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.src[0] : this.drn[0]);
    }

    double getCurrent() {
        return this.ids;
    }

    double getPower() {
        return this.ids * (this.volts[2] - this.volts[1]);
    }

    int getPostCount() {
        return 3;
    }

    void setPoints() {
        super.setPoints();
        int n = 16 * this.dsign;
        this.src = this.newPointArray(3);
        this.drn = this.newPointArray(3);
        this.interpPoint2(this.point1, this.point2, this.src[0], this.drn[0], 1.0, -n);
        this.interpPoint2(this.point1, this.point2, this.src[1], this.drn[1], 1.0 - 22.0 / this.dn, -n);
        this.interpPoint2(this.point1, this.point2, this.src[2], this.drn[2], 1.0 - 22.0 / this.dn, -n * 4 / 3);
        this.gate = this.newPointArray(3);
        this.interpPoint2(this.point1, this.point2, this.gate[0], this.gate[2], 1.0 - 28.0 / this.dn, n / 2);
        this.interpPoint(this.gate[0], this.gate[2], this.gate[1], 0.5);
        if (!this.drawDigital()) {
            this.arrowPoly = this.pnp == 1 ? this.calcArrow(this.src[1], this.src[0], 10.0, 4.0) : this.calcArrow(this.drn[0], this.drn[1], 12.0, 5.0);
        } else if (this.pnp == -1) {
            this.interpPoint(this.point1, this.point2, this.gate[1], 1.0 - 36.0 / this.dn);
            int n2 = this.dsign < 0 ? 32 : 31;
            this.pcircle = this.interpPoint(this.point1, this.point2, 1.0 - (double)n2 / this.dn);
            this.pcircler = 3;
        }
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[1]);
        sim.stampNonLinear(this.nodes[2]);
    }

    void doStep() {
        double[] dArray = new double[]{this.volts[0], this.volts[1], this.volts[2]};
        if (dArray[1] > this.lastv1 + 0.5) {
            dArray[1] = this.lastv1 + 0.5;
        }
        if (dArray[1] < this.lastv1 - 0.5) {
            dArray[1] = this.lastv1 - 0.5;
        }
        if (dArray[2] > this.lastv2 + 0.5) {
            dArray[2] = this.lastv2 + 0.5;
        }
        if (dArray[2] < this.lastv2 - 0.5) {
            dArray[2] = this.lastv2 - 0.5;
        }
        int n = 1;
        int n2 = 2;
        if ((double)this.pnp * dArray[1] > (double)this.pnp * dArray[2]) {
            n = 2;
            n2 = 1;
        }
        int n3 = 0;
        double d = dArray[n3] - dArray[n];
        double d2 = dArray[n2] - dArray[n];
        if (Math.abs(this.lastv1 - dArray[1]) > 0.01 || Math.abs(this.lastv2 - dArray[2]) > 0.01) {
            MosfetElm.sim.converged = false;
        }
        this.lastv1 = dArray[1];
        this.lastv2 = dArray[2];
        double d3 = d;
        double d4 = d2;
        d *= (double)this.pnp;
        d2 *= (double)this.pnp;
        this.ids = 0.0;
        this.gm = 0.0;
        double d5 = 0.0;
        double d6 = this.getBeta();
        if (d > 0.5 && this instanceof JfetElm) {
            sim.stop("JFET is reverse biased!", this);
            return;
        }
        if (d < this.vt) {
            d5 = 1.0E-8;
            this.ids = d2 * d5;
            this.mode = 0;
        } else if (d2 < d - this.vt) {
            this.ids = d6 * ((d - this.vt) * d2 - d2 * d2 * 0.5);
            this.gm = d6 * d2;
            d5 = d6 * (d - d2 - this.vt);
            this.mode = 1;
        } else {
            this.gm = d6 * (d - this.vt);
            d5 = 1.0E-8;
            this.ids = 0.5 * d6 * (d - this.vt) * (d - this.vt) + (d2 - (d - this.vt)) * d5;
            this.mode = 2;
        }
        double d7 = (double)(-this.pnp) * this.ids + d5 * d4 + this.gm * d3;
        sim.stampMatrix(this.nodes[n2], this.nodes[n2], d5);
        sim.stampMatrix(this.nodes[n2], this.nodes[n], -d5 - this.gm);
        sim.stampMatrix(this.nodes[n2], this.nodes[n3], this.gm);
        sim.stampMatrix(this.nodes[n], this.nodes[n2], -d5);
        sim.stampMatrix(this.nodes[n], this.nodes[n], d5 + this.gm);
        sim.stampMatrix(this.nodes[n], this.nodes[n3], -this.gm);
        sim.stampRightSide(this.nodes[n2], d7);
        sim.stampRightSide(this.nodes[n], -d7);
        if (n == 2 && this.pnp == 1 || n == 1 && this.pnp == -1) {
            this.ids = -this.ids;
        }
    }

    void getFetInfo(String[] stringArray, String string) {
        stringArray[0] = (this.pnp == -1 ? "p-" : "n-") + string;
        stringArray[0] = stringArray[0] + " (Vt = " + MosfetElm.getVoltageText((double)this.pnp * this.vt) + ")";
        stringArray[1] = (this.pnp == 1 ? "Ids = " : "Isd = ") + MosfetElm.getCurrentText(this.ids);
        stringArray[2] = "Vgs = " + MosfetElm.getVoltageText(this.volts[0] - this.volts[this.pnp == -1 ? 2 : 1]);
        stringArray[3] = (this.pnp == 1 ? "Vds = " : "Vsd = ") + MosfetElm.getVoltageText(this.volts[2] - this.volts[1]);
        stringArray[4] = this.mode == 0 ? "off" : (this.mode == 1 ? "linear" : "saturation");
        stringArray[5] = "gm = " + MosfetElm.getUnitText(this.gm, "A/V");
    }

    void getInfo(String[] stringArray) {
        this.getFetInfo(stringArray, "MOSFET");
    }

    boolean canViewInScope() {
        return true;
    }

    double getVoltageDiff() {
        return this.volts[2] - this.volts[1];
    }

    boolean getConnection(int n, int n2) {
        return n != 0 && n2 != 0;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Threshold Voltage", (double)this.pnp * this.vt, 0.01, 5.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Digital Symbol", this.drawDigital());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.vt = (double)this.pnp * editInfo.value;
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? this.flags | this.FLAG_DIGITAL : this.flags & ~this.FLAG_DIGITAL;
            this.setPoints();
        }
    }
}

