/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.util.StringTokenizer;

class SeqGenElm
extends ChipElm {
    short data = 0;
    byte position = 0;
    boolean oneshot = false;
    double lastchangetime = 0.0;
    boolean clockstate = false;

    boolean hasReset() {
        return false;
    }

    public SeqGenElm(int n, int n2) {
        super(n, n2);
    }

    public SeqGenElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.data = (short)new Integer(stringTokenizer.nextToken()).intValue();
        if (stringTokenizer.hasMoreTokens()) {
            this.oneshot = new Boolean(stringTokenizer.nextToken());
            this.position = (byte)8;
        }
    }

    String getChipName() {
        return "Sequence generator";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "");
        this.pins[0].clock = true;
        this.pins[1] = new ChipElm.Pin(1, 3, "Q");
        this.pins[1].output = true;
    }

    int getPostCount() {
        return 2;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void GetNextBit() {
        this.pins[1].value = (this.data >>> this.position & 1) != 0;
        this.position = (byte)(this.position + 1);
    }

    void execute() {
        if (this.oneshot && SeqGenElm.sim.t - this.lastchangetime > 0.005) {
            if (this.position <= 8) {
                this.GetNextBit();
            }
            this.lastchangetime = SeqGenElm.sim.t;
        }
        if (this.pins[0].value && !this.clockstate) {
            this.clockstate = true;
            if (this.oneshot) {
                this.position = 0;
            } else {
                this.GetNextBit();
                if (this.position >= 8) {
                    this.position = 0;
                }
            }
        }
        if (!this.pins[0].value) {
            this.clockstate = false;
        }
    }

    int getDumpType() {
        return 188;
    }

    String dump() {
        return super.dump() + " " + this.data + " " + this.oneshot;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 0 set", (this.data & 1) != 0);
            return editInfo;
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 1 set", (this.data & 2) != 0);
            return editInfo;
        }
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 2 set", (this.data & 4) != 0);
            return editInfo;
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 3 set", (this.data & 8) != 0);
            return editInfo;
        }
        if (n == 4) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 4 set", (this.data & 0x10) != 0);
            return editInfo;
        }
        if (n == 5) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 5 set", (this.data & 0x20) != 0);
            return editInfo;
        }
        if (n == 6) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 6 set", (this.data & 0x40) != 0);
            return editInfo;
        }
        if (n == 7) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bit 7 set", (this.data & 0x80) != 0);
            return editInfo;
        }
        if (n == 8) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("One shot", this.oneshot);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 1) : (short)(this.data & 0xFFFFFFFE);
            this.setPoints();
        }
        if (n == 1) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 2) : (short)(this.data & 0xFFFFFFFD);
            this.setPoints();
        }
        if (n == 2) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 4) : (short)(this.data & 0xFFFFFFFB);
            this.setPoints();
        }
        if (n == 3) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 8) : (short)(this.data & 0xFFFFFFF7);
            this.setPoints();
        }
        if (n == 4) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 0x10) : (short)(this.data & 0xFFFFFFEF);
            this.setPoints();
        }
        if (n == 5) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 0x20) : (short)(this.data & 0xFFFFFFDF);
            this.setPoints();
        }
        if (n == 6) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 0x40) : (short)(this.data & 0xFFFFFFBF);
            this.setPoints();
        }
        if (n == 7) {
            this.data = editInfo.checkbox.getState() ? (short)(this.data | 0x80) : (short)(this.data & 0xFFFFFF7F);
            this.setPoints();
        }
        if (n == 8) {
            if (editInfo.checkbox.getState()) {
                this.oneshot = true;
                this.position = (byte)8;
            } else {
                this.position = 0;
                this.oneshot = false;
            }
        }
    }
}

