/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class VoltageElm
extends CircuitElm {
    static final int FLAG_COS = 2;
    int waveform;
    static final int WF_DC = 0;
    static final int WF_AC = 1;
    static final int WF_SQUARE = 2;
    static final int WF_TRIANGLE = 3;
    static final int WF_SAWTOOTH = 4;
    static final int WF_PULSE = 5;
    static final int WF_VAR = 6;
    double frequency;
    double maxVoltage;
    double freqTimeZero;
    double bias;
    double phaseShift;
    double dutyCycle;
    final int circleSize = 17;

    VoltageElm(int n, int n2, int n3) {
        super(n, n2);
        this.waveform = n3;
        this.maxVoltage = 5.0;
        this.frequency = 40.0;
        this.dutyCycle = 0.5;
        this.reset();
    }

    public VoltageElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.maxVoltage = 5.0;
        this.frequency = 40.0;
        this.waveform = 0;
        this.dutyCycle = 0.5;
        try {
            this.waveform = new Integer(stringTokenizer.nextToken());
            this.frequency = new Double(stringTokenizer.nextToken());
            this.maxVoltage = new Double(stringTokenizer.nextToken());
            this.bias = new Double(stringTokenizer.nextToken());
            this.phaseShift = new Double(stringTokenizer.nextToken());
            this.dutyCycle = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((this.flags & 2) != 0) {
            this.flags &= 0xFFFFFFFD;
            this.phaseShift = 1.5707963267948966;
        }
        this.reset();
    }

    int getDumpType() {
        return 118;
    }

    String dump() {
        return super.dump() + " " + this.waveform + " " + this.frequency + " " + this.maxVoltage + " " + this.bias + " " + this.phaseShift + " " + this.dutyCycle;
    }

    void reset() {
        this.freqTimeZero = 0.0;
        this.curcount = 0.0;
    }

    double triangleFunc(double d) {
        if (d < Math.PI) {
            return d * 0.6366197723675814 - 1.0;
        }
        return 1.0 - (d - Math.PI) * 0.6366197723675814;
    }

    void stamp() {
        if (this.waveform == 0) {
            sim.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, this.getVoltage());
        } else {
            sim.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource);
        }
    }

    void doStep() {
        if (this.waveform != 0) {
            sim.updateVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, this.getVoltage());
        }
    }

    double getVoltage() {
        double d = Math.PI * 2 * (VoltageElm.sim.t - this.freqTimeZero) * this.frequency + this.phaseShift;
        switch (this.waveform) {
            case 0: {
                return this.maxVoltage + this.bias;
            }
            case 1: {
                return Math.sin(d) * this.maxVoltage + this.bias;
            }
            case 2: {
                return this.bias + (d % (Math.PI * 2) > Math.PI * 2 * this.dutyCycle ? -this.maxVoltage : this.maxVoltage);
            }
            case 3: {
                return this.bias + this.triangleFunc(d % (Math.PI * 2)) * this.maxVoltage;
            }
            case 4: {
                return this.bias + d % (Math.PI * 2) * (this.maxVoltage / Math.PI) - this.maxVoltage;
            }
            case 5: {
                return d % (Math.PI * 2) < 1.0 ? this.maxVoltage + this.bias : this.bias;
            }
        }
        return 0.0;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(this.waveform == 0 || this.waveform == 6 ? 8 : 34);
    }

    void draw(Graphics graphics) {
        this.setBbox(this.x, this.y, this.x2, this.y2);
        this.draw2Leads(graphics);
        if (this.waveform == 0) {
            this.setPowerColor(graphics, false);
            this.setVoltageColor(graphics, this.volts[0]);
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 0.0, 10.0);
            VoltageElm.drawThickLine(graphics, ps1, ps2);
            this.setVoltageColor(graphics, this.volts[1]);
            int n = 16;
            this.setBbox(this.point1, this.point2, n);
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 1.0, n);
            VoltageElm.drawThickLine(graphics, ps1, ps2);
        } else {
            this.setBbox(this.point1, this.point2, 17.0);
            this.interpPoint(this.lead1, this.lead2, ps1, 0.5);
            this.drawWaveform(graphics, ps1);
        }
        this.updateDotCount();
        if (VoltageElm.sim.dragElm != this) {
            if (this.waveform == 0) {
                this.drawDots(graphics, this.point1, this.point2, this.curcount);
            } else {
                this.drawDots(graphics, this.point1, this.lead1, this.curcount);
                this.drawDots(graphics, this.point2, this.lead2, -this.curcount);
            }
        }
        this.drawPosts(graphics);
    }

    void drawWaveform(Graphics graphics, Point point) {
        graphics.setColor(this.needsHighlight() ? selectColor : Color.gray);
        this.setPowerColor(graphics, false);
        int n = point.x;
        int n2 = point.y;
        VoltageElm.drawThickCircle(graphics, n, n2, 17);
        int n3 = 8;
        this.adjustBbox(n - 17, n2 - 17, n + 17, n2 + 17);
        switch (this.waveform) {
            case 0: {
                break;
            }
            case 2: {
                int n4 = (int)((double)(n3 * 2) * this.dutyCycle - (double)n3 + (double)n);
                n4 = VoltageElm.max(n - n3 + 3, VoltageElm.min(n + n3 - 3, n4));
                VoltageElm.drawThickLine(graphics, n - n3, n2 - n3, n - n3, n2);
                VoltageElm.drawThickLine(graphics, n - n3, n2 - n3, n4, n2 - n3);
                VoltageElm.drawThickLine(graphics, n4, n2 - n3, n4, n2 + n3);
                VoltageElm.drawThickLine(graphics, n + n3, n2 + n3, n4, n2 + n3);
                VoltageElm.drawThickLine(graphics, n + n3, n2, n + n3, n2 + n3);
                break;
            }
            case 5: {
                VoltageElm.drawThickLine(graphics, n - n3, (n2 += n3 / 2) - n3, n - n3, n2);
                VoltageElm.drawThickLine(graphics, n - n3, n2 - n3, n - n3 / 2, n2 - n3);
                VoltageElm.drawThickLine(graphics, n - n3 / 2, n2 - n3, n - n3 / 2, n2);
                VoltageElm.drawThickLine(graphics, n - n3 / 2, n2, n + n3, n2);
                break;
            }
            case 4: {
                VoltageElm.drawThickLine(graphics, n, n2 - n3, n - n3, n2);
                VoltageElm.drawThickLine(graphics, n, n2 - n3, n, n2 + n3);
                VoltageElm.drawThickLine(graphics, n, n2 + n3, n + n3, n2);
                break;
            }
            case 3: {
                int n5 = 5;
                VoltageElm.drawThickLine(graphics, n - n5 * 2, n2, n - n5, n2 - n3);
                VoltageElm.drawThickLine(graphics, n - n5, n2 - n3, n, n2);
                VoltageElm.drawThickLine(graphics, n, n2, n + n5, n2 + n3);
                VoltageElm.drawThickLine(graphics, n + n5, n2 + n3, n + n5 * 2, n2);
                break;
            }
            case 1: {
                int n5;
                int n6 = 10;
                int n7 = -1;
                int n8 = -1;
                for (n5 = -n6; n5 <= n6; ++n5) {
                    int n9 = n2 + (int)(0.95 * Math.sin((double)n5 * Math.PI / (double)n6) * (double)n3);
                    if (n7 != -1) {
                        VoltageElm.drawThickLine(graphics, n7, n8, n + n5, n9);
                    }
                    n7 = n + n5;
                    n8 = n9;
                }
                break;
            }
        }
        if (VoltageElm.sim.showValuesCheckItem.getState()) {
            String string = VoltageElm.getShortUnitText(this.frequency, "Hz");
            if (this.dx == 0 || this.dy == 0) {
                this.drawValues(graphics, string, 17.0);
            }
        }
    }

    int getVoltageSourceCount() {
        return 1;
    }

    double getPower() {
        return -this.getVoltageDiff() * this.current;
    }

    double getVoltageDiff() {
        return this.volts[1] - this.volts[0];
    }

    void getInfo(String[] stringArray) {
        switch (this.waveform) {
            case 0: 
            case 6: {
                stringArray[0] = "voltage source";
                break;
            }
            case 1: {
                stringArray[0] = "A/C source";
                break;
            }
            case 2: {
                stringArray[0] = "square wave gen";
                break;
            }
            case 5: {
                stringArray[0] = "pulse gen";
                break;
            }
            case 4: {
                stringArray[0] = "sawtooth gen";
                break;
            }
            case 3: {
                stringArray[0] = "triangle gen";
            }
        }
        stringArray[1] = "I = " + VoltageElm.getCurrentText(this.getCurrent());
        stringArray[2] = (this instanceof RailElm ? "V = " : "Vd = ") + VoltageElm.getVoltageText(this.getVoltageDiff());
        if (this.waveform != 0 && this.waveform != 6) {
            stringArray[3] = "f = " + VoltageElm.getUnitText(this.frequency, "Hz");
            stringArray[4] = "Vmax = " + VoltageElm.getVoltageText(this.maxVoltage);
            int n = 5;
            if (this.bias != 0.0) {
                stringArray[n++] = "Voff = " + VoltageElm.getVoltageText(this.bias);
            } else if (this.frequency > 500.0) {
                stringArray[n++] = "wavelength = " + VoltageElm.getUnitText(2.9979E8 / this.frequency, "m");
            }
            stringArray[n++] = "P = " + VoltageElm.getUnitText(this.getPower(), "W");
        }
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo(this.waveform == 0 ? "Voltage" : "Max Voltage", this.maxVoltage, -20.0, 20.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("Waveform", this.waveform, -1.0, -1.0);
            editInfo.choice = new Choice();
            editInfo.choice.add("D/C");
            editInfo.choice.add("A/C");
            editInfo.choice.add("Square Wave");
            editInfo.choice.add("Triangle");
            editInfo.choice.add("Sawtooth");
            editInfo.choice.add("Pulse");
            editInfo.choice.select(this.waveform);
            return editInfo;
        }
        if (this.waveform == 0) {
            return null;
        }
        if (n == 2) {
            return new EditInfo("Frequency (Hz)", this.frequency, 4.0, 500.0);
        }
        if (n == 3) {
            return new EditInfo("DC Offset (V)", this.bias, -20.0, 20.0);
        }
        if (n == 4) {
            return new EditInfo("Phase Offset (degrees)", this.phaseShift * 180.0 / Math.PI, -180.0, 180.0).setDimensionless();
        }
        if (n == 5 && this.waveform == 2) {
            return new EditInfo("Duty Cycle", this.dutyCycle * 100.0, 0.0, 100.0).setDimensionless();
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.maxVoltage = editInfo.value;
        }
        if (n == 3) {
            this.bias = editInfo.value;
        }
        if (n == 2) {
            double d = this.frequency;
            this.frequency = editInfo.value;
            double d2 = 1.0 / (8.0 * VoltageElm.sim.timeStep);
            if (this.frequency > d2) {
                this.frequency = d2;
            }
            double d3 = this.frequency - d;
            this.freqTimeZero = VoltageElm.sim.t - d * (VoltageElm.sim.t - this.freqTimeZero) / this.frequency;
        }
        if (n == 1) {
            int n2 = this.waveform;
            this.waveform = editInfo.choice.getSelectedIndex();
            if (this.waveform == 0 && n2 != 0) {
                editInfo.newDialog = true;
                this.bias = 0.0;
            } else if (this.waveform != 0 && n2 == 0) {
                editInfo.newDialog = true;
            }
            if ((this.waveform == 2 || n2 == 2) && this.waveform != n2) {
                editInfo.newDialog = true;
            }
            this.setPoints();
        }
        if (n == 4) {
            this.phaseShift = editInfo.value * Math.PI / 180.0;
        }
        if (n == 5) {
            this.dutyCycle = editInfo.value * 0.01;
        }
    }
}

