/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    private Vector modelListeners = new Vector();
    private Object root = null;

    public Object getRoot() {
        return this.root;
    }

    protected void setRoot(Object r) {
        this.root = r;
    }

    public Object[] getPathToRoot(Object node) {
        return this.getPathToRoot(node, 0);
    }

    private Object[] getPathToRoot(Object node, int i) {
        Object[] anode;
        if (node == null) {
            if (i == 0) {
                return null;
            }
            anode = new Object[i];
        } else {
            anode = node == this.getRoot() ? new Object[i] : this.getPathToRoot(this.getParent(node), ++i);
            anode[anode.length - i] = node;
        }
        return anode;
    }

    protected abstract Object getParent(Object var1);

    public void addTreeModelListener(TreeModelListener l) {
        this.modelListeners.addElement(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.modelListeners.removeElement(l);
    }

    public void reload() {
        this.reload(this.getRoot());
    }

    public void reload(Object node) {
        if (node != null) {
            TreePath tp = new TreePath(this.getPathToRoot(node));
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, tp));
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.nodeChanged(path.getLastPathComponent());
    }

    public void nodeInserted(Object node, Object child) {
        this.nodeInserted(node, child, -1);
    }

    public void nodeInserted(Object node, Object child, int index) {
        if (index < 0) {
            index = this.getIndexOfChild(node, child);
        }
        if (node != null && child != null && index >= 0) {
            TreePath tp = new TreePath(this.getPathToRoot(node));
            int[] ai = new int[]{index};
            Object[] ac = new Object[]{child};
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, tp, ai, ac));
        }
    }

    public void nodeRemoved(Object node, Object child, int index) {
        if (node != null && child != null && index >= 0) {
            TreePath tp = new TreePath(this.getPathToRoot(node));
            int[] ai = new int[]{index};
            Object[] ac = new Object[]{child};
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, tp, ai, ac));
        }
    }

    public void nodeChanged(Object node) {
        if (node != null) {
            TreePath tp = new TreePath(this.getPathToRoot(node));
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, tp, null, null));
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent event) {
        for (int i = 0; i < this.modelListeners.size(); ++i) {
            ((TreeModelListener)this.modelListeners.elementAt(i)).treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent event) {
        for (int i = 0; i < this.modelListeners.size(); ++i) {
            ((TreeModelListener)this.modelListeners.elementAt(i)).treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent event) {
        for (int i = 0; i < this.modelListeners.size(); ++i) {
            ((TreeModelListener)this.modelListeners.elementAt(i)).treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        for (int i = 0; i < this.modelListeners.size(); ++i) {
            ((TreeModelListener)this.modelListeners.elementAt(i)).treeStructureChanged(event);
        }
    }

    public ArrayList getExpandedPaths(JTree tree) {
        ArrayList expandedPaths = new ArrayList();
        this.addExpandedPaths(tree, tree.getPathForRow(0), expandedPaths);
        return expandedPaths;
    }

    private void addExpandedPaths(JTree tree, TreePath path, ArrayList pathlist) {
        Enumeration<TreePath> enumm = tree.getExpandedDescendants(path);
        while (enumm.hasMoreElements()) {
            TreePath tp = enumm.nextElement();
            pathlist.add(tp);
            this.addExpandedPaths(tree, tp, pathlist);
        }
    }

    public void expandPaths(JTree tree, ArrayList pathlist) {
        for (int i = 0; i < pathlist.size(); ++i) {
            tree.expandPath((TreePath)pathlist.get(i));
        }
    }
}

