/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import idiet.TTNode;
import idiet.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

class TTModel
extends AbstractTableModel
implements Externalizable {
    private static final long serialVersionUID = 761439067L;
    int rows = 0;
    final int columns = 6;
    double total_carbs = 0.0;
    double total_proteins = 0.0;
    double total_fats = 0.0;
    double total_cals = 0.0;
    double weight;
    ArrayList<Object> table = new ArrayList();
    ArrayList<Object> tabled = new ArrayList();

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeInt(this.rows);
        stream.writeDouble(this.total_carbs);
        stream.writeDouble(this.total_proteins);
        stream.writeDouble(this.total_fats);
        stream.writeDouble(this.total_cals);
        stream.writeDouble(this.weight);
        stream.writeObject(this.table);
        stream.writeObject(this.tabled);
    }

    public void readExternal(ObjectInput stream) throws IOException {
        try {
            this.rows = stream.readInt();
            this.total_carbs = stream.readDouble();
            this.total_proteins = stream.readDouble();
            this.total_fats = stream.readDouble();
            this.total_cals = stream.readDouble();
            this.weight = stream.readDouble();
            this.table = (ArrayList)stream.readObject();
            this.tabled = (ArrayList)stream.readObject();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TTModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getColumnName(int ind) {
        if (ind == 0) {
            return "";
        }
        if (ind == 1) {
            return "Meal";
        }
        if (ind == 2) {
            return "Carb";
        }
        if (ind == 3) {
            return "Prot";
        }
        if (ind == 4) {
            return "Fat";
        }
        if (ind == 5) {
            return "Cal";
        }
        return null;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void total() {
        int c = this.table.size();
        this.total_carbs = 0.0;
        this.total_proteins = 0.0;
        this.total_fats = 0.0;
        this.total_cals = 0.0;
        for (int i = 0; i < c; ++i) {
            TTNode ch = (TTNode)this.table.get(i);
            this.total_carbs += ch.getCarbs();
            this.total_fats += ch.getFats();
            this.total_proteins += ch.getProteins();
            this.total_cals += ch.getCalories();
        }
        this.total_carbs = Utils.round(this.total_carbs, 3);
        this.total_fats = Utils.round(this.total_fats, 3);
        this.total_proteins = Utils.round(this.total_proteins, 3);
        this.total_cals = Utils.round(this.total_cals, 3);
    }

    public double getCarbs() {
        return this.total_carbs;
    }

    public double getProteins() {
        return this.total_proteins;
    }

    public double getFats() {
        return this.total_fats;
    }

    public double getCals() {
        return this.total_cals;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return 6;
    }

    public TTNode getObjAt(int row) {
        if (row >= this.tabled.size()) {
            return null;
        }
        return (TTNode)this.tabled.get(row);
    }

    public boolean deleteRow(int row) {
        TTNode n = (TTNode)this.tabled.get(row);
        if (!n.isParent()) {
            this.tabled.remove(n);
            n.getParent().removeChild(n);
        } else if (n.isExtended()) {
            this.table.remove(n);
            int p = n.numbChildren();
            for (int i = 0; i < p + 1; ++i) {
                this.tabled.remove(row);
            }
        } else {
            this.table.remove(n);
            this.tabled.remove(n);
        }
        this.total();
        this.rows = this.tabled.size();
        return true;
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.tabled.size()) {
            return null;
        }
        if (this.tabled.get(row) == null) {
            return null;
        }
        TTNode n = (TTNode)this.tabled.get(row);
        if (column == 0) {
            if (n.isParent()) {
                if (n.isExtended()) {
                    return "-";
                }
                return "+";
            }
            return null;
        }
        if (column == 1) {
            return n.toString();
        }
        if (column == 2) {
            return n.getCarbs();
        }
        if (column == 3) {
            return n.getProteins();
        }
        if (column == 4) {
            return n.getFats();
        }
        if (column == 5) {
            return n.getCalories();
        }
        return null;
    }

    public boolean addParent(TTNode node) {
        this.table.add(node);
        this.tabled.add(node);
        ++this.rows;
        return true;
    }

    public boolean addChild(TTNode parent, TTNode child) {
        parent.addChild(child);
        child.addParent(parent);
        if (parent.isExtended()) {
            int i = this.tabled.indexOf(parent);
            this.tabled.add(i + parent.numbChildren(), child);
        }
        this.rows = this.tabled.size();
        this.total();
        return true;
    }

    public boolean expand(int row, int column) {
        if (((TTNode)this.tabled.get(row)).isParent() && !((TTNode)this.tabled.get(row)).isExtended()) {
            this.tabled.addAll(row + 1, ((TTNode)this.tabled.get(row)).getChildren());
            ((TTNode)this.tabled.get(row)).extend(true);
            this.rows = this.tabled.size();
            return true;
        }
        if (((TTNode)this.tabled.get(row)).isParent() && ((TTNode)this.tabled.get(row)).isExtended()) {
            for (int i = 0; i < ((TTNode)this.tabled.get(row)).numbChildren(); ++i) {
                this.tabled.remove(row + 1);
            }
            ((TTNode)this.tabled.get(row)).extend(false);
            this.rows = this.tabled.size();
            return true;
        }
        return false;
    }

    public int getParents() {
        return this.table.size();
    }
}

