/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import idiet.DietSetup;
import idiet.IDietApp;
import idiet.User;
import idiet.Utils;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class UserSetup
extends JDialog {
    User u;
    int units = 0;
    int gender = 1;
    boolean edit = false;
    int oage = 0;
    double oweight = 0.0;
    double oheight = 0.0;
    public JComboBox activityLevelBox;
    public JComboBox bloodPressureBox;
    public JComboBox bloodSugarBox;
    public JComboBox dayField;
    private JButton doneBtn;
    public JTextField fNameField;
    public JTextField height;
    private JLabel heightLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    public JRadioButton jRadioButton1;
    public JRadioButton jRadioButton2;
    public JRadioButton jRadioButton3;
    public JRadioButton jRadioButton4;
    private JToggleButton jToggleButton1;
    public JTextField lNameField;
    public JComboBox metabolismRateBox;
    public JComboBox monthField;
    private JPasswordField passwordFieldOne;
    private JPasswordField passwordFieldTwo;
    private ButtonGroup sexButtonGroup;
    private ButtonGroup unitsButtonGroup;
    public JTextField weight;
    private JLabel weightLabel;
    public JTextField yearField;

    public User getUser() {
        return this.u;
    }

    public void setUser(User u) {
        this.u = u;
    }

    public UserSetup() {
        super((Frame)null, true);
        this.initComponents();
        if (this.edit) {
            this.doneBtn.setText("Edit");
        }
    }

    private void initComponents() {
        this.unitsButtonGroup = new ButtonGroup();
        this.sexButtonGroup = new ButtonGroup();
        this.jPanel9 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.fNameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.lNameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.passwordFieldOne = new JPasswordField();
        this.passwordFieldTwo = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel10 = new JLabel();
        this.bloodPressureBox = new JComboBox();
        this.jLabel12 = new JLabel();
        this.metabolismRateBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.height = new JTextField();
        this.heightLabel = new JLabel();
        this.jLabel7 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.weight = new JTextField();
        this.weightLabel = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel11 = new JLabel();
        this.bloodSugarBox = new JComboBox();
        this.jLabel13 = new JLabel();
        this.activityLevelBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.monthField = new JComboBox();
        this.dayField = new JComboBox();
        this.yearField = new JTextField();
        this.doneBtn = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jPanel9.setName("jPanel9");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        ResourceMap resourceMap = Application.getInstance(IDietApp.class).getContext().getResourceMap(UserSetup.class);
        this.setTitle(resourceMap.getString("iDiet - User Setup.title", new Object[0]));
        this.setName("iDiet - User Setup");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel1.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel1.border.titleFont")));
        this.jPanel1.setName("jPanel1");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.fNameField.setText(resourceMap.getString("fNameField.text", new Object[0]));
        this.fNameField.setName("fNameField");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.lNameField.setText(resourceMap.getString("lNameField.text", new Object[0]));
        this.lNameField.setName("lNameField");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.passwordFieldOne.setText(resourceMap.getString("passwordFieldOne.text", new Object[0]));
        this.passwordFieldOne.setEnabled(false);
        this.passwordFieldOne.setName("passwordFieldOne");
        this.passwordFieldTwo.setText(resourceMap.getString("passwordFieldTwo.text", new Object[0]));
        this.passwordFieldTwo.setEnabled(false);
        this.passwordFieldTwo.setName("passwordFieldTwo");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(2, this.jLabel1).add(2, this.jLabel3).add(2, this.jLabel4)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.fNameField, -2, 92, -2).addPreferredGap(0).add(this.jLabel2).addPreferredGap(0).add(this.lNameField, -1, 92, Short.MAX_VALUE)).add(this.passwordFieldTwo, -1, 246, Short.MAX_VALUE).add(this.passwordFieldOne, -1, 246, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.jLabel2).add(this.fNameField, -2, -1, -2).add(this.lNameField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.passwordFieldOne, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel4).add(this.passwordFieldTwo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel2.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel2.border.titleFont")));
        this.jPanel2.setName("jPanel2");
        this.jPanel10.setName("jPanel10");
        this.jPanel6.setName("jPanel6");
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.bloodPressureBox.setModel(new DefaultComboBoxModel<String>(new String[]{"low", "normal", "high"}));
        this.bloodPressureBox.setSelectedIndex(1);
        this.bloodPressureBox.setName("bloodPressureBox");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.metabolismRateBox.setModel(new DefaultComboBoxModel<String>(new String[]{"low", "normal", "high"}));
        this.metabolismRateBox.setSelectedIndex(1);
        this.metabolismRateBox.setName("metabolismRateBox");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(1).add(jPanel6Layout.createSequentialGroup().add(jPanel6Layout.createParallelGroup(1).add(this.jLabel12).add(this.jLabel10)).add(9, 9, 9).add(jPanel6Layout.createParallelGroup(1, false).add(this.metabolismRateBox, 0, -1, Short.MAX_VALUE).add(this.bloodPressureBox, 0, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(1).add(jPanel6Layout.createSequentialGroup().add(jPanel6Layout.createParallelGroup(3).add(this.jLabel10).add(this.bloodPressureBox, -2, -1, -2)).addPreferredGap(0).add(jPanel6Layout.createParallelGroup(3).add(this.jLabel12).add(this.metabolismRateBox, -2, -1, -2)).addContainerGap(11, Short.MAX_VALUE)));
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.height.setText(resourceMap.getString("height.text", new Object[0]));
        this.height.setName("height");
        this.heightLabel.setText(resourceMap.getString("heightLabel.text", new Object[0]));
        this.heightLabel.setName("heightLabel");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.unitsButtonGroup.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.jRadioButton1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                UserSetup.this.jRadioButton1ItemStateChanged(evt);
            }
        });
        this.unitsButtonGroup.add(this.jRadioButton2);
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setName("jRadioButton2");
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(1).add(jPanel10Layout.createSequentialGroup().add(jPanel10Layout.createParallelGroup(1).add(jPanel10Layout.createSequentialGroup().add(this.jLabel6).add(33, 33, 33).add(this.height, -2, 63, -2).addPreferredGap(0).add(this.heightLabel)).add(jPanel10Layout.createSequentialGroup().add(this.jLabel7).addPreferredGap(1).add(this.jRadioButton1).addPreferredGap(0).add(this.jRadioButton2)).add(this.jPanel6, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(1).add(jPanel10Layout.createSequentialGroup().add(jPanel10Layout.createParallelGroup(3).add(this.jLabel6).add(this.height, -2, -1, -2).add(this.heightLabel)).addPreferredGap(0).add(jPanel10Layout.createParallelGroup(3).add(this.jLabel7).add(this.jRadioButton1).add(this.jRadioButton2)).addPreferredGap(1).add(this.jPanel6, -1, -1, Short.MAX_VALUE)));
        this.jPanel11.setName("jPanel11");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.weight.setText(resourceMap.getString("weight.text", new Object[0]));
        this.weight.setName("weight");
        this.weightLabel.setText(resourceMap.getString("weightLabel.text", new Object[0]));
        this.weightLabel.setName("weightLabel");
        this.jPanel7.setName("jPanel7");
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.bloodSugarBox.setModel(new DefaultComboBoxModel<String>(new String[]{"low", "normal", "high"}));
        this.bloodSugarBox.setSelectedIndex(1);
        this.bloodSugarBox.setName("bloodSugarBox");
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.activityLevelBox.setModel(new DefaultComboBoxModel<String>(new String[]{"low", "normal", "high"}));
        this.activityLevelBox.setSelectedIndex(1);
        this.activityLevelBox.setName("activityLevelBox");
        this.activityLevelBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserSetup.this.activityLevelBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(1).add(jPanel7Layout.createSequentialGroup().add(jPanel7Layout.createParallelGroup(1).add(this.jLabel13).add(this.jLabel11)).add(24, 24, 24).add(jPanel7Layout.createParallelGroup(2).add(this.bloodSugarBox, -2, -1, -2).add(this.activityLevelBox, -2, -1, -2))));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(1).add(jPanel7Layout.createSequentialGroup().add(jPanel7Layout.createParallelGroup(3).add(this.jLabel11).add(this.bloodSugarBox, -2, -1, -2)).addPreferredGap(0).add(jPanel7Layout.createParallelGroup(3).add(this.jLabel13).add(this.activityLevelBox, -2, -1, -2)).addContainerGap(11, Short.MAX_VALUE)));
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.sexButtonGroup.add(this.jRadioButton3);
        this.jRadioButton3.setText(resourceMap.getString("jRadioButton3.text", new Object[0]));
        this.jRadioButton3.setName("jRadioButton3");
        this.sexButtonGroup.add(this.jRadioButton4);
        this.jRadioButton4.setText(resourceMap.getString("jRadioButton4.text", new Object[0]));
        this.jRadioButton4.setName("jRadioButton4");
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(1).add(jPanel11Layout.createSequentialGroup().add(this.jLabel9).add(29, 29, 29).add(this.weight, -2, 68, -2).addPreferredGap(0).add(this.weightLabel)).add(jPanel11Layout.createSequentialGroup().add(this.jLabel8).addPreferredGap(0).add(this.jRadioButton3).addPreferredGap(0).add(this.jRadioButton4).add(12, 12, 12)).add(jPanel11Layout.createSequentialGroup().add(this.jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(1).add(jPanel11Layout.createSequentialGroup().add(jPanel11Layout.createParallelGroup(3).add(this.jLabel9).add(this.weight, -2, -1, -2).add(this.weightLabel)).addPreferredGap(0).add(jPanel11Layout.createParallelGroup(3).add(this.jLabel8).add(this.jRadioButton3).add(this.jRadioButton4)).addPreferredGap(1).add(this.jPanel7, -1, -1, Short.MAX_VALUE)));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.monthField.setModel(new DefaultComboBoxModel<String>(new String[]{"Month", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}));
        this.monthField.setName("monthField");
        this.dayField.setModel(new DefaultComboBoxModel<String>(new String[]{"Day", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}));
        this.dayField.setName("dayField");
        this.yearField.setText(resourceMap.getString("yearField.text", new Object[0]));
        this.yearField.setName("yearField");
        this.yearField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UserSetup.this.yearFieldMouseClicked(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabel5).addPreferredGap(0).add(this.monthField, -2, -1, -2)).add(this.jPanel10, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.dayField, -2, -1, -2).addPreferredGap(0).add(this.yearField, -2, 95, -2)).add(this.jPanel11, -2, -1, -2))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel5).add(this.monthField, -2, -1, -2).add(this.dayField, -2, -1, -2).add(this.yearField, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.jPanel11, -1, -1, Short.MAX_VALUE).add(this.jPanel10, -1, -1, Short.MAX_VALUE))));
        this.doneBtn.setText(resourceMap.getString("doneBtn.text", new Object[0]));
        this.doneBtn.setName("doneBtn");
        this.doneBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UserSetup.this.doneBtnMouseClicked(evt);
            }
        });
        this.jToggleButton1.setText(resourceMap.getString("jToggleButton1.text", new Object[0]));
        this.jToggleButton1.setName("jToggleButton1");
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserSetup.this.jToggleButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2, false).add(1, this.jPanel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jToggleButton1).addPreferredGap(0).add(this.doneBtn)).add(1, this.jPanel2, -1, 370, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.doneBtn).add(this.jToggleButton1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void yearFieldMouseClicked(MouseEvent evt) {
        if (this.yearField.getText().compareTo("Year") == 0) {
            this.yearField.setText("");
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        if (this.edit) {
            this.dispose();
        } else {
            IDietApp.getInstance().exit();
        }
    }

    private void doneBtnMouseClicked(MouseEvent evt) {
        File test;
        boolean errorb = false;
        boolean errorb2 = false;
        boolean nameerror = false;
        double weightD = 0.0;
        double heightD = 0.0;
        int year = 0;
        String[] badchars = new String[]{"/", "?", ">", "<", "\\", "]", "}", "[", "{", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "'", "\"", ";", ":", "|", "`"};
        String w_h = "";
        String error = "Please fill in the following boxes:\n";
        String fname = this.fNameField.getText();
        String lname = this.lNameField.getText();
        for (int i = 0; i < badchars.length; ++i) {
            if (!fname.contains(badchars[i]) && !lname.contains(badchars[i])) continue;
            JOptionPane.showMessageDialog(null, "Invalid character in your name: " + badchars[i]);
            nameerror = true;
            break;
        }
        if (!this.edit && (test = new File(System.getProperty("user.home") + "/.iDiet_profiles/" + fname.replaceAll(" ", "_") + "_" + lname.replaceAll(" ", "_"))).exists()) {
            JOptionPane.showMessageDialog(null, "User with your name already exists!");
            nameerror = true;
        }
        if (!nameerror) {
            if (this.weight.getText().length() != 0) {
                weightD = new Double(this.weight.getText());
                weightD = this.jRadioButton2.isSelected() ? Utils.round(weightD * 0.45359237, 1) : Utils.round(Utils.round(weightD / 0.45359237, 1) * 0.45359237, 1);
            } else {
                errorb2 = true;
                w_h = "Weight\n";
            }
            if (this.height.getText().length() != 0) {
                heightD = new Double(this.height.getText());
                heightD = this.jRadioButton2.isSelected() ? Utils.round(heightD * 2.54, 1) : Utils.round(Utils.round(heightD / 2.54, 1) * 2.54, 1);
            } else {
                errorb2 = true;
                w_h = w_h + "Height\n";
            }
            int month = this.monthField.getSelectedIndex();
            int day = this.dayField.getSelectedIndex();
            try {
                if (this.yearField.getText().length() != 0) {
                    year = new Integer(this.yearField.getText());
                } else {
                    errorb2 = true;
                    w_h = w_h + "Year\n";
                }
            }
            catch (Exception e) {
                errorb2 = true;
                w_h = w_h + "Year\n";
            }
            int metabolism = this.metabolismRateBox.getSelectedIndex();
            int blood_pressure = this.bloodPressureBox.getSelectedIndex();
            int blood_sugar = this.bloodSugarBox.getSelectedIndex();
            int activityLv = this.activityLevelBox.getSelectedIndex();
            if (fname.length() == 0) {
                error = error + "First Name\n";
                errorb = true;
            }
            if (lname.length() == 0) {
                error = error + "Last Name\n";
                errorb = true;
            }
            if (errorb2) {
                error = error + w_h;
                errorb = true;
            }
            if (this.monthField.getSelectedIndex() == 0) {
                error = error + "Month\n";
                errorb = true;
            }
            if (this.dayField.getSelectedIndex() == 0) {
                error = error + "Day\n";
                errorb = true;
            }
            if (!this.jRadioButton3.isSelected() && !this.jRadioButton4.isSelected()) {
                errorb = true;
                error = error + "Gender";
            }
            if (errorb) {
                JOptionPane.showMessageDialog(null, error);
            } else {
                Calendar now = Calendar.getInstance();
                Calendar bd = Calendar.getInstance();
                bd.set(year, month, day);
                int age = now.get(1) - bd.get(1);
                bd.add(1, age);
                if (now.before(bd)) {
                    --age;
                }
                if (this.jRadioButton3.isSelected()) {
                    this.gender = 0;
                }
                if (this.jRadioButton2.isSelected()) {
                    this.units = 1;
                }
                int cals = 0;
                cals = this.gender == 0 ? (int)(66.473 + 13.751 * weightD + 5.0033 * heightD - 6.755 * (double)age) : (int)(655.0955 + 9.463 * weightD + 1.8496 * heightD - 4.6756 * (double)age);
                switch (activityLv) {
                    case 0: {
                        cals = (int)((double)cals * 1.2);
                        break;
                    }
                    case 1: {
                        cals = (int)((double)cals * 1.5);
                        break;
                    }
                    case 2: {
                        cals = (int)((double)cals * 1.8);
                    }
                }
                if (this.edit) {
                    this.u.firstName = fname;
                    this.u.lastName = lname;
                    this.u.height = heightD;
                    this.u.weight = weightD;
                    this.u.bPressure = blood_pressure;
                    this.u.bSugar = blood_sugar;
                    this.u.metabolism = metabolism;
                    this.u.activity = activityLv;
                    this.u.bday = day;
                    this.u.bmonth = month;
                    this.u.byear = year;
                    this.u.gender = this.gender;
                    this.u.units = this.units;
                    if (this.u.scals != (double)cals) {
                        JOptionPane pane = new JOptionPane("Your suggested calories have changed with the new information!\nWould you like to start using your new suggested calories?");
                        Object[] options = new String[]{"Open Diet Setup", "Yes", "No"};
                        pane.setOptions(options);
                        JDialog dialog = pane.createDialog(new JFrame(), "WARNING");
                        dialog.setVisible(true);
                        Object obj = pane.getValue();
                        int result = -1;
                        for (int k = 0; k < options.length; ++k) {
                            if (!options[k].equals(obj)) continue;
                            result = k;
                        }
                        switch (result) {
                            case 0: {
                                this.u.scals = cals;
                                DietSetup ds = new DietSetup(this.u, true);
                                ds.protein = this.u.protein;
                                ds.proteinp = this.u.proteinp;
                                ds.totalCals = this.u.totalCals;
                                ds.fat = this.u.fat;
                                ds.fatp = this.u.fatp;
                                ds.carbs = this.u.carbs;
                                ds.carbsp = this.u.carbsp;
                                ds.diettype = this.u.diettype;
                                ds.setForm();
                                ds.triggerCalsChanged();
                                this.dispose();
                                ds.setVisible(true);
                                break;
                            }
                            case 1: {
                                this.u.scals = cals;
                                DietSetup d = new DietSetup(this.u, true);
                                d.protein = this.u.protein;
                                d.proteinp = this.u.proteinp;
                                d.totalCals = cals;
                                d.fatp = this.u.fatp;
                                d.fat = this.u.fat;
                                d.carbsp = this.u.carbsp;
                                d.carbs = this.u.carbs;
                                d.diettype = this.u.diettype;
                                d.setForm();
                                d.triggerCalsChanged();
                                this.u.protein = d.protein;
                                this.u.proteinp = d.proteinp;
                                this.u.totalCals = d.totalCals;
                                this.u.fat = d.fat;
                                this.u.fatp = d.fatp;
                                this.u.carbs = d.carbs;
                                this.u.carbsp = d.carbsp;
                                this.u.diettype = d.diettype;
                                this.u.setDiet(new String(new SimpleDateFormat("dd MMMMM yyyy").format(Calendar.getInstance().getTime())));
                                this.dispose();
                                break;
                            }
                            case 2: {
                                this.u.scals = cals;
                                this.dispose();
                            }
                        }
                    }
                    this.dispose();
                } else {
                    this.u = new User(fname, lname, heightD, weightD, blood_pressure, blood_sugar, metabolism, activityLv, day, month, year, this.gender, this.units);
                    this.u.scals = cals;
                    DietSetup ds = new DietSetup(this.u, false);
                    this.dispose();
                    ds.setVisible(true);
                }
            }
        }
    }

    private void jRadioButton1ItemStateChanged(ItemEvent evt) {
        double wD = 0.0;
        double hD = 0.0;
        if (this.weight.getText().length() > 0) {
            wD = new Double(this.weight.getText());
        }
        if (this.height.getText().length() > 0) {
            hD = new Double(this.height.getText());
        }
        if (this.jRadioButton1.isSelected()) {
            this.heightLabel.setText("cm");
            this.weightLabel.setText("kg");
            if (wD != 0.0) {
                this.weight.setText(new Double(Utils.round(wD *= 0.45359237, 1)).toString());
            }
            if (hD != 0.0) {
                this.height.setText(new Double(Utils.round(hD *= 2.54, 1)).toString());
            }
        } else {
            this.heightLabel.setText("in");
            this.weightLabel.setText("lb");
            if (wD != 0.0) {
                this.weight.setText(new Double(Utils.round(wD /= 0.45359237, 1)).toString());
            }
            if (hD != 0.0) {
                this.height.setText(new Double(Utils.round(hD /= 2.54, 1)).toString());
            }
        }
    }

    private void activityLevelBoxActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UserSetup().setVisible(true);
            }
        });
    }
}

