/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter
implements Evaluator {
    private static final int Icode_DUP = -1;
    private static final int Icode_DUP2 = -2;
    private static final int Icode_SWAP = -3;
    private static final int Icode_POP = -4;
    private static final int Icode_POP_RESULT = -5;
    private static final int Icode_IFEQ_POP = -6;
    private static final int Icode_VAR_INC_DEC = -7;
    private static final int Icode_NAME_INC_DEC = -8;
    private static final int Icode_PROP_INC_DEC = -9;
    private static final int Icode_ELEM_INC_DEC = -10;
    private static final int Icode_REF_INC_DEC = -11;
    private static final int Icode_SCOPE_LOAD = -12;
    private static final int Icode_SCOPE_SAVE = -13;
    private static final int Icode_TYPEOFNAME = -14;
    private static final int Icode_NAME_AND_THIS = -15;
    private static final int Icode_PROP_AND_THIS = -16;
    private static final int Icode_ELEM_AND_THIS = -17;
    private static final int Icode_VALUE_AND_THIS = -18;
    private static final int Icode_CLOSURE_EXPR = -19;
    private static final int Icode_CLOSURE_STMT = -20;
    private static final int Icode_CALLSPECIAL = -21;
    private static final int Icode_RETUNDEF = -22;
    private static final int Icode_GOSUB = -23;
    private static final int Icode_STARTSUB = -24;
    private static final int Icode_RETSUB = -25;
    private static final int Icode_LINE = -26;
    private static final int Icode_SHORTNUMBER = -27;
    private static final int Icode_INTNUMBER = -28;
    private static final int Icode_LITERAL_NEW = -29;
    private static final int Icode_LITERAL_SET = -30;
    private static final int Icode_SPARE_ARRAYLIT = -31;
    private static final int Icode_REG_IND_C0 = -32;
    private static final int Icode_REG_IND_C1 = -33;
    private static final int Icode_REG_IND_C2 = -34;
    private static final int Icode_REG_IND_C3 = -35;
    private static final int Icode_REG_IND_C4 = -36;
    private static final int Icode_REG_IND_C5 = -37;
    private static final int Icode_REG_IND1 = -38;
    private static final int Icode_REG_IND2 = -39;
    private static final int Icode_REG_IND4 = -40;
    private static final int Icode_REG_STR_C0 = -41;
    private static final int Icode_REG_STR_C1 = -42;
    private static final int Icode_REG_STR_C2 = -43;
    private static final int Icode_REG_STR_C3 = -44;
    private static final int Icode_REG_STR1 = -45;
    private static final int Icode_REG_STR2 = -46;
    private static final int Icode_REG_STR4 = -47;
    private static final int Icode_GETVAR1 = -48;
    private static final int Icode_SETVAR1 = -49;
    private static final int Icode_UNDEF = -50;
    private static final int Icode_ZERO = -51;
    private static final int Icode_ONE = -52;
    private static final int Icode_ENTERDQ = -53;
    private static final int Icode_LEAVEDQ = -54;
    private static final int Icode_TAIL_CALL = -55;
    private static final int Icode_LOCAL_CLEAR = -56;
    private static final int Icode_LITERAL_GETTER = -57;
    private static final int Icode_LITERAL_SETTER = -58;
    private static final int Icode_SETCONST = -59;
    private static final int Icode_SETCONSTVAR = -60;
    private static final int Icode_SETCONSTVAR1 = -61;
    private static final int Icode_GENERATOR = -62;
    private static final int Icode_GENERATOR_END = -63;
    private static final int Icode_DEBUGGER = -64;
    private static final int MIN_ICODE = -64;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private boolean itsInTryFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsICodeTop;
    private int itsStackDepth;
    private int itsLineNumber;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsLiteralIds = new ObjArray();
    private int itsExceptionTableTop;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_HANDLER_SLOT = 2;
    private static final int EXCEPTION_TYPE_SLOT = 3;
    private static final int EXCEPTION_LOCAL_SLOT = 4;
    private static final int EXCEPTION_SCOPE_SLOT = 5;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int ECF_TAIL = 1;

    private static CallFrame captureFrameForGenerator(CallFrame callFrame) {
        callFrame.frozen = true;
        CallFrame callFrame2 = callFrame.cloneFrozen();
        callFrame.frozen = false;
        callFrame2.parentFrame = null;
        callFrame2.frameIndex = 0;
        return callFrame2;
    }

    private static String bytecodeName(int n) {
        if (!Interpreter.validBytecode(n)) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return String.valueOf(n);
    }

    private static boolean validIcode(int n) {
        return -64 <= n && n <= -1;
    }

    private static boolean validTokenCode(int n) {
        return 2 <= n && n <= 79;
    }

    private static boolean validBytecode(int n) {
        return Interpreter.validIcode(n) || Interpreter.validTokenCode(n);
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer().transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.scriptOrFn = scriptOrFnNode;
        this.itsData = new InterpreterData(compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string);
        this.itsData.topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsData.itsName = functionNode.getFunctionName();
        if (!functionNode.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        if (functionNode.isGenerator()) {
            this.addIcode(-62);
            this.addUint16(functionNode.getBaseLineno() & 0xFFFF);
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement(node, 0);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(64);
        }
        if (this.itsData.itsICode.length != this.itsICodeTop) {
            object = new byte[this.itsICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, this.itsICodeTop);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            object = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argIsConst = this.scriptOrFn.getParamAndVarConst();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.itsLiteralIds.size() != 0) {
            this.itsData.literalIds = this.itsLiteralIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        int n2 = 0;
        while (n2 != n) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n2);
            Interpreter interpreter = new Interpreter();
            interpreter.compilerEnv = this.compilerEnv;
            interpreter.scriptOrFn = functionNode;
            interpreter.itsData = new InterpreterData(this.itsData);
            interpreter.generateFunctionICode();
            interpreterDataArray[n2] = interpreter.itsData;
            ++n2;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 != n) {
            String string = this.scriptOrFn.getRegexpString(n2);
            String string2 = this.scriptOrFn.getRegexpFlags(n2);
            objectArray[n2] = regExpProxy.compileRegExp(context, string, string2);
            ++n2;
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.itsLineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.itsLineNumber = n;
            this.addIcode(-26);
            this.addUint16(n & 0xFFFF);
        }
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node, int n) {
        int n2 = node.getType();
        Node node2 = node.getFirstChild();
        switch (n2) {
            case 108: {
                int n3 = node.getExistingIntProp(1);
                int n4 = this.scriptOrFn.getFunctionNode(n3).getFunctionType();
                if (n4 == 3) {
                    this.addIndexOp(-20, n3);
                } else if (n4 != 1) {
                    throw Kit.codeBug();
                }
                if (this.itsInFunctionFlag) break;
                this.addIndexOp(-19, n3);
                this.stackChange(1);
                this.addIcode(-5);
                this.stackChange(-1);
                break;
            }
            case 122: 
            case 127: 
            case 128: 
            case 129: 
            case 131: {
                this.updateLineNumber(node);
            }
            case 135: {
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 2: {
                this.visitExpression(node2, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 140: {
                int n5 = this.allocLocal();
                node.putIntProp(2, n5);
                this.updateLineNumber(node);
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-56, n5);
                this.releaseLocal(n5);
                break;
            }
            case 159: {
                this.addIcode(-64);
                break;
            }
            case 113: {
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                Node.Jump jump = (Node.Jump)node2.getNext();
                while (jump != null) {
                    if (jump.getType() != 114) {
                        throw this.badTree(jump);
                    }
                    Node node3 = jump.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(node3, 0);
                    this.addToken(46);
                    this.stackChange(-1);
                    this.addGoto(jump.target, -6);
                    this.stackChange(-1);
                    jump = (Node.Jump)jump.getNext();
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 130: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node node4 = ((Node.Jump)node).target;
                this.visitExpression(node2, 0);
                this.addGoto(node4, n2);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node node5 = ((Node.Jump)node).target;
                this.addGoto(node5, n2);
                break;
            }
            case 134: {
                Node node6 = ((Node.Jump)node).target;
                this.addGoto(node6, -23);
                break;
            }
            case 124: {
                this.stackChange(1);
                int n6 = this.getLocalBlockRef(node);
                this.addIndexOp(-24, n6);
                this.stackChange(-1);
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-25, n6);
                break;
            }
            case 132: 
            case 133: {
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(n2 == 132 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 80: {
                Node node7;
                Node.Jump jump = (Node.Jump)node;
                int n7 = this.getLocalBlockRef(jump);
                int n8 = this.allocLocal();
                this.addIndexOp(-13, n8);
                int n9 = this.itsICodeTop;
                boolean bl = this.itsInTryFlag;
                this.itsInTryFlag = true;
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.itsInTryFlag = bl;
                Node node8 = jump.target;
                if (node8 != null) {
                    int n10 = this.itsLabelTable[this.getTargetLabel(node8)];
                    this.addExceptionHandler(n9, n10, n10, false, n7, n8);
                }
                if ((node7 = jump.getFinally()) != null) {
                    int n11 = this.itsLabelTable[this.getTargetLabel(node7)];
                    this.addExceptionHandler(n9, n11, n11, true, n7, n8);
                }
                this.addIndexOp(-56, n8);
                this.releaseLocal(n8);
                break;
            }
            case 57: {
                int n12 = this.getLocalBlockRef(node);
                int n13 = node.getExistingIntProp(14);
                String string = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringPrefix(string);
                this.addIndexPrefix(n12);
                this.addToken(57);
                this.addUint8(n13 != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 50: {
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addToken(50);
                this.addUint16(this.itsLineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 51: {
                this.updateLineNumber(node);
                this.addIndexOp(51, this.getLocalBlockRef(node));
                break;
            }
            case 4: {
                this.updateLineNumber(node);
                if (node.getIntProp(20, 0) != 0) {
                    this.addIcode(-63);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                    break;
                }
                if (node2 != null) {
                    this.visitExpression(node2, 1);
                    this.addToken(4);
                    this.stackChange(-1);
                    break;
                }
                this.addIcode(-22);
                break;
            }
            case 64: {
                this.updateLineNumber(node);
                this.addToken(64);
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                this.visitExpression(node2, 0);
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            case -62: {
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (this.itsStackDepth != n) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int n) {
        int n2 = node.getType();
        Node node2 = node.getFirstChild();
        int n3 = this.itsStackDepth;
        switch (n2) {
            case 108: {
                int n4 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n4);
                if (functionNode.getFunctionType() != 2) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-19, n4);
                this.stackChange(1);
                break;
            }
            case 54: {
                int n5 = this.getLocalBlockRef(node);
                this.addIndexOp(54, n5);
                this.stackChange(1);
                break;
            }
            case 88: {
                Node node3 = node.getLastChild();
                while (node2 != node3) {
                    this.visitExpression(node2, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                    node2 = node2.getNext();
                }
                this.visitExpression(node2, n & 1);
                break;
            }
            case 137: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 38: 
            case 70: {
                if (n2 == 30) {
                    this.visitExpression(node2, 0);
                } else {
                    this.generateCallFunAndThis(node2);
                }
                int n6 = 0;
                while ((node2 = node2.getNext()) != null) {
                    this.visitExpression(node2, 0);
                    ++n6;
                }
                int n7 = node.getIntProp(10, 0);
                if (n7 != 0) {
                    this.addIndexOp(-21, n6);
                    this.addUint8(n7);
                    this.addUint8(n2 == 30 ? 1 : 0);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                } else {
                    if (n2 == 38 && (n & 1) != 0 && !this.compilerEnv.isGenerateDebugInfo() && !this.itsInTryFlag) {
                        n2 = -55;
                    }
                    this.addIndexOp(n2, n6);
                }
                if (n2 == 30) {
                    this.stackChange(-n6);
                } else {
                    this.stackChange(-1 - n6);
                }
                if (n6 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n6;
                break;
            }
            case 103: 
            case 104: {
                this.visitExpression(node2, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int n8 = this.itsICodeTop;
                int n9 = n2 == 104 ? 7 : 6;
                this.addGotoOp(n9);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                node2 = node2.getNext();
                this.visitExpression(node2, n & 1);
                this.resolveForwardGoto(n8);
                break;
            }
            case 101: {
                Node node4 = node2.getNext();
                Node node5 = node4.getNext();
                this.visitExpression(node2, 0);
                int n10 = this.itsICodeTop;
                this.addGotoOp(7);
                this.stackChange(-1);
                this.visitExpression(node4, n & 1);
                int n11 = this.itsICodeTop;
                this.addGotoOp(5);
                this.resolveForwardGoto(n10);
                this.itsStackDepth = n3;
                this.visitExpression(node5, n & 1);
                this.resolveForwardGoto(n11);
                break;
            }
            case 33: 
            case 34: {
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.addStringOp(n2, node2.getString());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 36: 
            case 46: 
            case 47: 
            case 52: 
            case 53: {
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 125: {
                this.visitExpression(node2, 0);
                if (n2 == 125) {
                    this.addIcode(-4);
                    this.addIcode(-50);
                    break;
                }
                this.addToken(n2);
                break;
            }
            case 67: 
            case 69: {
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 35: 
            case 138: {
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                String string = node2.getString();
                node2 = node2.getNext();
                if (n2 == 138) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, string);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addStringOp(35, string);
                this.stackChange(-1);
                break;
            }
            case 37: 
            case 139: {
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 139) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(36);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(37);
                this.stackChange(-2);
                break;
            }
            case 68: 
            case 141: {
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 141) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(67);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(68);
                this.stackChange(-1);
                break;
            }
            case 8: {
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(8, string);
                this.stackChange(-1);
                break;
            }
            case 154: {
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(-59, string);
                this.stackChange(-1);
                break;
            }
            case 136: {
                int n12 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n12 = this.scriptOrFn.getIndexForNameNode(node);
                }
                if (n12 == -1) {
                    this.addStringOp(-14, node.getString());
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(55, n12);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 39: 
            case 41: 
            case 49: {
                this.addStringOp(n2, node.getString());
                this.stackChange(1);
                break;
            }
            case 105: 
            case 106: {
                this.visitIncDec(node, node2);
                break;
            }
            case 40: {
                double d = node.getDouble();
                int n13 = (int)d;
                if ((double)n13 == d) {
                    if (n13 == 0) {
                        this.addIcode(-51);
                        if (1.0 / d < 0.0) {
                            this.addToken(29);
                        }
                    } else if (n13 == 1) {
                        this.addIcode(-52);
                    } else if ((short)n13 == n13) {
                        this.addIcode(-27);
                        this.addUint16(n13 & 0xFFFF);
                    } else {
                        this.addIcode(-28);
                        this.addInt(n13);
                    }
                } else {
                    int n14 = this.getDoubleIndex(d);
                    this.addIndexOp(40, n14);
                }
                this.stackChange(1);
                break;
            }
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n15 = this.scriptOrFn.getIndexForNameNode(node);
                this.addVarOp(55, n15);
                this.stackChange(1);
                break;
            }
            case 56: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n16 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(56, n16);
                break;
            }
            case 155: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n17 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(155, n17);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 63: {
                this.addToken(n2);
                this.stackChange(1);
                break;
            }
            case 61: 
            case 62: {
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 48: {
                int n18 = node.getExistingIntProp(4);
                this.addIndexOp(48, n18);
                this.stackChange(1);
                break;
            }
            case 65: 
            case 66: {
                this.visitLiteral(node, node2);
                break;
            }
            case 156: {
                this.visitArrayComprehension(node, node2, node2.getNext());
                break;
            }
            case 71: {
                this.visitExpression(node2, 0);
                this.addStringOp(n2, (String)node.getProp(17));
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                int n19 = node.getIntProp(16, 0);
                int n20 = 0;
                do {
                    this.visitExpression(node2, 0);
                    ++n20;
                } while ((node2 = node2.getNext()) != null);
                this.addIndexOp(n2, n19);
                this.stackChange(1 - n20);
                break;
            }
            case 145: {
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(-53);
                this.stackChange(-1);
                int n21 = this.itsICodeTop;
                this.visitExpression(node2.getNext(), 0);
                this.addBackwardGoto(-54, n21);
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 72: {
                if (node2 != null) {
                    this.visitExpression(node2, 0);
                } else {
                    this.addIcode(-50);
                    this.stackChange(1);
                }
                this.addToken(72);
                this.addUint16(node.getLineno() & 0xFFFF);
                break;
            }
            case 158: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                this.visitExpression(node6.getFirstChild(), 0);
                this.addToken(2);
                this.stackChange(-1);
                this.visitExpression(node7.getFirstChild(), 0);
                this.addToken(3);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (n3 + 1 != this.itsStackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        switch (n) {
            case 39: {
                String string = node.getString();
                this.addStringOp(-15, string);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 36: {
                Node node2 = node.getFirstChild();
                this.visitExpression(node2, 0);
                Node node3 = node2.getNext();
                if (n == 33) {
                    String string = node3.getString();
                    this.addStringOp(-16, string);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(node3, 0);
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(node, 0);
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        switch (n2) {
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n3 = this.scriptOrFn.getIndexForNameNode(node2);
                this.addVarOp(-7, n3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 39: {
                String string = node2.getString();
                this.addStringOp(-8, string);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.visitExpression(node3, 0);
                String string = node3.getNext().getString();
                this.addStringOp(-9, string);
                this.addUint8(n);
                break;
            }
            case 36: {
                Node node4 = node2.getFirstChild();
                this.visitExpression(node4, 0);
                Node node5 = node4.getNext();
                this.visitExpression(node5, 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            case 67: {
                Node node6 = node2.getFirstChild();
                this.visitExpression(node6, 0);
                this.addIcode(-11);
                this.addUint8(n);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
    }

    private void visitLiteral(Node node, Node node2) {
        int n;
        int n2 = node.getType();
        Object[] objectArray = null;
        if (n2 == 65) {
            n = 0;
            Node node3 = node2;
            while (node3 != null) {
                ++n;
                node3 = node3.getNext();
            }
        } else if (n2 == 66) {
            objectArray = (Object[])node.getProp(12);
            n = objectArray.length;
        } else {
            throw this.badTree(node);
        }
        this.addIndexOp(-29, n);
        this.stackChange(2);
        while (node2 != null) {
            int n3 = node2.getType();
            if (n3 == 150) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-57);
            } else if (n3 == 151) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-58);
            } else {
                this.visitExpression(node2, 0);
                this.addIcode(-30);
            }
            this.stackChange(-1);
            node2 = node2.getNext();
        }
        if (n2 == 65) {
            int[] nArray = (int[])node.getProp(11);
            if (nArray == null) {
                this.addToken(65);
            } else {
                int n4 = this.itsLiteralIds.size();
                this.itsLiteralIds.add(nArray);
                this.addIndexOp(-31, n4);
            }
        } else {
            int n5 = this.itsLiteralIds.size();
            this.itsLiteralIds.add(objectArray);
            this.addIndexOp(66, n5);
        }
        this.stackChange(-1);
    }

    private void visitArrayComprehension(Node node, Node node2, Node node3) {
        this.visitStatement(node2, this.itsStackDepth);
        this.visitExpression(node3, 0);
    }

    private int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(3);
        return node2.getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.itsLabelTable[n] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[n] = this.itsICodeTop;
    }

    private void addGoto(Node node, int n) {
        int n2;
        int n3 = this.getTargetLabel(node);
        if (n3 >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        if ((n2 = this.itsLabelTable[n3]) != -1) {
            this.addBackwardGoto(n, n2);
        } else {
            int n4 = this.itsICodeTop;
            this.addGotoOp(n);
            int n5 = this.itsFixupTableTop;
            if (this.itsFixupTable == null || n5 == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, lArray, 0, n5);
                    this.itsFixupTable = lArray;
                }
            }
            this.itsFixupTableTop = n5 + 1;
            this.itsFixupTable[n5] = (long)n3 << 32 | (long)n4;
        }
    }

    private void fixLabelGotos() {
        int n = 0;
        while (n < this.itsFixupTableTop) {
            long l = this.itsFixupTable[n];
            int n2 = (int)(l >> 32);
            int n3 = (int)l;
            int n4 = this.itsLabelTable[n2];
            if (n4 == -1) {
                throw Kit.codeBug();
            }
            this.resolveGoto(n3, n4);
            ++n;
        }
        this.itsFixupTableTop = 0;
    }

    private void addBackwardGoto(int n, int n2) {
        int n3 = this.itsICodeTop;
        if (n3 <= n2) {
            throw Kit.codeBug();
        }
        this.addGotoOp(n);
        this.resolveGoto(n3, n2);
    }

    private void resolveForwardGoto(int n) {
        if (this.itsICodeTop < n + 3) {
            throw Kit.codeBug();
        }
        this.resolveGoto(n, this.itsICodeTop);
    }

    private void resolveGoto(int n, int n2) {
        int n3 = n2 - n;
        if (n3 >= 0 && n3 <= 2) {
            throw Kit.codeBug();
        }
        int n4 = n + 1;
        if (n3 != (short)n3) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n4, n2);
            n3 = 0;
        }
        byte[] byArray = this.itsData.itsICode;
        byArray[n4] = (byte)(n3 >> 8);
        byArray[n4 + 1] = (byte)n3;
    }

    private void addToken(int n) {
        if (!Interpreter.validTokenCode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n);
    }

    private void addIcode(int n) {
        if (!Interpreter.validIcode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n & 0xFF);
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapacity(1);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1;
    }

    private void addUint16(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapacity(2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        this.itsICodeTop = n2 + 2;
    }

    private void addInt(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapacity(4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        this.itsICodeTop = n2 + 4;
    }

    private int getDoubleIndex(double d) {
        int n = this.itsDoubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.itsDoubleTableTop = n + 1;
        return n;
    }

    private void addGotoOp(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 3 > byArray.length) {
            byArray = this.increaseICodeCapacity(3);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1 + 2;
    }

    private void addVarOp(int n, int n2) {
        switch (n) {
            case 155: {
                if (n2 < 128) {
                    this.addIcode(-61);
                    this.addUint8(n2);
                    return;
                }
                this.addIndexOp(-60, n2);
                return;
            }
            case 55: 
            case 56: {
                if (n2 < 128) {
                    this.addIcode(n == 55 ? -48 : -49);
                    this.addUint8(n2);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(n, n2);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int n, String string) {
        this.addStringPrefix(string);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string) {
        int n = this.itsStrings.get(string, -1);
        if (n == -1) {
            n = this.itsStrings.size();
            this.itsStrings.put(string, n);
        }
        if (n < 4) {
            this.addIcode(-41 - n);
        } else if (n <= 255) {
            this.addIcode(-45);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-46);
            this.addUint16(n);
        } else {
            this.addIcode(-47);
            this.addInt(n);
        }
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-32 - n);
        } else if (n <= 255) {
            this.addIcode(-38);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-39);
            this.addUint16(n);
        } else {
            this.addIcode(-40);
            this.addInt(n);
        }
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = this.itsExceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n6) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.itsExceptionTableTop = n6 + 6;
    }

    private byte[] increaseICodeCapacity(int n) {
        int n2 = this.itsICodeTop;
        int n3 = this.itsData.itsICode.length;
        if (n2 + n <= n3) {
            throw Kit.codeBug();
        }
        if (n2 + n > (n3 *= 2)) {
            n3 = n2 + n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.itsStackDepth += n;
        } else {
            int n2 = this.itsStackDepth + n;
            if (n2 > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n2;
            }
            this.itsStackDepth = n2;
        }
    }

    private int allocLocal() {
        int n = this.itsLocalTop++;
        if (this.itsLocalTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.itsLocalTop;
        }
        return n;
    }

    private void releaseLocal(int n) {
        --this.itsLocalTop;
        if (n != this.itsLocalTop) {
            Kit.codeBug();
        }
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 != nArray.length) {
            block7: {
                int n6;
                int n7;
                block8: {
                    n7 = nArray[n5 + 0];
                    n6 = nArray[n5 + 1];
                    if (n7 > n || n >= n6 || bl && nArray[n5 + 3] != 1) break block7;
                    if (n2 < 0) break block8;
                    if (n4 < n6) break block7;
                    if (n3 > n7) {
                        Kit.codeBug();
                    }
                    if (n4 == n6) {
                        Kit.codeBug();
                    }
                }
                n2 = n5;
                n3 = n7;
                n4 = n6;
            }
            n5 += 6;
        }
        return n2;
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case -63: 
            case -62: 
            case 50: 
            case 72: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 57: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -61: 
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n = byArray.length;
        int n2 = 0;
        while (n2 != n) {
            byte by = byArray[n2];
            int n3 = Interpreter.bytecodeSpan(by);
            if (by == -26) {
                if (n3 != 3) {
                    Kit.codeBug();
                }
                int n4 = Interpreter.getIndex(byArray, n2 + 1);
                uintMap.put(n4, 0);
            }
            n2 += n3;
        }
        return uintMap.getKeys();
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        int n;
        Object[] objectArray;
        Context context = Context.getCurrentContext();
        if (context == null || context.lastInterpreterFrame == null) {
            rhinoException.interpreterStackInfo = null;
            rhinoException.interpreterLineData = null;
            return;
        }
        if (context.previousInterpreterInvocations == null || context.previousInterpreterInvocations.size() == 0) {
            objectArray = new CallFrame[1];
        } else {
            n = context.previousInterpreterInvocations.size();
            if (context.previousInterpreterInvocations.peek() == context.lastInterpreterFrame) {
                --n;
            }
            objectArray = new CallFrame[n + 1];
            context.previousInterpreterInvocations.toArray(objectArray);
        }
        objectArray[objectArray.length - 1] = (CallFrame)context.lastInterpreterFrame;
        n = 0;
        int n2 = 0;
        while (n2 != objectArray.length) {
            n += 1 + ((CallFrame)objectArray[n2]).frameIndex;
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = n;
        int n4 = objectArray.length;
        while (n4 != 0) {
            Object object = objectArray[--n4];
            while (object != null) {
                nArray[--n3] = ((CallFrame)object).pcSourceLineStart;
                object = ((CallFrame)object).parentFrame;
            }
        }
        if (n3 != 0) {
            Kit.codeBug();
        }
        rhinoException.interpreterStackInfo = objectArray;
        rhinoException.interpreterLineData = nArray;
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.lastInterpreterFrame;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        String string2 = "org.mozilla.javascript.Interpreter.interpretLoop";
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1000);
        String string3 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            --n;
            int n4 = string.indexOf(string2, n3);
            if (n4 < 0) break;
            n4 += string2.length();
            while (n4 != string.length()) {
                char c = string.charAt(n4);
                if (c == '\n' || c == '\r') break;
                ++n4;
            }
            stringBuffer.append(string.substring(n3, n4));
            n3 = n4;
            CallFrame callFrame = callFrameArray[n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuffer.append(string3);
                stringBuffer.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(interpreterData.itsName);
                }
                stringBuffer.append('(');
                stringBuffer.append(interpreterData.itsSourceFile);
                int n5 = nArray[n2];
                if (n5 >= 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(Interpreter.getIndex(interpreterData.itsICode, n5));
                }
                stringBuffer.append(')');
                callFrame = callFrame.parentFrame;
            }
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        if (rhinoException.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        while (n != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            CallFrame callFrame = callFrameArray[--n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuilder.append("\tat ");
                stringBuilder.append(interpreterData.itsSourceFile);
                int n3 = nArray[n2];
                if (n3 >= 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(Interpreter.getIndex(interpreterData.itsICode, n3));
                }
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuilder.append(" (");
                    stringBuilder.append(interpreterData.itsName);
                    stringBuilder.append(')');
                }
                stringBuilder.append(string);
                callFrame = callFrame.parentFrame;
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object2 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object2;
            }
            finally {
                context.interpreterSecurityDomain = object;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        callFrame.isContinuationsTopFrame = context.isContinuationsTopCall;
        context.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(context, callFrame, null);
    }

    public static Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        CallFrame callFrame = (CallFrame)object;
        GeneratorState generatorState = new GeneratorState(n, object2);
        if (n == 2) {
            try {
                return Interpreter.interpretLoop(context, callFrame, generatorState);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException != object2) {
                    throw runtimeException;
                }
                return Undefined.instance;
            }
        }
        Object object3 = Interpreter.interpretLoop(context, callFrame, generatorState);
        if (generatorState.returnedException != null) {
            throw generatorState.returnedException;
        }
        return object3;
    }

    public static Object restartContinuation(NativeContinuation nativeContinuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(nativeContinuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)nativeContinuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(nativeContinuation, null);
        continuationJump.result = object;
        return Interpreter.interpretLoop(context, null, continuationJump);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object interpretLoop(Context var0, CallFrame var1_1, Object var2_2) {
        block286: {
            var3_3 = UniqueTag.DOUBLE_MARK;
            var4_4 = Undefined.instance;
            var5_5 = var0.instructionThreshold != 0;
            var6_6 = null;
            var7_7 = -1;
            if (var0.lastInterpreterFrame != null) {
                if (var0.previousInterpreterInvocations == null) {
                    var0.previousInterpreterInvocations = new ObjArray();
                }
                var0.previousInterpreterInvocations.push(var0.lastInterpreterFrame);
            }
            var8_8 = null;
            if (var2_2 != null) {
                if (var2_2 instanceof GeneratorState) {
                    var8_8 = (GeneratorState)var2_2;
                    Interpreter.enterFrame(var0, var1_1, ScriptRuntime.emptyArgs, true);
                    var2_2 = null;
                } else if (!(var2_2 instanceof ContinuationJump)) {
                    Kit.codeBug();
                }
            }
            var9_9 = null;
            var10_10 = 0.0;
            block155: while (true) {
                block287: {
                    block285: {
                        try {
                            block156: while (true) {
                                if (var2_2 != null) {
                                    var1_1 = Interpreter.processThrowable(var0, var2_2, var1_1, var7_7, var5_5);
                                    var2_2 = var1_1.throwable;
                                    var1_1.throwable = null;
                                } else if (var8_8 == null && var1_1.frozen) {
                                    Kit.codeBug();
                                }
                                var12_11 = var1_1.stack;
                                var13_14 /* !! */  = var1_1.sDbl;
                                var14_15 /* !! */  = var1_1.varSource.stack;
                                var15_19 = var1_1.varSource.sDbl;
                                var16_21 = var1_1.varSource.stackAttributes;
                                var17_22 = var1_1.idata.itsICode;
                                var18_23 = var1_1.idata.itsStringTable;
                                var19_24 = var1_1.savedStackTop;
                                var0.lastInterpreterFrame = var1_1;
                                block157: while (true) {
                                    var20_25 = var17_22[var1_1.pc++];
                                    switch (var20_25) {
                                        case -62: {
                                            if (!var1_1.frozen) {
                                                --var1_1.pc;
                                                var21_26 = Interpreter.captureFrameForGenerator(var1_1);
                                                var21_26.frozen = true;
                                                var22_85 = new NativeGenerator(var1_1.scope, var21_26.fnOrScript, var21_26);
                                                var1_1.result = var22_85;
                                                break block157;
                                            }
                                        }
                                        case 72: {
                                            if (!var1_1.frozen) {
                                                return Interpreter.freezeGenerator(var0, var1_1, var19_24, var8_8);
                                            }
                                            var21_27 = Interpreter.thawGenerator(var1_1, var19_24, var8_8, var20_25);
                                            if (var21_27 == Scriptable.NOT_FOUND) continue block157;
                                            var2_2 = var21_27;
                                            break block285;
                                        }
                                        case -63: {
                                            var1_1.frozen = true;
                                            var21_28 = Interpreter.getIndex(var17_22, var1_1.pc);
                                            var8_8.returnedException = new JavaScriptException(NativeIterator.getStopIterationObject(var1_1.scope), var1_1.idata.itsSourceFile, var21_28);
                                            break block157;
                                        }
                                        case 50: {
                                            var21_29 = var12_11[var19_24];
                                            if (var21_29 == var3_3) {
                                                var21_29 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            --var19_24;
                                            var22_86 = Interpreter.getIndex(var17_22, var1_1.pc);
                                            var2_2 = new JavaScriptException(var21_29, var1_1.idata.itsSourceFile, var22_86);
                                            break block285;
                                        }
                                        case 51: {
                                            var2_2 = var12_11[var7_7 += var1_1.localShift];
                                            break block285;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            var21_30 = var12_11[--var19_24 + 1];
                                            var22_87 = var12_11[var19_24];
                                            if (var21_30 != var3_3) ** GOTO lbl83
                                            var24_134 = var13_14 /* !! */ [var19_24 + 1];
                                            var26_149 = Interpreter.stack_double(var1_1, var19_24);
                                            ** GOTO lbl86
lbl83:
                                            // 1 sources

                                            if (var22_87 != var3_3) ** GOTO lbl101
                                            var24_134 = ScriptRuntime.toNumber(var21_30);
                                            var26_149 = var13_14 /* !! */ [var19_24];
lbl86:
                                            // 2 sources

                                            switch (var20_25) {
                                                case 17: {
                                                    var23_117 = var26_149 >= var24_134;
                                                    ** GOTO lbl116
                                                }
                                                case 15: {
                                                    var23_117 = var26_149 <= var24_134;
                                                    ** GOTO lbl116
                                                }
                                                case 16: {
                                                    var23_117 = var26_149 > var24_134;
                                                    ** GOTO lbl116
                                                }
                                                case 14: {
                                                    var23_117 = var26_149 < var24_134;
                                                    ** GOTO lbl116
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl101:
                                            // 1 sources

                                            switch (var20_25) {
                                                case 17: {
                                                    var23_117 = ScriptRuntime.cmp_LE(var21_30, var22_87);
                                                    break;
                                                }
                                                case 15: {
                                                    var23_117 = ScriptRuntime.cmp_LE(var22_87, var21_30);
                                                    break;
                                                }
                                                case 16: {
                                                    var23_117 = ScriptRuntime.cmp_LT(var21_30, var22_87);
                                                    break;
                                                }
                                                case 14: {
                                                    var23_117 = ScriptRuntime.cmp_LT(var22_87, var21_30);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl116:
                                            // 8 sources

                                            var12_11[var19_24] = ScriptRuntime.wrapBoolean(var23_117);
                                            continue block157;
                                        }
                                        case 52: 
                                        case 53: {
                                            var21_31 = var12_11[var19_24];
                                            if (var21_31 == var3_3) {
                                                var21_31 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_88 = var12_11[--var19_24]) == var3_3) {
                                                var22_88 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var23_118 = var20_25 == 52 ? ScriptRuntime.in(var22_88, var21_31, var0) : ScriptRuntime.instanceOf(var22_88, var21_31, var0);
                                            var12_11[var19_24] = ScriptRuntime.wrapBoolean(var23_118);
                                            continue block157;
                                        }
                                        case 12: 
                                        case 13: {
                                            var22_89 = var12_11[--var19_24 + 1];
                                            var23_119 = var12_11[var19_24];
                                            var21_32 = var22_89 == var3_3 ? (var23_119 == var3_3 ? var13_14 /* !! */ [var19_24] == var13_14 /* !! */ [var19_24 + 1] : ScriptRuntime.eqNumber(var13_14 /* !! */ [var19_24 + 1], var23_119)) : (var23_119 == var3_3 ? ScriptRuntime.eqNumber(var13_14 /* !! */ [var19_24], var22_89) : ScriptRuntime.eq(var23_119, var22_89));
                                            var12_11[var19_24] = ScriptRuntime.wrapBoolean(var21_32 ^= var20_25 == 13);
                                            continue block157;
                                        }
                                        case 46: 
                                        case 47: {
                                            var21_33 = Interpreter.shallowEquals(var12_11, var13_14 /* !! */ , --var19_24);
                                            var12_11[var19_24] = ScriptRuntime.wrapBoolean(var21_33 ^= var20_25 == 47);
                                            continue block157;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(var1_1, var19_24--)) break;
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(var1_1, var19_24--)) break;
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(var1_1, var19_24--)) {
                                                var1_1.pc += 2;
                                                continue block157;
                                            }
                                            var12_11[var19_24--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = var1_1.pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (var19_24 == var1_1.emptyStackTop + 1) {
                                                var12_11[var7_7 += var1_1.localShift] = var12_11[var19_24];
                                                var13_14 /* !! */ [var7_7] = var13_14 /* !! */ [var19_24];
                                                --var19_24;
                                                continue block157;
                                            }
                                            if (var19_24 == var1_1.emptyStackTop) continue block157;
                                            Kit.codeBug();
                                            continue block157;
                                        }
                                        case -25: {
                                            if (var5_5) {
                                                Interpreter.addInstructionCount(var0, var1_1, 0);
                                            }
                                            if ((var21_34 = var12_11[var7_7 += var1_1.localShift]) != var3_3) {
                                                var2_2 = var21_34;
                                                break block285;
                                            }
                                            var1_1.pc = (int)var13_14 /* !! */ [var7_7];
                                            if (!var5_5) continue block157;
                                            var1_1.pcPrevBranch = var1_1.pc;
                                            continue block157;
                                        }
                                        case -4: {
                                            var12_11[var19_24] = null;
                                            --var19_24;
                                            continue block157;
                                        }
                                        case -5: {
                                            var1_1.result = var12_11[var19_24];
                                            var1_1.resultDbl = var13_14 /* !! */ [var19_24];
                                            var12_11[var19_24] = null;
                                            --var19_24;
                                            continue block157;
                                        }
                                        case -1: {
                                            var12_11[var19_24 + 1] = var12_11[var19_24];
                                            var13_14 /* !! */ [var19_24 + 1] = var13_14 /* !! */ [var19_24];
                                            ++var19_24;
                                            continue block157;
                                        }
                                        case -2: {
                                            var12_11[var19_24 + 1] = var12_11[var19_24 - 1];
                                            var13_14 /* !! */ [var19_24 + 1] = var13_14 /* !! */ [var19_24 - 1];
                                            var12_11[var19_24 + 2] = var12_11[var19_24];
                                            var13_14 /* !! */ [var19_24 + 2] = var13_14 /* !! */ [var19_24];
                                            var19_24 += 2;
                                            continue block157;
                                        }
                                        case -3: {
                                            var21_35 = var12_11[var19_24];
                                            var12_11[var19_24] = var12_11[var19_24 - 1];
                                            var12_11[var19_24 - 1] = var21_35;
                                            var22_90 = var13_14 /* !! */ [var19_24];
                                            var13_14 /* !! */ [var19_24] = var13_14 /* !! */ [var19_24 - 1];
                                            var13_14 /* !! */ [var19_24 - 1] = var22_90;
                                            continue block157;
                                        }
                                        case 4: {
                                            var1_1.result = var12_11[var19_24];
                                            var1_1.resultDbl = var13_14 /* !! */ [var19_24];
                                            --var19_24;
                                            break block157;
                                        }
                                        case 64: {
                                            break block157;
                                        }
                                        case -22: {
                                            var1_1.result = var4_4;
                                            break block157;
                                        }
                                        case 27: {
                                            var21_36 = Interpreter.stack_int32(var1_1, var19_24);
                                            var12_11[var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = ~var21_36;
                                            continue block157;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            var21_37 = Interpreter.stack_int32(var1_1, var19_24 - 1);
                                            var22_91 = Interpreter.stack_int32(var1_1, var19_24);
                                            var12_11[--var19_24] = var3_3;
                                            switch (var20_25) {
                                                case 11: {
                                                    var21_37 &= var22_91;
                                                    break;
                                                }
                                                case 9: {
                                                    var21_37 |= var22_91;
                                                    break;
                                                }
                                                case 10: {
                                                    var21_37 ^= var22_91;
                                                    break;
                                                }
                                                case 18: {
                                                    var21_37 <<= var22_91;
                                                    break;
                                                }
                                                case 19: {
                                                    var21_37 >>= var22_91;
                                                }
                                            }
                                            var13_14 /* !! */ [var19_24] = var21_37;
                                            continue block157;
                                        }
                                        case 20: {
                                            var21_38 = Interpreter.stack_double(var1_1, var19_24 - 1);
                                            var23_120 = Interpreter.stack_int32(var1_1, var19_24) & 31;
                                            var12_11[--var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = ScriptRuntime.toUint32(var21_38) >>> var23_120;
                                            continue block157;
                                        }
                                        case 28: 
                                        case 29: {
                                            var21_39 = Interpreter.stack_double(var1_1, var19_24);
                                            var12_11[var19_24] = var3_3;
                                            if (var20_25 == 29) {
                                                var21_39 = -var21_39;
                                            }
                                            var13_14 /* !! */ [var19_24] = var21_39;
                                            continue block157;
                                        }
                                        case 21: {
                                            Interpreter.do_add(var12_11, var13_14 /* !! */ , --var19_24, var0);
                                            continue block157;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            var21_40 = Interpreter.stack_double(var1_1, var19_24);
                                            var23_121 = Interpreter.stack_double(var1_1, --var19_24);
                                            var12_11[var19_24] = var3_3;
                                            switch (var20_25) {
                                                case 22: {
                                                    var23_121 -= var21_40;
                                                    break;
                                                }
                                                case 23: {
                                                    var23_121 *= var21_40;
                                                    break;
                                                }
                                                case 24: {
                                                    var23_121 /= var21_40;
                                                    break;
                                                }
                                                case 25: {
                                                    var23_121 %= var21_40;
                                                }
                                            }
                                            var13_14 /* !! */ [var19_24] = var23_121;
                                            continue block157;
                                        }
                                        case 26: {
                                            var12_11[var19_24] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(var1_1, var19_24) == false);
                                            continue block157;
                                        }
                                        case 49: {
                                            var12_11[++var19_24] = ScriptRuntime.bind(var0, var1_1.scope, var6_6);
                                            continue block157;
                                        }
                                        case 8: {
                                            var21_41 = var12_11[var19_24];
                                            if (var21_41 == var3_3) {
                                                var21_41 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var22_92 = (Scriptable)var12_11[--var19_24];
                                            var12_11[var19_24] = ScriptRuntime.setName(var22_92, var21_41, var0, var1_1.scope, var6_6);
                                            continue block157;
                                        }
                                        case -59: {
                                            var21_42 = var12_11[var19_24];
                                            if (var21_42 == var3_3) {
                                                var21_42 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var22_93 = (Scriptable)var12_11[--var19_24];
                                            var12_11[var19_24] = ScriptRuntime.setConst(var22_93, var21_42, var0, var6_6);
                                            continue block157;
                                        }
                                        case 31: {
                                            var21_43 = var12_11[var19_24];
                                            if (var21_43 == var3_3) {
                                                var21_43 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_94 = var12_11[--var19_24]) == var3_3) {
                                                var22_94 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.delete(var22_94, var21_43, var0);
                                            continue block157;
                                        }
                                        case 34: {
                                            var21_44 = var12_11[var19_24];
                                            if (var21_44 == var3_3) {
                                                var21_44 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.getObjectPropNoWarn(var21_44, var6_6, var0);
                                            continue block157;
                                        }
                                        case 33: {
                                            var21_45 = var12_11[var19_24];
                                            if (var21_45 == var3_3) {
                                                var21_45 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.getObjectProp(var21_45, var6_6, var0, var1_1.scope);
                                            continue block157;
                                        }
                                        case 35: {
                                            var21_46 = var12_11[var19_24];
                                            if (var21_46 == var3_3) {
                                                var21_46 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_95 = var12_11[--var19_24]) == var3_3) {
                                                var22_95 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.setObjectProp(var22_95, var6_6, var21_46, var0);
                                            continue block157;
                                        }
                                        case -9: {
                                            var21_47 = var12_11[var19_24];
                                            if (var21_47 == var3_3) {
                                                var21_47 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.propIncrDecr(var21_47, var6_6, var0, var17_22[var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 36: {
                                            var21_48 = var12_11[--var19_24];
                                            if (var21_48 == var3_3) {
                                                var21_48 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var23_122 = var12_11[var19_24 + 1]) != var3_3) {
                                                var22_96 = ScriptRuntime.getObjectElem(var21_48, var23_122, var0, var1_1.scope);
                                            } else {
                                                var24_135 = var13_14 /* !! */ [var19_24 + 1];
                                                var22_96 = ScriptRuntime.getObjectIndex(var21_48, var24_135, var0);
                                            }
                                            var12_11[var19_24] = var22_96;
                                            continue block157;
                                        }
                                        case 37: {
                                            var21_49 = var12_11[(var19_24 -= 2) + 2];
                                            if (var21_49 == var3_3) {
                                                var21_49 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24 + 2]);
                                            }
                                            if ((var22_97 = var12_11[var19_24]) == var3_3) {
                                                var22_97 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var24_136 = var12_11[var19_24 + 1]) != var3_3) {
                                                var23_123 = ScriptRuntime.setObjectElem(var22_97, var24_136, var21_49, var0);
                                            } else {
                                                var25_144 = var13_14 /* !! */ [var19_24 + 1];
                                                var23_123 = ScriptRuntime.setObjectIndex(var22_97, var25_144, var21_49, var0);
                                            }
                                            var12_11[var19_24] = var23_123;
                                            continue block157;
                                        }
                                        case -10: {
                                            var21_50 = var12_11[var19_24];
                                            if (var21_50 == var3_3) {
                                                var21_50 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_98 = var12_11[--var19_24]) == var3_3) {
                                                var22_98 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.elemIncrDecr(var22_98, var21_50, var0, var17_22[var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 67: {
                                            var21_51 = (Ref)var12_11[var19_24];
                                            var12_11[var19_24] = ScriptRuntime.refGet(var21_51, var0);
                                            continue block157;
                                        }
                                        case 68: {
                                            var21_52 = var12_11[var19_24];
                                            if (var21_52 == var3_3) {
                                                var21_52 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var22_99 = (Ref)var12_11[--var19_24];
                                            var12_11[var19_24] = ScriptRuntime.refSet(var22_99, var21_52, var0);
                                            continue block157;
                                        }
                                        case 69: {
                                            var21_53 = (Ref)var12_11[var19_24];
                                            var12_11[var19_24] = ScriptRuntime.refDel(var21_53, var0);
                                            continue block157;
                                        }
                                        case -11: {
                                            var21_54 = (Ref)var12_11[var19_24];
                                            var12_11[var19_24] = ScriptRuntime.refIncrDecr(var21_54, var0, var17_22[var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 54: {
                                            var12_11[++var19_24] = var12_11[var7_7 += var1_1.localShift];
                                            var13_14 /* !! */ [var19_24] = var13_14 /* !! */ [var7_7];
                                            continue block157;
                                        }
                                        case -56: {
                                            var12_11[var7_7 += var1_1.localShift] = null;
                                            continue block157;
                                        }
                                        case -15: {
                                            var12_11[++var19_24] = ScriptRuntime.getNameFunctionAndThis(var6_6, var0, var1_1.scope);
                                            var12_11[++var19_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -16: {
                                            var21_55 = var12_11[var19_24];
                                            if (var21_55 == var3_3) {
                                                var21_55 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.getPropFunctionAndThis(var21_55, var6_6, var0, var1_1.scope);
                                            var12_11[++var19_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -17: {
                                            var21_56 = var12_11[var19_24 - 1];
                                            if (var21_56 == var3_3) {
                                                var21_56 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24 - 1]);
                                            }
                                            if ((var22_100 = var12_11[var19_24]) == var3_3) {
                                                var22_100 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24 - 1] = ScriptRuntime.getElemFunctionAndThis(var21_56, var22_100, var0);
                                            var12_11[var19_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -18: {
                                            var21_57 = var12_11[var19_24];
                                            if (var21_57 == var3_3) {
                                                var21_57 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.getValueFunctionAndThis(var21_57, var0);
                                            var12_11[++var19_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -21: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var21_58 = var17_22[var1_1.pc] & 255;
                                            var22_101 = var17_22[var1_1.pc + 1] != 0;
                                            var23_124 = Interpreter.getIndex(var17_22, var1_1.pc + 2);
                                            if (var22_101) {
                                                var24_137 = var12_11[var19_24 -= var7_7];
                                                if (var24_137 == var3_3) {
                                                    var24_137 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                                }
                                                var25_145 = Interpreter.getArgsArray(var12_11, var13_14 /* !! */ , var19_24 + 1, var7_7);
                                                var12_11[var19_24] = ScriptRuntime.newSpecial(var0, var24_137, var25_145, var1_1.scope, var21_58);
                                            } else {
                                                var24_137 = (Scriptable)var12_11[(var19_24 -= 1 + var7_7) + 1];
                                                var25_145 = (Object[])var12_11[var19_24];
                                                var26_150 = Interpreter.getArgsArray(var12_11, var13_14 /* !! */ , var19_24 + 2, var7_7);
                                                var12_11[var19_24] = ScriptRuntime.callSpecial(var0, (Callable)var25_145, (Scriptable)var24_137, var26_150, var1_1.scope, var1_1.thisObj, var21_58, var1_1.idata.itsSourceFile, var23_124);
                                            }
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case -55: 
                                        case 38: 
                                        case 70: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var21_59 = (Callable)var12_11[var19_24 -= 1 + var7_7];
                                            var22_102 = (Scriptable)var12_11[var19_24 + 1];
                                            if (var20_25 == 70) {
                                                var23_125 = Interpreter.getArgsArray(var12_11, var13_14 /* !! */ , var19_24 + 2, var7_7);
                                                var12_11[var19_24] = ScriptRuntime.callRef(var21_59, var22_102, var23_125, var0);
                                                continue block157;
                                            }
                                            var23_126 = var1_1.scope;
                                            if (var1_1.useActivation) {
                                                var23_126 = ScriptableObject.getTopLevelScope(var1_1.scope);
                                            }
                                            if (var21_59 instanceof InterpretedFunction) {
                                                var24_138 = (InterpretedFunction)var21_59;
                                                if (var1_1.fnOrScript.securityDomain == var24_138.securityDomain) {
                                                    var25_146 = var1_1;
                                                    var26_151 = new CallFrame();
                                                    if (var20_25 == -55) {
                                                        var25_146 = var1_1.parentFrame;
                                                        Interpreter.exitFrame(var0, var1_1, null);
                                                    }
                                                    Interpreter.initFrame(var0, var23_126, var22_102, var12_11, var13_14 /* !! */ , var19_24 + 2, var7_7, var24_138, var25_146, var26_151);
                                                    if (var20_25 != -55) {
                                                        var1_1.savedStackTop = var19_24;
                                                        var1_1.savedCallOp = var20_25;
                                                    }
                                                    var1_1 = var26_151;
                                                    continue block156;
                                                }
                                            }
                                            if (var21_59 instanceof NativeContinuation) {
                                                var24_139 = new ContinuationJump((NativeContinuation)var21_59, var1_1);
                                                if (var7_7 == 0) {
                                                    var24_139.result = var4_4;
                                                } else {
                                                    var24_139.result = var12_11[var19_24 + 2];
                                                    var24_139.resultDbl = var13_14 /* !! */ [var19_24 + 2];
                                                }
                                                var2_2 = var24_139;
                                                break block285;
                                            }
                                            if (var21_59 instanceof IdFunctionObject) {
                                                var24_140 = (IdFunctionObject)var21_59;
                                                if (NativeContinuation.isContinuationConstructor(var24_140)) {
                                                    var1_1.stack[var19_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                    continue block157;
                                                }
                                                if (BaseFunction.isApplyOrCall(var24_140) && (var25_147 = ScriptRuntime.getCallable(var22_102)) instanceof InterpretedFunction) {
                                                    var26_152 = (InterpretedFunction)var25_147;
                                                    if (var1_1.fnOrScript.securityDomain == var26_152.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForApplyOrCall(var0, var1_1, var7_7, var12_11, var13_14 /* !! */ , var19_24, var20_25, var23_126, var24_140, var26_152);
                                                        continue block156;
                                                    }
                                                }
                                            }
                                            if (var21_59 instanceof ScriptRuntime.NoSuchMethodShim) {
                                                var24_141 = (ScriptRuntime.NoSuchMethodShim)var21_59;
                                                var25_148 = var24_141.noSuchMethodMethod;
                                                if (var25_148 instanceof InterpretedFunction) {
                                                    var26_153 = (InterpretedFunction)var25_148;
                                                    if (var1_1.fnOrScript.securityDomain == var26_153.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForNoSuchMethod(var0, var1_1, var7_7, var12_11, var13_14 /* !! */ , var19_24, var20_25, var22_102, var23_126, var24_141, var26_153);
                                                        continue block156;
                                                    }
                                                }
                                            }
                                            var0.lastInterpreterFrame = var1_1;
                                            var1_1.savedCallOp = var20_25;
                                            var1_1.savedStackTop = var19_24;
                                            var12_11[var19_24] = var21_59.call(var0, var23_126, var22_102, Interpreter.getArgsArray(var12_11, var13_14 /* !! */ , var19_24 + 2, var7_7));
                                            var0.lastInterpreterFrame = null;
                                            continue block157;
                                        }
                                        case 30: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            if ((var21_60 = var12_11[var19_24 -= var7_7]) instanceof InterpretedFunction) {
                                                var22_103 = (InterpretedFunction)var21_60;
                                                if (var1_1.fnOrScript.securityDomain == var22_103.securityDomain) {
                                                    var23_127 = var22_103.createObject(var0, var1_1.scope);
                                                    var24_142 = new CallFrame();
                                                    Interpreter.initFrame(var0, var1_1.scope, var23_127, var12_11, var13_14 /* !! */ , var19_24 + 1, var7_7, var22_103, var1_1, var24_142);
                                                    var12_11[var19_24] = var23_127;
                                                    var1_1.savedStackTop = var19_24;
                                                    var1_1.savedCallOp = var20_25;
                                                    var1_1 = var24_142;
                                                    continue block156;
                                                }
                                            }
                                            if (!(var21_60 instanceof Function)) {
                                                if (var21_60 == var3_3) {
                                                    var21_60 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                                }
                                                throw ScriptRuntime.notFunctionError(var21_60);
                                            }
                                            var22_104 = (Function)var21_60;
                                            if (var22_104 instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor(var23_128 = (IdFunctionObject)var22_104)) {
                                                var1_1.stack[var19_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                continue block157;
                                            }
                                            var23_129 = Interpreter.getArgsArray(var12_11, var13_14 /* !! */ , var19_24 + 1, var7_7);
                                            var12_11[var19_24] = var22_104.construct(var0, var1_1.scope, var23_129);
                                            continue block157;
                                        }
                                        case 32: {
                                            var21_61 = var12_11[var19_24];
                                            if (var21_61 == var3_3) {
                                                var21_61 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.typeof(var21_61);
                                            continue block157;
                                        }
                                        case -14: {
                                            var12_11[++var19_24] = ScriptRuntime.typeofName(var1_1.scope, var6_6);
                                            continue block157;
                                        }
                                        case 41: {
                                            var12_11[++var19_24] = var6_6;
                                            continue block157;
                                        }
                                        case -27: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = Interpreter.getShort(var17_22, var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -28: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = Interpreter.getInt(var17_22, var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case 40: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = var1_1.idata.itsDoubleTable[var7_7];
                                            continue block157;
                                        }
                                        case 39: {
                                            var12_11[++var19_24] = ScriptRuntime.name(var0, var1_1.scope, var6_6);
                                            continue block157;
                                        }
                                        case -8: {
                                            var12_11[++var19_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, var6_6, var0, var17_22[var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -61: {
                                            var7_7 = var17_22[var1_1.pc++];
                                        }
                                        case 155: {
                                            if (!var1_1.useActivation) {
                                                if ((var16_21[var7_7] & 1) == 0) {
                                                    throw Context.reportRuntimeError1("msg.var.redecl", var1_1.idata.argNames[var7_7]);
                                                }
                                                if ((var16_21[var7_7] & 8) == 0) continue block157;
                                                var14_15 /* !! */ [var7_7] = var12_11[var19_24];
                                                v0 = var7_7;
                                                var16_21[v0] = var16_21[v0] & -9;
                                                var15_19[var7_7] = var13_14 /* !! */ [var19_24];
                                                continue block157;
                                            }
                                            var21_62 = var12_11[var19_24];
                                            if (var21_62 == var3_3) {
                                                var21_62 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var6_6 = var1_1.idata.argNames[var7_7];
                                            if (var1_1.scope instanceof ConstProperties) {
                                                var22_105 = (ConstProperties)var1_1.scope;
                                                var22_105.putConst(var6_6, var1_1.scope, var21_62);
                                                continue block157;
                                            }
                                            throw Kit.codeBug();
                                        }
                                        case -49: {
                                            var7_7 = var17_22[var1_1.pc++];
                                        }
                                        case 56: {
                                            if (!var1_1.useActivation) {
                                                if ((var16_21[var7_7] & 1) != 0) continue block157;
                                                var14_15 /* !! */ [var7_7] = var12_11[var19_24];
                                                var15_19[var7_7] = var13_14 /* !! */ [var19_24];
                                                continue block157;
                                            }
                                            var21_63 = var12_11[var19_24];
                                            if (var21_63 == var3_3) {
                                                var21_63 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var6_6 = var1_1.idata.argNames[var7_7];
                                            var1_1.scope.put(var6_6, var1_1.scope, var21_63);
                                            continue block157;
                                        }
                                        case -48: {
                                            var7_7 = var17_22[var1_1.pc++];
                                        }
                                        case 55: {
                                            ++var19_24;
                                            if (!var1_1.useActivation) {
                                                var12_11[var19_24] = var14_15 /* !! */ [var7_7];
                                                var13_14 /* !! */ [var19_24] = var15_19[var7_7];
                                                continue block157;
                                            }
                                            var6_6 = var1_1.idata.argNames[var7_7];
                                            var12_11[var19_24] = var1_1.scope.get(var6_6, var1_1.scope);
                                            continue block157;
                                        }
                                        case -7: {
                                            ++var19_24;
                                            var21_64 = var17_22[var1_1.pc];
                                            if (!var1_1.useActivation) {
                                                var12_11[var19_24] = var3_3;
                                                var22_106 = var14_15 /* !! */ [var7_7];
                                                if (var22_106 == var3_3) {
                                                    var23_130 = var15_19[var7_7];
                                                } else {
                                                    var23_130 = ScriptRuntime.toNumber(var22_106);
                                                    var14_15 /* !! */ [var7_7] = var3_3;
                                                }
                                                var15_19[var7_7] = var25_144 = (var21_64 & 1) == 0 ? var23_130 + 1.0 : var23_130 - 1.0;
                                                var13_14 /* !! */ [var19_24] = (var21_64 & 2) == 0 ? var25_144 : var23_130;
                                            } else {
                                                var22_106 = var1_1.idata.argNames[var7_7];
                                                var12_11[var19_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, (String)var22_106, var0, var21_64);
                                            }
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -51: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = 0.0;
                                            continue block157;
                                        }
                                        case -52: {
                                            var12_11[++var19_24] = var3_3;
                                            var13_14 /* !! */ [var19_24] = 1.0;
                                            continue block157;
                                        }
                                        case 42: {
                                            var12_11[++var19_24] = null;
                                            continue block157;
                                        }
                                        case 43: {
                                            var12_11[++var19_24] = var1_1.thisObj;
                                            continue block157;
                                        }
                                        case 63: {
                                            var12_11[++var19_24] = var1_1.fnOrScript;
                                            continue block157;
                                        }
                                        case 44: {
                                            var12_11[++var19_24] = Boolean.FALSE;
                                            continue block157;
                                        }
                                        case 45: {
                                            var12_11[++var19_24] = Boolean.TRUE;
                                            continue block157;
                                        }
                                        case -50: {
                                            var12_11[++var19_24] = var4_4;
                                            continue block157;
                                        }
                                        case 2: {
                                            var21_65 = var12_11[var19_24];
                                            if (var21_65 == var3_3) {
                                                var21_65 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            --var19_24;
                                            var1_1.scope = ScriptRuntime.enterWith(var21_65, var0, var1_1.scope);
                                            continue block157;
                                        }
                                        case 3: {
                                            var1_1.scope = ScriptRuntime.leaveWith(var1_1.scope);
                                            continue block157;
                                        }
                                        case 57: {
                                            var21_66 = var1_1.idata.itsICode[var1_1.pc] != 0;
                                            var22_107 = (Throwable)var12_11[--var19_24 + 1];
                                            var23_131 = var21_66 == false ? null : (Scriptable)var12_11[var7_7 += var1_1.localShift];
                                            var12_11[var7_7] = ScriptRuntime.newCatchScope(var22_107, var23_131, var6_6, var0, var1_1.scope);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 58: 
                                        case 59: 
                                        case 60: {
                                            var21_67 = var12_11[var19_24];
                                            if (var21_67 == var3_3) {
                                                var21_67 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            --var19_24;
                                            var22_108 = var20_25 == 58 ? 0 : (var20_25 == 59 ? 1 : 2);
                                            var12_11[var7_7 += var1_1.localShift] = ScriptRuntime.enumInit(var21_67, var0, var22_108);
                                            continue block157;
                                        }
                                        case 61: 
                                        case 62: {
                                            var21_68 = var12_11[var7_7 += var1_1.localShift];
                                            var12_11[++var19_24] = var20_25 == 61 ? ScriptRuntime.enumNext(var21_68) : ScriptRuntime.enumId(var21_68, var0);
                                            continue block157;
                                        }
                                        case 71: {
                                            var21_69 = var12_11[var19_24];
                                            if (var21_69 == var3_3) {
                                                var21_69 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.specialRef(var21_69, var6_6, var0);
                                            continue block157;
                                        }
                                        case 76: {
                                            var21_70 = var12_11[var19_24];
                                            if (var21_70 == var3_3) {
                                                var21_70 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_109 = var12_11[--var19_24]) == var3_3) {
                                                var22_109 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.memberRef(var22_109, var21_70, var0, var7_7);
                                            continue block157;
                                        }
                                        case 77: {
                                            var21_71 = var12_11[var19_24];
                                            if (var21_71 == var3_3) {
                                                var21_71 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_110 = var12_11[--var19_24]) == var3_3) {
                                                var22_110 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var23_132 = var12_11[--var19_24]) == var3_3) {
                                                var23_132 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.memberRef(var23_132, var22_110, var21_71, var0, var7_7);
                                            continue block157;
                                        }
                                        case 78: {
                                            var21_72 = var12_11[var19_24];
                                            if (var21_72 == var3_3) {
                                                var21_72 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.nameRef(var21_72, var0, var1_1.scope, var7_7);
                                            continue block157;
                                        }
                                        case 79: {
                                            var21_73 = var12_11[var19_24];
                                            if (var21_73 == var3_3) {
                                                var21_73 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            if ((var22_111 = var12_11[--var19_24]) == var3_3) {
                                                var22_111 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.nameRef(var22_111, var21_73, var0, var1_1.scope, var7_7);
                                            continue block157;
                                        }
                                        case -12: {
                                            var1_1.scope = (Scriptable)var12_11[var7_7 += var1_1.localShift];
                                            continue block157;
                                        }
                                        case -13: {
                                            var12_11[var7_7 += var1_1.localShift] = var1_1.scope;
                                            continue block157;
                                        }
                                        case -19: {
                                            var12_11[++var19_24] = InterpretedFunction.createFunction(var0, var1_1.scope, var1_1.fnOrScript, var7_7);
                                            continue block157;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(var0, var1_1.scope, var1_1.fnOrScript, var7_7);
                                            continue block157;
                                        }
                                        case 48: {
                                            var12_11[++var19_24] = var1_1.scriptRegExps[var7_7];
                                            continue block157;
                                        }
                                        case -29: {
                                            var12_11[++var19_24] = new int[var7_7];
                                            var12_11[++var19_24] = new Object[var7_7];
                                            var13_14 /* !! */ [var19_24] = 0.0;
                                            continue block157;
                                        }
                                        case -30: {
                                            var21_74 = var12_11[var19_24];
                                            if (var21_74 == var3_3) {
                                                var21_74 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var22_112 = (int)var13_14 /* !! */ [--var19_24];
                                            ((Object[])var12_11[var19_24])[var22_112] = var21_74;
                                            var13_14 /* !! */ [var19_24] = var22_112 + 1;
                                            continue block157;
                                        }
                                        case -57: {
                                            var21_75 = var12_11[var19_24];
                                            var22_113 = (int)var13_14 /* !! */ [--var19_24];
                                            ((Object[])var12_11[var19_24])[var22_113] = var21_75;
                                            ((int[])var12_11[var19_24 - 1])[var22_113] = -1;
                                            var13_14 /* !! */ [var19_24] = var22_113 + 1;
                                            continue block157;
                                        }
                                        case -58: {
                                            var21_76 = var12_11[var19_24];
                                            var22_114 = (int)var13_14 /* !! */ [--var19_24];
                                            ((Object[])var12_11[var19_24])[var22_114] = var21_76;
                                            ((int[])var12_11[var19_24 - 1])[var22_114] = 1;
                                            var13_14 /* !! */ [var19_24] = var22_114 + 1;
                                            continue block157;
                                        }
                                        case -31: 
                                        case 65: 
                                        case 66: {
                                            var21_77 = (Object[])var12_11[var19_24];
                                            var22_115 = (int[])var12_11[--var19_24];
                                            if (var20_25 == 66) {
                                                var24_143 /* !! */  = (Object[])var1_1.idata.literalIds[var7_7];
                                                var23_133 = ScriptRuntime.newObjectLiteral(var24_143 /* !! */ , var21_77, var22_115, var0, var1_1.scope);
                                            } else {
                                                var24_143 /* !! */  = null;
                                                if (var20_25 == -31) {
                                                    var24_143 /* !! */  = (int[])var1_1.idata.literalIds[var7_7];
                                                }
                                                var23_133 = ScriptRuntime.newArrayLiteral(var21_77, (int[])var24_143 /* !! */ , var0, var1_1.scope);
                                            }
                                            var12_11[var19_24] = var23_133;
                                            continue block157;
                                        }
                                        case -53: {
                                            var21_78 = var12_11[var19_24];
                                            if (var21_78 == var3_3) {
                                                var21_78 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            --var19_24;
                                            var1_1.scope = ScriptRuntime.enterDotQuery(var21_78, var1_1.scope);
                                            continue block157;
                                        }
                                        case -54: {
                                            var21_79 = Interpreter.stack_boolean(var1_1, var19_24);
                                            var22_116 = ScriptRuntime.updateDotQuery(var21_79, var1_1.scope);
                                            if (var22_116 != null) {
                                                var12_11[var19_24] = var22_116;
                                                var1_1.scope = ScriptRuntime.leaveDotQuery(var1_1.scope);
                                                var1_1.pc += 2;
                                                continue block157;
                                            }
                                            --var19_24;
                                            break;
                                        }
                                        case 73: {
                                            var21_80 = var12_11[var19_24];
                                            if (var21_80 == var3_3) {
                                                var21_80 = ScriptRuntime.wrapNumber(var13_14 /* !! */ [var19_24]);
                                            }
                                            var12_11[var19_24] = ScriptRuntime.setDefaultNamespace(var21_80, var0);
                                            continue block157;
                                        }
                                        case 74: {
                                            var21_81 = var12_11[var19_24];
                                            if (var21_81 == var3_3) continue block157;
                                            var12_11[var19_24] = ScriptRuntime.escapeAttributeValue(var21_81, var0);
                                            continue block157;
                                        }
                                        case 75: {
                                            var21_82 = var12_11[var19_24];
                                            if (var21_82 == var3_3) continue block157;
                                            var12_11[var19_24] = ScriptRuntime.escapeTextValue(var21_82, var0);
                                            continue block157;
                                        }
                                        case -64: {
                                            if (var1_1.debuggerFrame == null) continue block157;
                                            var1_1.debuggerFrame.onDebuggerStatement(var0);
                                            continue block157;
                                        }
                                        case -26: {
                                            var1_1.pcSourceLineStart = var1_1.pc;
                                            if (var1_1.debuggerFrame != null) {
                                                var21_83 = Interpreter.getIndex(var17_22, var1_1.pc);
                                                var1_1.debuggerFrame.onLineChange(var0, var21_83);
                                            }
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -32: {
                                            var7_7 = 0;
                                            continue block157;
                                        }
                                        case -33: {
                                            var7_7 = 1;
                                            continue block157;
                                        }
                                        case -34: {
                                            var7_7 = 2;
                                            continue block157;
                                        }
                                        case -35: {
                                            var7_7 = 3;
                                            continue block157;
                                        }
                                        case -36: {
                                            var7_7 = 4;
                                            continue block157;
                                        }
                                        case -37: {
                                            var7_7 = 5;
                                            continue block157;
                                        }
                                        case -38: {
                                            var7_7 = 255 & var17_22[var1_1.pc];
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -39: {
                                            var7_7 = Interpreter.getIndex(var17_22, var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -40: {
                                            var7_7 = Interpreter.getInt(var17_22, var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case -41: {
                                            var6_6 = var18_23[0];
                                            continue block157;
                                        }
                                        case -42: {
                                            var6_6 = var18_23[1];
                                            continue block157;
                                        }
                                        case -43: {
                                            var6_6 = var18_23[2];
                                            continue block157;
                                        }
                                        case -44: {
                                            var6_6 = var18_23[3];
                                            continue block157;
                                        }
                                        case -45: {
                                            var6_6 = var18_23[255 & var17_22[var1_1.pc]];
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -46: {
                                            var6_6 = var18_23[Interpreter.getIndex(var17_22, var1_1.pc)];
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -47: {
                                            var6_6 = var18_23[Interpreter.getInt(var17_22, var1_1.pc)];
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        default: {
                                            Interpreter.dumpICode(var1_1.idata);
                                            throw new RuntimeException("Unknown icode : " + var20_25 + " @ pc : " + (var1_1.pc - 1));
                                        }
                                    }
                                    if (var5_5) {
                                        Interpreter.addInstructionCount(var0, var1_1, 2);
                                    }
                                    var1_1.pc = (var21_84 = Interpreter.getShort(var17_22, var1_1.pc)) != 0 ? (var1_1.pc += var21_84 - 1) : var1_1.idata.longJumps.getExistingInt(var1_1.pc);
                                    if (!var5_5) continue;
                                    var1_1.pcPrevBranch = var1_1.pc;
                                }
                                Interpreter.exitFrame(var0, var1_1, null);
                                var9_9 = var1_1.result;
                                var10_10 = var1_1.resultDbl;
                                if (var1_1.parentFrame != null) {
                                    var1_1 = var1_1.parentFrame;
                                    if (var1_1.frozen) {
                                        var1_1 = var1_1.cloneFrozen();
                                    }
                                    Interpreter.setCallResult(var1_1, var9_9, var10_10);
                                    var9_9 = null;
                                    continue;
                                }
                                break block286;
                                break;
                            }
                        }
                        catch (Throwable var12_12) {
                            if (var2_2 != null) {
                                var12_12.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            var2_2 = var12_12;
                        }
                    }
                    if (var2_2 == null) {
                        Kit.codeBug();
                    }
                    var13_14 /* !! */  = null;
                    if (var8_8 != null && var8_8.operation == 2 && var2_2 == var8_8.value) {
                        var12_13 = 1;
                    } else if (var2_2 instanceof JavaScriptException) {
                        var12_13 = 2;
                    } else if (var2_2 instanceof EcmaError) {
                        var12_13 = 2;
                    } else if (var2_2 instanceof EvaluatorException) {
                        var12_13 = 2;
                    } else if (var2_2 instanceof RuntimeException) {
                        var12_13 = var0.hasFeature(13) != false ? 2 : 1;
                    } else if (var2_2 instanceof Error) {
                        var12_13 = var0.hasFeature(13) != false ? 2 : 0;
                    } else if (var2_2 instanceof ContinuationJump) {
                        var12_13 = 1;
                        var13_14 /* !! */  = (double[])((ContinuationJump)var2_2);
                    } else {
                        v1 = var12_13 = var0.hasFeature(13) != false ? 2 : 1;
                    }
                    if (var5_5) {
                        try {
                            Interpreter.addInstructionCount(var0, var1_1, 100);
                        }
                        catch (RuntimeException var14_16) {
                            var2_2 = var14_16;
                            var12_13 = 1;
                        }
                        catch (Error var14_17) {
                            var2_2 = var14_17;
                            var13_14 /* !! */  = null;
                            var12_13 = 0;
                        }
                    }
                    if (var1_1.debuggerFrame != null && var2_2 instanceof RuntimeException) {
                        var14_15 /* !! */  = (RuntimeException)var2_2;
                        try {
                            var1_1.debuggerFrame.onExceptionThrown(var0, (Throwable)var14_15 /* !! */ );
                        }
                        catch (Throwable var15_20) {
                            var2_2 = var15_20;
                            var13_14 /* !! */  = null;
                            var12_13 = 0;
                        }
                    }
                    do {
                        if (var12_13 != 0 && (var7_7 = Interpreter.getExceptionHandler(var1_1, var14_18 = var12_13 != 2)) >= 0) continue block155;
                        Interpreter.exitFrame(var0, var1_1, var2_2);
                        var1_1 = var1_1.parentFrame;
                        if (var1_1 == null) break block287;
                    } while (var13_14 /* !! */  == null || var13_14 /* !! */ .branchFrame != var1_1);
                    var7_7 = -1;
                    continue;
                }
                if (var13_14 /* !! */  == null) break block286;
                if (var13_14 /* !! */ .branchFrame != null) {
                    Kit.codeBug();
                }
                if (var13_14 /* !! */ .capturedFrame == null) break;
                var7_7 = -1;
            }
            var9_9 = var13_14 /* !! */ .result;
            var10_10 = var13_14 /* !! */ .resultDbl;
            var2_2 = null;
        }
        if (var0.previousInterpreterInvocations != null && var0.previousInterpreterInvocations.size() != 0) {
            var0.lastInterpreterFrame = var0.previousInterpreterInvocations.pop();
        } else {
            var0.lastInterpreterFrame = null;
            var0.previousInterpreterInvocations = null;
        }
        if (var2_2 != null) {
            if (var2_2 instanceof RuntimeException) {
                throw (RuntimeException)var2_2;
            }
            throw (Error)var2_2;
        }
        return var9_9 != var3_3 ? var9_9 : ScriptRuntime.wrapNumber(var10_10);
    }

    private static CallFrame initFrameForNoSuchMethod(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, Scriptable scriptable2, ScriptRuntime.NoSuchMethodShim noSuchMethodShim, InterpretedFunction interpretedFunction) {
        Object object;
        Object[] objectArray2 = null;
        int n4 = n2 + 2;
        Object[] objectArray3 = new Object[n];
        int n5 = 0;
        while (n5 < n) {
            object = objectArray[n4];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n4]);
            }
            objectArray3[n5] = object;
            ++n5;
            ++n4;
        }
        objectArray2 = new Object[]{noSuchMethodShim.methodName, context.newArray(scriptable2, objectArray3)};
        CallFrame callFrame2 = callFrame;
        object = new CallFrame();
        if (n3 == -55) {
            callFrame2 = callFrame.parentFrame;
            Interpreter.exitFrame(context, callFrame, null);
        }
        Interpreter.initFrame(context, scriptable2, scriptable, objectArray2, null, 0, 2, interpretedFunction, callFrame2, (CallFrame)object);
        if (n3 != -55) {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shallowEquals(Object[] objectArray, double[] dArray, int n) {
        double d;
        double d2;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        UniqueTag uniqueTag = UniqueTag.DOUBLE_MARK;
        if (object == uniqueTag) {
            d2 = dArray[n + 1];
            if (object2 == uniqueTag) {
                d = dArray[n];
                return d == d2;
            } else {
                if (!(object2 instanceof Number)) return false;
                d = ((Number)object2).doubleValue();
            }
            return d == d2;
        } else {
            if (object2 != uniqueTag) return ScriptRuntime.shallowEq(object2, object);
            d = dArray[n];
            if (object == uniqueTag) {
                d2 = dArray[n + 1];
                return d == d2;
            } else {
                if (!(object instanceof Number)) return false;
                d2 = ((Number)object).doubleValue();
            }
        }
        return d == d2;
    }

    private static CallFrame processThrowable(Context context, Object object, CallFrame callFrame, int n, boolean bl) {
        if (n >= 0) {
            if (callFrame.frozen) {
                callFrame = callFrame.cloneFrozen();
            }
            int[] nArray = callFrame.idata.itsExceptionTable;
            callFrame.pc = nArray[n + 2];
            if (bl) {
                callFrame.pcPrevBranch = callFrame.pc;
            }
            callFrame.savedStackTop = callFrame.emptyStackTop;
            int n2 = callFrame.localShift + nArray[n + 5];
            int n3 = callFrame.localShift + nArray[n + 4];
            callFrame.scope = (Scriptable)callFrame.stack[n2];
            callFrame.stack[n3] = object;
            object = null;
        } else {
            ContinuationJump continuationJump = (ContinuationJump)object;
            object = null;
            if (continuationJump.branchFrame != callFrame) {
                Kit.codeBug();
            }
            if (continuationJump.capturedFrame == null) {
                Kit.codeBug();
            }
            int n4 = continuationJump.capturedFrame.frameIndex + 1;
            if (continuationJump.branchFrame != null) {
                n4 -= continuationJump.branchFrame.frameIndex;
            }
            int n5 = 0;
            CallFrame[] callFrameArray = null;
            CallFrame callFrame2 = continuationJump.capturedFrame;
            int n6 = 0;
            while (n6 != n4) {
                if (!callFrame2.frozen) {
                    Kit.codeBug();
                }
                if (Interpreter.isFrameEnterExitRequired(callFrame2)) {
                    if (callFrameArray == null) {
                        callFrameArray = new CallFrame[n4 - n6];
                    }
                    callFrameArray[n5] = callFrame2;
                    ++n5;
                }
                callFrame2 = callFrame2.parentFrame;
                ++n6;
            }
            while (n5 != 0) {
                callFrame2 = callFrameArray[--n5];
                Interpreter.enterFrame(context, callFrame2, ScriptRuntime.emptyArgs, true);
            }
            callFrame = continuationJump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult(callFrame, continuationJump.result, continuationJump.resultDbl);
        }
        callFrame.throwable = object;
        return callFrame;
    }

    private static Object freezeGenerator(Context context, CallFrame callFrame, int n, GeneratorState generatorState) {
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeError0("msg.yield.closing");
        }
        callFrame.frozen = true;
        callFrame.result = callFrame.stack[n];
        callFrame.resultDbl = callFrame.sDbl[n];
        callFrame.savedStackTop = n;
        --callFrame.pc;
        ScriptRuntime.exitActivationFunction(context);
        return callFrame.result != UniqueTag.DOUBLE_MARK ? callFrame.result : ScriptRuntime.wrapNumber(callFrame.resultDbl);
    }

    private static Object thawGenerator(CallFrame callFrame, int n, GeneratorState generatorState, int n2) {
        callFrame.frozen = false;
        int n3 = Interpreter.getIndex(callFrame.idata.itsICode, callFrame.pc);
        callFrame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, callFrame.idata.itsSourceFile, n3);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (n2 == 72) {
            callFrame.stack[n] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static CallFrame initFrameForApplyOrCall(Context context, CallFrame object, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, IdFunctionObject idFunctionObject, InterpretedFunction interpretedFunction) {
        Scriptable scriptable2;
        Object object2;
        if (n != 0) {
            object2 = objectArray[n2 + 2];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                object2 = ScriptRuntime.wrapNumber(dArray[n2 + 2]);
            }
            scriptable2 = ScriptRuntime.toObjectOrNull(context, object2);
        } else {
            scriptable2 = null;
        }
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        if (n3 == -55) {
            Interpreter.exitFrame(context, (CallFrame)object, null);
            object = ((CallFrame)object).parentFrame;
        } else {
            ((CallFrame)object).savedStackTop = n2;
            ((CallFrame)object).savedCallOp = n3;
        }
        object2 = new CallFrame();
        if (BaseFunction.isApply(idFunctionObject)) {
            Object[] objectArray2 = n < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[n2 + 3]);
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray2, null, 0, objectArray2.length, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        } else {
            int n4 = 1;
            while (n4 < n) {
                objectArray[n2 + 1 + n4] = objectArray[n2 + 2 + n4];
                dArray[n2 + 1 + n4] = dArray[n2 + 2 + n4];
                ++n4;
            }
            n4 = n < 2 ? 0 : n - 1;
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray, dArray, n2 + 2, n4, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        }
        object = object2;
        return object;
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        double[] dArray2;
        int[] nArray;
        Object[] objectArray2;
        boolean bl;
        int n3;
        int n4;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = !interpreterData.useDynamicScope ? interpretedFunction.getParentScope() : scriptable;
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            int n5 = 0;
            while (n5 < interpreterData.itsNestedFunctions.length) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[n5];
                if (interpreterData2.itsFunctionType == 1) {
                    Interpreter.initFunction(context, scriptable3, interpretedFunction, n5);
                }
                ++n5;
            }
        }
        Scriptable[] scriptableArray = null;
        if (interpreterData.itsRegExpLiterals != null) {
            scriptableArray = interpreterData.itsFunctionType != 0 ? interpretedFunction.functionRegExps : interpretedFunction.createRegExpWraps(context, scriptable3);
        }
        if ((n4 = interpreterData.itsMaxFrameArray) != (n3 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n4 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            nArray = callFrame2.stackAttributes;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n4];
            nArray = new int[n4];
            dArray2 = new double[n4];
        }
        int n6 = interpreterData.getParamAndVarCount();
        int n7 = 0;
        while (n7 < n6) {
            if (interpreterData.getParamOrVarConst(n7)) {
                nArray[n7] = 13;
            }
            ++n7;
        }
        n7 = interpreterData.argCount;
        if (n7 > n2) {
            n7 = n2;
        }
        callFrame2.parentFrame = callFrame;
        int n8 = callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        if (callFrame2.frameIndex > context.getMaximumInterpreterStackDepth()) {
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.stackAttributes = nArray;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n3;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.scriptRegExps = scriptableArray;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n3;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n7);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n7);
        }
        int n9 = n7;
        while (n9 != interpreterData.itsMaxVars) {
            objectArray2[n9] = Undefined.instance;
            ++n9;
        }
        if (bl) {
            n9 = n3 + 1;
            while (n9 != objectArray2.length) {
                objectArray2[n9] = null;
                ++n9;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray, false);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2;
        boolean bl3 = callFrame.idata.itsNeedsActivation;
        boolean bl4 = bl2 = callFrame.debuggerFrame != null;
        if (bl3 || bl2) {
            Scriptable scriptable = callFrame.scope;
            if (scriptable == null) {
                Kit.codeBug();
            } else if (bl) {
                while (scriptable instanceof NativeWith) {
                    if ((scriptable = scriptable.getParentScope()) != null && (callFrame.parentFrame == null || callFrame.parentFrame.scope != scriptable)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (bl2) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl3) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 38) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    public static NativeContinuation captureContinuation(Context context) {
        if (context.lastInterpreterFrame == null || !(context.lastInterpreterFrame instanceof CallFrame)) {
            throw new IllegalStateException("Interpreter frames not found");
        }
        return Interpreter.captureContinuation(context, (CallFrame)context.lastInterpreterFrame, true);
    }

    private static NativeContinuation captureContinuation(Context context, CallFrame callFrame, boolean bl) {
        NativeContinuation nativeContinuation = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(nativeContinuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame;
        CallFrame callFrame3 = callFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            int n = callFrame2.savedStackTop + 1;
            while (n != callFrame2.stack.length) {
                callFrame2.stack[n] = null;
                callFrame2.stackAttributes[n] = 0;
                ++n;
            }
            if (callFrame2.savedCallOp == 38) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame3 = callFrame2;
            callFrame2 = callFrame2.parentFrame;
        }
        if (bl) {
            while (callFrame3.parentFrame != null) {
                callFrame3 = callFrame3.parentFrame;
            }
            if (!callFrame3.isContinuationsTopFrame) {
                throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
            }
        }
        nativeContinuation.initImplementation(callFrame);
        return nativeContinuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        double d = object == UniqueTag.DOUBLE_MARK ? callFrame.sDbl[n] : ScriptRuntime.toNumber(object);
        return ScriptRuntime.toInt32(d);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof String) {
                String string = (String)object2;
                String string2 = ScriptRuntime.toString(object);
                objectArray[n] = string.concat(string2);
            } else if (object instanceof String) {
                String string = ScriptRuntime.toString(object2);
                String string3 = (String)object;
                objectArray[n] = string.concat(string3);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof String) {
            String string = (String)object2;
            String string4 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string.concat(string4) : string4.concat(string);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        int[] stackAttributes;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        boolean isContinuationsTopFrame;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.stackAttributes = (int[])this.stackAttributes.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation nativeContinuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)nativeContinuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    static class GeneratorState {
        int operation;
        Object value;
        RuntimeException returnedException;

        GeneratorState(int n, Object object) {
            this.operation = n;
            this.value = object;
        }
    }
}

