/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Frame;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.io.GExtensionFileFilter;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;

public class GExportOffAction
implements GAction {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        String filePath = documentHandler.getFigurePath();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        String figureName = figure.getName();
        GSolid solid = figure.getSolid();
        Frame ownerFrame = documentHandler.getOwnerFrame();
        FileFilter[] filters = new FileFilter[]{new GExtensionFileFilter("off")};
        GFileWriter writer = documentHandler.getFileWriter(ownerFrame, filePath, filters, true);
        try {
            int option;
            writer.selectFile();
            if (!writer.approved()) {
                return false;
            }
            if (writer.fileExists() && (option = GGraphicsFactory.getInstance().showYesNoDialog(GDictionary.get("FileExistsOverwrite", new String[0]))) != 0) {
                return false;
            }
            StringBuffer buf = new StringBuffer();
            solid.toOff(buf);
            writer.write(String.valueOf(buf));
        }
        catch (Exception exception) {
            documentHandler.error(GDictionary.get("CannotExport", figureName));
        }
        filePath = writer.getSelectedFilePath();
        logger.info((Object)(figureName + ": " + filePath));
        return true;
    }
}

