/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.List;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GRenameVariableDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GRenameVariableAction
implements GLoggable,
GActionWithHelp {
    private String oldName;
    private String newName;
    private GDocument document;
    private GNotepad notepad;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        this.notepad = this.document.getNotepad();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            this.prefillSelection();
            List<GNotepadVariable> variables = this.notepad.getVariables();
            String[] variableNames = new String[variables.size()];
            for (int i = 0; i < variables.size(); ++i) {
                variableNames[i] = variables.get(i).getName();
            }
            GRenameVariableDialog dialog = new GRenameVariableDialog(documentHandler.getOwnerFrame(), this, variableNames);
            dialog.prefill(this.oldName);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            this.notepad.clearSelection();
        }
        documentHandler.notepadChanged();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)String.format("Variable %s renamed to %s", this.oldName, this.newName));
        return true;
    }

    private void prefillSelection() {
        GNotepadRecord notepadRecord = this.document.getNotepad().getSelectedRecord();
        if (notepadRecord != null) {
            this.oldName = notepadRecord.getVariable().getName();
        }
    }

    public void setInput(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    public void validateApply() throws Exception {
        if (this.newName.trim().length() == 0) {
            logger.error((Object)"No name");
            throw new Exception(GDictionary.get("EnterNewVariableName", new String[0]));
        }
        if (this.oldName.equals(this.newName)) {
            logger.error((Object)String.format("New name same as old, %s", this.oldName));
            throw new Exception(GDictionary.get("NamesAreSame", new String[0]));
        }
        if (!this.newName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
            logger.info((Object)String.format("Bad variable name: %s", this.newName));
            throw new Exception(GDictionary.get("InvalidVariable", this.newName));
        }
        if (this.document.getVariable(this.newName) != null) {
            logger.error((Object)String.format("Duplicate variable %", this.newName));
            throw new Exception(GDictionary.get("DuplicateVariable", this.newName));
        }
        this.document.getNotepad().renameVariable(this);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.document.getNotepad().undoRenameVariable(this);
        documentHandler.notepadChanged();
        logger.info((Object)String.format("Rename variable %s to %s undone", this.oldName, this.newName));
    }

    @Override
    public GLoggable clone() {
        GRenameVariableAction action = new GRenameVariableAction();
        action.oldName = this.oldName;
        action.newName = this.newName;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("RenameVariableTo", this.oldName, this.newName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("oldName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No old name");
            throw new Exception();
        }
        this.oldName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("newName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No new name");
            throw new Exception();
        }
        this.newName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<oldName>").append(this.oldName).append("</oldName>").append("\n<newName>").append(this.newName).append("</newName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("renameVariable", this.oldName, this.newName);
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public List<GNotepadVariable> getVariables() {
        return this.notepad.getVariables();
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

