/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionPlaneAnswer;
import net.geocentral.geometria.model.answer.GFixedPlaneAnswer;
import net.geocentral.geometria.model.answer.GLineSetAnswer;
import net.geocentral.geometria.model.answer.GMultipleChoiceAnswer;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.model.answer.GPointSetAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GSolutionConditionPlaneAnswerDialog;
import net.geocentral.geometria.view.GSolutionFixedPlaneAnswerDialog;
import net.geocentral.geometria.view.GSolutionLineSetAnswerDialog;
import net.geocentral.geometria.view.GSolutionMultipleChoiceAnswerDialog;
import net.geocentral.geometria.view.GSolutionNumberAnswerDialog;
import net.geocentral.geometria.view.GSolutionPointSetAnswerDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GSolutionAnswerAction
implements GLoggable,
GActionWithHelp,
GFigureAction {
    private String valueString;
    private String figureName;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GSolution document = documentHandler.getMasterSolution();
        GProblem problem = document.getProblem();
        GAnswer problemAnswer = problem.getAnswer();
        if (silent) {
            boolean validated = problemAnswer.validate(this.valueString, this.figureName, document);
            if (validated) {
                documentHandler.setActiveDocument(document);
                documentHandler.documentChanged();
            }
            return validated;
        }
        if (problemAnswer instanceof GNumberAnswer) {
            GSolutionNumberAnswerDialog dialog = new GSolutionNumberAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GNumberAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GPointSetAnswer) {
            GSolutionPointSetAnswerDialog dialog = new GSolutionPointSetAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GPointSetAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GLineSetAnswer) {
            GSolutionLineSetAnswerDialog dialog = new GSolutionLineSetAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GLineSetAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GFixedPlaneAnswer) {
            GSolutionFixedPlaneAnswerDialog dialog = new GSolutionFixedPlaneAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GFixedPlaneAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GConditionPlaneAnswer) {
            GSolutionConditionPlaneAnswerDialog dialog = new GSolutionConditionPlaneAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GConditionPlaneAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GMultipleChoiceAnswer) {
            GSolutionMultipleChoiceAnswerDialog dialog = new GSolutionMultipleChoiceAnswerDialog(documentHandler.getOwnerFrame(), this, (GMultipleChoiceAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        }
        documentHandler.setDocumentModified(true);
        logger.info((Object)this.valueString);
        return true;
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)(this.valueString + " : " + this.figureName));
    }

    @Override
    public GLoggable clone() {
        GSolutionAnswerAction action = new GSolutionAnswerAction();
        action.valueString = this.valueString;
        action.figureName = this.figureName;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("CorrectAnswer", this.valueString);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("value");
        if (ns.getLength() == 0) {
            logger.info((Object)"No value");
            throw new Exception();
        }
        this.valueString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("figureName");
        if (ns.getLength() > 0) {
            this.figureName = ns.item(0).getTextContent();
        }
        if ((ns = node.getElementsByTagName("comments")).getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<value>").append(this.valueString).append("</value>");
        if (this.figureName != null) {
            buf.append("\n<figureName>").append(this.figureName).append("</figureName>");
        }
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String valueString, String figureName) {
        logger.info((Object)(valueString + " : " + figureName));
        this.valueString = valueString;
        this.figureName = figureName;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("correctAnswer", new String[0]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

