/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSolid;
import org.apache.log4j.Logger;

public class GSolidFactory {
    private static GSolidFactory instance;
    private static Logger logger;

    private GSolidFactory() {
    }

    public static GSolidFactory getInstance() {
        if (instance == null) {
            instance = new GSolidFactory();
        }
        return instance;
    }

    public GSolid newPrism(int sideCount) {
        int i;
        logger.info((Object)sideCount);
        double dAngle = Math.PI * 2 / (double)sideCount;
        double angle = 0.0;
        ArrayList<GPoint3d> ps = new ArrayList<GPoint3d>();
        String label = null;
        for (i = 0; i < sideCount; ++i) {
            label = GLabelFactory.getInstance().nextLabel(label);
            GPoint3d p = new GPoint3d(Math.cos(angle), Math.sin(angle), 0.0, label);
            p.setVertex(true);
            ps.add(p);
            angle += dAngle;
        }
        for (i = 0; i < sideCount; ++i) {
            label = GLabelFactory.getInstance().nextLabel(label);
            Point3d pBase = ((GPoint3d)ps.get((int)i)).coords;
            GPoint3d p = new GPoint3d(pBase.x, pBase.y, 1.0, label);
            p.setVertex(true);
            ps.add(p);
        }
        ArrayList<GFace> faces = new ArrayList<GFace>();
        ArrayList<GLine> upperEdges = new ArrayList<GLine>();
        ArrayList<GLine> lowerEdges = new ArrayList<GLine>();
        for (int i2 = 0; i2 < sideCount; ++i2) {
            GPoint3d pBase1 = (GPoint3d)ps.get(i2);
            GPoint3d pBase2 = (GPoint3d)ps.get((i2 + 1) % sideCount);
            GPoint3d p1 = (GPoint3d)ps.get(sideCount + i2);
            GPoint3d p2 = (GPoint3d)ps.get(sideCount + (i2 + 1) % sideCount);
            ArrayList<GLine> sideEdges = new ArrayList<GLine>();
            GLine line = new GLine(pBase1.getLabel(), pBase2.getLabel());
            sideEdges.add(line);
            line = new GLine(pBase1.getLabel(), pBase2.getLabel());
            lowerEdges.add(line);
            line = new GLine(pBase2.getLabel(), p2.getLabel());
            sideEdges.add(line);
            line = new GLine(p2.getLabel(), p1.getLabel());
            sideEdges.add(line);
            line = new GLine(p1.getLabel(), p2.getLabel());
            upperEdges.add(line);
            line = new GLine(p1.getLabel(), pBase1.getLabel());
            sideEdges.add(line);
            GFace face = new GFace(4, sideEdges);
            faces.add(face);
        }
        GFace face = new GFace(sideCount, lowerEdges);
        faces.add(face);
        face = new GFace(sideCount, upperEdges);
        faces.add(face);
        return new GSolid(ps, faces);
    }

    public GSolid newPyramid(int sideCount) {
        logger.info((Object)sideCount);
        double dAngle = Math.PI * 2 / (double)sideCount;
        double angle = 0.0;
        ArrayList<GPoint3d> ps = new ArrayList<GPoint3d>();
        String label = null;
        for (int i = 0; i < sideCount; ++i) {
            label = GLabelFactory.getInstance().nextLabel(label);
            GPoint3d p = new GPoint3d(Math.cos(angle), Math.sin(angle), 0.0, label);
            p.setVertex(true);
            ps.add(p);
            angle += dAngle;
        }
        label = GLabelFactory.getInstance().nextLabel(label);
        GPoint3d apex = new GPoint3d(0.0, 0.0, 2.0 * Math.sqrt(0.6666666666666666), label);
        apex.setVertex(true);
        ps.add(apex);
        ArrayList<GFace> faces = new ArrayList<GFace>();
        ArrayList<GLine> baseEdges = new ArrayList<GLine>();
        for (int i = 0; i < sideCount; ++i) {
            GPoint3d p1 = (GPoint3d)ps.get(i);
            GPoint3d p2 = (GPoint3d)ps.get((i + 1) % sideCount);
            ArrayList<GLine> sideEdges = new ArrayList<GLine>();
            GLine edge = new GLine(p1.getLabel(), p2.getLabel());
            sideEdges.add(edge);
            edge = new GLine(p1.getLabel(), p2.getLabel());
            baseEdges.add(edge);
            edge = new GLine(p2.getLabel(), apex.getLabel());
            sideEdges.add(edge);
            edge = new GLine(apex.getLabel(), p1.getLabel());
            sideEdges.add(edge);
            GFace face = new GFace(3, sideEdges);
            faces.add(face);
        }
        GFace face = new GFace(sideCount, baseEdges);
        faces.add(face);
        return new GSolid(ps, faces);
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

